/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.FutureDealSum;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CtpDealModel;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class CtpDealSumPart
extends MxPart {
    @FXML
    private TableView<FutureDealSum> tableSum;
    @FXML
    private TableColumn<FutureDealSum, String> code;
    @FXML
    private TableColumn<FutureDealSum, String> name;
    @FXML
    private TableColumn<FutureDealSum, MxNode> side;
    @FXML
    private TableColumn<FutureDealSum, MxNode> ocFlag;
    @FXML
    private TableColumn<FutureDealSum, MxNode> shFlag;
    @FXML
    private TableColumn<FutureDealSum, String> type;
    @FXML
    private TableColumn<FutureDealSum, Number> count;
    @FXML
    private TableColumn<FutureDealSum, Number> price;
    @FXML
    private TableColumn<FutureDealSum, String> account;
    @FXML
    private TableColumn<FutureDealSum, String> source;
    @FXML
    private TextField searchText;
    @FXML
    private RadioButton radioContract;
    @FXML
    private RadioButton radioStrategy;
    private ToggleGroup group = new ToggleGroup();
    private ObservableList<FutureDealSum> list = FxUtils.newList();
    private List<FutureDealSum> listAll = new ArrayList<FutureDealSum>();
    @Inject
    private CtpDealModel model;
    @Inject
    private IRefDataMng refMng;
    private Predicate<FutureDealSum> pd = new Predicate<FutureDealSum>(){

        @Override
        public boolean test(FutureDealSum t) {
            return t.getCode().trim().toUpperCase().contains(CtpDealSumPart.this.searchText.getText().trim().toUpperCase());
        }
    };
    private InvalidationListener listener = ob -> {
        ObservableList dealList = this.model.getList();
        HashMap<String, FutureDealSum> map = new HashMap<String, FutureDealSum>();
        HashSet<String> set = new HashSet<String>();
        for (CtpDeal deal : dealList) {
            FutureDealSum sum;
            if (deal.getSource().isEmpty()) continue;
            String key = this.radioContract.isSelected() ? String.valueOf(deal.getSecId()) + deal.getType() + deal.getSide().getRaw() + deal.getOcFlag().getRaw() + deal.getInvestorId() : String.valueOf(deal.getSecId()) + deal.getType() + deal.getSide().getRaw() + deal.getOcFlag().getRaw() + deal.getInvestorId() + deal.getSource();
            if (set.contains(key)) {
                sum = (FutureDealSum)map.get(key);
                sum.setCount(sum.getCount() + deal.getLastQty());
                sum.setAmount(sum.getAmount() + deal.getLastPx() * deal.getLastQty());
                continue;
            }
            sum = new FutureDealSum();
            sum.update(deal);
            map.put(key, sum);
            set.add(key);
        }
        for (FutureDealSum sum : map.values()) {
            sum.setPrice(sum.getAmount() / sum.getCount());
        }
        this.listAll.clear();
        this.listAll.addAll(map.values());
        this.filter();
    };
    private InvalidationListener listenerSearch = ob -> this.filter();

    private void filter() {
        this.list.setAll((Collection)this.listAll.stream().filter(this.pd).collect(Collectors.toList()));
        this.tableSum.refresh();
        this.list.sort((o1, o2) -> o1.getCode().compareTo(o2.getCode()));
        this.tableSum.sort();
    }

    @FXML
    private void initialize() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerSearch));
        this.createTable();
        this.refresh();
        this.radioContract.setToggleGroup(this.group);
        this.radioStrategy.setToggleGroup(this.group);
        this.radioContract.setSelected(true);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            this.listener.invalidated(null);
            if (this.radioContract.isSelected()) {
                this.source.setVisible(false);
            } else {
                this.source.setVisible(true);
            }
        });
        this.tableSum.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            FutureDealSum deal = (FutureDealSum)this.tableSum.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.futures.part.deal.sum")) {
                MEvent e = new MEvent();
                e.put((Object)"input_ctp_market_making", (Object)deal.getCode());
                this.es.postEvent("input_ctp_market_making", e);
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)deal.getCode());
                eCall.put((Object)"side_sell", (Object)deal.getSide());
                this.es.postEvent("input_futures_trade_market", eCall);
            }
        });
    }

    @FXML
    private void refresh() {
        this.model.query();
    }

    private void createTable() {
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getCode()));
        this.name.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getName()));
        this.side.setCellValueFactory(data -> {
            MxNode node = new MxNode().load("side", ((FutureDealSum)data.getValue()).getSide());
            SimpleObjectProperty obj = new SimpleObjectProperty((Object)node);
            return obj;
        });
        this.side.setCellFactory(cell -> new SideCell());
        this.ocFlag.setCellValueFactory(data -> {
            MxNode node = new MxNode().load("position_effect", ((FutureDealSum)data.getValue()).getOcFlag());
            SimpleObjectProperty obj = new SimpleObjectProperty((Object)node);
            return obj;
        });
        this.shFlag.setCellValueFactory(data -> {
            MxNode node = new MxNode().load("sh_flag", ((FutureDealSum)data.getValue()).getShFlag());
            SimpleObjectProperty obj = new SimpleObjectProperty((Object)node);
            return obj;
        });
        this.type.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getType()));
        this.count.setCellValueFactory(data -> new SimpleLongProperty((long)((FutureDealSum)data.getValue()).getCount()));
        this.price.setCellValueFactory(data -> new SimpleDoubleProperty(((FutureDealSum)data.getValue()).getPrice()));
        this.price.setCellFactory(cell -> new PriceCell());
        this.account.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getAccount()));
        this.source.setCellValueFactory(data -> new SimpleStringProperty(((FutureDealSum)data.getValue()).getSource()));
        this.tableSum.setPlaceholder((Node)new Label());
        this.tableSum.setItems(this.list);
    }

    class PriceCell
    extends TableCell<FutureDealSum, Number> {
        int scale = 3;

        PriceCell() {
        }

        protected void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                FutureDealSum sum = (FutureDealSum)this.getTableRow().getItem();
                RefItem refItem = CtpDealSumPart.this.refMng.getItem(sum.getMarket(), sum.getCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

