/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.CtpDealModel;
import cms.tmx.query.history.views.TypeCell;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CtpDealPart
extends MxPart {
    @FXML
    protected TableView<CtpDeal> tableCtpDeal;
    @FXML
    private TableColumn<CtpDeal, String> colParentId;
    @FXML
    private TableColumn<CtpDeal, String> colSource;
    @FXML
    private TableColumn<CtpDeal, String> colSecId;
    @FXML
    private TableColumn<CtpDeal, String> colSecName;
    @FXML
    private TableColumn<CtpDeal, MxNode> colMarket;
    @FXML
    private TableColumn<CtpDeal, MxNode> colDir;
    @FXML
    private TableColumn<CtpDeal, MxNode> colOC;
    @FXML
    private TableColumn<CtpDeal, MxNode> colSH;
    @FXML
    private TableColumn<CtpDeal, Number> colVol;
    @FXML
    private TableColumn<CtpDeal, Number> colPrice;
    @FXML
    private TableColumn<CtpDeal, Number> colExecFee;
    @FXML
    private TableColumn<CtpDeal, String> colTime;
    @FXML
    private TableColumn<CtpDeal, String> colENo;
    @FXML
    private TableColumn<CtpDeal, String> colAcc;
    @FXML
    private TableColumn<CtpDeal, String> colSecAcc;
    @FXML
    private TableColumn<CtpDeal, String> colDealNo;
    @FXML
    protected TableView<CtpDeal> tableCtpDealSum;
    @FXML
    private TableColumn<CtpDeal, String> colSecIdSum;
    @FXML
    private TableColumn<CtpDeal, String> colSecNameSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colMarketSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colDirSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colOCSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colSHSum;
    @FXML
    private TableColumn<CtpDeal, Number> colVolSum;
    @FXML
    private TableColumn<CtpDeal, Number> colPriceSum;
    @FXML
    private TableColumn<CtpDeal, Number> colCount;
    @FXML
    private TableColumn<CtpDeal, String> colAccSum;
    @FXML
    private TableColumn<CtpDeal, String> colType;
    @FXML
    private TextField searchText;
    @FXML
    private RadioButton detailRadio;
    @FXML
    private RadioButton sumRadio;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    private CtpDealModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private DealFactory fDeal;
    private MxList<CtpDeal> mxList = new MxList();
    protected MxList<CtpDeal> mxSumList = new MxList();
    protected List<CtpDeal> sumList = new LinkedList<CtpDeal>();
    private static final Logger logger = LogManager.getLogger(CtpDealPart.class);
    @Inject
    private MxAlert alert;
    private Predicate<CtpDeal> pd = deal -> {
        String text = this.searchText.getText().toUpperCase().trim();
        return deal.getInstrument().getSecId().toUpperCase().contains(text) || deal.getInstrument().getSymbol().toUpperCase().contains(text) || deal.getOrderId().contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        List<CtpDeal> newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<CtpDeal>)this.model.getList());
        }
        this.sumList = this.createSumList(newList);
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
            this.tableCtpDeal.sort();
            this.tableCtpDeal.refresh();
            this.mxSumList.update(this.sumList, this.pd);
            Collections.sort(this.mxSumList.getList(), (o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
            this.tableCtpDealSum.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        this.mxList.filter(this.model.getList(), this.pd);
        this.mxSumList.filter(this.sumList, this.pd);
    };

    @Focus
    public void onFocus() {
        this.tableCtpDeal.refresh();
    }

    @FXML
    public void initialize() {
        this.setRadio();
        this.createTable();
        this.createSumTable();
        this.listener();
        this.refresh();
        this.tableCtpDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CtpDeal deal = (CtpDeal)this.tableCtpDeal.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.deal")) {
                MEvent e = new MEvent();
                e.put((Object)"code", (Object)deal.getSecId());
                this.es.postEvent("input.ctp.future.trade", e);
            }
        });
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    private void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.sumRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableCtpDeal.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableCtpDealSum.visibleProperty().bind((ObservableValue)this.sumRadio.selectedProperty());
    }

    protected String getKey(CtpDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getInstrument().getSecId() + deal.getSide().getRaw() + deal.getOcFlag().getRaw() + deal.getShFlag().getRaw();
        return key;
    }

    @FXML
    private void refresh() {
        this.model.query();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableCtpDeal);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCtpDeal, (String)"\u6210\u4ea4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void copySum() {
        TableUtils.copyContentWithHead(this.tableCtpDealSum);
    }

    @FXML
    public void exportExcelSum() {
        try {
            ExcelUtils.writeExcel(this.tableCtpDealSum, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected List<CtpDeal> createSumList(List<CtpDeal> newList) {
        HashMap<String, CtpDeal> map = new HashMap<String, CtpDeal>();
        LinkedList<CtpDeal> list = new LinkedList<CtpDeal>();
        int i = 0;
        while (i < newList.size()) {
            CtpDeal deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                CtpDeal newDeal = (CtpDeal)CtpDeal.class.cast(this.fDeal.create("FUTURES"));
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(newDeal.getLastPx() * newDeal.getLastQty());
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                CtpDeal oldDeal = (CtpDeal)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double amount = deal.getLastAmount();
                double oldQty = oldDeal.getLastQty();
                double oldAmount = oldDeal.getLastAmount();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastAmount(oldAmount + amount);
                oldDeal.setLastAmountSum(oldDeal.getLastAmountSum() + price * qty);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1L);
            }
            ++i;
        }
        for (CtpDeal deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmountSum() / deal.getLastQty() * 100000.0) / 100000.0);
                continue;
            }
            deal.setLastPx(0.0);
        }
        return list;
    }

    private void createTable() {
        this.colParentId.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getParentId()));
        this.colSource.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getSource()));
        this.colSecId.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().marketProperty());
        this.colDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getSide()));
        this.colDir.setCellFactory(cell -> new SideCell());
        this.colVol.setCellFactory(column -> new EditTableCell(0));
        this.colVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastQty()));
        this.colOC.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getOcFlag()));
        this.colSH.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getShFlag()));
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastPx()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colExecFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getExecFee()));
        this.colExecFee.setCellFactory(p -> new FeeCell());
        this.colTime.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getExecTime()));
        this.colENo.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getOrderId()));
        this.colDealNo.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getExecId()));
        this.colAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInverstorSecId()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getType()));
        this.colType.setCellFactory(cell -> new TypeCell());
        this.tableCtpDeal.setPlaceholder((Node)new Label());
        this.tableCtpDeal.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tableCtpDeal);
    }

    private void createSumTable() {
        this.colSecIdSum.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().secIdProperty());
        this.colSecNameSum.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().symbolProperty());
        this.colMarketSum.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().marketProperty());
        this.colDirSum.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getSide()));
        this.colDirSum.setCellFactory(cell -> new SideCell());
        this.colVolSum.setCellFactory(column -> new EditTableCell(0));
        this.colVolSum.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastQty()));
        this.colOCSum.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getOcFlag()));
        this.colSHSum.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getShFlag()));
        this.colPriceSum.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastPx()));
        this.colPriceSum.setCellFactory(p -> new PriceCell());
        this.colCount.setCellValueFactory(data -> new SimpleLongProperty(((CtpDeal)data.getValue()).getDealCount()));
        this.colAccSum.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInvestorId()));
        this.tableCtpDealSum.setPlaceholder((Node)new Label());
        this.tableCtpDealSum.setItems(this.mxSumList.getList());
        TableUtils.orgnizeClmWidth(this.tableCtpDealSum);
    }

    private class FeeCell
    extends DoubleTableCell<CtpDeal> {
        int scale = 3;

        private FeeCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CtpDeal> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CtpDeal dealItem = (CtpDeal)CtpDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CtpDealPart.this.refMng.getItem(dealItem.getInstrument().getMarket().getRaw(), dealItem.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

