/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.ObCtpDeal;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CtpDealModel;
import cms.tmx.query.current.views.SortPolicy;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CtpDealPagePart
extends MxPart {
    @FXML
    protected TableView<ObCtpDeal> tableCtpDeal;
    @FXML
    private TableColumn<ObCtpDeal, String> secId;
    @FXML
    private TableColumn<ObCtpDeal, String> secName;
    @FXML
    private TableColumn<ObCtpDeal, MxNode> exMarket;
    @FXML
    private TableColumn<ObCtpDeal, String> side;
    @FXML
    private TableColumn<ObCtpDeal, MxNode> exOcFlag;
    @FXML
    private TableColumn<ObCtpDeal, MxNode> exShFlag;
    @FXML
    private TableColumn<ObCtpDeal, Number> lastQty;
    @FXML
    private TableColumn<ObCtpDeal, Number> lastPx;
    @FXML
    private TableColumn<ObCtpDeal, Number> execFee;
    @FXML
    private TableColumn<ObCtpDeal, String> ordDateTime;
    @FXML
    private TableColumn<ObCtpDeal, MxNode> dealType;
    @FXML
    private TableColumn<ObCtpDeal, String> execDateTime;
    @FXML
    private TableColumn<ObCtpDeal, String> orderId;
    @FXML
    private TableColumn<ObCtpDeal, String> investorId;
    @FXML
    private TableColumn<ObCtpDeal, String> inverstorSecId;
    @FXML
    private TableColumn<ObCtpDeal, String> execId;
    @FXML
    protected TableView<CtpDeal> tableCtpDealSum;
    @FXML
    private TableColumn<CtpDeal, String> colSecIdSum;
    @FXML
    private TableColumn<CtpDeal, String> colSecNameSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colMarketSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colDirSum;
    @FXML
    protected TableColumn<CtpDeal, MxNode> colOCSum;
    @FXML
    private TableColumn<CtpDeal, MxNode> colSHSum;
    @FXML
    private TableColumn<CtpDeal, Number> colVolSum;
    @FXML
    private TableColumn<CtpDeal, Number> colPriceSum;
    @FXML
    private TableColumn<CtpDeal, Number> colCount;
    @FXML
    private TableColumn<CtpDeal, String> colAccSum;
    @FXML
    protected TextField searchText;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton sumRadio;
    protected ToggleGroup group = new ToggleGroup();
    @Inject
    protected CtpDealModel model;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private DealFactory fDeal;
    private static final Integer PAGE_SIZE = 500;
    protected MxPageList<CtpDeal, ObCtpDeal> mxList = new MxPageList(PAGE_SIZE.intValue(), ObCtpDeal.class);
    protected MxList<CtpDeal> mxSumList = new MxList();
    protected static final Logger logger = LogManager.getLogger(CtpDealPagePart.class);
    @FXML
    private Label lbCurrentCount;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbCountSeparator;
    private boolean dragFlag = false;
    private long lastDragTime = 0L;
    private ScrollBar bar;
    private double lastPosition = 0.0;
    @Inject
    protected MxAlert alert;
    @FXML
    private ComboBox<String> cmbAccnt;
    private static final String ALL = "\u5168\u90e8";
    public Callback<TableView<ObCtpDeal>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<ObCtpDeal>(){

        @Override
        public void afterSort() {
            CtpDealPagePart.this.lstnModel.invalidated(null);
        }
    };
    long lastLoadTime = 0L;
    private Predicate<CtpDeal> pd = deal -> {
        if (!this.checkAccnt((CtpDeal)deal)) {
            return false;
        }
        String text = this.searchText.getText().toUpperCase().trim();
        if (deal.getSecId().toUpperCase().contains(text)) {
            return true;
        }
        if (this.premise((CtpDeal)deal) && deal.getSecName().toUpperCase().contains(text)) {
            return true;
        }
        if (deal.getOrderId().contains(text)) {
            return true;
        }
        String source = deal.getSource();
        return source != null && source.trim().toUpperCase().contains(text);
    };
    private InvalidationListener sumListener = ob -> {
        if (!this.sumRadio.isSelected()) {
            return;
        }
        ArrayList<CtpDeal> newList = new ArrayList<CtpDeal>();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<CtpDeal>)this.model.getList());
        }
        List<CtpDeal> newSumList = this.createSumList(newList);
        Platform.runLater(() -> {
            this.mxSumList.update(newSumList, this.pd);
            this.tableCtpDealSum.sort();
            this.tableCtpDealSum.refresh();
            this.tableCtpDealSum.layout();
        });
    };
    protected InvalidationListener lstnModel = ob -> {
        logger.info("ctp deal page part visit:" + this.isVisible());
        this.refreshList();
    };
    @Inject
    private MScheduler scheduler;
    protected InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        ArrayList<CtpDeal> newList = new ArrayList<CtpDeal>();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<CtpDeal>)this.model.getList());
        }
        List<CtpDeal> newSumList = this.createSumList(newList);
        Platform.runLater(() -> {
            this.mxList.filter(newList, this.pd);
            this.mxSumList.filter(newSumList, this.pd);
            this.sort();
            this.updateTable();
            this.filterSumTable();
        });
    });

    @Focus
    public void onFocus() {
        this.tableCtpDeal.refresh();
    }

    @FXML
    public void initialize() {
        this.tableCtpDeal.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.setRadio();
        this.createTable();
        this.createSumTable();
        this.listener();
        this.refresh();
        this.initPage();
        this.tableCtpDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCtpDeal deal = (ObCtpDeal)this.tableCtpDeal.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.future.part.deal")) {
                MEvent e = new MEvent();
                e.put((Object)"code", (Object)deal.getSecId());
                this.es.postEvent("input.ctp.future.trade", e);
            }
        });
        this.tableCtpDeal.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.dragFlag) {
                    event.consume();
                }
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableCtpDeal.lookup(".scroll-bar:vertical");
                }
                if (this.bar.getValue() != this.lastPosition) {
                    long current = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.lastDragTime < 100L) {
                        return;
                    }
                    this.lastDragTime = current;
                    if (this.bar.getValue() < this.lastPosition) {
                        if (this.bar.getValue() <= this.bar.getMax() * 0.1) {
                            this.loadPrevPage();
                        }
                    } else if (this.bar.getValue() >= this.bar.getMax() * 0.9) {
                        this.loadNextPage();
                    }
                    this.lastPosition = this.bar.getValue();
                }
            }
        });
        this.tableCtpDeal.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.dragFlag = false;
        });
        this.tableCtpDeal.setOnScroll(ob -> {
            long now = System.currentTimeMillis();
            if (now - this.lastLoadTime < 1000L) {
                return;
            }
            this.lastLoadTime = now;
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableCtpDeal.lookup(".scroll-bar:vertical");
            }
            if (ob.getDeltaY() > 0.0) {
                if (this.lbCurrentCount.getText().startsWith("1-")) {
                    return;
                }
                this.loadPrevPage();
                this.bar.setValue(1.0);
                return;
            }
            if (this.lbCurrentCount.getText().endsWith("-" + this.lbTotalCount.getText())) {
                return;
            }
            this.loadNextPage();
            this.bar.setValue(0.0);
        });
        this.initCmbAccnt();
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.model.getFundsList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
    }

    private void initPage() {
        this.lbCurrentCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbTotalCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbCountSeparator.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
    }

    private void loadNextPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE >= this.mxList.getList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE < this.mxList.getList().size()) {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() + PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    private void loadPrevPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() == 0) {
            return;
        }
        if (this.mxList.getBeginIndex() - PAGE_SIZE < 0) {
            this.mxList.setBeginIndex(0);
        } else {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() - PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.sumRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableCtpDeal.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableCtpDealSum.visibleProperty().bind((ObservableValue)this.sumRadio.selectedProperty());
        this.sumRadio.selectedProperty().addListener(this.sumListener);
    }

    protected String getKey(CtpDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getSecId() + deal.getSide().getRaw() + deal.getOcFlag().getRaw() + deal.getShFlag().getRaw();
        return key;
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.sumRadio.selectedProperty().removeListener(this.sumListener);
    }

    @FXML
    protected void refresh() {
        this.mxList.setBeginIndex(0);
        this.model.query();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableCtpDeal, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listDeal = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            System.out.println("ctpDeal   |  " + Thread.currentThread().getName());
            listDeal.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableCtpDeal, (List)listDeal, (String)"\u6210\u4ea4\u660e\u7ec6");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    private void copySum() {
        TableUtils.copyContentWithHead(this.tableCtpDealSum);
    }

    @FXML
    public void exportExcelSum() {
        try {
            ExcelUtils.writeExcel(this.tableCtpDealSum, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected boolean premise(CtpDeal order) {
        return true;
    }

    private boolean checkAccnt(CtpDeal deal) {
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return true;
        }
        String[] split = accntNow.split("__");
        return ALL.equals(accntNow) || deal.getExtAccntId().contains(split[0]);
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<CtpDeal> newList = new ArrayList<CtpDeal>();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<CtpDeal>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        this.sort();
        this.updateTable();
        if (this.sumRadio.isSelected()) {
            List<CtpDeal> newSumList = this.createSumList(newList);
            Platform.runLater(() -> {
                this.mxSumList.update(newSumList, this.pd);
                this.tableCtpDealSum.sort();
                this.tableCtpDealSum.refresh();
                this.tableCtpDealSum.layout();
            });
        }
    }

    private void sort() {
        try {
            ObservableList sortOrder = this.tableCtpDeal.getSortOrder();
            if (sortOrder == null || sortOrder.isEmpty()) {
                this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
            }
            for (TableColumn column : sortOrder) {
                this.mxList.getList().sort((o1, o2) -> {
                    try {
                        Method method = CtpDeal.class.getMethod("get" + CtpDealPagePart.capitalize(column.getId()), new Class[0]);
                        Object s1 = method.invoke(o1, new Object[0]);
                        Object s2 = method.invoke(o2, new Object[0]);
                        if (s1 instanceof Number) {
                            return QueryUtils.compareNumber(column, s1, s2);
                        }
                        if (s1 instanceof MxNode) {
                            return QueryUtils.compareMxNode(column, s1, s2);
                        }
                        return QueryUtils.compareString(column, s1, s2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u6210\u4ea4\u6392\u5e8f\u51fa\u9519", (Throwable)e);
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    protected void filterSumTable() {
    }

    private void updateTable() {
        Platform.runLater(() -> {
            this.mxList.updatePageList();
            this.tableCtpDeal.layout();
        });
        if (this.lbCurrentCount != null && this.lbTotalCount != null) {
            String current = String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE));
            Platform.runLater(() -> {
                this.lbCurrentCount.setText(current);
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            });
        }
    }

    protected List<CtpDeal> createSumList(List<CtpDeal> newList) {
        HashMap<String, CtpDeal> map = new HashMap<String, CtpDeal>();
        LinkedList<CtpDeal> list = new LinkedList<CtpDeal>();
        int i = 0;
        while (i < newList.size()) {
            CtpDeal deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                CtpDeal newDeal = (CtpDeal)CtpDeal.class.cast(this.fDeal.create("FUTURES"));
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(newDeal.getLastPx() * newDeal.getLastQty());
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                CtpDeal oldDeal = (CtpDeal)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double amount = deal.getLastAmount();
                double oldQty = oldDeal.getLastQty();
                double oldAmount = oldDeal.getLastAmount();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastAmount(oldAmount + amount);
                oldDeal.setLastAmountSum(oldDeal.getLastAmountSum() + price * qty);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1L);
            }
            ++i;
        }
        for (CtpDeal deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmountSum() / deal.getLastQty() * 100000.0) / 100000.0);
                continue;
            }
            deal.setLastPx(0.0);
        }
        return list;
    }

    private void createTable() {
        this.secId.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).secNameProperty());
        this.exMarket.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).getInstrument().marketProperty());
        this.side.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).sideProperty());
        this.side.setCellFactory(cell -> new SideCell());
        this.lastQty.setCellFactory(column -> new EditTableCell(0));
        this.lastQty.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).lastQtyProperty());
        this.exOcFlag.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).ocFlagProperty());
        this.exShFlag.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).shFlagProperty());
        this.lastPx.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).lastPxProperty());
        this.lastPx.setCellFactory(p -> new ObPriceCell());
        this.execFee.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).execFeeProperty());
        this.execFee.setCellFactory(p -> new FeeCell());
        this.execDateTime.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).execTimeProperty());
        this.ordDateTime.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).ordTimeProperty());
        this.dealType.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).dealTypeProperty());
        this.dealType.setCellFactory(cell -> new DealTypeCell());
        this.orderId.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).orderIdProperty());
        this.execId.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).execIdProperty());
        this.investorId.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).investorIdProperty());
        this.inverstorSecId.setCellValueFactory(data -> ((ObCtpDeal)data.getValue()).inverstorSecIdProperty());
        this.tableCtpDeal.setPlaceholder((Node)new Label());
        this.tableCtpDeal.setItems(this.mxList.getPageList());
        TableUtils.orgnizeClmWidth(this.tableCtpDeal);
    }

    private void createSumTable() {
        this.colSecIdSum.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().secIdProperty());
        this.colSecNameSum.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().symbolProperty());
        this.colMarketSum.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().marketProperty());
        this.colDirSum.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getSide()));
        this.colDirSum.setCellFactory(cell -> new cms.tmx.query.utils.SideCell());
        this.colVolSum.setCellFactory(column -> new EditTableCell(0));
        this.colVolSum.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastQty()));
        this.colOCSum.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getOcFlag()));
        this.colSHSum.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getShFlag()));
        this.colPriceSum.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastPx()));
        this.colCount.setCellValueFactory(data -> new SimpleLongProperty(((CtpDeal)data.getValue()).getDealCount()));
        this.colAccSum.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInvestorId()));
        this.tableCtpDealSum.setPlaceholder((Node)new Label());
        this.tableCtpDealSum.setItems(this.mxSumList.getList());
        TableUtils.orgnizeClmWidth(this.tableCtpDealSum);
    }

    private class DealTypeCell
    extends TableCell<ObCtpDeal, MxNode> {
        private Label label = new Label();

        private DealTypeCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            ObCtpDeal deal = (ObCtpDeal)ObCtpDeal.class.cast(this.getTableRow().getItem());
            int side = StringUtils.parseInt((String)deal.getDealType().getRaw());
            this.label.setText(value.toString());
            switch (side) {
                case 1: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case 2: {
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class FeeCell<T>
    extends DoubleTableCell<T> {
        int scale = 3;

        private FeeCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class ObPriceCell
    extends DoubleTableCell<ObCtpDeal> {
        int scale = 3;

        private ObPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCtpDeal dealItem = (ObCtpDeal)ObCtpDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CtpDealPagePart.this.refMng.getItem(dealItem.getInstrument().getMarket().getRaw(), dealItem.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CtpDeal> {
        int scale = 5;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CtpDeal dealItem = (CtpDeal)CtpDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CtpDealPagePart.this.refMng.getItem(dealItem.getInstrument().getMarket().getRaw(), dealItem.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObCtpDeal, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            ObCtpDeal deal = (ObCtpDeal)ObCtpDeal.class.cast(this.getTableRow().getItem());
            int side = StringUtils.parseInt((String)deal.getSideRaw());
            this.label.setText(value);
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

