/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.query.current.views.CcsOrderPart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.stage.FileChooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;

public class ConvertibleOrderPart
extends CcsOrderPart {
    private static final Logger logger = LogManager.getLogger(ConvertibleOrderPart.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @FXML
    public void superExcel() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy/MM/dd");
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFRow row = null;
        row = spreadsheet.createRow(0);
        String[] head = new String[]{"\u5185\u90e8\u8bc1\u5238\u8d26\u6237\u4ee3\u7801", "\u5916\u90e8\u8bc1\u5238\u8d26\u6237\u4ee3\u7801", "\u4ea4\u6613\u65e5\u671f", "\u4ea4\u6613\u5e02\u573a", "\u4ea4\u6613\u5bf9\u624b", "\u5bf9\u624b\u65b9\u94f6\u884c\u8d26\u53f7", "\u4ea4\u6613\u5458", "\u6267\u884c\u5e02\u573a", "\u91d1\u878d\u5de5\u5177\u4ee3\u7801", "\u4ea4\u6613\u65b9\u5411", "\u4ef7\u683c(\u5143)", "\u4ea4\u6613\u9762\u989d(\u4e07)", "\u786e\u8ba4\u65e5\u671f", "\u9884\u8ba1\u6301\u6709\u5230\u671f\u65e5", "\u5907\u6ce8", "\u590d\u6838\u4eba", "\u4e2d\u4ecb\u673a\u6784", "\u4e2d\u4ecb\u8d39\u7528"};
        int j = 0;
        while (j < head.length) {
            HSSFCell cell = row.createCell(j);
            cell.setCellValue(head[j]);
            cell.setCellStyle(cellStyle);
            ++j;
        }
        int index = 1;
        int i = 0;
        while (i < this.tableOrder.getItems().size()) {
            ObservableList list = this.tableOrder.getItems();
            CcsOrder ccsOrder = (CcsOrder)list.get(i);
            if ("200".equals(ccsOrder.getSide().getRaw())) {
                row = spreadsheet.createRow(index);
                String date = ccsOrder.getOrdDate();
                Date d = null;
                try {
                    d = sdf.parse(date);
                }
                catch (ParseException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                int j2 = 0;
                while (j2 < head.length) {
                    if (head[j2].equals("\u5185\u90e8\u8bc1\u5238\u8d26\u6237\u4ee3\u7801")) {
                        row.createCell(j2).setCellValue("ZQ004");
                    } else if (head[j2].equals("\u5916\u90e8\u8bc1\u5238\u8d26\u6237\u4ee3\u7801")) {
                        row.createCell(j2).setCellValue(ccsOrder.getExtSecAccntId());
                    } else if (head[j2].equals("\u4ea4\u6613\u65e5\u671f")) {
                        row.createCell(j2).setCellValue(sdf2.format(d));
                    } else if (head[j2].equals("\u4ea4\u6613\u5e02\u573a")) {
                        row.createCell(j2).setCellValue(ccsOrder.getInstrument().getMarket().getValue());
                    } else if (head[j2].equals("\u4ea4\u6613\u5bf9\u624b")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u5bf9\u624b\u65b9\u94f6\u884c\u8d26\u53f7")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u4ea4\u6613\u5458")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u6267\u884c\u5e02\u573a")) {
                        row.createCell(j2).setCellValue(String.valueOf(ccsOrder.getInstrument().getMarket().getValue()) + "\u7ade\u4ef7\u7cfb\u7edf");
                    } else if (head[j2].equals("\u91d1\u878d\u5de5\u5177\u4ee3\u7801")) {
                        row.createCell(j2).setCellValue(ccsOrder.getInstrument().getSecId());
                    } else if (head[j2].equals("\u4ea4\u6613\u65b9\u5411")) {
                        row.createCell(j2).setCellValue("\u8ba4\u8d2d");
                    } else if (head[j2].equals("\u4ef7\u683c(\u5143)")) {
                        row.createCell(j2).setCellValue(ccsOrder.getPrice());
                    } else if (head[j2].equals("\u4ea4\u6613\u9762\u989d(\u4e07)")) {
                        if (ccsOrder.getInstrument().getMarket().getRaw().equals("XSHG")) {
                            row.createCell(j2).setCellValue((double)ccsOrder.getOrderQty() * 1000.0 / 10000.0);
                        } else if (ccsOrder.getInstrument().getMarket().getRaw().equals("XSHE")) {
                            row.createCell(j2).setCellValue((double)ccsOrder.getOrderQty() * 100.0 / 10000.0);
                        }
                    } else if (head[j2].equals("\u786e\u8ba4\u65e5\u671f")) {
                        Calendar c = Calendar.getInstance();
                        c.setTime(d);
                        int count = 0;
                        do {
                            c.add(5, 1);
                            if (c.get(7) == 1 || c.get(7) == 7) continue;
                            ++count;
                        } while (count < 3);
                        row.createCell(j2).setCellValue(sdf2.format(c.getTime()));
                    } else if (head[j2].equals("\u9884\u8ba1\u6301\u6709\u5230\u671f\u65e5")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u5907\u6ce8")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u590d\u6838\u4eba")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u4e2d\u4ecb\u673a\u6784")) {
                        row.createCell(j2).setCellValue("");
                    } else if (head[j2].equals("\u4e2d\u4ecb\u8d39\u7528")) {
                        row.createCell(j2).setCellValue("");
                    }
                    ++j2;
                }
                ++index;
            }
            ++i;
        }
        int j3 = 0;
        while (j3 < head.length) {
            spreadsheet.autoSizeColumn(j3);
            ++j3;
        }
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("excel files (*.xls)", new String[]{".xls"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName("\u8ba4\u8d2d\u7533\u8d2d\u8d4e\u56de--\u53ef\u8f6c\u503a\u7533\u8d2d");
        File file = chooser.showSaveDialog(null);
        try {
            if (file != null) {
                FileOutputStream out = new FileOutputStream(file);
                workbook.write((OutputStream)out);
                workbook.close();
                out.close();
            } else {
                workbook.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

