/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class CcsUnfinishedOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(CcsUnfinishedOrderPart.class);
    @FXML
    protected TableView<CcsOrder> tableUnOrder;
    @FXML
    protected TableColumn<CcsOrder, Boolean> selected;
    @FXML
    private TableColumn<CcsOrder, String> colSecId;
    @FXML
    private TableColumn<CcsOrder, String> colSecName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CcsOrder, String> colOrdTime;
    @FXML
    private TableColumn<CcsOrder, MxNode> colOrdStatus;
    @FXML
    private TableColumn<CcsOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CcsOrder, String> colUnit;
    @FXML
    private TableColumn<CcsOrder, String> colOrderId;
    @FXML
    private TableColumn<CcsOrder, String> colAccId;
    @FXML
    private TableColumn<CcsOrder, String> colCounterName;
    @FXML
    private TableColumn<CcsOrder, String> colSecAcc;
    @FXML
    private TableColumn<CcsOrder, Number> colPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colFrozenAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colDoneVol;
    @FXML
    private TableColumn<CcsOrder, Number> colPercent;
    @FXML
    private TableColumn<CcsOrder, Number> colAvgPrice;
    @FXML
    private TableColumn<CcsOrder, String> colBaseId;
    @FXML
    private TableColumn<CcsOrder, String> colType;
    @FXML
    private TableColumn<CcsOrder, String> colInfo;
    @FXML
    private TableColumn<CcsOrder, String> colUser;
    @FXML
    protected TableColumn<CcsOrder, String> colReference;
    @FXML
    protected TextField searchText;
    @FXML
    protected ComboBox<MxNode> cmbPriceTp;
    @FXML
    protected Spinner<Double> spnPriceFlP;
    @FXML
    protected Spinner<Double> spnPriceFlU;
    @FXML
    protected Label labFloatU;
    @FXML
    protected Label lbQuerying;
    @FXML
    protected HBox boxCancelAndOrder;
    @FXML
    protected Button btnOrderCancel;
    @FXML
    protected Button btnAllOrderCancel;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    @FXML
    protected CheckComboBox<String> ccmbAccnt;
    @FXML
    protected Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    protected Label lbMarket;
    @FXML
    protected CheckComboBox<String> ccmbSecAcc;
    @FXML
    protected Label lbSecAcc;
    protected String filterType = "";
    protected boolean accFalg = false;
    protected boolean secAccFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> secIds = new HashSet<String>();
    protected Set<String> accIds = new HashSet<String>();
    @Inject
    private IFundAccountService fundService;
    @Inject
    protected CcsUnfinishedOrderModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IUiRightService rightsModel;
    public static final String PRICE_ADJUST_UNIT = "price_adjust_unit";
    public static final String PRICE_ADJUST_UNIT_PERCENT = "1";
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    protected MxList<CcsOrder> mxList = new MxList();
    private MxGroup group = new MxGroup();
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    protected Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        if (en.getUserId().contains(text)) {
            return true;
        }
        if (en.getUserName().contains(text)) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    protected InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableUnOrder.sort();
            this.tableUnOrder.refresh();
        });
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getList(), this.pd);
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
        }
    };
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    protected DialogFactory df;
    @Inject
    private LoadPartModel load;

    @FXML
    public void initialize() {
        this.initValues();
        this.createTableView();
        this.bind();
        this.listener();
        this.checkRights();
        this.isPop();
        this.refresh();
        this.initCheckComboBox();
        this.tableUnOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder order = (CcsOrder)this.tableUnOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.unfinishedorder")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
    }

    protected void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
        this.lbqueryListener();
    }

    protected void lbqueryListener() {
        this.model.queryingProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (newV.booleanValue()) {
                this.lbQuerying.setVisible(true);
            } else {
                this.lbQuerying.setVisible(false);
            }
        }));
    }

    @PreDestroy
    protected void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
    }

    private void checkRights() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String unOrderUpdate = "";
        String unCancel = "";
        switch (parentId) {
            case "CMS-TMX-STOCK-PART-UNFINISHEDORDER": {
                unOrderUpdate = "cms.tmx.stock.part.unfinishedorder_update";
                unCancel = "cms.tmx.stock.part.unfinishedorder_cancel";
                break;
            }
            case "CMS-TMX-BOND-PART-UNFINISHEDORDER": {
                unOrderUpdate = "cms.tmx.bond.part.unfinishedorder_update";
                unCancel = "cms.tmx.bond.part.unfinishedorder_cancel";
                break;
            }
            case "CMS-TMX-FUND-PART-UNFINISHEDORDER": {
                unOrderUpdate = "cms.tmx.fund.part.unfinishedorder_update";
                unCancel = "cms.tmx.fund.part.unfinishedorder_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-UNFINISHED-QUERY": {
                unOrderUpdate = "cms.tmx.instructions.part.portfolio.basket.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.portfolio.basket.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-REGULAR-UNFINISHED-QUERY": {
                unOrderUpdate = "cms.tmx.instructions.part.regular.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.regular.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-UNFINISHED-QUERY": {
                unOrderUpdate = "cms.tmx.instructions.part.portfolio.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.portfolio.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-REPO-UNFINISHED-QUERY": {
                unOrderUpdate = "cms.tmx.instructions.part.portfolio.repo.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.portfolio.repo.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-BASKET-UNFINISHED-QUERY": {
                unOrderUpdate = "cms.tmx.instructions.part.basket.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.basket.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-FUND-PART-QUERY-UNFINISHED": {
                unCancel = "cms.tmx.fund.part.query.unfinished_cancel";
                break;
            }
            case "CMS-TMX-BOND-PART-REPO-UNFINISHEDORDER": {
                unOrderUpdate = "cms.tmx.bond.part.repo.unfinishedorder_update";
                unCancel = "cms.tmx.bond.part.repo.unfinishedorder_cancel";
                break;
            }
            case "CMS-TMX-CONDITION-PART-UNFINISHED": {
                unCancel = "cms.tmx.condition.part.unfinished_cancel";
                break;
            }
            case "CMS-TMX-STOCK-PART-RATIONED-UNFINISHED": {
                unOrderUpdate = "cms_tmx_stock_part_rationed_unfinished_update";
                unCancel = "cms_tmx_stock_part_rationed_unfinished_cancel";
                break;
            }
        }
        if (this.boxCancelAndOrder != null) {
            this.rightsModel.registerCheck((Pane)this.boxCancelAndOrder, new String[]{unOrderUpdate});
        }
        if (this.btnOrderCancel != null && this.rightsModel.registerCheck((Control)this.btnOrderCancel, new String[]{unCancel})) {
            TableUtils.doubleClicked(this.tableUnOrder, item -> {
                item.setSelected(true);
                this.orderCancelOne((CcsOrder)item);
                return true;
            });
        }
    }

    protected void bind() {
        this.cmbPriceTp.setItems(this.model.getPriceType().getNodes());
        this.model.priceFloatProperty().bindBidirectional((Property)this.spnPriceFlP.getEditor().textProperty());
        this.model.floatUnitProperty().bindBidirectional((Property)this.labFloatU.textProperty());
        this.cmbPriceTp.valueProperty().bindBidirectional(this.model.priceTypeProperty());
    }

    protected boolean premise(CcsOrder or) {
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains("\u5168\u90e8") || this.accIds.contains(or.getInvestorId());
            }
            case "2": {
                return this.secIds.contains("\u5168\u90e8") || this.secIds.contains(or.getInverstorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(or.getInstrument().getMarket().getRaw())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    protected void initValues() {
        MxNode node = MxNodeFactory.create((String)PRICE_ADJUST_UNIT, (String)PRICE_ADJUST_UNIT_PERCENT);
        this.labFloatU.textProperty().setValue(node.getValue());
        this.labFloatU.setOnMouseClicked(event -> this.changePriceUnit());
        this.labFloatU.getStyleClass().add((Object)"lbPercentYuan");
        this.group.add(new Control[]{this.spnPriceFlU, this.spnPriceFlP}).setVisible(new Control[]{this.spnPriceFlP});
        this.spnPriceFlU.getEditor().setText("0.000");
        this.spnPriceFlP.getEditor().setText("0.00");
        SpinnerUtils.arrowsStyle(this.spnPriceFlP);
        SpinnerUtils.arrowsStyle(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 3, 3, 1000.0).ctrl(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 2, 2, 100.0).ctrl(this.spnPriceFlP);
    }

    protected void changePriceUnit() {
        if ("%".equals(this.labFloatU.getText())) {
            this.labFloatU.setText("\u5143");
            this.group.setVisible(new Control[]{this.spnPriceFlU});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlP.getEditor().textProperty(), (Property)this.spnPriceFlU.getEditor().textProperty());
        } else {
            this.labFloatU.setText("%");
            this.group.setVisible(new Control[]{this.spnPriceFlP});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlU.getEditor().textProperty(), (Property)this.spnPriceFlP.getEditor().textProperty());
        }
    }

    protected void createTableView() {
        this.tableUnOrder.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder ord;
            if (event.getClickCount() == 1 && (ord = (CcsOrder)this.tableUnOrder.getSelectionModel().getSelectedItem()) != null) {
                String code = ord.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)ord.getInstrument().getSecType());
                eCall.put((Object)"tMarket", (Object)ord.getInstrument().getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setCellValueFactory(data -> ((CcsOrder)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.colSecId.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        if (this.colCounterName != null) {
            this.colCounterName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getCounterName()));
        }
        this.colSecName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colOrderAmt.setCellFactory(p -> new PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new PriceCell());
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getCumQty()));
        this.colDoneVol.setCellFactory(cell -> new NumberTableCell());
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new AvgPriceCell());
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTypeDesc()));
        this.colBaseId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getBaseId()));
        this.colOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getOrdStatus()));
        this.colMarket.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().marketProperty());
        this.colUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUnit()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrderId()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInverstorSecId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserId()));
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getReference()));
        this.tableUnOrder.setItems(this.mxList.getList());
        this.tableUnOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableUnOrder);
        this.colOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableUnOrder.getSortOrder().add(this.colOrdTime);
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableUnOrder, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableUnOrder, (String)"\u672a\u5b8c\u6210\u59d4\u6258\u67e5\u8be2", (int)1, (int)(this.tableUnOrder.getColumns().size() - 1));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void refresh() {
        this.model.query();
    }

    @FXML
    protected void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        this.ordersCancel((List<CcsOrder>)list, "\u64a4\u5355\u786e\u8ba4", false, TIP);
    }

    @FXML
    protected void allOrderCancel() {
        ObservableList list = this.mxList.getList();
        this.allOrdersCancel((List<CcsOrder>)list, "\u64a4\u5355\u786e\u8ba4", false);
    }

    protected void allOrdersCancel(List<CcsOrder> list, String dialogName, boolean isDiskless) {
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.ERROR, TIP)) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog(list, dialogName, isDiskless)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.model.cancel(list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    protected void ordersCancel(List<CcsOrder> list, String dialogName, boolean isDiskless, String tip) {
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.ERROR, tip)) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog(list, dialogName, isDiskless)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = this.model.cancel(list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    private boolean createDialog(List<CcsOrder> list, String dialogName, boolean isDiskless) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CcsOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setOrderId(or.getOrderId());
            if (!StringUtils.isEmpty((String)or.getReference())) {
                en.setReference(or.getReference());
            }
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            en.setQuantity(or.getOrderQty() - or.getCumQty());
            en.setPrice(or.getPrice());
            if ("XSHG".equals(or.getInstrument().getMarket().getRaw()) && "BOND".equals(or.getInstrument().getSecType())) {
                en.setAmt((double)en.getQuantity() * en.getPrice() * 10.0);
            } else {
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        obj.setIsDiskless(isDiskless);
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    protected void orderCancelOne(CcsOrder order) {
        ObservableList list = FxUtils.newList();
        list.add((Object)order);
        if (list.size() < 1) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog((List<CcsOrder>)list, "\u64a4\u5355\u786e\u8ba4", false)) {
            return;
        }
        MEvent event = this.model.cancel((List<CcsOrder>)list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    @FXML
    private void cancelAndOrder() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        boolean containsSAT = false;
        for (CcsOrder ccsOrder : list) {
            if (StringUtils.isEmpty((String)ccsOrder.getInstrument().getSecId()) || !StringUtils.isEmpty((String)ccsOrder.getReference()) || !ccsOrder.getInstrument().getSecId().startsWith("688") || ccsOrder.getOrdType() != 49) continue;
            containsSAT = true;
            break;
        }
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)((Object)this.of.create(CcsReplaceConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        HashMap<CcsCancelEntrust, CcsOrder> satEnOrMap = new HashMap<CcsCancelEntrust, CcsOrder>();
        HashMap<CcsCancelEntrust, CcsOrder> enOrMap = new HashMap<CcsCancelEntrust, CcsOrder>();
        ArrayList<String> referenceIds = new ArrayList<String>();
        this.model.queryMarketItem((List<CcsOrder>)list);
        for (CcsOrder or2 : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or2.getExtAccntId(), or2.getExtSecAccntId());
            en.setSec(or2.getInstrument().getSecId());
            en.setSecName(or2.getInstrument().getSymbol());
            en.setAcc(or2.getInvestorId());
            en.setSecAcc(or2.getInverstorSecId());
            en.setSecType(or2.getInstrument().getSecType());
            en.setMarket(or2.getInstrument().getMarket().getRaw());
            en.setOrderType(or2.getOrdType());
            if (or2.getOrdType() == 99) {
                en.setOrderTypeStr("\u76d8\u540e\u56fa\u5b9a\u4ef7");
            }
            en.setOrderId(or2.getOrderId());
            en.setQuantity(or2.getOrderQty() - or2.getCumQty());
            en.setSide(or2.getSide());
            en.setPrice(this.model.getNewPrice((Order)or2, StringUtils.parseInt((String)this.model.getPriceType().getRaw()), this.model.getFloatUnit(), this.model.getPriceFloat()));
            if (!StringUtils.isEmpty((String)or2.getReference())) {
                en.setReference(or2.getReference());
                referenceIds.add(or2.getReference());
            }
            or2.setNewPrice(en.getPrice());
            if ("XSHG".equals(or2.getInstrument().getMarket().getRaw()) && "BOND".equals(or2.getInstrument().getSecType())) {
                en.setAmt(BigDecimal.valueOf(en.getQuantity()).multiply(BigDecimal.valueOf(en.getPrice())).doubleValue() * 10.0);
            } else {
                en.setAmt(BigDecimal.valueOf(en.getQuantity()).multiply(BigDecimal.valueOf(en.getPrice())).doubleValue());
            }
            if (StringUtils.isEmpty((String)or2.getReference()) && 50 == or2.getOrdType() && Double.doubleToLongBits(or2.getNewPrice()) == Double.doubleToLongBits(or2.getPrice())) {
                en.setTip("".equals(or2.getOrderId()) ? null : "\u4e0e\u539f\u59d4\u6258\u4ef7\u683c\u76f8\u540c\uff0c\u65e0\u9700\u64a4\u5355\u91cd\u4e0b\u3002\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getOrderId());
                or2.setCanCancelReplace(false);
                en.setIsModified(true);
            } else {
                or2.setCanCancelReplace(true);
                en.setTip("".equals(or2.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getOrderId());
            }
            if (or2.getInstrument().getSecId() != null && or2.getInstrument().getSecId().startsWith("688") && or2.getOrdType() == 49) {
                satEnOrMap.put(en, or2);
            }
            enList.add(en);
            enOrMap.put(en, or2);
        }
        if (containsSAT) {
            if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u60a8\u9009\u4e2d\u7684\u9879\u76ee\u5305\u542b\u975e\u6307\u4ee4\u79d1\u521b\u677f\u5e02\u4ef7\u5355\uff0c\u64a4\u5355\u91cd\u4e0b\u540e\u53d8\u6210\u9650\u4ef7\u5355", "\u64a4\u5355\u91cd\u4e0b\u63d0\u9192")) {
                return;
            }
            this.model.checkSATPrice(satEnOrMap);
        }
        if (referenceIds.size() > 0) {
            try {
                this.model.checkInstructionPrice(enOrMap, referenceIds);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u6307\u4ee4\u4fe1\u606f\u5931\u8d25");
                logger.error("get instruction failed : " + e.getMessage());
                return;
            }
        }
        this.sort(enList);
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355\u91cd\u4e0b");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u91cd\u4e0b\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\u91cd\u4e0b\uff01");
            return;
        }
        FilteredList filteredList = list.filtered(or -> or.isCanCancelReplace());
        if (filteredList.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u4e0d\u7b26\u5408\u64a4\u5355\u91cd\u4e0b\u6761\u4ef6\u3002");
            return;
        }
        MEvent event = this.model.cancelAndOrder((List<CcsOrder>)filteredList);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    private void sort(List<CcsCancelEntrust> enList) {
        Collections.sort(enList, new Comparator<CcsCancelEntrust>(){

            @Override
            public int compare(CcsCancelEntrust o1, CcsCancelEntrust o2) {
                if (o2.isIsModified() && !o1.isIsModified()) {
                    return 1;
                }
                if (o1.isIsModified() && !o2.isIsModified()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public boolean extend(CcsOrder en) {
        return false;
    }

    protected void isPop() {
        String parentId;
        switch (parentId = this.p.getParent().getParent().getId().toUpperCase()) {
            case "CMS-TMX-STOCK-PART-UNFINISHEDORDER": {
                this.model.setType(PRICE_ADJUST_UNIT_PERCENT, "200001");
                break;
            }
            case "CMS-TMX-BOND-PART-UNFINISHEDORDER": {
                this.model.setType("3", "200003");
                break;
            }
            case "CMS-TMX-FUND-PART-UNFINISHEDORDER": {
                this.model.setType("2", "200002");
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-REGULAR-UNFINISHED-QUERY": {
                this.model.setType("5", "200058");
                break;
            }
        }
        this.model.doSet();
    }

    protected void initCheckComboBox() {
        this.initFilterAcc();
        this.initFilterSecAcc();
        this.initFilterMarket();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"pos_filter_type");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "2": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(true);
                    this.lbSecAcc.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    break;
                }
            }
            this.lstnSearch.invalidated(null);
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.lstnSearch.invalidated(null);
        this.accFalg = true;
        this.marketFalg = true;
        this.secAccFalg = true;
    }

    protected void initFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"ccs_pos_market_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }

    protected void initFilterAcc() {
        LinkedList<String> listAccnt = new LinkedList<String>();
        listAccnt.add("\u5168\u90e8");
        this.fundService.getFundAccountList("CCS").forEach(fund -> {
            boolean bl = listAccnt.add(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName());
        });
        this.ccmbAccnt.getItems().addAll(listAccnt);
        this.ccmbAccnt.getCheckModel().checkAll();
        int i = 1;
        while (i < listAccnt.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.accFalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (String id : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(id.split("__")[0]);
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    protected void initFilterSecAcc() {
        LinkedList<String> listSecAccnt = new LinkedList<String>();
        listSecAccnt.add("\u5168\u90e8");
        listSecAccnt.addAll(this.model.getInvestorSecIds());
        this.ccmbSecAcc.getItems().addAll(listSecAccnt);
        this.ccmbSecAcc.getCheckModel().checkAll();
        this.lbSecAcc.setText("\u5168\u90e8");
        this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
        this.secIds.clear();
        for (String secAccount : listSecAccnt) {
            this.secIds.add(secAccount);
        }
        int i = 1;
        while (i < listSecAccnt.size()) {
            this.ccmbSecAcc.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.secAccFalg) {
                    this.secAccFalg = false;
                    if (!now.booleanValue() && this.ccmbSecAcc.getItemBooleanProperty(0).get()) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbSecAcc.getItems().size() - this.ccmbSecAcc.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.secAccFalg = true;
                }
            });
            ++i;
        }
        this.ccmbSecAcc.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.secAccFalg) {
                this.secAccFalg = false;
                if (now.booleanValue()) {
                    this.ccmbSecAcc.getCheckModel().checkAll();
                } else {
                    this.ccmbSecAcc.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.secAccFalg = true;
            }
        });
        this.ccmbSecAcc.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbSecAcc.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbSecAcc.setText(accStr);
            this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
            this.secIds.clear();
            this.secIds.addAll((Collection<String>)this.ccmbSecAcc.getCheckModel().getCheckedItems());
        });
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsUnfinishedOrderPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsUnfinishedOrderPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<CcsOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

