/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.query.current.views.CcsUnfinishedOrderPart;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.utils.FundAccountStringConverter;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class CcsUnfinishedOrderCreaterPart
extends CcsUnfinishedOrderPart {
    private static final Logger logger = LogManager.getLogger(CcsUnfinishedOrderPart.class);
    @FXML
    protected TableView<CcsOrder> tableUnOrder;
    @FXML
    private Label lbAccnt;
    @FXML
    protected TableColumn<CcsOrder, Boolean> selected;
    @FXML
    private TableColumn<CcsOrder, String> colSecId;
    @FXML
    private TableColumn<CcsOrder, String> colSecName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CcsOrder, String> colOrdTime;
    @FXML
    private TableColumn<CcsOrder, String> colOrdStatus;
    @FXML
    private TableColumn<CcsOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CcsOrder, String> colUnit;
    @FXML
    private TableColumn<CcsOrder, String> colOrderId;
    @FXML
    private TableColumn<CcsOrder, String> colAccId;
    @FXML
    private TableColumn<CcsOrder, String> colSecAcc;
    @FXML
    private TableColumn<CcsOrder, Number> colPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colTotalValue;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colFrozenAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colDoneVol;
    @FXML
    private TableColumn<CcsOrder, Number> colPercent;
    @FXML
    private TableColumn<CcsOrder, Number> colAvgPrice;
    @FXML
    private TableColumn<CcsOrder, String> colBaseId;
    @FXML
    private TableColumn<CcsOrder, String> colType;
    @FXML
    private TableColumn<CcsOrder, String> colInfo;
    @FXML
    private TableColumn<CcsOrder, String> colUser;
    @FXML
    protected TableColumn<CcsOrder, String> colReference;
    @FXML
    protected TableColumn<CcsOrder, String> colAccName;
    @FXML
    protected TextField searchText;
    @FXML
    protected ComboBox<AssetGrp> cbAssetGrp;
    @FXML
    protected CheckComboBox<FundAccount> ccmbAccnt;
    @Inject
    private AccountMngServiceImpl accMngService;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private IBaseApi iba;
    private List<FundAccount> fundAccs = new ArrayList<FundAccount>();
    @FXML
    protected CheckBox cbSumByPrice;
    @FXML
    protected Label lbSum;
    @FXML
    protected Label lbOrderNum;
    @FXML
    protected Label lbOrderAmt;
    @FXML
    protected Label lbDoneVol;
    @FXML
    protected Label lbTotalValue;
    @FXML
    protected Label lbPercent;
    @FXML
    protected CheckBox cbSH;
    @FXML
    protected CheckBox cbSZ;
    @FXML
    protected CheckBox cbBuy;
    @FXML
    protected CheckBox cbSell;
    @FXML
    protected Button cancel;
    @Inject
    private IFundAccountService fundService;
    @Inject
    protected CcsUnfinishedOrderModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IUiRightService rightsModel;
    boolean ccmbfalg = false;
    public static final String PRICE_ADJUST_UNIT = "price_adjust_unit";
    public static final String PRICE_ADJUST_UNIT_PERCENT = "1";
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    protected MxList<CcsOrder> mxList = new MxList();
    protected MxList<CcsOrder> mxSumList = new MxList();
    private MxGroup group = new MxGroup();
    protected Map<String, CheckBox> mapCBox = new HashMap<String, CheckBox>();
    Map<String, List<CcsOrder>> ordsMap = new HashMap<String, List<CcsOrder>>();
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    protected FundAccount fundAll = new FundAccount();
    protected AssetGrp assetAll = new AssetGrp();
    protected Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        boolean flag = false;
        ObservableList listAccnt = this.ccmbAccnt.getCheckModel().getCheckedItems();
        for (FundAccount acc : listAccnt) {
            if (acc == null || !acc.getInvestId().equals(en.getInvestorId())) continue;
            flag = true;
            break;
        }
        CheckBox cboxMarket = this.mapCBox.get(en.getInstrument().getMarket().getRaw());
        if (cboxMarket != null && !cboxMarket.isSelected()) {
            return false;
        }
        CheckBox cboxSide = this.mapCBox.get(en.getSide().getRaw());
        if (cboxSide != null && !cboxSide.isSelected()) {
            return false;
        }
        if (this.assetAll.equals(this.cbAssetGrp.getSelectionModel().getSelectedItem()) && listAccnt.contains(this.fundAll)) {
            flag = true;
        }
        if (en.getInstrument().getSecId().contains(text) && flag) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    protected InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        List newList = Collections.synchronizedList(new ArrayList());
        List<CcsOrder> newSumList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
            newSumList.addAll(this.createSumList((List<CcsOrder>)this.model.getList()));
        }
        this.mxList.update(newList, this.pd);
        this.mxSumList.update(newSumList, this.pd);
        System.out.println("");
        Platform.runLater(() -> {
            if (this.cbSumByPrice.isSelected()) {
                this.sumNum(this.mxSumList);
            } else {
                this.sumNum(this.mxList);
            }
            if (this.cbSumByPrice.isSelected()) {
                Collections.sort(this.mxSumList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            } else {
                Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            }
        });
        this.tableUnOrder.sort();
        this.tableUnOrder.refresh();
    };
    protected InvalidationListener lstnSearch = ob -> {
        this.mxList.filter(this.model.getList(), this.pd);
        this.mxSumList.filter(this.createSumList((List<CcsOrder>)this.model.getList()), this.pd);
        Platform.runLater(() -> {
            if (this.cbSumByPrice.isSelected()) {
                this.sumNum(this.mxSumList);
            } else {
                this.sumNum(this.mxList);
            }
        });
        this.tableUnOrder.sort();
        this.tableUnOrder.refresh();
    };
    protected InvalidationListener lstnCCmb = ob -> {
        this.mxList.filter(this.model.getList(), this.pd);
        this.mxSumList.filter(this.createSumList((List<CcsOrder>)this.model.getList()), this.pd);
        Platform.runLater(() -> {
            if (this.cbSumByPrice.isSelected()) {
                this.sumNum(this.mxSumList);
            } else {
                this.sumNum(this.mxList);
            }
        });
        this.tableUnOrder.sort();
        this.tableUnOrder.refresh();
    };
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    protected DialogFactory df;
    @Inject
    private LoadPartModel load;
    @Inject
    private OrderFactory orderFactory;

    @Override
    @PreDestroy
    protected void close() {
        super.close();
        this.model.changedProperty().removeListener(this.lstnModel);
        this.ccmbAccnt.getCheckModel().getCheckedItems().removeListener(this.lstnCCmb);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void initCheckBox() {
        this.mapCBox.put("XSHG", this.cbSH);
        this.mapCBox.put("XSHE", this.cbSZ);
        this.mapCBox.put("49", this.cbBuy);
        this.mapCBox.put("50", this.cbSell);
        CheckBox cbox = new CheckBox();
        cbox.setSelected(false);
        this.mapCBox.put("71", cbox);
        this.mapCBox.put("70", this.cbBuy);
        this.cbSH.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
        this.cbSZ.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
        this.cbBuy.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
        this.cbSell.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
    }

    @Override
    @FXML
    public void initialize() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.createTableView();
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(this.lstnCCmb);
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getList();
            synchronized (observableList) {
                this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
            observableList = this.mxSumList.getList();
            synchronized (observableList) {
                this.mxSumList.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
        this.checkRights();
        this.isPop();
        this.initCheckBox();
        this.refresh();
        this.tableUnOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder order = (CcsOrder)this.tableUnOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.unfinishedorder")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
        this.initCheckCmbBox();
        this.initChackSumBox();
        this.initAssetGrp();
        this.cbSumByPrice.setSelected(true);
        this.lstnSearch.invalidated(null);
        this.cancel.setVisible(false);
    }

    private void initChackSumBox() {
        this.cbSumByPrice.selectedProperty().addListener((ob, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                Collections.sort(this.mxSumList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
                this.tableUnOrder.setItems(this.mxSumList.getList());
                Platform.runLater(() -> this.sumNum(this.mxSumList));
                this.tableUnOrder.sort();
                this.tableUnOrder.refresh();
            } else {
                Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
                this.tableUnOrder.setItems(this.mxList.getList());
                Platform.runLater(() -> this.sumNum(this.mxList));
                this.tableUnOrder.sort();
                this.tableUnOrder.refresh();
            }
        });
    }

    @Override
    protected void initCheckComboBox() {
    }

    private void initCheckCmbBox() {
        this.fundAll.setExtAccntId("\u5168\u90e8");
        this.fundAll.setInvestId("\u5168\u90e8");
        this.ccmbAccnt.getItems().add((Object)this.fundAll);
        this.fundAccs = this.fundService.getAllFundAccountList();
        this.ccmbAccnt.getItems().addAll(this.fundAccs);
        this.ccmbAccnt.setConverter((StringConverter)new FundAccountStringConverter());
        this.ccmbAccnt.getCheckModel().checkAll();
        this.ccmbAccntLis();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(this.fundAll)) {
                accStr = "";
                for (FundAccount fundAccount : listItem) {
                    if (fundAccount == null) continue;
                    accStr = String.valueOf(accStr) + fundAccount.getInvestId() + "__" + fundAccount.getAccountName() + ",";
                }
                if (!StringUtils.isEmpty((String)accStr)) {
                    accStr = accStr.substring(0, accStr.length() - 1);
                }
            }
            this.lstnSearch.invalidated(null);
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
        this.lstnSearch.invalidated(null);
        this.ccmbfalg = true;
        this.initAssetGrp();
    }

    private void ccmbAccntLis() {
        int i = 1;
        while (i < this.ccmbAccnt.getItems().size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.ccmbfalg) {
                    this.ccmbfalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.ccmbfalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.ccmbfalg) {
                this.ccmbfalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.ccmbfalg = true;
            }
        });
    }

    private void initAssetGrp() {
        try {
            this.assetAll.setId("\u5168\u90e8");
            this.assetAll.setName("\u5168\u90e8");
            this.cbAssetGrp.getItems().setAll((Object[])new AssetGrp[]{this.assetAll});
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            ArrayList listAsset = new ArrayList();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && PRICE_ADJUST_UNIT_PERCENT.equals(item.getType().getRaw())) {
                    listAsset.add(item);
                }
            });
            for (AssetGrp assetGrp : listAsset) {
                String[] ids;
                String[] stringArray = ids = assetGrp.getAssetUnitId().split(",");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String accntId = stringArray[n2];
                    Account acc = this.accMngService.getAccountById(accntId);
                    if (acc != null) {
                        assetGrp.getInvestorIds().add(acc.getInvestorId());
                    }
                    ++n2;
                }
            }
            this.cbAssetGrp.getItems().addAll(listAsset);
        }
        catch (MException e) {
            logger.error("\u8d44\u4ea7\u7ec4\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        this.cbAssetGrp.getSelectionModel().select(0);
        this.cbAssetGrp.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            if ("\u5168\u90e8".equals(newV.getId())) {
                this.ccmbAccnt.getItems().clear();
                this.ccmbAccnt.getItems().add((Object)this.fundAll);
                this.ccmbAccnt.getItems().addAll(this.fundAccs);
                this.ccmbAccnt.getCheckModel().checkAll();
            } else {
                this.ccmbAccnt.getItems().clear();
                this.ccmbAccnt.getItems().add((Object)this.fundAll);
                ArrayList<FundAccount> funds = new ArrayList<FundAccount>();
                for (FundAccount fa : this.fundAccs) {
                    if (!newV.getInvestorIds().contains(fa.getInvestId())) continue;
                    funds.add(fa);
                }
                this.ccmbAccnt.getItems().addAll(funds);
                this.ccmbAccnt.getCheckModel().checkAll();
            }
            this.ccmbAccntLis();
        });
    }

    /*
     * Unable to fully structure code
     */
    private void checkRights() {
        var2_2 = parentId = this.p.getParent().getParent().getId().toUpperCase();
        tmp = -1;
        switch (var2_2.hashCode()) {
            case -2075212694: {
                if (var2_2.equals("CMS-TMX-BOND-PART-REPO-UNFINISHEDORDER")) {
                    tmp = 1;
                }
                break;
            }
            case -1872511557: {
                if (var2_2.equals("CMS-TMX-INSTRUCTIONS-PART-REGULAR-UNFINISHED-QUERY")) {
                    tmp = 1;
                }
                break;
            }
            case -1445971820: {
                if (var2_2.equals("CMS-TMX-FUND-PART-QUERY-UNFINISHED")) {
                    tmp = 1;
                }
                break;
            }
            case -1242412732: {
                if (var2_2.equals("CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-UNFINISHED-QUERY")) {
                    tmp = 1;
                }
                break;
            }
            case -1023758510: {
                if (var2_2.equals("CMS-TMX-STOCK-PART-UNFINISHEDORDER")) {
                    tmp = 1;
                }
                break;
            }
            case -87482561: {
                if (var2_2.equals("CMS-TMX-FUND-PART-UNFINISHEDORDER")) {
                    tmp = 1;
                }
                break;
            }
            case 33460737: {
                if (var2_2.equals("CMS-TMX-BOND-PART-UNFINISHEDORDER")) {
                    tmp = 1;
                }
                break;
            }
            case 511289487: {
                if (var2_2.equals("CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-UNFINISHED-QUERY")) {
                    tmp = 1;
                }
                break;
            }
            case 551532195: {
                if (var2_2.equals("CMS-TMX-INSTRUCTIONS-PART-REGULAR-CCSUNFINISHEDORDER-CREATER-QUERY-ZY")) {
                    tmp = 1;
                }
                break;
            }
            case 1445745129: {
                if (!var2_2.equals("CMS-TMX-INSTRUCTIONS-PART-BASKET-UNFINISHED-QUERY")) break;
                tmp = 1;
                break;
            }
        }
        ** switch (tmp)
lbl56:
        // 2 sources

    }

    @Override
    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @FXML
    public void cancel() {
    }

    @Override
    protected void createTableView() {
        this.tableUnOrder.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder ord;
            if (event.getClickCount() == 1 && (ord = (CcsOrder)this.tableUnOrder.getSelectionModel().getSelectedItem()) != null) {
                String code = ord.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)ord.getInstrument().getSecType());
                eCall.put((Object)"tMarket", (Object)ord.getInstrument().getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setCellValueFactory(data -> ((CcsOrder)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.colSecId.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colOrderAmt.setCellFactory(p -> new PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new PriceCell());
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getCumQty()));
        this.colDoneVol.setCellFactory(cell -> new NumberTableCell());
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new AvgPriceCell());
        this.colTotalValue.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getTotalValue()));
        this.colTotalValue.setCellFactory(p -> new AvgPriceCell());
        this.colAccName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getAccName()));
        this.colAccName.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((CcsOrder)this.getValue()).getAccName();
            }
        });
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTypeDesc()));
        this.colBaseId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getBaseId()));
        this.colOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getExOrdStatus()));
        this.colMarket.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().marketProperty());
        this.colUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUnit()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrderId()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInverstorSecId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserId()));
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getReference()));
        if (this.cbSumByPrice.isSelected()) {
            this.tableUnOrder.setItems(this.mxSumList.getList());
        } else {
            this.tableUnOrder.setItems(this.mxList.getList());
        }
        this.tableUnOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableUnOrder);
        this.colOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableUnOrder.getSortOrder().add(this.colOrdTime);
    }

    @Override
    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableUnOrder, (int)1, (int)0);
    }

    @Override
    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableUnOrder, (String)"\u672a\u5b8c\u6210\u59d4\u6258\u67e5\u8be2", (int)1, (int)(this.tableUnOrder.getColumns().size() - 1));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @Override
    @FXML
    protected void refresh() {
        this.model.query();
        Platform.runLater(() -> {
            if (this.cbSumByPrice.isSelected()) {
                this.sumNum(this.mxSumList);
            } else {
                this.sumNum(this.mxList);
            }
        });
    }

    @Override
    public boolean extend(CcsOrder en) {
        return false;
    }

    @Override
    protected void isPop() {
        String parentId;
        switch (parentId = this.p.getParent().getParent().getId().toUpperCase()) {
            case "CMS-TMX-STOCK-PART-UNFINISHEDORDER": {
                this.model.setType(PRICE_ADJUST_UNIT_PERCENT, "200001");
                break;
            }
            case "CMS-TMX-BOND-PART-UNFINISHEDORDER": {
                this.model.setType("3", "200003");
                break;
            }
            case "CMS-TMX-FUND-PART-UNFINISHEDORDER": {
                this.model.setType("2", "200002");
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-REGULAR-UNFINISHED-QUERY": {
                this.model.setType("5", "200058");
                break;
            }
        }
        this.model.doSet();
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private List<CcsOrder> createSumList(List<CcsOrder> mxNewList) {
        HashMap<String, CcsOrder> map = new HashMap<String, CcsOrder>();
        this.ordsMap.clear();
        LinkedList<CcsOrder> list = new LinkedList<CcsOrder>();
        for (CcsOrder order : mxNewList) {
            CcsOrder newOrder;
            String key = this.getKey(order);
            if (order.getSide().getRaw().equals("70")) {
                newOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
                newOrder.update((Object)order);
                list.add(newOrder);
                continue;
            }
            if (this.ordsMap.get(key) == null) {
                LinkedList<CcsOrder> lists = new LinkedList<CcsOrder>();
                CcsOrder newOrder2 = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
                newOrder2.update((Object)order);
                lists.add(newOrder2);
                this.ordsMap.put(key, lists);
            } else {
                this.ordsMap.get(key).add(order);
            }
            if (map.get(key) == null) {
                newOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
                newOrder.update((Object)order);
                list.add(newOrder);
                map.put(key, newOrder);
                continue;
            }
            CcsOrder oldOrder = (CcsOrder)map.get(key);
            int qty = order.getOrderQty();
            double amount = order.getOrderAmt();
            double frozenMargin = order.getFrozenMargin();
            int cumQty = order.getCumQty();
            double totalValue = order.getTotalValue();
            double filledAvgPrice = order.getFilledAvgPrice();
            int oldQty = oldOrder.getOrderQty();
            double oldAmount = oldOrder.getOrderAmt();
            double oldFrozenMargin = oldOrder.getFrozenMargin();
            int oldCumQty = oldOrder.getCumQty();
            double oldTotalValue = oldOrder.getTotalValue();
            double oldProductOfAvgAndQty = oldOrder.getProductOfAvgAndQty();
            oldOrder.setOrderQty(oldQty + qty);
            oldOrder.setOrderAmt(oldAmount + amount);
            oldOrder.setFrozenMargin(frozenMargin + oldFrozenMargin);
            oldOrder.setCumQty(oldCumQty + cumQty);
            oldOrder.setTotalValue(oldTotalValue + totalValue);
            oldOrder.setProductOfAvgAndQty(oldProductOfAvgAndQty + filledAvgPrice * (double)cumQty);
        }
        for (CcsOrder ccsOrder : list) {
            if (ccsOrder.getSide().getRaw().equals("70")) continue;
            if (ccsOrder.getOrderQty() != 0) {
                int orderQty = ccsOrder.getOrderQty();
                if ("XSHG".equals(ccsOrder.getInstrument().getMarket().getRaw()) && "BOND".equals(ccsOrder.getInstrument().getSecType())) {
                    orderQty *= 10;
                }
                ccsOrder.setPrice(ccsOrder.getOrderAmt() / (double)orderQty);
            }
            ccsOrder.setDonePercent((double)ccsOrder.getCumQty() * 1.0 / (double)ccsOrder.getOrderQty() * 100.0);
            if (ccsOrder.getCumQty() != 0) {
                int cumQty = ccsOrder.getCumQty();
                if ("XSHG".equals(ccsOrder.getInstrument().getMarket().getRaw()) && "BOND".equals(ccsOrder.getInstrument().getSecType())) {
                    cumQty *= 10;
                }
                ccsOrder.setAvgPx(ccsOrder.getTotalValue() / (double)cumQty);
            } else {
                ccsOrder.setAvgPx(0.0);
            }
            ccsOrder.setOrdTime("");
            ccsOrder.setOrderId("");
            ccsOrder.setUserId("");
            ccsOrder.setErrInfo("");
            ccsOrder.setBaseId("");
            ccsOrder.setOrdTypeDesc("");
            ccsOrder.setReference("");
            ccsOrder.setExOrdStatus("");
        }
        return list;
    }

    protected String getKey(CcsOrder order) {
        String key = String.valueOf(order.getExtAccntId()) + order.getSecId() + order.getSide().getRaw() + order.getPrice();
        return key;
    }

    private void sumNum(MxList<CcsOrder> mxListSum) {
        this.lbSum.setText("0");
        this.lbOrderNum.setText("0");
        this.lbOrderAmt.setText("0");
        this.lbDoneVol.setText("0");
        this.lbTotalValue.setText("0");
        this.lbPercent.setText("0");
        double orderAmt = 0.0;
        int orderNum = 0;
        double doneVol = 0.0;
        double totalValue = 0.0;
        double percent = 0.0;
        for (CcsOrder order : mxListSum.getList()) {
            orderAmt += order.getOrderAmt();
            orderNum += order.getOrderQty();
            doneVol += (double)order.getCumQty();
            totalValue += order.getTotalValue();
        }
        if (totalValue != 0.0) {
            percent = totalValue / orderAmt * 100.0;
        }
        this.lbSum.setText(StringUtils.toThousands((Number)mxListSum.getList().size()));
        this.lbOrderNum.setText(StringUtils.toThousands((Number)orderNum));
        this.lbOrderAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbDoneVol.setText(StringUtils.toThousands((Number)doneVol));
        this.lbTotalValue.setText(StringUtils.toThousands((Number)totalValue, (int)2));
        this.lbPercent.setText(StringUtils.toThousands((Number)percent, (int)2));
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsUnfinishedOrderCreaterPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsUnfinishedOrderCreaterPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<CcsOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

