/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.query.current.models.PositionCarriedForwardModel;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class CcsSetMailDialog
extends DialogObj {
    @FXML
    private TableView<FundAccount> tableItems;
    @FXML
    private TableColumn<FundAccount, String> index;
    @FXML
    private TableColumn<FundAccount, String> colAcc;
    @FXML
    private TableColumn<FundAccount, String> colAccName;
    @FXML
    private TableColumn<FundAccount, String> colMail;
    @FXML
    private Label labSuccess;
    @Inject
    private PositionCarriedForwardModel model;
    private ObservableList<FundAccount> list;
    @Inject
    private MxAlert alert;
    private static final Logger logger = Logger.getLogger(CcsSetMailDialog.class);
    private static final String EMAIL = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
    String oldValue = "";

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.createTable();
    }

    @FXML
    public void save() {
        try {
            this.model.updateAccntEmail((List<FundAccount>)this.list);
            this.labSuccess.setVisible(true);
        }
        catch (MException e) {
            logger.error((Object)("\u66f4\u65b0\u90ae\u7bb1\u5931\u8d25" + e.getMessage()), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createTable() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colAcc.setCellValueFactory(m -> ((FundAccount)m.getValue()).investIdProperty());
        this.colAccName.setCellValueFactory(m -> ((FundAccount)m.getValue()).accountNameProperty());
        this.colMail.setCellValueFactory(m -> ((FundAccount)m.getValue()).emailProperty());
        this.colMail.setCellFactory(pw -> new MxEditTableCell());
        this.colMail.setEditable(true);
        this.colMail.addEventHandler(TableColumn.editCommitEvent(), handler -> {
            FundAccount acc;
            String newValue = handler.getNewValue().toString().trim();
            this.oldValue = "";
            if (handler.getOldValue() != null) {
                this.oldValue = handler.getOldValue().toString();
            }
            if ((acc = (FundAccount)handler.getRowValue()) != null && newValue.chars().count() > 0L) {
                boolean flag = StringUtils.patternCheck((String)EMAIL, (String)newValue);
                if (!flag) {
                    try {
                        throw new MException(0, "\u90ae\u7bb1\u5730\u5740\u4e0d\u7b26\u5408\u8981\u6c42");
                    }
                    catch (MException e) {
                        Platform.runLater(() -> {
                            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            acc.setEmail(this.oldValue);
                        });
                        return;
                    }
                }
                acc.setEmail(newValue);
            }
        });
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setItems(this.list);
        this.tableItems.setEditable(true);
    }

    public void setList(List<FundAccount> list) {
        this.list = FXCollections.observableList(list);
    }

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    private class MxEditTableCell<S>
    extends TextFieldTableCell<S, String> {
        private TextField textField;
        private ChangeListener<Boolean> lstnFocus = (ob, old, now) -> {
            if (!now.booleanValue() && this.textField != null) {
                this.commitEdit(this.textField.getText());
            }
        };

        public MxEditTableCell() {
            this.setConverter((StringConverter)new DefaultStringConverter());
        }

        public void startEdit() {
            super.startEdit();
            try {
                if (this.textField == null) {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("textField");
                    field.setAccessible(true);
                    this.textField = (TextField)field.get((Object)this);
                    if (this.textField != null) {
                        this.textField.focusedProperty().addListener(this.lstnFocus);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void commitEdit(String newValue) {
            TableView table;
            if (!this.isEditing() && !newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
                TableColumn col = this.getTableColumn();
                TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newValue);
                Event.fireEvent((EventTarget)col, (Event)event);
            }
            super.commitEdit((Object)newValue);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                    this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : ((String)this.getItem()).toString();
        }
    }
}

