/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.PositionCarriedForwardModel;
import cms.tmx.query.current.views.CcsPositionPart;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class CcsPositionSumIndustryPart
extends CcsPositionPart {
    @FXML
    private TableColumn<CcsPosition, String> colAccName;
    @FXML
    private TableColumn<CcsPosition, String> colIndustry;
    @FXML
    private TableColumn<CcsPosition, Number> colCarryBuyCostAmt;
    @FXML
    private TableColumn<CcsPosition, Number> colCarryBuyCostAmtRate;
    @FXML
    private TableColumn<CcsPosition, Number> colPosiCapital;
    @FXML
    private TableColumn<CcsPosition, Number> colPosiCapitalRate;
    @FXML
    private CheckBox cbZero;
    @Inject
    protected PositionCarriedForwardModel model;
    @FXML
    protected ComboBox<AssetGrp> cbAssetGrp;
    @FXML
    protected CheckComboBox<FundAccount> ccmbAccnt;
    @Inject
    private AccountMngServiceImpl accMngService;
    @Inject
    private EPartService eps;
    @Inject
    private PositionFactory positionFactory;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private IBaseApi iba;
    private List<FundAccount> fundAccs = new ArrayList<FundAccount>();
    private MxList<CcsPosition> posiSumList = new MxList();
    private static final Logger logger = LogManager.getLogger(CcsPositionSumIndustryPart.class);
    private InvalidationListener lstnZero = ob -> {
        new AssetGrp();
        this.lstnSearch.invalidated(null);
    };

    protected URL getFXMLLocation() {
        return ((Object)((Object)this)).getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".fxml");
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.fundAccs = this.fundService.getAllFundAccountList();
        this.initAssetGrp();
        this.initCBZero();
        this.cbZero.setSelected(true);
        this.initFilter();
    }

    private void initFilter() {
        this.cmbFilter.setVisible(false);
    }

    private void initCBZero() {
        this.cbZero.selectedProperty().addListener(this.lstnZero);
    }

    private void initAssetGrp() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("\u5168\u90e8");
            asset.setName("\u5168\u90e8");
            this.cbAssetGrp.getItems().add((Object)asset);
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            ArrayList listAsset = new ArrayList();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "1".equals(item.getType().getRaw())) {
                    listAsset.add(item);
                }
            });
            for (AssetGrp assetGrp : listAsset) {
                String[] ids;
                String[] stringArray = ids = assetGrp.getAssetUnitId().split(",");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String accntId = stringArray[n2];
                    Account acc = this.accMngService.getAccountById(accntId);
                    if (acc != null) {
                        assetGrp.getInvestorIds().add(acc.getInvestorId());
                    }
                    ++n2;
                }
            }
            this.cbAssetGrp.getItems().addAll(listAsset);
        }
        catch (MException e) {
            logger.error("\u8d44\u4ea7\u7ec4\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        this.cbAssetGrp.getSelectionModel().select(0);
        this.cbAssetGrp.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            if ("\u5168\u90e8".equals(newV.getId())) {
                this.ccmbAccnt.getItems().clear();
                this.ccmbAccnt.getItems().add((Object)this.fundAll);
                this.ccmbAccnt.getItems().addAll(this.fundAccs);
                this.ccmbAccnt.getCheckModel().checkAll();
                this.ccmbSecAcc.getItems().clear();
                this.ccmbSecAcc.getItems().add((Object)this.secAccAll);
                this.ccmbSecAcc.getItems().addAll((Collection)this.listSecAccnt);
                this.ccmbSecAcc.getCheckModel().checkAll();
            } else {
                this.ccmbAccnt.getItems().clear();
                this.ccmbAccnt.getItems().add((Object)this.fundAll);
                ArrayList<FundAccount> funds = new ArrayList<FundAccount>();
                for (FundAccount fa : this.fundAccs) {
                    if (!newV.getInvestorIds().contains(fa.getInvestId())) continue;
                    funds.add(fa);
                }
                this.ccmbAccnt.getItems().addAll(funds);
                this.ccmbAccnt.getCheckModel().checkAll();
                this.ccmbSecAcc.getItems().clear();
                this.ccmbSecAcc.getItems().add((Object)this.secAccAll);
                ArrayList<SecAccount> secAccs = new ArrayList<SecAccount>();
                for (SecAccount fa : this.listSecAccnt) {
                    if (!newV.getInvestorIds().contains(fa.getInverstorId())) continue;
                    secAccs.add(fa);
                }
                this.ccmbSecAcc.getItems().addAll(secAccs);
                this.ccmbSecAcc.getCheckModel().checkAll();
            }
            this.ccmbAccntLis();
            this.initPosFilterSecAcc();
        });
    }

    @Override
    public boolean premise(CcsPosition order) {
        if (this.model.getPledgeCode().contains(order.getSecId())) {
            return false;
        }
        if (this.cbZero.isSelected() && (order.getTotalVol() < 0L || order.getTotalVol() == 0L)) {
            return false;
        }
        return super.premise(order);
    }

    @Override
    public void lstnExtendOperation(List<CcsPosition> list) {
        double capital = 0.0;
        double totalPl = 0.0;
        for (CcsPosition posi : list) {
            capital += posi.getCapitalization();
            totalPl += posi.getTotalPl();
        }
        for (CcsPosition posi : list) {
            double capitalPrecent = 0.0;
            if (capital != 0.0) {
                capitalPrecent = posi.getCapitalization() * 100.0 / capital;
            }
            posi.setCapitalPrecent(this.formatScale(capitalPrecent, 2));
            double totalPlPrecent = 0.0;
            if (totalPl != 0.0) {
                totalPlPrecent = posi.getTotalPl() * 100.0 / totalPl;
            }
            posi.setTotalProfitLossPrecent(this.formatScale(totalPlPrecent, 2));
            double plRate = 0.0;
            if (posi.getCarryBuyCostAmtNew() != 0.0) {
                plRate = posi.getFloatPl() * 100.0 / posi.getCarryBuyCostAmtNew();
            }
            posi.setPlRate(this.formatScale(plRate, 2));
        }
        this.sumList(list);
    }

    private void sumList(List<CcsPosition> posis) {
        LinkedList<CcsPosition> list = new LinkedList<CcsPosition>();
        HashMap<String, CcsPosition> map = new HashMap<String, CcsPosition>();
        double buyCostAmtSum = 0.0;
        double capitalizationSum = 0.0;
        boolean flag = false;
        for (CcsPosition posi : posis) {
            String key = this.getKey(posi);
            if (map.get(key) == null) {
                CcsPosition ccsPosi = (CcsPosition)CcsPosition.class.cast(this.positionFactory.create(posi.getMarketGrp()));
                ccsPosi.update((Object)posi);
                list.add(ccsPosi);
                map.put(key, ccsPosi);
                continue;
            }
            CcsPosition oldPosi = (CcsPosition)map.get(key);
            double buyCostAmt = posi.getCarryBuyCostAmtNew();
            double capitalization = posi.getCapitalization();
            double buyCostAmtOld = oldPosi.getCarryBuyCostAmtNew();
            double capitalizationOld = oldPosi.getCapitalization();
            if (!posi.getInvestorId().equals(oldPosi.getInvestorId())) {
                flag = true;
            }
            oldPosi.setCarryBuyCostAmtNew(buyCostAmtOld + buyCostAmt);
            oldPosi.setCapitalization(capitalizationOld + capitalization);
        }
        for (String key : map.keySet()) {
            if (flag) {
                ((CcsPosition)map.get(key)).setInvestorId("");
                ((CcsPosition)map.get(key)).setInvestorName("");
            } else {
                ((CcsPosition)map.get(key)).setInvestorId(posis.get(0).getInvestorId());
                ((CcsPosition)map.get(key)).setInvestorName(posis.get(0).getInvestorName());
            }
            buyCostAmtSum += ((CcsPosition)map.get(key)).getCarryBuyCostAmtNew();
            capitalizationSum += ((CcsPosition)map.get(key)).getCapitalization();
        }
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            CcsPosition ccsPosition;
            ccsPosition.setCarryBuyCostAmtRate((ccsPosition = (CcsPosition)iterator.next()).getCarryBuyCostAmtNew() != 0.0 && buyCostAmtSum != 0.0 ? ccsPosition.getCarryBuyCostAmtNew() / buyCostAmtSum * 100.0 : 0.0);
            ccsPosition.setPosiCapitalRate(ccsPosition.getCapitalization() != 0.0 && capitalizationSum != 0.0 ? ccsPosition.getCapitalization() / capitalizationSum * 100.0 : 0.0);
        }
        this.posiSumList.update(list);
    }

    private String getKey(CcsPosition posi) {
        return posi.getIndustry();
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    @Override
    protected void createTable() {
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsPosition pos;
            if (event.getClickCount() == 2) {
                CcsPosition pos2 = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem();
                if (pos2 != null) {
                    String code = pos2.getSecId();
                    MEvent eCall = new MEvent();
                    eCall.put((Object)"sec_code", (Object)code);
                    eCall.put((Object)"sec_type", (Object)pos2.getSecType());
                    eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                    eCall.put((Object)"count", (Object)pos2.getCanVol());
                    eCall.put((Object)"side_sell", (Object)(pos2.getCanVol() >= 0L ? 1 : 0));
                    eCall.put((Object)"secAccount", (Object)pos2.getExtSecAccId());
                    eCall.put((Object)"tMarket", (Object)pos2.getMarket().getRaw());
                    this.es.sendEvent("trade.panel.set.code", eCall);
                }
            } else if (event.getClickCount() == 1 && (pos = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                String code = pos.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)pos.getSecType());
                eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                eCall.put((Object)"count", (Object)pos.getCanVol());
                eCall.put((Object)"side_sell", (Object)(pos.getCanVol() >= 0L ? 1 : 0));
                eCall.put((Object)"secAccount", (Object)pos.getExtSecAccId());
                eCall.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.colAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorIdProperty());
        this.colAccName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorNameProperty());
        this.colAccName.setCellFactory(data -> new TooltipTableCell<CcsPosition, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : (String)((CcsPosition)this.getValue()).investorNameProperty().get();
            }
        });
        this.colCarryBuyCostAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryBuyCostAmtNewProperty());
        this.colCarryBuyCostAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colPosiCapital.setCellValueFactory(data -> ((CcsPosition)data.getValue()).capitalizationProperty());
        this.colPosiCapital.setCellFactory(cell -> new DoubleTableCell());
        this.colCarryBuyCostAmtRate.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryBuyCostAmtRateProperty());
        this.colCarryBuyCostAmtRate.setCellFactory(cell -> new DoubleTableCell());
        this.colPosiCapitalRate.setCellValueFactory(data -> ((CcsPosition)data.getValue()).posiCapitalRateProperty());
        this.colPosiCapitalRate.setCellFactory(cell -> new DoubleTableCell());
        this.colIndustry.setCellValueFactory(data -> ((CcsPosition)data.getValue()).industryProperty());
        this.tablePosition.getColumns().remove((Object)this.colCost);
        this.tablePosition.getColumns().remove((Object)this.colCostAmt);
        this.tablePosition.getColumns().remove((Object)this.colTodayRealizedPl);
        this.tablePosition.getColumns().remove((Object)this.colPercent);
        this.tablePosition.getColumns().remove((Object)this.colYield);
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.posiSumList.getList());
        TableUtils.orgnizeClmWidth((TableView)this.tablePosition);
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @Override
    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead((TableView)this.tablePosition, (int)0, (int)0);
    }

    @Override
    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel((TableView)this.tablePosition, (String)"\u6301\u4ed3\u884c\u4e1a\u7edf\u8ba1");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @Override
    public CcsPositionModel getModel() {
        return this.model;
    }
}

