/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.current.views.CcsPositionPart;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsPositionStdBondPart
extends CcsPositionPart {
    private static final Logger logger = LogManager.getLogger(CcsPositionStdBondPart.class);
    @FXML
    protected TableView<CcsPosition> tablePosition;
    @FXML
    protected TableColumn<CcsPosition, String> colSecId;
    @FXML
    protected TableColumn<CcsPosition, String> colSecName;
    @FXML
    protected TableColumn<CcsPosition, Number> colTotalVolStd;
    @FXML
    protected TableColumn<CcsPosition, String> colUnit;
    @FXML
    protected TableColumn<CcsPosition, Number> colAvail;
    @FXML
    protected TableColumn<CcsPosition, Number> colSellOut;
    @FXML
    protected TableColumn<CcsPosition, Number> colSellOutFrozen;
    @FXML
    protected TableColumn<CcsPosition, Number> colReduceQty;
    @FXML
    protected TableColumn<CcsPosition, Number> colPreTotalQty;
    @FXML
    protected TableColumn<CcsPosition, Number> colTotalVol;
    @FXML
    protected TableColumn<CcsPosition, MxNode> colMarket;
    @FXML
    protected TableColumn<CcsPosition, String> colAcc;
    @FXML
    protected TableColumn<CcsPosition, String> colSecAcc;

    @Inject
    public CcsPositionStdBondPart() {
        this.path = "CcsPositionStdBondPart.fxml";
    }

    @Override
    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.check();
        this.fxmlDone = true;
        this.initCheckComboBox();
        this.getModel().initQuery();
    }

    @Override
    public boolean premise(CcsPosition pos) {
        if (!"STD_BOND".equals(pos.getSecType())) {
            return false;
        }
        System.currentTimeMillis();
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains(pos.getInvestorId());
            }
            case "2": {
                return this.secIds.contains(pos.getInverstorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(pos.getMarket().getRaw())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected void createTable() {
        int doubleClickCount = 2;
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsPosition pos;
            if (event.getClickCount() == doubleClickCount) {
                CcsPosition pos2 = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem();
                if (pos2 != null) {
                    String code = pos2.getSecId();
                    MEvent eCall = new MEvent();
                    eCall.put((Object)"sec_code", (Object)code);
                    eCall.put((Object)"sec_type", (Object)pos2.getSecType());
                    eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                    eCall.put((Object)"count", (Object)pos2.getCanVol());
                    eCall.put((Object)"side_sell", (Object)(pos2.getCanVol() >= 0L ? 1 : 0));
                    eCall.put((Object)"secAccount", (Object)pos2.getExtSecAccId());
                    eCall.put((Object)"tMarket", (Object)pos2.getMarket().getRaw());
                    this.es.sendEvent("trade.panel.set.code", eCall);
                }
            } else if (event.getClickCount() == 1 && (pos = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                String code = pos.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)pos.getSecType());
                eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                eCall.put((Object)"count", (Object)pos.getCanVol());
                eCall.put((Object)"side_sell", (Object)(pos.getCanVol() >= 0L ? 1 : 0));
                eCall.put((Object)"secAccount", (Object)pos.getExtSecAccId());
                eCall.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.colSecId.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secNameProperty());
        this.colTotalVolStd.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalVolStdProperty());
        this.colTotalVolStd.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).unitProperty());
        this.colMarket.setCellValueFactory(data -> ((CcsPosition)data.getValue()).marketProperty());
        this.colAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).inverstorSecIdProperty());
        this.colAvail.setCellValueFactory(data -> ((CcsPosition)data.getValue()).availProperty());
        this.colAvail.setCellFactory(p -> new NumberTableCell());
        this.colSellOut.setCellValueFactory(data -> ((CcsPosition)data.getValue()).sellOutProperty());
        this.colSellOut.setCellFactory(p -> new NumberTableCell());
        this.colSellOutFrozen.setCellValueFactory(data -> ((CcsPosition)data.getValue()).sellOutFrozenProperty());
        this.colSellOutFrozen.setCellFactory(p -> new NumberTableCell());
        this.colReduceQty.setCellValueFactory(data -> ((CcsPosition)data.getValue()).reduceQtyProperty());
        this.colReduceQty.setCellFactory(p -> new CcsPositionPart.PriceCell());
        this.colPreTotalQty.setCellValueFactory(data -> ((CcsPosition)data.getValue()).preTotalQtyProperty());
        this.colPreTotalQty.setCellFactory(p -> new CcsPositionPart.PriceCell());
        this.colTotalVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalVolProperty());
        this.colTotalVol.setCellFactory(p -> new CcsPositionPart.PriceCell());
        this.colReduceQty.setVisible(false);
        this.colPreTotalQty.setVisible(false);
        this.colTotalVol.setVisible(false);
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @Override
    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u6807\u51c6\u5238\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

