/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.InstructionShortcutModel;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CcsOrderSumShortcutPart
extends MxPart {
    @FXML
    private TableView<CcsOrder> tableOrder;
    @FXML
    private TableColumn<CcsOrder, String> colSecId;
    @FXML
    private TableColumn<CcsOrder, String> colSecName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CcsOrder, String> colAccId;
    @FXML
    private TableColumn<CcsOrder, String> colAccName;
    @FXML
    private TableColumn<CcsOrder, Number> colPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderAmt;
    @FXML
    private TableColumn<CcsOrder, String> colReference;
    @FXML
    private TextField searchText;
    @Inject
    private CcsOrderModel model;
    @Inject
    private IRefDataMng refMng;
    private static final Logger logger = LogManager.getLogger(CcsOrderSumShortcutPart.class);
    @Inject
    private MxAlert alert;
    private MxList<CcsOrder> mxList = new MxList();
    private List<CcsOrder> sumList = new ArrayList<CcsOrder>();
    @Inject
    private InstructionShortcutModel shortModel;
    @Inject
    private OrderFactory orderFactory;
    private Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        List<CcsOrder> list = this.sumList;
        synchronized (list) {
            this.mxList.filter(this.sumList, this.pd);
        }
    };
    private InvalidationListener lstnPart = ob -> {
        String partId = this.shortModel.getSelectedPart();
        if (!"cms.tmx.instructions.part.shortcut.ordersum.query".equals(partId)) {
            return;
        }
        Platform.runLater(() -> this.tableOrder.requestFocus());
    };

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder order = (CcsOrder)this.tableOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.order")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
        this.shortModel.addSearch(this.searchText);
        this.shortModel.selectedPartProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnPart));
        this.initKeyPressHandler();
    }

    public void finalize() {
        this.shortModel.removeSearch(this.searchText);
    }

    public boolean premise(CcsOrder order) {
        return true;
    }

    public boolean extend(CcsOrder order) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tableOrder.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<CcsOrder> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsOrder>)this.getModel().getList());
        }
        this.sumList = this.createSumList(newList);
        this.mxList.update(this.sumList, this.pd);
        Platform.runLater(() -> {
            this.tableOrder.sort();
            this.tableOrder.refresh();
        });
    }

    private String getKey(CcsOrder order) {
        String key = String.valueOf(order.getExtAccntId()) + order.getReference() + order.getSecId() + order.getSide().getRaw() + order.getPrice();
        return key;
    }

    private List<CcsOrder> createSumList(List<CcsOrder> newList) {
        HashMap<String, CcsOrder> map = new HashMap<String, CcsOrder>();
        LinkedList<CcsOrder> list = new LinkedList<CcsOrder>();
        for (CcsOrder order : newList) {
            if ("52".equals(order.getOrdStatus().getRaw()) || "56".equals(order.getOrdStatus().getRaw())) continue;
            String key = this.getKey(order);
            if (map.get(key) == null) {
                CcsOrder newOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
                newOrder.update((Object)order);
                if ("70".equals(order.getOrdStatus().getRaw())) {
                    newOrder.setOrderQty(newOrder.getOrderQty() - (int)order.getWthQty());
                }
                list.add(newOrder);
                map.put(key, newOrder);
                continue;
            }
            CcsOrder oldOrder = (CcsOrder)map.get(key);
            int qty = order.getOrderQty();
            if ("70".equals(order.getOrdStatus().getRaw())) {
                qty -= (int)order.getWthQty();
            }
            double amount = order.getOrderAmt();
            int oldQty = oldOrder.getOrderQty();
            double oldAmount = oldOrder.getOrderAmt();
            oldOrder.setOrderQty(oldQty + qty);
            oldOrder.setOrderAmt(oldAmount + amount);
        }
        return list;
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.DOWN == event.getCode() || KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.tableOrder.requestFocus());
            }
        });
        this.tableOrder.setOnKeyPressed(event -> {
            if (KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
        this.tableOrder.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableOrder.getSelectionModel().getSelectedItem() == null && !this.tableOrder.getItems().isEmpty()) {
                this.tableOrder.getSelectionModel().select(0);
            }
        });
    }

    private void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableOrder);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableOrder, (String)"\u59d4\u6258\u5206\u4ef7\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.colSecId.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(p -> new NumberTableCell());
        this.colOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colOrderAmt.setCellFactory(p -> new PriceCell());
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.colAccName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getAccName()));
        this.colAccName.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((CcsOrder)this.getValue()).getAccName();
            }
        });
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getReference()));
        this.tableOrder.setItems(this.mxList.getList());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
    }

    private OrderQueryModel<CcsOrder> getModel() {
        return this.model;
    }

    private class PriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsOrderSumShortcutPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<CcsOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

