/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CcsOrderPart
extends MxPart {
    @FXML
    protected TableView<CcsOrder> tableOrder;
    @FXML
    private TableColumn<CcsOrder, String> colSecId;
    @FXML
    private TableColumn<CcsOrder, String> colSecName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CcsOrder, String> colOrdTime;
    @FXML
    private TableColumn<CcsOrder, MxNode> colOrdStatus;
    @FXML
    private TableColumn<CcsOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CcsOrder, String> colUnit;
    @FXML
    private TableColumn<CcsOrder, String> colOrderId;
    @FXML
    private TableColumn<CcsOrder, String> colAccId;
    @FXML
    private TableColumn<CcsOrder, String> colSecAcc;
    @FXML
    private TableColumn<CcsOrder, Number> colPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CcsOrder, String> colType;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colFrozenAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colDoneVol;
    @FXML
    private TableColumn<CcsOrder, Number> colPercent;
    @FXML
    private TableColumn<CcsOrder, Number> colAvgPrice;
    @FXML
    private TableColumn<CcsOrder, String> colInfo;
    @FXML
    private TableColumn<CcsOrder, String> colUser;
    @FXML
    private TableColumn<CcsOrder, String> colUserName;
    @FXML
    protected TableColumn<CcsOrder, String> colReference;
    @FXML
    protected TextField searchText;
    @Inject
    protected CcsOrderModel model;
    @Inject
    protected IRefDataMng refMng;
    private static final Logger logger = LogManager.getLogger(CcsOrderPart.class);
    @Inject
    private MxAlert alert;
    protected MxList<CcsOrder> mxList = new MxList();
    protected Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        if (en.getUserId().contains(text)) {
            return true;
        }
        if (en.getUserName().contains(text)) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            this.mxList.filter(this.getModel().getList(), this.pd);
        }
    };
    @Inject
    private LoadPartModel load;

    public boolean premise(CcsOrder order) {
        return true;
    }

    public boolean extend(CcsOrder order) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tableOrder.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<CcsOrder> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsOrder>)this.getModel().getList());
        }
        this.mxList.update(newList, this.pd);
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        Platform.runLater(() -> this.tableOrder.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsOrder order = (CcsOrder)this.tableOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.order")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
    }

    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableOrder);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableOrder, (String)"\u59d4\u6258\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createTable() {
        this.colSecId.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(p -> new NumberTableCell());
        this.colOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colOrderAmt.setCellFactory(p -> new PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new PriceCell());
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getCumQty()));
        this.colDoneVol.setCellFactory(p -> new NumberTableCell());
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(data -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new AvgPriceCell());
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTypeDesc()));
        this.colOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getOrdStatus()));
        this.colMarket.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().marketProperty());
        this.colUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUnit()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrderId()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInverstorSecId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserId()));
        this.colUserName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserName()));
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getReference()));
        this.tableOrder.setItems(this.mxList.getList());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
        this.colOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableOrder.getSortOrder().add(this.colOrdTime);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected OrderQueryModel<CcsOrder> getModel() {
        return this.model;
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsOrderPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsOrderPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<CcsOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

