/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.ObCcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.current.views.SortPolicy;
import cms.tmx.query.utils.FundAccountStringConverter;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class CcsOrderPageCreaterPart
extends MxPart {
    private static final Integer PAGE_SIZE = 500;
    @FXML
    protected TableView<ObCcsOrder> tableOrder;
    @FXML
    private Label lbAccnt;
    @FXML
    private TableColumn<ObCcsOrder, String> baseId;
    @FXML
    private TableColumn<ObCcsOrder, String> secId;
    @FXML
    private TableColumn<ObCcsOrder, String> secName;
    @FXML
    private TableColumn<ObCcsOrder, String> side;
    @FXML
    private TableColumn<ObCcsOrder, String> ordTime;
    @FXML
    private TableColumn<ObCcsOrder, String> ordStatus;
    @FXML
    private TableColumn<ObCcsOrder, String> market;
    @FXML
    private TableColumn<ObCcsOrder, String> unit;
    @FXML
    private TableColumn<ObCcsOrder, String> orderId;
    @FXML
    private TableColumn<ObCcsOrder, String> investorId;
    @FXML
    private TableColumn<ObCcsOrder, String> inverstorSecId;
    @FXML
    private TableColumn<ObCcsOrder, Number> price;
    @FXML
    private TableColumn<ObCcsOrder, Number> orderQty;
    @FXML
    private TableColumn<ObCcsOrder, String> ordTypeDesc;
    @FXML
    private TableColumn<ObCcsOrder, Number> orderAmt;
    @FXML
    private TableColumn<ObCcsOrder, Number> frozenMargin;
    @FXML
    private TableColumn<ObCcsOrder, Number> cumQty;
    @FXML
    private TableColumn<ObCcsOrder, Number> donePercent;
    @FXML
    private TableColumn<ObCcsOrder, Number> avgPx;
    @FXML
    private TableColumn<ObCcsOrder, String> accName;
    @FXML
    private TableColumn<ObCcsOrder, Number> totalValue;
    @FXML
    private TableColumn<ObCcsOrder, Number> wthQty;
    @FXML
    private TableColumn<ObCcsOrder, String> ordDate;
    @FXML
    private TableColumn<ObCcsOrder, String> extOrderId;
    @FXML
    private TableColumn<ObCcsOrder, String> wthTime;
    @FXML
    protected CheckComboBox<FundAccount> ccmbAccnt;
    @FXML
    private TableColumn<ObCcsOrder, String> errInfo;
    @FXML
    private TableColumn<ObCcsOrder, String> userId;
    @FXML
    private TableColumn<ObCcsOrder, String> userName;
    @FXML
    protected TableColumn<ObCcsOrder, String> reference;
    @FXML
    protected TextField searchText;
    @Inject
    protected CcsOrderModel model;
    @Inject
    protected IRefDataMng refMng;
    @FXML
    private Label lbCurrentCount;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbCountSeparator;
    @FXML
    protected CheckBox cbSumByAcc;
    @FXML
    protected CheckBox cbSH;
    @FXML
    protected CheckBox cbSZ;
    @FXML
    protected CheckBox cbBuy;
    @FXML
    protected CheckBox cbSell;
    boolean ccmbfalg = false;
    @FXML
    private Label lbSum;
    @FXML
    private Label lbOrderAmt;
    @FXML
    private Label lbTotalValue;
    @Inject
    protected MxAlert alert;
    protected FundAccount fundAll = new FundAccount();
    protected AssetGrp assetAll = new AssetGrp();
    private List<FundAccount> fundAccs = new ArrayList<FundAccount>();
    @FXML
    protected ComboBox<AssetGrp> cbAssetGrp;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private AccountMngServiceImpl accMngService;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private IBaseApi iba;
    private long lastLoadTime;
    protected MxPageList<CcsOrder, ObCcsOrder> mxList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    protected MxPageList<CcsOrder, ObCcsOrder> mxSumList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    protected Map<String, CheckBox> mapCBox = new HashMap<String, CheckBox>();
    protected Predicate<CcsOrder> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsOrder)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        if (en.getUserId().contains(text)) {
            return true;
        }
        if (en.getUserName().contains(text)) {
            return true;
        }
        return this.extend((CcsOrder)en);
    };
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            this.mxList.filter(this.getModel().getList(), this.pd);
            this.mxSumList.filter(this.createSumList((List<CcsOrder>)this.getModel().getList()), this.pd);
        }
        this.sort(this.mxSumList);
        this.sort(this.mxList);
        this.mxSumList.updatePageList();
        this.mxList.updatePageList();
        this.tableOrder.refresh();
        Platform.runLater(() -> {
            if (this.cbSumByAcc.isSelected()) {
                this.sumNum(this.mxSumList);
                this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxSumList.getBeginIndex() + 1)) + "-" + (this.mxSumList.getBeginIndex() + PAGE_SIZE > this.mxSumList.getList().size() ? String.valueOf(this.mxSumList.getList().size()) : String.valueOf(this.mxSumList.getBeginIndex() + PAGE_SIZE)));
                this.lbTotalCount.setText(String.valueOf(this.mxSumList.getList().size()));
            } else {
                this.sumNum(this.mxList);
                this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            }
        });
    };
    public Callback<TableView<ObCcsOrder>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<ObCcsOrder>(){

        @Override
        public void afterSort() {
            CcsOrderPageCreaterPart.this.lstnModel.invalidated(null);
        }
    };
    private ScrollBar bar;
    private double lastPosition = 0.0;
    private boolean dragFlag = false;
    private long lastDragTime = 0L;
    @Inject
    private IFundAccountService fundService;
    List<String> listAccId = FxUtils.newList();
    @Inject
    private LoadPartModel load;
    @Inject
    private OrderFactory orderFactory;

    public boolean premise(CcsOrder order) {
        boolean flag = false;
        ObservableList listAccnt = this.ccmbAccnt.getCheckModel().getCheckedItems();
        for (FundAccount acc : listAccnt) {
            if (acc == null || !acc.getInvestId().equals(order.getInvestorId())) continue;
            flag = true;
            break;
        }
        CheckBox cboxMarket = this.mapCBox.get(order.getInstrument().getMarket().getRaw());
        if (cboxMarket != null && !cboxMarket.isSelected()) {
            return false;
        }
        CheckBox cboxSide = this.mapCBox.get(order.getSide().getRaw());
        if (cboxSide != null && !cboxSide.isSelected()) {
            return false;
        }
        if (this.assetAll.equals(this.cbAssetGrp.getSelectionModel().getSelectedItem()) && listAccnt.contains(this.fundAll)) {
            return true;
        }
        return flag;
    }

    public boolean extend(CcsOrder order) {
        return false;
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @Focus
    public void onFocus() {
        this.tableOrder.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    protected void refreshList() {
        if (!this.isVisible()) {
            return;
        }
        ArrayList<CcsOrder> newList = new ArrayList<CcsOrder>();
        ArrayList<CcsOrder> newSumList = new ArrayList<CcsOrder>();
        ObservableList<CcsOrder> observableList = this.getModel().getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsOrder>)this.getModel().getList());
            newSumList.addAll(this.createSumList((List<CcsOrder>)this.getModel().getList()));
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.mxSumList.update(newSumList, this.pd);
            this.sort(this.mxSumList);
            this.sort(this.mxList);
            this.mxList.updatePageList();
            this.mxSumList.updatePageList();
            if (this.cbSumByAcc.isSelected()) {
                this.sumNum(this.mxSumList);
            } else {
                this.sumNum(this.mxList);
            }
            if (this.lbCurrentCount != null && this.lbTotalCount != null) {
                if (this.cbSumByAcc.isSelected()) {
                    this.lbCurrentCount.setText(String.valueOf(this.mxSumList.getBeginIndex() == 0 && this.mxSumList.getList().size() == 0 ? "0" : String.valueOf(this.mxSumList.getBeginIndex() + 1)) + "-" + (this.mxSumList.getBeginIndex() + PAGE_SIZE > this.mxSumList.getList().size() ? String.valueOf(this.mxSumList.getList().size()) : String.valueOf(this.mxSumList.getBeginIndex() + PAGE_SIZE)));
                    this.lbTotalCount.setText(String.valueOf(this.mxSumList.getList().size()));
                } else {
                    this.lbCurrentCount.setText(String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                    this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
                }
            }
        });
    }

    protected void sort(MxPageList<CcsOrder, ObCcsOrder> list) {
        try {
            list.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            ObservableList sortOrder = this.tableOrder.getSortOrder();
            for (TableColumn column : sortOrder) {
                list.getList().sort((o1, o2) -> {
                    try {
                        Method method = CcsOrder.class.getMethod("get" + CcsOrderPageCreaterPart.capitalize(column.getId()), new Class[0]);
                        Object s1 = method.invoke(o1, new Object[0]);
                        Object s2 = method.invoke(o2, new Object[0]);
                        if (s1 instanceof Number) {
                            return QueryUtils.compareNumber(column, s1, s2);
                        }
                        if (s1 instanceof MxNode) {
                            return QueryUtils.compareMxNode(column, s1, s2);
                        }
                        return QueryUtils.compareString(column, s1, s2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    private void sumLoadNextPage(MxPageList<CcsOrder, ObCcsOrder> list) {
        if (list.getList().size() == list.getPageList().size()) {
            return;
        }
        if (list.getBeginIndex() + PAGE_SIZE >= list.getList().size()) {
            return;
        }
        if (list.getBeginIndex() + PAGE_SIZE < list.getList().size()) {
            list.setBeginIndex(list.getBeginIndex() + PAGE_SIZE);
        }
    }

    private void loadNextPage() {
        if (this.cbSumByAcc.isSelected()) {
            this.sumLoadNextPage(this.mxSumList);
        } else {
            this.sumLoadNextPage(this.mxList);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    private void sumLoadPrevPage(MxPageList<CcsOrder, ObCcsOrder> list) {
        if (list.getList().size() == list.getPageList().size()) {
            return;
        }
        if (list.getBeginIndex() == 0) {
            return;
        }
        if (list.getBeginIndex() - PAGE_SIZE < 0) {
            list.setBeginIndex(0);
        } else {
            list.setBeginIndex(list.getBeginIndex() - PAGE_SIZE);
        }
    }

    private void loadPrevPage() {
        if (this.cbSumByAcc.isSelected()) {
            this.sumLoadPrevPage(this.mxSumList);
        } else {
            this.sumLoadPrevPage(this.mxList);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    protected void initCheckBox() {
        this.mapCBox.put("XSHG", this.cbSH);
        this.mapCBox.put("XSHE", this.cbSZ);
        this.mapCBox.put("49", this.cbBuy);
        this.mapCBox.put("50", this.cbSell);
        CheckBox cbox = new CheckBox();
        cbox.setSelected(false);
        this.mapCBox.put("71", cbox);
        this.mapCBox.put("70", this.cbBuy);
        this.cbSH.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
        this.cbSZ.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
        this.cbBuy.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
        this.cbSell.selectedProperty().addListener(ob -> this.lstnSearch.invalidated(null));
    }

    @FXML
    public void initialize() {
        this.tableOrder.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
        this.initCheckBox();
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsOrder order = (ObCcsOrder)this.tableOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.order")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.dragFlag) {
                    event.consume();
                }
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableOrder.lookup(".scroll-bar:vertical");
                }
                if (this.bar.getValue() != this.lastPosition) {
                    long current = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.lastDragTime < 200L) {
                        return;
                    }
                    this.lastDragTime = current;
                    if (this.bar.getValue() < this.lastPosition) {
                        if (this.bar.getValue() == this.bar.getMax() * 0.0) {
                            this.loadPrevPage();
                        }
                    } else if (this.bar.getValue() == this.bar.getMax()) {
                        this.loadNextPage();
                    }
                    this.lastPosition = this.bar.getValue();
                }
            }
        });
        this.tableOrder.setOnScroll(ob -> {
            long now = System.currentTimeMillis();
            if (now - this.lastLoadTime < 1000L) {
                return;
            }
            this.lastLoadTime = now;
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableOrder.lookup(".scroll-bar:vertical");
            }
            if (ob.getDeltaY() > 0.0) {
                if (this.lbCurrentCount.getText().startsWith("1-")) {
                    return;
                }
                this.loadPrevPage();
                this.bar.setValue(1.0);
                return;
            }
            if (this.lbCurrentCount.getText().endsWith("-" + this.lbTotalCount.getText())) {
                return;
            }
            this.loadNextPage();
            this.bar.setValue(0.0);
        });
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.dragFlag = false;
        });
        this.initCheckCmbBox();
        this.initChackSumBox();
        this.initAssetGrp();
        this.lstnSearch.invalidated(null);
    }

    private void initChackSumBox() {
        this.cbSumByAcc.selectedProperty().addListener((ob, oldVal, newVal) -> {
            this.refreshList();
            Platform.runLater(() -> {
                if (newVal.booleanValue()) {
                    this.sumNum(this.mxSumList);
                    this.tableOrder.setItems(this.mxSumList.getPageList());
                    this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxSumList.getBeginIndex() + 1)) + "-" + (this.mxSumList.getBeginIndex() + PAGE_SIZE > this.mxSumList.getList().size() ? String.valueOf(this.mxSumList.getList().size()) : String.valueOf(this.mxSumList.getBeginIndex() + PAGE_SIZE)));
                    this.lbTotalCount.setText(String.valueOf(this.mxSumList.getList().size()));
                } else {
                    this.sumNum(this.mxList);
                    this.tableOrder.setItems(this.mxList.getPageList());
                    this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                    this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
                }
            });
        });
    }

    private void initCheckCmbBox() {
        this.fundAll.setExtAccntId("\u5168\u90e8");
        this.fundAll.setInvestId("\u5168\u90e8");
        this.ccmbAccnt.getItems().add((Object)this.fundAll);
        this.fundAccs = this.fundService.getAllFundAccountList();
        this.ccmbAccnt.getItems().addAll(this.fundAccs);
        this.ccmbAccnt.setConverter((StringConverter)new FundAccountStringConverter());
        this.ccmbAccnt.getCheckModel().checkAll();
        this.ccmbAccLis();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(this.fundAll)) {
                accStr = "";
                for (FundAccount fundAccount : listItem) {
                    if (fundAccount == null) continue;
                    accStr = String.valueOf(accStr) + fundAccount.getInvestId() + "__" + fundAccount.getAccountName() + ",";
                }
                if (!StringUtils.isEmpty((String)accStr)) {
                    accStr = accStr.substring(0, accStr.length() - 1);
                }
            }
            this.lstnSearch.invalidated(null);
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
        this.lstnSearch.invalidated(null);
        this.ccmbfalg = true;
    }

    private void ccmbAccLis() {
        int i = 1;
        while (i < this.ccmbAccnt.getItems().size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.ccmbfalg) {
                    this.ccmbfalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.ccmbfalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.ccmbfalg) {
                this.ccmbfalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.ccmbfalg = true;
            }
        });
    }

    private void initAssetGrp() {
        try {
            this.assetAll.setId("\u5168\u90e8");
            this.assetAll.setName("\u5168\u90e8");
            this.cbAssetGrp.getItems().add((Object)this.assetAll);
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            ArrayList listAsset = new ArrayList();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "1".equals(item.getType().getRaw())) {
                    listAsset.add(item);
                }
            });
            for (AssetGrp assetGrp : listAsset) {
                String[] ids;
                String[] stringArray = ids = assetGrp.getAssetUnitId().split(",");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String accntId = stringArray[n2];
                    Account acc = this.accMngService.getAccountById(accntId);
                    if (acc != null) {
                        assetGrp.getInvestorIds().add(acc.getInvestorId());
                    }
                    ++n2;
                }
            }
            this.cbAssetGrp.getItems().addAll(listAsset);
        }
        catch (MException e) {
            this.logger.error("\u8d44\u4ea7\u7ec4\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        this.cbAssetGrp.getSelectionModel().select(0);
        this.cbAssetGrp.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            if ("\u5168\u90e8".equals(newV.getId())) {
                this.ccmbAccnt.getItems().clear();
                this.ccmbAccnt.getItems().add((Object)this.fundAll);
                this.ccmbAccnt.getItems().addAll(this.fundAccs);
                this.ccmbAccnt.getCheckModel().checkAll();
            } else {
                this.ccmbAccnt.getItems().clear();
                this.ccmbAccnt.getItems().add((Object)this.fundAll);
                ArrayList<FundAccount> funds = new ArrayList<FundAccount>();
                for (FundAccount fa : this.fundAccs) {
                    if (!newV.getInvestorIds().contains(fa.getInvestId())) continue;
                    funds.add(fa);
                }
                this.ccmbAccnt.getItems().addAll(funds);
                this.ccmbAccnt.getCheckModel().checkAll();
            }
            this.ccmbAccLis();
        });
    }

    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.mxSumList.setBeginIndex(0);
        this.getModel().query();
    }

    @FXML
    public void cancel() {
    }

    @FXML
    public void copy() {
        if (this.cbSumByAcc.isSelected()) {
            TableUtils.copyContentWithHead(this.tableOrder, (ObservableList)this.mxSumList.getList());
        } else {
            TableUtils.copyContentWithHead(this.tableOrder, (ObservableList)this.mxList.getList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            if (this.cbSumByAcc.isSelected()) {
                listOrder.addAll(this.mxSumList.getList());
            } else {
                listOrder.addAll(this.mxList.getList());
            }
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableOrder, (List)listOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void createTable() {
        this.tableOrder.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsOrder ord;
            if (event.getClickCount() == 1 && (ord = (ObCcsOrder)this.tableOrder.getSelectionModel().getSelectedItem()) != null) {
                String code = ord.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)ord.getInstrument().getSecType());
                eCall.put((Object)"tMarket", (Object)ord.getInstrument().getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.secId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secNameProperty());
        this.side.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).sideProperty());
        this.side.setCellFactory(cell -> new SideCell());
        this.price.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).priceProperty());
        this.price.setCellFactory(p -> new PriceCell());
        this.orderQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderQtyProperty());
        this.orderQty.setCellFactory(p -> new NumberTableCell());
        this.orderAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderAmtProperty());
        this.orderAmt.setCellFactory(p -> new PriceCell());
        this.frozenMargin.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).frozenMarginProperty());
        this.frozenMargin.setCellFactory(p -> new PriceCell());
        this.cumQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).cumQtyProperty());
        this.cumQty.setCellFactory(p -> new NumberTableCell());
        this.donePercent.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).donePercentProperty());
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).avgPxProperty());
        this.avgPx.setCellFactory(p -> new AvgPriceCell());
        this.ordTypeDesc.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordTypeDescProperty());
        this.baseId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).baseIdProperty());
        this.ordDate.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordDateProperty());
        this.totalValue.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).totalValueProperty());
        this.totalValue.setCellFactory(data -> new DoubleTableCell());
        this.wthQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).wthQtyProperty());
        this.wthQty.setCellFactory(p -> new NumberTableCell());
        this.extOrderId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderIdProperty());
        this.wthTime.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).wthTimeProperty());
        this.ordTime.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordTimeProperty());
        this.ordStatus.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).exOrdStatusProperty());
        this.market.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).marketProperty());
        this.unit.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).unitProperty());
        this.orderId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderIdProperty());
        this.investorId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).investorIdProperty());
        this.accName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).accNameProperty());
        this.accName.setCellFactory(data -> new TooltipTableCell<ObCcsOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : (String)((ObCcsOrder)this.getValue()).accNameProperty().get();
            }
        });
        this.inverstorSecId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).inverstorSecIdProperty());
        this.errInfo.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).errInfoProperty());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObCcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObCcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.userId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).userIdProperty());
        this.userId.setCellFactory(data -> new TooltipTableCell<ObCcsOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((ObCcsOrder)this.getValue()).getUserId();
            }
        });
        this.userName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).userNameProperty());
        this.userName.setCellFactory(data -> new TooltipTableCell<ObCcsOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((ObCcsOrder)this.getValue()).getUserName();
            }
        });
        this.reference.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).referenceProperty());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
        if (this.cbSumByAcc.isSelected()) {
            this.tableOrder.setItems(this.mxSumList.getPageList());
        } else {
            this.tableOrder.setItems(this.mxList.getPageList());
        }
        this.ordTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableOrder.getSortOrder().add(this.ordTime);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected OrderQueryModel<CcsOrder> getModel() {
        return this.model;
    }

    private void checkStatus(CcsOrder order, CcsOrder oldOrder) {
        switch (order.getOrdStatus().getRaw()) {
            case "50": {
                if (oldOrder.getVal() / 100000 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 100000);
                break;
            }
            case "49": {
                if (oldOrder.getVal() / 10000 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 10000);
                break;
            }
            case "48": {
                if (oldOrder.getVal() / 1000 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 1000);
                break;
            }
            case "52": {
                if (oldOrder.getVal() / 10 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 10);
                break;
            }
            case "70": {
                if (oldOrder.getVal() / 100 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 100);
                break;
            }
            case "56": {
                if (oldOrder.getVal() % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 1);
                break;
            }
        }
    }

    private void checkOneStatus(CcsOrder oldOrder) {
        switch (oldOrder.getOrdStatus().getRaw()) {
            case "50": {
                if (oldOrder.getVal() / 100000 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 100000);
                break;
            }
            case "49": {
                if (oldOrder.getVal() / 10000 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 10000);
                break;
            }
            case "48": {
                if (oldOrder.getVal() / 1000 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 1000);
                break;
            }
            case "52": {
                if (oldOrder.getVal() / 10 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 10);
                break;
            }
            case "70": {
                if (oldOrder.getVal() / 100 % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 100);
                break;
            }
            case "56": {
                if (oldOrder.getVal() % 10 == 1) break;
                oldOrder.setVal(oldOrder.getVal() + 1);
                break;
            }
        }
    }

    private void setStatus(CcsOrder ccsOrder) {
        int val = ccsOrder.getVal();
        if (val == 0) {
            ccsOrder.setExOrdStatus("");
        } else if (val == 1) {
            ccsOrder.setExOrdStatus("\u88ab\u62d2");
        } else if (val == 100000) {
            ccsOrder.setExOrdStatus("\u5168\u6210");
        } else if (val <= 11) {
            ccsOrder.setExOrdStatus("\u64a4\u5355");
        } else if (val == 1000 || val == 1001) {
            ccsOrder.setExOrdStatus("\u5df2\u62a5");
        } else if (val / 100 % 10 == 0 && val / 10 % 10 == 0) {
            ccsOrder.setExOrdStatus("\u90e8\u6210");
        } else if (val / 100000 == 0 && val / 10000 % 10 == 0) {
            ccsOrder.setExOrdStatus("\u90e8\u64a4");
        } else {
            ccsOrder.setExOrdStatus("\u90e8\u6210\u90e8\u64a4");
        }
    }

    private List<CcsOrder> createSumList(List<CcsOrder> mxNewList) {
        HashMap<String, CcsOrder> map = new HashMap<String, CcsOrder>();
        LinkedList<CcsOrder> list = new LinkedList<CcsOrder>();
        for (CcsOrder order : mxNewList) {
            CcsOrder newOrder;
            String key = this.getKey(order);
            if (order.getSide().getRaw().equals("70")) {
                newOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
                newOrder.update((Object)order);
                this.checkOneStatus(newOrder);
                list.add(newOrder);
                continue;
            }
            if ("52".equals(order.getOrdStatus().getRaw()) || "56".equals(order.getOrdStatus().getRaw())) continue;
            if (map.get(key) == null) {
                newOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
                newOrder.update((Object)order);
                this.checkOneStatus(newOrder);
                list.add(newOrder);
                map.put(key, newOrder);
                continue;
            }
            if ("52".equals(order.getOrdStatus().getRaw()) || "56".equals(order.getOrdStatus().getRaw())) continue;
            CcsOrder oldOrder = (CcsOrder)map.get(key);
            int qty = order.getOrderQty();
            double amount = order.getOrderAmt();
            double frozenMargin = order.getFrozenMargin();
            int cumQty = order.getCumQty();
            double totalValue = order.getTotalValue();
            double filledAvgPrice = order.getFilledAvgPrice();
            String userId = order.getUserId();
            String userName = order.getUserName();
            long wthQtyNum = order.getWthQty();
            int oldQty = oldOrder.getOrderQty();
            double oldAmount = oldOrder.getOrderAmt();
            double oldFrozenMargin = oldOrder.getFrozenMargin();
            int oldCumQty = oldOrder.getCumQty();
            double oldTotalValue = oldOrder.getTotalValue();
            double oldProductOfAvgAndQty = oldOrder.getProductOfAvgAndQty();
            String oldUserId = oldOrder.getUserId();
            String oldUserName = oldOrder.getUserName();
            long oldWthQtyNum = oldOrder.getWthQty();
            oldOrder.setOrderQty(oldQty + qty);
            oldOrder.setOrderAmt(oldAmount + amount);
            oldOrder.setFrozenMargin(frozenMargin + oldFrozenMargin);
            oldOrder.setCumQty(oldCumQty + cumQty);
            oldOrder.setTotalValue(oldTotalValue + totalValue);
            oldOrder.setProductOfAvgAndQty(oldProductOfAvgAndQty + filledAvgPrice * (double)cumQty);
            oldOrder.setWthQty(wthQtyNum + oldWthQtyNum);
            LinkedList<String> listName = new LinkedList<String>();
            LinkedList<String> listId = new LinkedList<String>();
            String[] splitName = oldUserName.split("\u3001");
            listName.addAll(Arrays.asList(splitName));
            if (!listName.contains(userName)) {
                oldOrder.setUserName(String.valueOf(oldUserName) + "\u3001" + userName);
            }
            String[] splitId = oldUserId.split("\u3001");
            listId.addAll(Arrays.asList(splitId));
            if (!listId.contains(userId)) {
                oldOrder.setUserId(String.valueOf(oldUserId) + "\u3001" + userId);
            }
            this.checkStatus(order, oldOrder);
        }
        for (CcsOrder ccsOrder : list) {
            if (ccsOrder.getSide().getRaw().equals("70")) continue;
            int orderQty = ccsOrder.getOrderQty();
            if ("XSHG".equals(ccsOrder.getInstrument().getMarket().getRaw()) && "BOND".equals(ccsOrder.getInstrument().getSecType())) {
                orderQty *= 10;
            }
            ccsOrder.setPrice(ccsOrder.getOrderAmt() / (double)orderQty);
            ccsOrder.setDonePercent((double)ccsOrder.getCumQty() * 1.0 / (double)ccsOrder.getOrderQty() * 100.0);
            this.setStatus(ccsOrder);
            if (ccsOrder.getCumQty() != 0) {
                int cumQty = ccsOrder.getCumQty();
                if ("XSHG".equals(ccsOrder.getInstrument().getMarket().getRaw()) && "BOND".equals(ccsOrder.getInstrument().getSecType())) {
                    cumQty *= 10;
                }
                ccsOrder.setAvgPx(ccsOrder.getTotalValue() / (double)cumQty);
            } else {
                ccsOrder.setAvgPx(0.0);
            }
            ccsOrder.setOrdTime("");
            ccsOrder.setOrderId("");
            ccsOrder.setErrInfo("");
            ccsOrder.setBaseId("");
            ccsOrder.setOrdTypeDesc("");
            ccsOrder.setWthTime("");
            ccsOrder.setReference("");
            ccsOrder.setUserId(ccsOrder.getUserId());
            ccsOrder.setUserName(ccsOrder.getUserName());
        }
        return list;
    }

    private String getKey(CcsOrder order) {
        String key = String.valueOf(order.getExtAccntId()) + order.getSecId() + order.getSide();
        return key;
    }

    private void sumNum(MxPageList<CcsOrder, ObCcsOrder> mxList) {
        double orderAmt = 0.0;
        double totalValue = 0.0;
        for (CcsOrder order : mxList.getList()) {
            orderAmt += order.getOrderAmt();
            totalValue += order.getTotalValue();
        }
        this.lbOrderAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbTotalValue.setText(StringUtils.toThousands((Number)totalValue, (int)2));
        this.lbSum.setText(String.valueOf(mxList.getList().size()));
    }

    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    private class AvgPriceCell
    extends DoubleTableCell<ObCcsOrder> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCcsOrder order = (ObCcsOrder)ObCcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsOrderPageCreaterPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<ObCcsOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCcsOrder order = (ObCcsOrder)ObCcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsOrderPageCreaterPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObCcsOrder, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            ObCcsOrder order = (ObCcsOrder)ObCcsOrder.class.cast(this.getTableRow().getItem());
            int side = StringUtils.parseInt((String)order.getSideRaw());
            this.label.setText(value);
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

