/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.MailExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.ObCcsDeal;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.models.PositionCarriedForwardModel;
import cms.tmx.query.current.views.CcsSetMailDialog;
import cms.tmx.query.utils.FundAccountStringConverter;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.controlsfx.control.CheckComboBox;

public class CcsMailCreaterPart
extends MxPart {
    @FXML
    private CheckComboBox<FundAccount> ccmbAccnt;
    @FXML
    private Button btnMail;
    @FXML
    private Label lbToday;
    @FXML
    private Label lbDate;
    @FXML
    private Label lbAcc;
    @FXML
    private Label lbAccName;
    @FXML
    private Label lbAccAsset;
    @FXML
    private Label lbAccAvail;
    @FXML
    private Label lbTotalPl;
    @FXML
    private Label lbRealPl;
    @FXML
    private Label lbFloatPL;
    @FXML
    private Label lbTodayTotalPl;
    @FXML
    private Label lbTodayRealPl;
    @FXML
    private Label lbTodayFloatPL;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbCapital;
    @FXML
    private Label lbPosiAmt;
    @FXML
    private TableView<CcsPosition> tablePosition;
    @FXML
    private TableColumn<CcsPosition, String> colSecId;
    @FXML
    private TableColumn<CcsPosition, String> colSecName;
    @FXML
    private TableColumn<CcsPosition, Number> colTotalVol;
    @FXML
    private TableColumn<CcsPosition, Number> colCarryBuyCost;
    @FXML
    private TableColumn<CcsPosition, Number> colNowPrice;
    @FXML
    private TableColumn<CcsPosition, Number> colCarryBuyCostAmt;
    @FXML
    private TableColumn<CcsPosition, Number> colPosiCapital;
    @FXML
    private TableColumn<CcsPosition, Number> colProfit;
    @FXML
    private TableColumn<CcsPosition, Number> colPlRate;
    @FXML
    private TableColumn<CcsPosition, Number> colRealizedPl;
    @FXML
    private TableColumn<CcsPosition, Number> colTotalPl;
    @FXML
    private TableColumn<CcsPosition, Number> colCapitalPrecent;
    @FXML
    private TableColumn<CcsPosition, Number> colTotalProfitLossPrecent;
    @FXML
    private TableView<CcsDeal> tableDealCount;
    @FXML
    private TableColumn<CcsDeal, String> colCountSecId;
    @FXML
    private TableColumn<CcsDeal, String> colCountSecName;
    @FXML
    private TableColumn<CcsDeal, MxNode> colCountDir;
    @FXML
    private TableColumn<CcsDeal, Number> colCountVol;
    @FXML
    private TableColumn<CcsDeal, String> colCountUnit;
    @FXML
    private TableColumn<CcsDeal, Number> colCountPrice;
    @FXML
    private TableColumn<CcsDeal, MxNode> colCountMkt;
    @FXML
    private TableColumn<CcsDeal, Number> colCountAmount;
    @FXML
    private TableColumn<CcsDeal, Number> colCount;
    @Inject
    private CcsDealModel dealModel;
    @Inject
    private PositionCarriedForwardModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private DealFactory fDeal;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @FXML
    private Label lbAccnt;
    private MxList<CcsDeal> mxDealList = new MxList();
    private MxList<CcsDeal> mxCountList = new MxList();
    private List<CcsDeal> countList = new LinkedList<CcsDeal>();
    private MxList<CcsPosition> mxList = new MxList();
    private MxList<CcsPosition> mxZeroList = new MxList();
    private static final Logger logger = LogManager.getLogger(CcsMailCreaterPart.class);
    private static final DateTimeFormatter formatterToday = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter formatterDate = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
    private FundAccount fundAll = new FundAccount();
    @Inject
    private IFundAccountService fundService;
    private Set<String> accIds = new HashSet<String>();
    private boolean accFalg = false;
    private FundAccount fundAccount;
    @Inject
    private MxAlert alert;
    private Predicate<CcsPosition> pd = p -> {
        if (!this.premise((CcsPosition)p, false)) {
            return false;
        }
        if (this.extend((Position)p)) {
            return true;
        }
        return true;
    };
    private Predicate<CcsPosition> pdZero = p -> {
        if (!this.premise((CcsPosition)p, true)) {
            return false;
        }
        if (this.extend((Position)p)) {
            return true;
        }
        return true;
    };
    private Predicate<CcsDeal> pdDeal = deal -> {
        if (!this.premise((CcsDeal)deal)) {
            return false;
        }
        if (this.extend((CcsDeal)deal)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnSearch = ob -> {
        this.mxList.filter(this.model.getList(), this.pd);
        this.lstnExtendOperation((List<CcsPosition>)this.mxList.getList(), false);
        this.mxZeroList.filter(this.model.getList(), this.pdZero);
        this.lstnExtendOperation((List<CcsPosition>)this.mxZeroList.getList(), true);
        this.mxCountList.update(this.countList, this.pdDeal);
    };
    private InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        Platform.runLater(() -> {
            ArrayList newList = new ArrayList();
            ObservableList observableList = this.model.getList();
            synchronized (observableList) {
                newList.addAll(this.model.getList());
            }
            this.mxList.update(newList, this.pd);
            this.mxZeroList.update(newList, this.pdZero);
            Collections.sort(this.mxList.getList(), (o1, o2) -> {
                if (o1 == null || o2 == null || "".equals(o1) || "".equals(o2)) {
                    return 0;
                }
                return o1.getSecId().compareTo(o2.getSecId());
            });
            this.tablePosition.sort();
            this.lstnExtendOperation((List<CcsPosition>)this.mxList.getList(), false);
            this.lstnExtendOperation((List<CcsPosition>)this.mxZeroList.getList(), true);
        });
    };
    private InvalidationListener lstnModelDeal = ob -> {
        if (!this.isVisible()) {
            return;
        }
        ArrayList<CcsDeal> newList = new ArrayList<CcsDeal>();
        ObservableList observableList = this.dealModel.getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsDeal>)this.getModel().getList());
        }
        this.mxDealList.update(newList, this.pdDeal);
        this.countList = this.createCountList(newList);
        this.mxCountList.update(this.countList, this.pdDeal);
        Platform.runLater(() -> {
            this.tableDealCount.sort();
            this.tableDealCount.refresh();
        });
    };

    @FXML
    public void initialize() {
        this.initDate();
        this.queryEmail();
        this.listener();
        this.createTable();
        this.createCountTable();
        this.initPosFilterAcc();
        this.refreshDeal();
        this.refreshPosition();
    }

    private void initDate() {
        LocalDate local = LocalDate.now();
        String today = local.format(formatterToday);
        String date = local.format(formatterDate);
        this.lbToday.setText(today);
        this.lbDate.setText(date);
    }

    private void queryEmail() {
        List list = this.fundService.getFundAccountList("CCS");
        try {
            this.model.queryAccntEmail(list);
        }
        catch (MException | Exception e) {
            logger.error("\u67e5\u8be2\u90ae\u7bb1\u5931\u8d25" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
    }

    private void initPosFilterAcc() {
        this.btnMail.setDisable(true);
        this.fundAll.setExtAccntId("\u5168\u90e8");
        this.fundAll.setInvestId("\u5168\u90e8");
        this.ccmbAccnt.getItems().add((Object)this.fundAll);
        this.ccmbAccnt.getItems().addAll((Collection)this.fundService.getFundAccountList("CCS"));
        this.ccmbAccnt.setConverter((StringConverter)new FundAccountStringConverter());
        this.ccmbAccnt.getCheckModel().checkAll();
        this.ccmbAccntList();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            BigDecimal accAsset = new BigDecimal(0.0);
            BigDecimal accAvail = new BigDecimal(0.0);
            if (!listItem.contains(this.fundAll)) {
                accStr = "";
                for (FundAccount fundAccount : listItem) {
                    if (fundAccount == null) continue;
                    accStr = String.valueOf(accStr) + fundAccount.getInvestId() + "__" + fundAccount.getAccountName() + ",";
                }
                if (!StringUtils.isEmpty((String)accStr)) {
                    accStr = accStr.substring(0, accStr.length() - 1);
                }
                if (listItem.size() == 1) {
                    this.lbAcc.setText(((FundAccount)listItem.get(0)).getInvestId());
                    this.lbAccName.setText(((FundAccount)listItem.get(0)).getAccountName());
                    this.btnMail.setDisable(false);
                    this.fundAccount = (FundAccount)listItem.get(0);
                } else {
                    this.lbAcc.setText("");
                    this.lbAccName.setText("");
                    this.btnMail.setDisable(true);
                }
            } else {
                this.lbAcc.setText("");
                this.lbAccName.setText("");
                this.btnMail.setDisable(true);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (FundAccount fundAcc : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(fundAcc.getInvestId());
                accAsset = accAsset.add(BigDecimal.valueOf(fundAcc.getAssetAmt()));
                accAvail = accAvail.add(BigDecimal.valueOf(fundAcc.getAvailable()));
            }
            this.lbAccAsset.setText(StringUtils.toThousands((Number)accAsset.doubleValue(), (int)2));
            this.lbAccAvail.setText(StringUtils.toThousands((Number)accAvail.doubleValue(), (int)2));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
        this.accFalg = true;
    }

    private void ccmbAccntList() {
        int i = 1;
        while (i < this.ccmbAccnt.getItems().size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.accFalg = true;
            }
        });
    }

    private String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getSecId() + deal.getSide().getRaw();
        return key;
    }

    private void listener() {
        this.getModel().changedProperty().addListener(this.lstnModelDeal);
        this.model.changedProperty().addListener(this.lstnModel);
        this.lbAccnt.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.getModel().changedProperty().removeListener(this.lstnModelDeal);
        this.model.changedProperty().removeListener(this.lstnModel);
        this.lbAccnt.textProperty().removeListener(this.lstnSearch);
    }

    public void lstnExtendOperation(List<CcsPosition> list, boolean containZero) {
        BigDecimal capital = new BigDecimal(0.0);
        BigDecimal floatPl = new BigDecimal(0.0);
        BigDecimal realPl = new BigDecimal(0.0);
        BigDecimal totalPl = new BigDecimal(0.0);
        BigDecimal posiAmt = new BigDecimal(0.0);
        BigDecimal todayFloatPl = new BigDecimal(0.0);
        BigDecimal todayRealPl = new BigDecimal(0.0);
        BigDecimal todayTotalPl = new BigDecimal(0.0);
        for (CcsPosition posi : list) {
            capital = capital.add(BigDecimal.valueOf(posi.getCapitalization()));
            floatPl = floatPl.add(BigDecimal.valueOf(posi.getFloatPl()));
            realPl = realPl.add(BigDecimal.valueOf(posi.getRealizedPl()));
            totalPl = totalPl.add(BigDecimal.valueOf(posi.getTotalPl()));
            posiAmt = posiAmt.add(BigDecimal.valueOf(posi.getCarryBuyCostAmtNew()));
            todayFloatPl = todayFloatPl.add(BigDecimal.valueOf(posi.getTodayFloatPl()));
            todayRealPl = todayRealPl.add(BigDecimal.valueOf(posi.getTodayRealPl()));
            todayTotalPl = todayTotalPl.add(BigDecimal.valueOf(posi.getTodayTotalPl()));
        }
        if (containZero) {
            this.lbPosiAmt.setText(StringUtils.toThousands((Number)posiAmt.doubleValue(), (int)2));
            this.lbCapital.setText(StringUtils.toThousands((Number)capital.doubleValue(), (int)2));
            this.lbFloatPL.setText(StringUtils.toThousands((Number)floatPl.doubleValue(), (int)2));
            this.lbRealPl.setText(StringUtils.toThousands((Number)realPl.doubleValue(), (int)2));
            this.lbTotalPl.setText(StringUtils.toThousands((Number)totalPl.doubleValue(), (int)2));
            this.lbTodayFloatPL.setText(StringUtils.toThousands((Number)todayFloatPl.doubleValue(), (int)2));
            this.lbTodayRealPl.setText(StringUtils.toThousands((Number)todayRealPl.doubleValue(), (int)2));
            this.lbTodayTotalPl.setText(StringUtils.toThousands((Number)todayTotalPl.doubleValue(), (int)2));
        }
        if (!containZero) {
            this.lbNum.setText(StringUtils.toThousands((Number)list.size()));
            for (CcsPosition posi : list) {
                double capitalPrecent = 0.0;
                if (capital.doubleValue() != 0.0) {
                    capitalPrecent = posi.getCapitalization() * 100.0 / capital.doubleValue();
                }
                posi.setCapitalPrecent(this.formatScale(capitalPrecent, 2));
                double totalPlPrecent = 0.0;
                if (totalPl.doubleValue() != 0.0) {
                    totalPlPrecent = posi.getTotalPl() * 100.0 / totalPl.doubleValue();
                }
                posi.setTotalProfitLossPrecent(this.formatScale(totalPlPrecent, 2));
                double plRate = 0.0;
                if (posi.getCarryBuyCostAmtNew() != 0.0) {
                    plRate = posi.getFloatPl() * 100.0 / posi.getCarryBuyCostAmtNew();
                }
                posi.setPlRate(this.formatScale(plRate, 2));
            }
        }
    }

    private double formatScale(double d, int scale) {
        return BigDecimal.valueOf(d).setScale(scale, 4).doubleValue();
    }

    public boolean extend(Position posi) {
        return false;
    }

    public boolean premise(CcsPosition pos, boolean containZero) {
        if (this.model.getPledgeCode().contains(pos.getSecId())) {
            return false;
        }
        if (!(containZero || pos.getTotalVol() >= 0L && pos.getTotalVol() != 0L)) {
            return false;
        }
        return this.accIds.contains(pos.getInvestorId());
    }

    @FXML
    public void refreshDeal() {
        this.getModel().query();
    }

    @FXML
    public void refreshPosition() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead(this.tablePosition, (int)0, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u80a1\u4efd\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copyCount() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelCount() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void mail() {
        if (StringUtils.isEmpty((String)this.fundAccount.getEmail())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8bbe\u7f6e\u90ae\u7bb1");
            return;
        }
        HSSFWorkbook wb = this.setAccountToExcel();
        MailExcelUtils.writeExcel(this.tablePosition, (String)"\u6301\u4ed3\u80a1\u4efd", (HSSFWorkbook)wb, (int)1);
        MailExcelUtils.writeExcel(this.tableDealCount, (String)"\u5f53\u65e5\u4ea4\u6613", (HSSFWorkbook)wb, (int)2);
        byte[] data = MailExcelUtils.createExcel((HSSFWorkbook)wb);
        try {
            this.model.uploadAccntEmail(data, this.fundAccount);
            this.alert.check(false, Alert.AlertType.INFORMATION, "\u53d1\u9001\u90ae\u7bb1\u6210\u529f");
        }
        catch (MException e) {
            logger.error("\u53d1\u9001\u5931\u8d25" + e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private HSSFWorkbook setAccountToExcel() {
        Object[][] co = new Object[6][6];
        co[0][0] = "\u62a5\u8868\u65e5\u671f";
        co[0][1] = this.lbDate.getText();
        co[0][2] = "\u8d44\u91d1\u53f7";
        co[0][3] = this.lbAcc.getText();
        co[0][4] = "\u8d26\u6237\u540d\u79f0";
        co[0][5] = this.lbAccName.getText();
        co[1][0] = "\u6574\u4f53\u60c5\u51b5";
        co[2][0] = "\u603b\u8d44\u4ea7";
        co[2][1] = StringUtils.parseString((String)this.lbAccAsset.getText());
        co[2][2] = "\u53ef\u7528\u8d44\u91d1";
        co[2][3] = StringUtils.parseString((String)this.lbAccAvail.getText());
        co[3][0] = "\u603b\u76c8\u4e8f";
        co[3][1] = StringUtils.parseString((String)this.lbTotalPl.getText());
        co[3][2] = "\u5b9e\u73b0\u76c8\u4e8f";
        co[3][3] = StringUtils.parseString((String)this.lbRealPl.getText());
        co[3][4] = "\u6d6e\u52a8\u76c8\u4e8f";
        co[3][5] = StringUtils.parseString((String)this.lbFloatPL.getText());
        co[4][0] = "\u5f53\u65e5\u603b\u76c8\u4e8f";
        co[4][1] = StringUtils.parseString((String)this.lbTodayTotalPl.getText());
        co[4][2] = "\u5f53\u65e5\u5b9e\u73b0\u76c8\u4e8f";
        co[4][3] = StringUtils.parseString((String)this.lbTodayRealPl.getText());
        co[4][4] = "\u5f53\u65e5\u6d6e\u52a8\u76c8\u4e8f";
        co[4][5] = StringUtils.parseString((String)this.lbTodayFloatPL.getText());
        co[5][0] = "\u6301\u4ed3\u8bc1\u5238\u6570\u91cf";
        co[5][1] = StringUtils.parseString((String)this.lbNum.getText());
        co[5][2] = "\u6301\u4ed3\u5e02\u503c";
        co[5][3] = StringUtils.parseString((String)this.lbCapital.getText());
        co[5][4] = "\u6301\u4ed3\u6210\u672c";
        co[5][5] = StringUtils.parseString((String)this.lbPosiAmt.getText());
        return MailExcelUtils.getHSSFWorkbook((String)"\u8d44\u91d1\u4fe1\u606f", null, (Object[][])co, null);
    }

    @FXML
    public void setAcc() {
        List list = this.fundService.getFundAccountList("CCS");
        try {
            this.model.queryAccntEmail(list);
            CcsSetMailDialog obj = (CcsSetMailDialog)((Object)this.of.create(CcsSetMailDialog.class));
            obj.setList(list);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u90ae\u7bb1\u8bbe\u7f6e");
            dialog.launch();
        }
        catch (MException | Exception e) {
            logger.error("\u67e5\u8be2\u90ae\u7bb1\u5931\u8d25" + e.getMessage(), e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public boolean premise(CcsDeal deal) {
        return this.accIds.contains(deal.getInvestorId());
    }

    public boolean extend(CcsDeal deal) {
        return false;
    }

    public void onVisit() {
        this.lstnModelDeal.invalidated(null);
    }

    private List<CcsDeal> createCountList(List<CcsDeal> newList) {
        HashMap<String, CcsDeal> map = new HashMap<String, CcsDeal>();
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        int i = 0;
        while (i < newList.size()) {
            CcsDeal deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                CcsDeal newDeal = (CcsDeal)CcsDeal.class.cast(this.fDeal.create("CCS"));
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(newDeal.getLastPx() * newDeal.getLastQty());
                newDeal.setInvestorName(deal.getInvestorName());
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                CcsDeal oldDeal = (CcsDeal)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double amount = deal.getLastAmount();
                double oldQty = oldDeal.getLastQty();
                double oldAmount = oldDeal.getLastAmount();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastAmount(oldAmount + amount);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1L);
                oldDeal.setInvestorName(deal.getInvestorName());
                oldDeal.setLastAmountSum(oldDeal.getLastAmountSum() + price * qty);
            }
            ++i;
        }
        for (CcsDeal deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmountSum() / deal.getLastQty() * 10000.0) / 10000.0);
                continue;
            }
            deal.setLastPx(0.0);
        }
        return list;
    }

    private void createCountTable() {
        this.colCountSecId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getSecId()));
        this.colCountSecName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getSecName()));
        this.colCountDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getSide()));
        this.colCountDir.setCellFactory(cell -> new SideCell());
        this.colCountVol.setCellFactory(column -> new NumberTableCell());
        this.colCountVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastQty()));
        this.colCountUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getUnit()));
        this.colCountPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastPx()));
        this.colCountPrice.setCellFactory(p -> new AvgPriceCell());
        this.colCountMkt.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getMarket()));
        this.colCountAmount.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastAmount()));
        this.colCountAmount.setCellFactory(p -> new DoubleTableCell());
        this.colCount.setCellValueFactory(data -> new SimpleLongProperty(((CcsDeal)data.getValue()).getDealCount()));
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getList());
        TableUtils.orgnizeClmWidth(this.tableDealCount);
    }

    private void createTable() {
        this.colSecId.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secNameProperty());
        this.colTotalVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalVolProperty());
        this.colTotalVol.setCellFactory(cell -> new NumberTableCell());
        this.colCarryBuyCost.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryBuyCostProperty());
        this.colCarryBuyCost.setCellFactory(data -> new DoubleTableCell(3));
        this.colNowPrice.setCellValueFactory(data -> ((CcsPosition)data.getValue()).nowPriceProperty());
        this.colNowPrice.setCellFactory(cell -> new DoubleTableCell(3));
        this.colCarryBuyCostAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryBuyCostAmtNewProperty());
        this.colCarryBuyCostAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colPosiCapital.setCellValueFactory(data -> ((CcsPosition)data.getValue()).capitalizationProperty());
        this.colPosiCapital.setCellFactory(cell -> new DoubleTableCell());
        this.colProfit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).floatPlProperty());
        this.colProfit.setCellFactory(data -> new DoubleTableCell());
        this.colRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).realizedPlProperty());
        this.colRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colTotalPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalPlProperty());
        this.colTotalPl.setCellFactory(data -> new DoubleTableCell());
        this.colPlRate.setCellValueFactory(data -> ((CcsPosition)data.getValue()).plRateProperty());
        this.colPlRate.setCellFactory(cell -> new DoubleTableCell());
        this.colCapitalPrecent.setCellValueFactory(data -> ((CcsPosition)data.getValue()).capitalPrecentProperty());
        this.colCapitalPrecent.setCellFactory(cell -> new DoubleTableCell());
        this.colTotalProfitLossPrecent.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalProfitLossPrecentProperty());
        this.colTotalProfitLossPrecent.setCellFactory(cell -> new DoubleTableCell());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    protected DealQueryModel<CcsDeal> getModel() {
        return this.dealModel;
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsDeal> {
        int scale = 4;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class ObPriceCell
    extends DoubleTableCell<ObCcsDeal> {
        int scale = 3;

        private ObPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCcsDeal deal = (ObCcsDeal)ObCcsDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsMailCreaterPart.this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

