/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CcsDealPart
extends MxPart {
    @FXML
    protected TableView<CcsDeal> tableDeal;
    @FXML
    private TableColumn<CcsDeal, String> colSecId;
    @FXML
    private TableColumn<CcsDeal, String> colSecName;
    @FXML
    private TableColumn<CcsDeal, MxNode> colDir;
    @FXML
    private TableColumn<CcsDeal, Number> colVol;
    @FXML
    private TableColumn<CcsDeal, String> colUnit;
    @FXML
    private TableColumn<CcsDeal, Number> colPrice;
    @FXML
    private TableColumn<CcsDeal, String> colTime;
    @FXML
    private TableColumn<CcsDeal, MxNode> colMkt;
    @FXML
    private TableColumn<CcsDeal, String> colENo;
    @FXML
    private TableColumn<CcsDeal, String> colDealNo;
    @FXML
    private TableColumn<CcsDeal, String> colAcc;
    @FXML
    private TableColumn<CcsDeal, String> colSecAcc;
    @FXML
    private TableColumn<CcsDeal, Number> colAmt;
    @FXML
    protected TableColumn<CcsDeal, String> colReference;
    @FXML
    protected TableView<CcsDeal> tableDealCount;
    @FXML
    private TableColumn<CcsDeal, String> colCountSecId;
    @FXML
    private TableColumn<CcsDeal, String> colCountSecName;
    @FXML
    private TableColumn<CcsDeal, MxNode> colCountDir;
    @FXML
    private TableColumn<CcsDeal, Number> colCountVol;
    @FXML
    private TableColumn<CcsDeal, String> colCountUnit;
    @FXML
    private TableColumn<CcsDeal, Number> colCountPrice;
    @FXML
    private TableColumn<CcsDeal, MxNode> colCountMkt;
    @FXML
    private TableColumn<CcsDeal, Number> colCountAmount;
    @FXML
    private TableColumn<CcsDeal, Number> colCount;
    @FXML
    private TableColumn<CcsDeal, String> colCountAcc;
    @FXML
    protected TextField searchText;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton countRadio;
    @Inject
    protected CcsDealModel model;
    protected ToggleGroup group = new ToggleGroup();
    @Inject
    private IRefDataMng refMng;
    @Inject
    private DealFactory fDeal;
    protected MxList<CcsDeal> mxList = new MxList();
    protected MxList<CcsDeal> mxCountList = new MxList();
    protected List<CcsDeal> countList = new LinkedList<CcsDeal>();
    private static final Logger logger = LogManager.getLogger(CcsDealPart.class);
    @Inject
    private MxAlert alert;
    protected Predicate<CcsDeal> pd = deal -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsDeal)deal)) {
            return false;
        }
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (deal.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (deal.getOrderId().contains(text)) {
            return true;
        }
        return this.extend((CcsDeal)deal);
    };
    protected InvalidationListener lstnModel = ob -> {
        List<CcsDeal> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<CcsDeal> observableList = this.getModel().getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsDeal>)this.getModel().getList());
        }
        this.countList = this.createCountList(newList);
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
            this.tableDeal.sort();
            this.tableDeal.refresh();
            this.mxCountList.update(this.countList, this.pd);
            Collections.sort(this.mxCountList.getList(), (o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
            this.tableDealCount.sort();
            this.tableDealCount.refresh();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<CcsDeal> observableList = this.getModel().getList();
        synchronized (observableList) {
            this.mxList.filter(this.getModel().getList(), this.pd);
            this.mxCountList.filter(this.countList, this.pd);
        }
    };
    @Inject
    private LoadPartModel load;

    @FXML
    public void initialize() {
        this.listener();
        this.setRadio();
        this.createTable();
        this.createCountTable();
        this.refresh();
        this.onFocus();
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsDeal deal = (CcsDeal)this.tableDeal.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.deal")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
        if (this.tableDealCount != null) {
            this.tableDealCount.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                CcsDeal deal = (CcsDeal)this.tableDealCount.getSelectionModel().getSelectedItem();
                if (deal == null) {
                    return;
                }
                if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.deal")) {
                    MEvent e = new MEvent();
                    e.put((Object)"sec_code", (Object)deal.getSecId());
                    e.put((Object)"tMarket", (Object)deal.getInstrument().getMarket().getRaw());
                    this.es.postEvent("input.bond.trade", e);
                }
            });
        }
    }

    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableDeal.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        if (this.tableDealCount != null) {
            this.tableDealCount.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
        }
    }

    protected String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getInstrument().getSecId() + deal.getSide().getRaw();
        return key;
    }

    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Focus
    public void onFocus() {
        this.tableDeal.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableDeal);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableDeal, (String)"\u6210\u4ea4\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @FXML
    public void copyCount() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelCount() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public boolean premise(CcsDeal deal) {
        return true;
    }

    public boolean extend(CcsDeal deal) {
        return false;
    }

    protected List<CcsDeal> createCountList(List<CcsDeal> newList) {
        HashMap<String, CcsDeal> map = new HashMap<String, CcsDeal>();
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        int i = 0;
        while (i < newList.size()) {
            CcsDeal deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                CcsDeal newDeal = (CcsDeal)CcsDeal.class.cast(this.fDeal.create("CCS"));
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(newDeal.getLastPx() * newDeal.getLastQty());
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                CcsDeal oldDeal = (CcsDeal)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double amount = deal.getLastAmount();
                double oldQty = oldDeal.getLastQty();
                double oldAmount = oldDeal.getLastAmount();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastAmount(oldAmount + amount);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1L);
                oldDeal.setLastAmountSum(oldDeal.getLastAmountSum() + price * qty);
            }
            ++i;
        }
        for (CcsDeal deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmountSum() / deal.getLastQty() * 10000.0) / 10000.0);
                continue;
            }
            deal.setLastPx(0.0);
        }
        return list;
    }

    protected void createTable() {
        this.colSecId.setCellValueFactory(data -> ((CcsDeal)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsDeal)data.getValue()).getInstrument().symbolProperty());
        this.colDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getSide()));
        this.colDir.setCellFactory(cell -> new SideCell());
        this.colVol.setCellFactory(column -> new NumberTableCell());
        this.colVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastQty()));
        this.colUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getUnit()));
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastPx()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getExecTime()));
        this.colMkt.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getMarket()));
        this.colENo.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getOrderId()));
        this.colDealNo.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getExecId()));
        this.colAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInverstorSecId()));
        this.colAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastAmount()));
        this.colAmt.setCellFactory(p -> new PriceCell());
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getReference()));
        this.tableDeal.setPlaceholder((Node)new Label());
        this.tableDeal.setItems(this.mxList.getList());
        this.colTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableDeal.getSortOrder().add(this.colTime);
        TableUtils.orgnizeClmWidth(this.tableDeal);
    }

    protected void createCountTable() {
        this.colCountSecId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getSecId()));
        this.colCountSecName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getSecName()));
        this.colCountDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getSide()));
        this.colCountDir.setCellFactory(cell -> new SideCell());
        this.colCountVol.setCellFactory(column -> new NumberTableCell());
        this.colCountVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastQty()));
        this.colCountUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getUnit()));
        this.colCountPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastPx()));
        this.colCountPrice.setCellFactory(p -> new AvgPriceCell());
        this.colCountMkt.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getMarket()));
        this.colCountAmount.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastAmount()));
        this.colCountAmount.setCellFactory(p -> new DoubleTableCell());
        this.colCount.setCellValueFactory(data -> new SimpleLongProperty(((CcsDeal)data.getValue()).getDealCount()));
        this.colCountAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInvestorId()));
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getList());
        TableUtils.orgnizeClmWidth(this.tableDealCount);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected DealQueryModel<CcsDeal> getModel() {
        return this.model;
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsDeal> {
        int scale = 4;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsDeal> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsDeal deal = (CcsDeal)CcsDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsDealPart.this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<CcsDeal, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

