/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.ObCcsDeal;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.query.current.views.SortPolicy;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class CcsDealPagePart
extends MxPart {
    private static final Integer PAGE_SIZE = 500;
    @FXML
    protected TableView<ObCcsDeal> tableDeal;
    @FXML
    private TableColumn<ObCcsDeal, String> secId;
    @FXML
    private TableColumn<ObCcsDeal, String> secName;
    @FXML
    private TableColumn<ObCcsDeal, String> side;
    @FXML
    private TableColumn<ObCcsDeal, Number> lastQty;
    @FXML
    private TableColumn<ObCcsDeal, String> unit;
    @FXML
    private TableColumn<ObCcsDeal, Number> lastPx;
    @FXML
    private TableColumn<ObCcsDeal, String> execTime;
    @FXML
    private TableColumn<ObCcsDeal, String> market;
    @FXML
    private TableColumn<ObCcsDeal, String> orderId;
    @FXML
    private TableColumn<ObCcsDeal, String> baseId;
    @FXML
    private TableColumn<ObCcsDeal, String> execId;
    @FXML
    private TableColumn<ObCcsDeal, String> investorId;
    @FXML
    private TableColumn<ObCcsDeal, String> counterName;
    @FXML
    private TableColumn<ObCcsDeal, String> investorName;
    @FXML
    private TableColumn<ObCcsDeal, String> inverstorSecId;
    @FXML
    private TableColumn<ObCcsDeal, Number> lastAmount;
    @FXML
    private TableColumn<ObCcsDeal, String> reference;
    @FXML
    protected TableView<CcsDeal> tableDealCount;
    @FXML
    private TableColumn<CcsDeal, String> colCountSecId;
    @FXML
    private TableColumn<CcsDeal, String> colCountSecName;
    @FXML
    private TableColumn<CcsDeal, MxNode> colCountDir;
    @FXML
    private TableColumn<CcsDeal, Number> colCountVol;
    @FXML
    private TableColumn<CcsDeal, String> colCountUnit;
    @FXML
    private TableColumn<CcsDeal, Number> colCountPrice;
    @FXML
    private TableColumn<CcsDeal, MxNode> colCountMkt;
    @FXML
    private TableColumn<CcsDeal, Number> colCountAmount;
    @FXML
    private TableColumn<CcsDeal, Number> colCount;
    @FXML
    private TableColumn<CcsDeal, String> colCountAcc;
    @FXML
    private TableColumn<CcsDeal, String> colCountAccName;
    @FXML
    protected TextField searchText;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton countRadio;
    @Inject
    protected CcsDealModel model;
    protected ToggleGroup group = new ToggleGroup();
    @Inject
    private IRefDataMng refMng;
    @Inject
    private DealFactory fDeal;
    protected MxPageList<CcsDeal, ObCcsDeal> mxList = new MxPageList(PAGE_SIZE.intValue(), ObCcsDeal.class);
    protected MxList<CcsDeal> mxCountList = new MxList();
    private static final Logger logger = LogManager.getLogger(CcsDealPagePart.class);
    @FXML
    private Label lbCurrentCount;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbCountSeparator;
    private boolean dragFlag = false;
    private long lastDragTime = 0L;
    private ScrollBar bar;
    private double lastPosition = 0.0;
    @Inject
    private MxAlert alert;
    public Callback<TableView<ObCcsDeal>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<ObCcsDeal>(){

        @Override
        public void afterSort() {
            CcsDealPagePart.this.lstnModel.invalidated(null);
        }
    };
    private long lastLoadTime;
    protected Predicate<CcsDeal> pd = deal -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((CcsDeal)deal)) {
            return false;
        }
        if (deal.getSecId().contains(text)) {
            return true;
        }
        if (deal.getSecName().contains(text)) {
            return true;
        }
        if (deal.getOrderId().contains(text)) {
            return true;
        }
        return this.extend((CcsDeal)deal);
    };
    protected InvalidationListener lstnModel = ob -> this.refreshModel();
    protected InvalidationListener lstnSearch = ob -> {
        ArrayList<CcsDeal> newList = new ArrayList<CcsDeal>();
        ObservableList<CcsDeal> observableList = this.getModel().getList();
        synchronized (observableList) {
            this.mxList.filter(this.getModel().getList(), this.pd);
            newList.addAll((Collection<CcsDeal>)this.getModel().getList());
        }
        List<CcsDeal> newCountList = this.createCountList(newList);
        this.mxCountList.filter(newCountList, this.pd);
        this.sort();
        this.updateTable();
    };
    @Inject
    private LoadPartModel load;

    @FXML
    public void initialize() {
        this.tableDeal.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.listener();
        this.setRadio();
        this.createTable();
        this.createCountTable();
        this.refresh();
        this.onFocus();
        this.initPage();
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsDeal deal = (ObCcsDeal)this.tableDeal.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.deal")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
        this.tableDealCount.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsDeal deal = (CcsDeal)this.tableDealCount.getSelectionModel().getSelectedItem();
            if (deal == null) {
                return;
            }
            if (this.p.getParent().getParent().getId().replaceAll("-", ".").equals("cms.tmx.bond.part.deal")) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getInstrument().getMarket().getRaw());
                this.es.postEvent("input.bond.trade", e);
            }
        });
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.dragFlag) {
                    event.consume();
                }
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableDeal.lookup(".scroll-bar:vertical");
                }
                if (this.bar.getValue() != this.lastPosition) {
                    long current = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.lastDragTime < 100L) {
                        return;
                    }
                    this.lastDragTime = current;
                    if (this.bar.getValue() < this.lastPosition) {
                        if (this.bar.getValue() <= this.bar.getMax() * 0.1) {
                            this.loadPrevPage();
                        }
                    } else if (this.bar.getValue() >= this.bar.getMax() * 0.9) {
                        this.loadNextPage();
                    }
                    this.lastPosition = this.bar.getValue();
                }
            }
        });
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.dragFlag = false;
        });
        this.tableDeal.setOnScroll(ob -> {
            long now = System.currentTimeMillis();
            if (now - this.lastLoadTime < 1000L) {
                return;
            }
            this.lastLoadTime = now;
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableDeal.lookup(".scroll-bar:vertical");
            }
            if (ob.getDeltaY() > 0.0) {
                if (this.lbCurrentCount.getText().startsWith("1-")) {
                    return;
                }
                this.loadPrevPage();
                this.bar.setValue(1.0);
                return;
            }
            if (this.lbCurrentCount.getText().endsWith("-" + this.lbTotalCount.getText())) {
                return;
            }
            this.loadNextPage();
            this.bar.setValue(0.0);
        });
    }

    private void initPage() {
        this.lbCurrentCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbTotalCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbCountSeparator.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
    }

    @PreDestroy
    public void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    private void loadNextPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE >= this.mxList.getList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE < this.mxList.getList().size()) {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() + PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    private void loadPrevPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() == 0) {
            return;
        }
        if (this.mxList.getBeginIndex() - PAGE_SIZE < 0) {
            this.mxList.setBeginIndex(0);
        } else {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() - PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableDeal.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableDealCount.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
    }

    protected String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getSecId() + deal.getSide().getRaw();
        return key;
    }

    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Focus
    public void onFocus() {
        this.tableDeal.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableDeal, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listDeal = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listDeal.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableDeal, (List)listDeal, (String)"\u6210\u4ea4\u660e\u7ec6");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.getModel().query();
    }

    @FXML
    public void copyCount() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelCount() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public boolean premise(CcsDeal deal) {
        return true;
    }

    public boolean extend(CcsDeal deal) {
        return false;
    }

    public void onVisit() {
        this.exe.execute(() -> this.lstnModel.invalidated(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        if (!this.isVisible()) {
            return;
        }
        ArrayList<CcsDeal> newList = new ArrayList<CcsDeal>();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<CcsDeal>)this.getModel().getList());
        }
        this.mxList.update(newList, this.pd);
        this.sort();
        this.updateTable();
        List<CcsDeal> newCountList = this.createCountList(newList);
        System.out.println(newCountList.size());
        Platform.runLater(() -> {
            this.mxCountList.update(newCountList, this.pd);
            this.tableDealCount.sort();
            this.tableDealCount.refresh();
        });
    }

    public void sort() {
        try {
            this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
            ObservableList sortOrder = this.tableDeal.getSortOrder();
            for (TableColumn column : sortOrder) {
                this.mxList.getList().sort((o1, o2) -> {
                    try {
                        Method method = CcsDeal.class.getMethod("get" + CcsDealPagePart.capitalize(column.getId()), new Class[0]);
                        Object s1 = method.invoke(o1, new Object[0]);
                        Object s2 = method.invoke(o2, new Object[0]);
                        if (s1 instanceof Number) {
                            return QueryUtils.compareNumber(column, s1, s2);
                        }
                        if (s1 instanceof MxNode) {
                            return QueryUtils.compareMxNode(column, s1, s2);
                        }
                        return QueryUtils.compareString(column, s1, s2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("ccsDealPagePart sort error:", (Throwable)e);
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public void updateTable() {
        Platform.runLater(() -> {
            this.mxList.updatePageList();
            if (this.lbCurrentCount != null && this.lbTotalCount != null) {
                this.lbCurrentCount.setText(String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            }
        });
    }

    protected List<CcsDeal> createCountList(List<CcsDeal> newList) {
        HashMap<String, CcsDeal> map = new HashMap<String, CcsDeal>();
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        int i = 0;
        while (i < newList.size()) {
            CcsDeal deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                CcsDeal newDeal = (CcsDeal)CcsDeal.class.cast(this.fDeal.create("CCS"));
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(newDeal.getLastPx() * newDeal.getLastQty());
                newDeal.setInvestorName(deal.getInvestorName());
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                CcsDeal oldDeal = (CcsDeal)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double amount = deal.getLastAmount();
                double oldQty = oldDeal.getLastQty();
                double oldAmount = oldDeal.getLastAmount();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastAmount(oldAmount + amount);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1L);
                oldDeal.setInvestorName(deal.getInvestorName());
                oldDeal.setLastAmountSum(oldDeal.getLastAmountSum() + price * qty);
            }
            ++i;
        }
        for (CcsDeal deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmountSum() / deal.getLastQty() * 10000.0) / 10000.0);
                continue;
            }
            deal.setLastPx(0.0);
        }
        return list;
    }

    protected void createTable() {
        this.tableDeal.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsDeal dl;
            if (event.getClickCount() == 1 && (dl = (ObCcsDeal)this.tableDeal.getSelectionModel().getSelectedItem()) != null) {
                String code = dl.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)dl.getInstrument().getSecType());
                eCall.put((Object)"tMarket", (Object)dl.getInstrument().getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.secId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).secNameProperty());
        this.side.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).sideProperty());
        this.side.setCellFactory(cell -> new SideCell());
        this.lastQty.setCellFactory(column -> new NumberTableCell());
        this.lastQty.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).lastQtyProperty());
        this.unit.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).unitProperty());
        this.lastPx.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).lastPxProperty());
        this.lastPx.setCellFactory(p -> new ObPriceCell());
        this.execTime.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).execTimeProperty());
        this.market.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).marketProperty());
        this.orderId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).orderIdProperty());
        this.baseId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).baseIdProperty());
        this.execId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).execIdProperty());
        this.investorId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).investorIdProperty());
        this.inverstorSecId.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).inverstorSecIdProperty());
        this.lastAmount.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).lastAmountProperty());
        this.lastAmount.setCellFactory(p -> new ObPriceCell());
        this.reference.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).referenceProperty());
        this.investorName.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).investorNameProperty());
        this.investorName.setCellFactory(data -> new TooltipTableCell<ObCcsDeal, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : (String)((ObCcsDeal)this.getValue()).investorNameProperty().get();
            }
        });
        if (this.counterName != null) {
            this.counterName.setCellValueFactory(data -> ((ObCcsDeal)data.getValue()).counterNameProperty());
        }
        this.tableDeal.setPlaceholder((Node)new Label());
        this.tableDeal.setItems(this.mxList.getPageList());
        this.execTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableDeal.getSortOrder().add(this.execTime);
        TableUtils.orgnizeClmWidth(this.tableDeal);
    }

    protected void createCountTable() {
        this.tableDealCount.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsDeal dl;
            if (event.getClickCount() == 1 && (dl = (CcsDeal)this.tableDealCount.getSelectionModel().getSelectedItem()) != null) {
                String code = dl.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"sec_type", (Object)dl.getInstrument().getSecType());
                eCall.put((Object)"tMarket", (Object)dl.getInstrument().getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.zy.code", eCall);
            }
        });
        this.colCountSecId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getSecId()));
        this.colCountSecName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getSecName()));
        this.colCountDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getSide()));
        this.colCountDir.setCellFactory(cell -> new cms.tmx.query.utils.SideCell());
        this.colCountVol.setCellFactory(column -> new NumberTableCell());
        this.colCountVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastQty()));
        this.colCountUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getUnit()));
        this.colCountPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastPx()));
        this.colCountPrice.setCellFactory(p -> new AvgPriceCell());
        this.colCountMkt.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getMarket()));
        this.colCountAmount.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastAmount()));
        this.colCountAmount.setCellFactory(p -> new DoubleTableCell());
        this.colCount.setCellValueFactory(data -> new SimpleLongProperty(((CcsDeal)data.getValue()).getDealCount()));
        this.colCountAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInvestorId()));
        this.colCountAccName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInvestorName()));
        this.colCountAccName.setCellFactory(data -> new TooltipTableCell<CcsDeal, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((CcsDeal)this.getValue()).getInvestorName();
            }
        });
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getList());
        TableUtils.orgnizeClmWidth(this.tableDealCount);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected DealQueryModel<CcsDeal> getModel() {
        return this.model;
    }

    private class AvgPriceCell
    extends DoubleTableCell<CcsDeal> {
        int scale = 4;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    protected class ObPriceCell
    extends DoubleTableCell<ObCcsDeal> {
        int scale = 3;

        protected ObPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObCcsDeal deal = (ObCcsDeal)ObCcsDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsDealPagePart.this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsDeal> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsDeal deal = (CcsDeal)CcsDeal.class.cast(this.getTableRow().getItem());
                RefItem refItem = CcsDealPagePart.this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObCcsDeal, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return;
            }
            ObCcsDeal deal = (ObCcsDeal)ObCcsDeal.class.cast(this.getTableRow().getItem());
            int side = StringUtils.parseInt((String)deal.getSideRaw());
            this.label.setText(value);
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

