/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.views.LoadPartModel;
import java.net.URL;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsAcctDetailPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(CcsAcctDetailPart.class);
    @FXML
    protected TableView<FundAccount> tableAcc;
    @FXML
    protected TableColumn<CcsFundAccount, String> colAcc;
    @FXML
    protected TableColumn<CcsFundAccount, String> colAccName;
    @FXML
    protected TableColumn<CcsFundAccount, Number> colAvailable;
    @FXML
    protected TableColumn<CcsFundAccount, Number> colDesCapital;
    @FXML
    protected TableColumn<CcsFundAccount, Number> colAsset;
    protected MxList<FundAccount> mxList = new MxList();
    @Inject
    protected IFundAccountService serviceFundAccount;
    @Inject
    protected MxAlert alert;
    protected InvalidationListener lstnTable = ob -> {
        this.mxList.update(this.serviceFundAccount.getFundAccountList("CCS"));
        this.layout();
    };
    @Inject
    private LoadPartModel load;

    @FXML
    public void initialize() {
        this.mxList.update(this.serviceFundAccount.getFundAccountList("CCS"));
        this.serviceFundAccount.changedProperty().addListener(this.lstnTable);
        this.createTableView();
    }

    @PreDestroy
    private void close() {
        this.serviceFundAccount.changedProperty().removeListener(this.lstnTable);
    }

    protected void query() {
        this.serviceFundAccount.queryFundAccountList();
    }

    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableAcc, (String)"\u8d26\u53f7\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createTableView() {
        this.tableAcc.setPlaceholder((Node)new Label());
        this.tableAcc.setItems(this.mxList.getList());
        this.colAcc.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).investIdProperty());
        this.colAccName.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).accountNameProperty());
        this.colAvailable.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).availableProperty());
        this.colAvailable.setCellFactory(column -> new DoubleTableCell());
        this.colDesCapital.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).withdrawQuotaProperty());
        this.colDesCapital.setCellFactory(column -> new DoubleTableCell());
        this.colAsset.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).assetAmtProperty());
        this.colAsset.setCellFactory(column -> new DoubleTableCell());
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        MenuItem itemExcel = new MenuItem("\u5bfc\u51faEXCEL");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        menu.getItems().add((Object)itemExcel);
        itemCopy.setOnAction(event -> this.copy());
        itemRefresh.setOnAction(event -> this.query());
        itemExcel.setOnAction(event -> this.exportExcel());
        this.tableAcc.setContextMenu(menu);
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.colAcc.getText()) + "\t" + this.colAccName.getText() + "\t" + this.colAsset.getText() + "\t" + this.colDesCapital.getText() + "\t" + this.colAvailable.getText() + '\n');
        for (FundAccount item : this.mxList.getList()) {
            CcsFundAccount cur = (CcsFundAccount)CcsFundAccount.class.cast(item);
            clipboardString.append(String.valueOf(cur.getInvestId()) + "\t" + cur.getAccountName() + "\t" + cur.getAssetAmt() + "\t" + cur.getWithdrawQuota() + "\t" + cur.getAvailable() + '\n');
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }
}

