/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.basket.BasketCcsOrderModel;
import cms.tmx.query.current.models.basket.BasketTaskModel;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.query.current.views.LoadPartModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasketTaskPart
extends MxPart {
    @FXML
    protected TreeTableView<BasketCcsOrder> treeTableBasketTask;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Boolean> colCheckBox;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colBatchSNo;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colBasketName;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colFundAccntId;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colSecAccntId;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colSecCode;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colOrderId;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colSecName;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, MxNode> colBs;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Number> colQuantity;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Number> colPrice;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Number> colEntrustAmt;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Number> colCxlAmt;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Number> colTradeAmt;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, Number> colDonePct;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colEntrustTime;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, MxNode> colEntrustStatus;
    @FXML
    protected TreeTableColumn<BasketCcsOrder, String> colRemark;
    @FXML
    private TreeTableColumn<BasketCcsOrder, String> colPortfolioName;
    @FXML
    protected ComboBox<MxNode> cmbPriceTp;
    @FXML
    protected Spinner<Double> spnPriceFlP;
    @FXML
    protected Spinner<Double> spnPriceFlU;
    @FXML
    protected Label labFloatU;
    @FXML
    protected Button btnCancelOrder;
    @FXML
    protected Button btnCancelAllOrder;
    @FXML
    protected Button btnCancelReOrder;
    @Inject
    protected IUiRightService rightsModel;
    @Inject
    private BasketTaskModel model;
    @Inject
    protected BasketCcsOrderModel orderMng;
    @Inject
    protected MxAlert alert;
    protected TreeItem<BasketCcsOrder> root;
    protected MxGroup group = new MxGroup();
    @Inject
    protected MObjFactory of;
    @Inject
    protected LoadPartModel load;
    @Inject
    protected IRefDataMng refMng;
    public static final String PRICE_ADJUST_UNIT = "price_adjust_unit";
    public static final String PRICE_ADJUST_UNIT_PERCENT = "1";
    protected static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    protected static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    protected static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    private static final Logger logger = LogManager.getLogger(BasketTaskPart.class);
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.treeTableBasketTask.refresh();
        this.treeTableBasketTask.sort();
    });
    protected Callback<TreeTableColumn<BasketCcsOrder, Boolean>, TreeTableCell<BasketCcsOrder, Boolean>> checkBoxFactory = p -> new TreeTableCell<BasketCcsOrder, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((BasketCcsOrder)this.getTreeTableRow().getItem()).selectedProperty());
                    this.disableProperty().bind((ObservableValue)((BasketCcsOrder)this.getTreeTableRow().getItem()).canCancelProperty().not());
                    checkBox.disableProperty().addListener((ob, old, newV) -> checkBox.pseudoClassStateChanged(pcMxSelected, newV.booleanValue()));
                    this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, checkBox.disableProperty().get());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (this.getTreeTableRow().getTreeItem().isLeaf()) {
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((BasketCcsOrder)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                            }
                        });
                    } else {
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> {
                            if (((BasketCcsOrder)each.getValue()).canCancel()) {
                                ((BasketCcsOrder)each.getValue()).setSelected(((BasketCcsOrder)treeItem.getValue()).isSelected());
                            }
                        }));
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                } else {
                    this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                }
            }
        }
    };
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    protected DialogFactory df;
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("48", "49");

    @FXML
    public void initialize() {
        this.initValues();
        this.treeTableBasketTask.setRoot(this.root);
        this.createTableView();
        this.checkRights();
        this.createMenu();
        this.getModel().changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    private void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
    }

    protected void initValues() {
        MxNode node = MxNodeFactory.create((String)PRICE_ADJUST_UNIT, (String)PRICE_ADJUST_UNIT_PERCENT);
        this.labFloatU.textProperty().setValue(node.getValue());
        this.labFloatU.setOnMouseClicked(event -> this.changePriceUnit());
        this.labFloatU.getStyleClass().add((Object)"lbPercentYuan");
        this.root = this.getModel().getTree();
        this.group.add(new Control[]{this.spnPriceFlU, this.spnPriceFlP}).setVisible(new Control[]{this.spnPriceFlP});
        this.spnPriceFlU.getEditor().setText("0.000");
        this.spnPriceFlP.getEditor().setText("0.00");
        SpinnerUtils.arrowsStyle(this.spnPriceFlP);
        SpinnerUtils.arrowsStyle(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 3, 3, 1000.0).ctrl(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 2, 2, 100.0).ctrl(this.spnPriceFlP);
        this.cmbPriceTp.setItems(this.orderMng.getPriceType().getNodes());
        this.orderMng.priceFloatProperty().bindBidirectional((Property)this.spnPriceFlP.getEditor().textProperty());
        this.orderMng.floatUnitProperty().bindBidirectional((Property)this.labFloatU.textProperty());
        this.cmbPriceTp.valueProperty().bindBidirectional(this.orderMng.priceTypeProperty());
    }

    protected void changePriceUnit() {
        if ("%".equals(this.labFloatU.getText())) {
            this.labFloatU.setText("\u5143");
            this.group.setVisible(new Control[]{this.spnPriceFlU});
            MxBindings.bindBidirectional((Property)this.orderMng.priceFloatProperty(), (Property)this.spnPriceFlP.getEditor().textProperty(), (Property)this.spnPriceFlU.getEditor().textProperty());
        } else {
            this.labFloatU.setText("%");
            this.group.setVisible(new Control[]{this.spnPriceFlP});
            MxBindings.bindBidirectional((Property)this.orderMng.priceFloatProperty(), (Property)this.spnPriceFlU.getEditor().textProperty(), (Property)this.spnPriceFlP.getEditor().textProperty());
        }
    }

    private void checkRights() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String unOrderUpdate = "";
        String unCancel = "";
        switch (parentId) {
            case "CMS-TMX-INSTRUCTIONS-PART-BASKET-TASK": {
                unOrderUpdate = "cms.tmx.instructions.part.basket.task.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.basket.task.unfinished.query_cancel";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-TASK": {
                unOrderUpdate = "cms.tmx.instructions.part.portfolio.basket.task.unfinished.query_update";
                unCancel = "cms.tmx.instructions.part.portfolio.basket.task.unfinished.query_cancel";
                break;
            }
        }
        if (this.btnCancelReOrder != null) {
            this.rightsModel.registerCheck((Control)this.btnCancelReOrder, new String[]{unOrderUpdate});
        }
        if (this.btnCancelOrder != null) {
            this.rightsModel.registerCheck((Control)this.btnCancelOrder, new String[]{unCancel});
        }
    }

    protected void createTableView() {
        this.colCheckBox.setCellFactory(this.checkBoxFactory);
        this.colBatchSNo.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).batchIdProperty());
        this.colBatchSNo.setCellFactory(p -> new MClpsTreeTableCell());
        this.colBasketName.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).basketNameProperty());
        this.colFundAccntId.setCellValueFactory(p -> {
            SimpleStringProperty inverstorIdProperty = new SimpleStringProperty("");
            if (StringUtils.isEmpty((String)((BasketCcsOrder)p.getValue().getValue()).getLegId())) {
                inverstorIdProperty.set(((BasketCcsOrder)p.getValue().getValue()).getInvestorId());
            }
            return inverstorIdProperty;
        });
        this.colSecAccntId.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).inverstorSecIdProperty());
        this.colSecCode.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).getInstrument().symbolProperty());
        this.colBs.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).sideProperty());
        this.colBs.setCellFactory(cell -> new SideCell());
        this.colQuantity.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).orderQtyProperty());
        this.colQuantity.setCellFactory(cell -> new NumberTreeTableCell());
        this.colPrice.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).priceProperty());
        this.colPrice.setCellFactory(p -> new PriceTableCell());
        this.colOrderId.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).extOrderIdProperty());
        this.colEntrustAmt.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).orderAmountProperty());
        this.colEntrustAmt.setCellFactory(p -> new AmountTableCell());
        this.colCxlAmt.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).cxlAmountProperty());
        this.colCxlAmt.setCellFactory(p -> new AmountTableCell());
        this.colTradeAmt.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).tradeAmountProperty());
        this.colTradeAmt.setCellFactory(p -> new AmountTableCell());
        this.colDonePct.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).donePercentProperty());
        this.colDonePct.setCellFactory(p -> new DonePercentTableCell(2));
        this.colEntrustTime.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).ordTimeProperty());
        this.colEntrustStatus.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).ordStatusProperty());
        this.colEntrustStatus.setCellFactory(p -> new StatusTableCell());
        this.colPortfolioName.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).portfolioNameProperty());
        this.colRemark.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue().getValue()).errorInfoProperty());
        this.colRemark.setCellFactory(p -> new AutoTableCell());
        this.treeTableBasketTask.setPlaceholder((Node)new Label());
        this.treeTableBasketTask.setShowRoot(false);
        TableUtils.orgnizeClmWidth(this.treeTableBasketTask);
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colBatchSNo.setSortType(TreeTableColumn.SortType.DESCENDING);
        this.treeTableBasketTask.getSortOrder().add(this.colBatchSNo);
        this.treeTableBasketTask.sort();
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.colBatchSNo.getText()) + "\t" + this.colBasketName.getText() + "\t" + this.colFundAccntId.getText() + "\t" + this.colSecAccntId.getText() + "\t" + this.colSecCode.getText() + "\t" + this.colSecName.getText() + "\t" + this.colBs.getText() + "\t" + this.colOrderId.getText() + "\t" + this.colQuantity.getText() + "\t" + this.colPrice.getText() + "\t" + this.colEntrustAmt.getText() + "\t" + this.colTradeAmt.getText() + "\t" + this.colCxlAmt.getText() + "\t" + this.colDonePct.getText() + "\t" + this.colEntrustTime.getText() + "\t" + this.colEntrustStatus.getText() + "\t" + this.colPortfolioName.getText() + "\t" + this.colRemark.getText() + "\t" + '\n');
        for (TreeItem item : this.root.getChildren()) {
            BasketCcsOrder order = (BasketCcsOrder)item.getValue();
            clipboardString.append(String.valueOf(order.getListId()) + "\t" + order.getBasketName() + "\t" + order.getInvestorId() + "\t" + "\t" + "\t" + "\t" + "\t" + "\t" + "\t" + "\t" + order.getOrderAmount() + "\t" + order.getTradeAmount() + "\t" + order.getCxlAmount() + "\t" + order.getDonePercent() + "\t" + order.getOrdTime() + "\t" + order.getBatchStatus().getValue() + "\t" + order.getPortfolioName() + "\t" + order.getErrorInfo() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                BasketCcsOrder orderLeg = (BasketCcsOrder)subItem.getValue();
                clipboardString.append("\t\t\t" + orderLeg.getInverstorSecId() + "\t" + orderLeg.getInstrument().getSecId() + "\t" + orderLeg.getInstrument().getSymbol() + "\t" + orderLeg.getSide().getValue() + "\t" + orderLeg.getExtOrderId() + "\t" + orderLeg.getOrderQty() + "\t" + orderLeg.getPrice() + "\t" + orderLeg.getOrderAmount() + "\t" + orderLeg.getTradeAmount() + "\t" + orderLeg.getCxlAmount() + "\t" + orderLeg.getDonePercent() + "\t" + orderLeg.getOrdTime() + "\t" + orderLeg.getOrdStatus().getValue() + "\t" + "\t" + orderLeg.getErrorInfo() + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    protected void createMenu() {
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.treeTableBasketTask.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.refresh());
        itemCopy.setOnAction(event -> this.copy());
    }

    protected void refresh() {
        this.colSecAccntId.getCellData(1);
        this.getModel().query();
        this.treeTableBasketTask.refresh();
        this.treeTableBasketTask.sort();
    }

    @FXML
    protected void reOrder() {
        LinkedList<BasketCcsOrder> list = new LinkedList<BasketCcsOrder>();
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        HashMap<CcsCancelEntrust, BasketCcsOrder> enOrMap = new HashMap<CcsCancelEntrust, BasketCcsOrder>();
        ArrayList<String> referenceIds = new ArrayList<String>();
        for (TreeItem order : this.root.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
            FilteredList basketList = order.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected() && ((BasketCcsOrder)ad.getValue()).getOrdStatus().getRaw() != "");
            String reference = ((BasketCcsOrder)order.getValue()).getReference();
            referenceIds.add(reference);
            this.orderMng.queryMarketItem((List<TreeItem<BasketCcsOrder>>)basketList);
            for (TreeItem ord : basketList) {
                BasketCcsOrder or2 = (BasketCcsOrder)ord.getValue();
                or2.setReference(reference);
                CcsCancelEntrust en = this.ccf.createCcsSingle(or2.getExtAccntId(), or2.getExtSecAccntId());
                en.setReference(reference);
                en.setSec(or2.getInstrument().getSecId());
                en.setSecName(or2.getInstrument().getSymbol());
                en.setAcc(or2.getInvestorId());
                en.setSecAcc(or2.getInverstorSecId());
                en.setSecType(or2.getInstrument().getSecType());
                en.setMarket(or2.getInstrument().getMarket().getRaw());
                en.setPortfolioName(((BasketCcsOrder)order.getValue()).getPortfolioName());
                en.setOrderType(or2.getOrdType());
                en.setQuantity(or2.getOrderQty() - or2.getCumQty());
                en.setSide(or2.getSide());
                en.setPrice(this.orderMng.getNewPrice(or2, StringUtils.parseInt((String)this.orderMng.getPriceType().getRaw()), this.orderMng.getFloatUnit(), this.orderMng.getPriceFloat()));
                or2.setNewPrice(en.getPrice());
                if ("XSHG".equals(or2.getInstrument().getMarket().getRaw()) && "BOND".equals(or2.getInstrument().getSecType())) {
                    en.setAmt((double)en.getQuantity() * en.getPrice() * 10.0);
                } else {
                    en.setAmt((double)en.getQuantity() * en.getPrice());
                }
                en.setTip("".equals(or2.getExtOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getExtOrderId());
                enList.add(en);
                list.add((BasketCcsOrder)ord.getValue());
                enOrMap.put(en, or2);
            }
        }
        if (referenceIds.size() > 0) {
            try {
                this.model.checkInstructionPrice(enOrMap, referenceIds);
            }
            catch (MException | Exception e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u6307\u4ee4\u4fe1\u606f\u5931\u8d25");
                logger.error("get instruction failed : " + e.getMessage());
                return;
            }
        }
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        this.sort(enList);
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)((Object)this.of.create(CcsReplaceConfirmDialog.class));
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355\u91cd\u4e0b");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u91cd\u4e0b\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\u91cd\u4e0b\uff01");
            return;
        }
        List filteredList = list.stream().filter(or -> or.isCanCancelReplace()).collect(Collectors.toList());
        if (filteredList.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6307\u5b9a\u4ef7\u6307\u4ee4\u5355\u4e0d\u53ef\u64a4\u5355\u91cd\u4e0b\u3002");
            return;
        }
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        int countSuc = 0;
        int countFailed = 0;
        for (TreeItem order : this.root.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
            orderList.clear();
            for (TreeItem ord : order.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected() && ((BasketCcsOrder)ad.getValue()).getOrdStatus().getRaw() != "")) {
                orderList.add((BasketCcsOrder)ord.getValue());
                ((BasketCcsOrder)ord.getValue()).setSelected(false);
            }
            ((BasketCcsOrder)order.getValue()).setSelected(false);
            MEvent event = this.orderMng.cancelAndOrder(orderList, (BasketCcsOrder)order.getValue());
            countSuc += event.getInt("suc.count");
            countFailed += event.getInt("fail.count");
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4\u6210\u529f\uff1a" + countSuc + "\u7b14\n\u5931\u8d25\uff1a" + countFailed + "\u7b14");
    }

    @FXML
    protected void cancelOrder() {
        LinkedList<BasketCcsOrder> list = new LinkedList<BasketCcsOrder>();
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (TreeItem order : this.root.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
            for (TreeItem ord : order.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected() && ((BasketCcsOrder)ad.getValue()).getOrdStatus().getRaw() != "")) {
                BasketCcsOrder or = (BasketCcsOrder)ord.getValue();
                CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
                en.setSec(or.getInstrument().getSecId());
                en.setSecName(or.getInstrument().getSymbol());
                en.setAcc(or.getInvestorId());
                en.setSecAcc(or.getInverstorSecId());
                en.setSecType(or.getInstrument().getSecType());
                en.setMarket(or.getInstrument().getMarket().getRaw());
                en.setPortfolioName(((BasketCcsOrder)order.getValue()).getPortfolioName());
                en.setOrderType(or.getOrdType());
                en.setSide(or.getSide());
                en.setTip("".equals(or.getExtOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getExtOrderId());
                enList.add(en);
                list.add((BasketCcsOrder)ord.getValue());
            }
        }
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        int countSuc = 0;
        int countFailed = 0;
        for (TreeItem order : this.root.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
            orderList.clear();
            for (TreeItem ord : order.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
                orderList.add((BasketCcsOrder)ord.getValue());
                ((BasketCcsOrder)ord.getValue()).setSelected(false);
            }
            ((BasketCcsOrder)order.getValue()).setSelected(false);
            MEvent event = this.orderMng.cancel(orderList);
            countSuc += event.getInt("suc.count");
            countFailed += event.getInt("fail.count");
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + countSuc + "\u7b14\n\u5931\u8d25\uff1a" + countFailed + "\u7b14");
    }

    @FXML
    protected void cancelAllOrder() {
        LinkedList<BasketCcsOrder> list = new LinkedList<BasketCcsOrder>();
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (TreeItem order : this.root.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
            for (TreeItem ord : order.getChildren().filtered(ad -> CAN_CANCEL_STATUS.contains(((BasketCcsOrder)ad.getValue()).getOrdStatus().getRaw()) && ((BasketCcsOrder)ad.getValue()).getOrdStatus().getRaw() != "")) {
                BasketCcsOrder or = (BasketCcsOrder)ord.getValue();
                CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
                en.setSec(or.getInstrument().getSecId());
                en.setSecName(or.getInstrument().getSymbol());
                en.setAcc(or.getInvestorId());
                en.setSecAcc(or.getInverstorSecId());
                en.setSecType(or.getInstrument().getSecType());
                en.setMarket(or.getInstrument().getMarket().getRaw());
                en.setPortfolioName(((BasketCcsOrder)order.getValue()).getPortfolioName());
                en.setOrderType(or.getOrdType());
                en.setSide(or.getSide());
                en.setTip("".equals(or.getExtOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getExtOrderId());
                enList.add(en);
                list.add((BasketCcsOrder)ord.getValue());
            }
        }
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        int countSuc = 0;
        int countFailed = 0;
        for (TreeItem order : this.root.getChildren().filtered(ad -> ((BasketCcsOrder)ad.getValue()).isSelected())) {
            orderList.clear();
            for (TreeItem ord : order.getChildren().filtered(ad -> CAN_CANCEL_STATUS.contains(((BasketCcsOrder)ad.getValue()).getOrdStatus().getRaw()) && ((BasketCcsOrder)ad.getValue()).isSelected())) {
                orderList.add((BasketCcsOrder)ord.getValue());
                ((BasketCcsOrder)ord.getValue()).setSelected(false);
            }
            ((BasketCcsOrder)order.getValue()).setSelected(false);
            MEvent event = this.orderMng.cancel(orderList);
            countSuc += event.getInt("suc.count");
            countFailed += event.getInt("fail.count");
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + countSuc + "\u7b14\n\u5931\u8d25\uff1a" + countFailed + "\u7b14");
    }

    private void sort(List<CcsCancelEntrust> enList) {
        Collections.sort(enList, new Comparator<CcsCancelEntrust>(){

            @Override
            public int compare(CcsCancelEntrust o1, CcsCancelEntrust o2) {
                if (o2.isIsModified() && !o1.isIsModified()) {
                    return 1;
                }
                if (o1.isIsModified() && !o2.isIsModified()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public BasketTaskModel getModel() {
        return this.model;
    }

    public void setModel(BasketTaskModel model) {
        this.model = model;
    }

    public BasketCcsOrderModel getOrderMng() {
        return this.orderMng;
    }

    public void setOrderMng(BasketCcsOrderModel orderMng) {
        this.orderMng = orderMng;
    }

    protected class AmountTableCell
    extends EditTreeTableCell<BasketCcsOrder> {
        double unit = 0.001;

        protected AmountTableCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                if (treeItem != null && StringUtils.isEmpty((String)((BasketCcsOrder)treeItem.getValue()).getLegId())) {
                    this.setText(StringUtils.toPriceStr((double)item.doubleValue(), (double)0.001));
                } else {
                    BasketCcsOrder order = (BasketCcsOrder)treeItem.getValue();
                    RefItem refItem = BasketTaskPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                    if (refItem != null) {
                        this.unit = refItem.getPriceUnit();
                    }
                    this.setText(StringUtils.toPriceStr((double)item.doubleValue(), (double)this.unit));
                }
            }
        }
    }

    private class AutoTableCell<S, T>
    extends TreeTableCell<BasketCcsOrder, T> {
        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                BasketCcsOrder order = (BasketCcsOrder)BasketCcsOrder.class.cast(this.getTreeTableRow().getItem());
                if (order == null || StringUtils.isEmpty((String)order.getErrorInfo()) || this.getTreeTableRow().getParent().getParent() == null) {
                    this.setText(null);
                    return;
                }
                String errorInfo = order.getErrorInfo();
                if (!StringUtils.isEmpty((String)errorInfo)) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(errorInfo);
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(errorInfo);
            }
        }
    }

    protected class BatchHideTableCell
    extends EditTreeTableCell<BasketCcsOrder> {
        protected BatchHideTableCell() {
        }

        public void updateItem(Number item, boolean empty) {
            TreeItem treeItem;
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null && (treeItem = this.getTreeTableRow().getTreeItem()) != null && StringUtils.isEmpty((String)((BasketCcsOrder)treeItem.getValue()).getLegId())) {
                this.setText(null);
            }
        }
    }

    protected class DonePercentTableCell
    extends EditTreeTableCell<BasketCcsOrder> {
        DonePercentTableCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            TreeItem treeItem;
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null && (treeItem = this.getTreeTableRow().getTreeItem()) != null && ((BasketCcsOrder)treeItem.getValue()).getOrdStatus().getRaw().equals("999")) {
                this.setText(null);
            }
        }
    }

    protected class MClpsTreeTableCell<S>
    extends TreeTableCell<S, String> {
        public MClpsTreeTableCell() {
            if (this.getTreeTableRow() == null || this.getTreeTableRow().getTreeItem() != null && this.getTreeTableRow().getTreeItem().getParent().getParent() != null) {
                this.setOnMouseClicked(event -> {
                    TreeItem item = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (item != null) {
                        if (item.isExpanded()) {
                            item.setExpanded(false);
                        } else {
                            item.setExpanded(true);
                        }
                    }
                });
            }
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    if (this.getTreeTableRow() == null || this.getTreeTableRow().getTreeItem() != null && this.getTreeTableRow().getTreeItem().getParent().getParent() != null) {
                        this.setText(null);
                    } else {
                        this.setText(String.valueOf(item));
                    }
                }
            } else {
                this.setText(null);
            }
        }
    }

    protected class PriceTableCell
    extends EditTreeTableCell<BasketCcsOrder> {
        double unit = 0.001;

        protected PriceTableCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                if (treeItem != null && StringUtils.isEmpty((String)((BasketCcsOrder)treeItem.getValue()).getLegId())) {
                    this.setText(null);
                } else {
                    BasketCcsOrder order = (BasketCcsOrder)treeItem.getValue();
                    RefItem refItem = BasketTaskPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                    if (refItem != null) {
                        this.unit = refItem.getPriceUnit();
                    }
                    this.setText(StringUtils.toPriceStr((double)item.doubleValue(), (double)this.unit));
                }
            }
        }
    }

    private class SideCell
    extends TreeTableCell<BasketCcsOrder, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    protected class StatusTableCell<T>
    extends TreeTableCell<BasketCcsOrder, MxNode> {
        protected StatusTableCell() {
        }

        public void updateItem(MxNode item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem != null && !StringUtils.isEmpty((String)((BasketCcsOrder)treeItem.getValue()).getListId()) && StringUtils.isEmpty((String)((BasketCcsOrder)treeItem.getValue()).getLegId())) {
                        this.setText(((BasketCcsOrder)treeItem.getValue()).getBatchStatus().getValue());
                    } else if (treeItem != null && !StringUtils.isEmpty((String)((BasketCcsOrder)treeItem.getValue()).getLegId())) {
                        this.setText(((BasketCcsOrder)treeItem.getValue()).getOrdStatus().getValue());
                    }
                }
            } else {
                this.setText(null);
            }
        }
    }
}

