/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.api.data.IRefItem;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.ObCcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.BasketQueryModel;
import cms.tmx.query.current.models.InstructExecModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.InstructionOrderModel;
import cms.tmx.query.current.models.InstructionShortcutModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class BasketQueryPart
extends MxPart {
    private static final Integer PAGE_SIZE = 500;
    @FXML
    protected TableView<Instruction> tableBatchSNoQuery;
    @FXML
    protected TableColumn<Instruction, String> colBatchSNo;
    @FXML
    protected TableColumn<Instruction, String> colFundAccntId;
    @FXML
    protected TableColumn<Instruction, String> colBasketName;
    @FXML
    protected TableColumn<Instruction, String> colBasketStrategy;
    @FXML
    protected TableColumn<Instruction, MxNode> colEntrustStatus;
    @FXML
    protected TableColumn<Instruction, Number> colQuantity;
    @FXML
    protected TableColumn<Instruction, Number> colEntrustAmt;
    @FXML
    protected TableColumn<Instruction, Number> colCumQty;
    @FXML
    protected TableColumn<Instruction, Number> colTradeAmt;
    @FXML
    protected TableColumn<Instruction, Number> colDonePct;
    @FXML
    protected TableColumn<Instruction, String> colOrdTime;
    @FXML
    protected TableColumn<Instruction, Number> colEffectEntrustQty;
    @FXML
    protected TableColumn<Instruction, Number> colEffectEntrustAmt;
    @FXML
    protected TableColumn<Instruction, String> colEndTime;
    @FXML
    protected TableColumn<Instruction, MxNode> colAlgoName;
    @FXML
    protected Button btnCancel;
    @FXML
    protected TableView<ObCcsOrder> tableSampleQuery;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleBasketId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleBasketName;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleAccountId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleAccountName;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleSide;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleSecId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleSecName;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleUnit;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleInverstorStatus;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleInstPrice;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleInstQty;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleInstAmt;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleOrdPrice;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleNowPrice;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleOrderQty;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleOrderAmt;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleCxlQty;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleCxlAmt;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleAvgPx;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleCumQty;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleTotalValue;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colSampleDonePercent;
    @FXML
    protected TableColumn<ObCcsOrder, String> colSampleUserName;
    @FXML
    protected TableView<ObCcsOrder> tableCcsOrderQuery;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdSide;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdInvestorId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdInvestorName;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdSecId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdSecName;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdStutas;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colOrdPrice;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colOrdQty;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colOrdAmt;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colOrdCumPx;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colOrdCumQty;
    @FXML
    protected TableColumn<ObCcsOrder, Number> colOrdCumAmt;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdOrderId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdErrInfo;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrdSecAccntId;
    @FXML
    protected TableColumn<ObCcsOrder, String> colOrderTime;
    @Inject
    protected InstructionModel model;
    @Inject
    protected InstructionOrderModel instructionOrderModel;
    @Inject
    private InstructionShortcutModel shortModel;
    @Inject
    private InstructExecModel executionModel;
    @Inject
    private BasketQueryModel basketQueryModel;
    @Inject
    protected MxAlert alert;
    @FXML
    private Label lbOrderQty;
    @FXML
    private Label lbOrderAmt;
    @FXML
    private Label lbCumQty;
    @FXML
    private Label lbCumAmt;
    @FXML
    private Label lbEffctQty;
    @FXML
    private Label lbEffctAmt;
    @FXML
    private Label lbInstQty;
    @FXML
    private Label lbInstAmt;
    @FXML
    private Label lbOrdQty;
    @FXML
    private Label lbOrdAmt;
    @FXML
    private Label lbWthQty;
    @FXML
    private Label lbWthAmt;
    @FXML
    private Label lbCumOrdQty;
    @FXML
    private Label lbCumOrdAmt;
    protected MxList<Instruction> mxList = new MxList();
    protected MxPageList<CcsOrder, ObCcsOrder> mxOrderList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    protected MxPageList<CcsOrder, ObCcsOrder> mxCcsOrderList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    private MxList<InstructionExec> execuMxList = new MxList();
    protected MxList<CcsOrder> mxBasketOrderList = new MxList();
    protected Map<String, CcsOrder> orderMap = new HashMap<String, CcsOrder>();
    protected Map<String, List<CcsOrder>> orderListMap = new HashMap<String, List<CcsOrder>>();
    protected Map<Instruction, List<Instruction>> orderBasketMxListMap = new ConcurrentHashMap<Instruction, List<Instruction>>();
    private Instruction selectedItem;
    private ObCcsOrder selectedCcsItem;
    private static final Logger logger = LogManager.getLogger(BasketQueryPart.class);
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    protected Predicate<Instruction> pd = en -> {
        if (!this.premise((Instruction)en)) {
            return false;
        }
        if (this.extend((Instruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> {
            this.sumNum(this.mxList);
            this.tableBatchSNoQuery.sort();
            this.tableBatchSNoQuery.refresh();
        });
    };
    protected InvalidationListener lstnInstModel = ob -> {
        long startTime = System.currentTimeMillis();
        this.tableSampleQuery.getSelectionModel().clearSelection();
        this.mxCcsOrderList.clear();
        this.mxCcsOrderList.getPageList().clear();
        this.refreshOrder();
        long endTime = System.currentTimeMillis();
        System.err.println("\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime - startTime) + "ms");
        Platform.runLater(() -> {
            this.sumOrderNum((List<CcsOrder>)this.mxOrderList.getList());
            this.tableSampleQuery.sort();
            this.tableSampleQuery.refresh();
        });
    };
    protected InvalidationListener lstnInstBasket = ob -> {
        List<CcsOrder> newList = Collections.synchronizedList(new ArrayList());
        List<CcsOrder> list = this.basketQueryModel.getMxOrderList();
        synchronized (list) {
            newList.addAll(this.basketQueryModel.getMxOrderList());
        }
        this.mxOrderList.update(newList);
    };
    protected InvalidationListener lstnExecModel = ob -> {
        Platform.runLater(() -> {
            if (this.selectedItem == null) {
                return;
            }
            List<Order> newList = Collections.synchronizedList(new ArrayList());
            List<CcsOrder> ccsList = Collections.synchronizedList(new ArrayList());
            ObservableList<Order> observableList = this.instructionOrderModel.getList();
            synchronized (observableList) {
                newList.addAll((Collection<Order>)this.instructionOrderModel.getList());
            }
            for (Order od : newList) {
                if (!(od instanceof CcsOrder)) continue;
                System.out.println(od.getNowPrice());
                ccsList.add((CcsOrder)od);
            }
            this.mxOrderList.update(ccsList);
            this.mxOrderList.updatePageList();
            Collections.sort(this.mxOrderList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        });
        this.tableSampleQuery.sort();
        this.tableSampleQuery.refresh();
    };
    protected InvalidationListener lstnSampleModel = ob -> {
        this.selectedCcsItem = (ObCcsOrder)this.tableSampleQuery.getSelectionModel().getSelectedItem();
        List newList = Collections.synchronizedList(new ArrayList());
        if (this.selectedCcsItem != null) {
            this.mxCcsOrderList.clear();
            List<CcsOrder> list = this.basketQueryModel.getOrderListMap().get(String.valueOf(this.selectedCcsItem.getInvestorId()) + this.selectedCcsItem.getSecId());
            synchronized (list) {
                newList.addAll(this.basketQueryModel.getOrderListMap().get(String.valueOf(this.selectedCcsItem.getInvestorId()) + this.selectedCcsItem.getSecId()));
            }
            this.mxCcsOrderList.addAll(newList);
            this.mxCcsOrderList.updatePageList();
            Platform.runLater(() -> {
                Collections.sort(this.mxCcsOrderList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
                this.tableCcsOrderQuery.sort();
                this.tableCcsOrderQuery.refresh();
            });
        }
    };
    private InvalidationListener lstnCheckPart = ob -> {
        String partId = this.shortModel.getSelectedPart();
        if (!"cms.tmx.instructions.part.shortcut.basketorder.query".equals(partId)) {
            return;
        }
        Platform.runLater(() -> this.tableBatchSNoQuery.requestFocus());
    };
    protected MEventHandler newPrice = event -> Platform.runLater(() -> {
        ObservableList neworderList = this.mxOrderList.getList();
        if (neworderList.isEmpty()) {
            return;
        }
        ObservableList observableList = neworderList;
        synchronized (observableList) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (CcsOrder order : neworderList) {
                RefItem item = this.refMng.getItem(order.getMarket(), order.getSecId());
                if (item == null || item == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.marketMng.queryNewPriceIn5Seconds(listItem, gears);
            }
            for (Order ord : this.mxOrderList.getList()) {
                MarketItem marketItem;
                RefItem item = this.refMng.getItem(ord.getInstrument().getMarket().getRaw(), ord.getSecId());
                if (item == null || (marketItem = this.marketMng.getInfo((IRefItem)item)) == null) continue;
                if (marketItem.getNowPrice() == 0.0) {
                    ord.setNowPrice(marketItem.getClosePrice());
                } else {
                    ord.setNowPrice(marketItem.getNowPrice());
                }
                if ("".equals(marketItem.getStatus())) {
                    ord.setInverstorStatus("\u6b63\u5e38");
                    continue;
                }
                ord.setInverstorStatus(marketItem.getStatus());
            }
        }
        this.mxOrderList.updatePageList();
    });

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.initListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    protected void refreshOrder() {
        this.selectedItem = (Instruction)this.tableBatchSNoQuery.getSelectionModel().getSelectedItem();
        if (this.selectedItem != null) {
            this.execuMxList.clear();
            this.basketQueryModel.query(this.selectedItem);
            List<CcsOrder> newCcsList = Collections.synchronizedList(new ArrayList());
            List<CcsOrder> list = this.basketQueryModel.getMxOrderList();
            synchronized (list) {
                newCcsList.addAll(this.basketQueryModel.getMxOrderList());
            }
            this.mxOrderList.update(newCcsList);
            this.mxOrderList.updatePageList();
            Platform.runLater(() -> {
                Collections.sort(this.mxOrderList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
                this.sumOrderNum((List<CcsOrder>)this.mxOrderList.getList());
                this.tableSampleQuery.sort();
                this.tableSampleQuery.refresh();
            });
        }
    }

    private void initListener() {
        this.tableBatchSNoQuery.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableBatchSNoQuery.getSelectionModel().getSelectedItem() == null && !this.tableBatchSNoQuery.getItems().isEmpty()) {
                this.tableBatchSNoQuery.getSelectionModel().clearSelection();
            }
        });
        this.shortModel.selectedPartProperty().addListener(this.lstnCheckPart);
        this.tableBatchSNoQuery.getSelectionModel().selectedItemProperty().addListener(this.lstnInstModel);
        this.tableSampleQuery.getSelectionModel().selectedItemProperty().addListener(this.lstnSampleModel);
        this.basketQueryModel.changedProperty().addListener(this.lstnInstBasket);
    }

    @PreDestroy
    protected void close() {
        this.shortModel.selectedPartProperty().removeListener(this.lstnCheckPart);
        this.tableBatchSNoQuery.getSelectionModel().selectedItemProperty().removeListener(this.lstnInstModel);
        this.tableSampleQuery.getSelectionModel().selectedItemProperty().removeListener(this.lstnSampleModel);
        this.es.unSubscribe("newPriceBaketQuery", this.newPrice);
    }

    public boolean premise(Instruction order) {
        boolean flag = false;
        switch (order.getType().getRaw()) {
            case "4": 
            case "5": 
            case "12": 
            case "13": 
            case "16": 
            case "17": {
                flag = true;
                break;
            }
        }
        return flag;
    }

    public boolean extend(Instruction order) {
        return false;
    }

    public void onVisit() {
        this.getLstnModel().invalidated(null);
    }

    @FXML
    public void refresh() {
        this.model.query();
        this.executionModel.query();
    }

    private void createCcsOrderView() {
        this.colOrdSide.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).sideProperty());
        this.colOrdInvestorId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).investorIdProperty());
        this.colOrdInvestorName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).accNameProperty());
        this.colOrdSecId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secIdProperty());
        this.colOrdSecName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secNameProperty());
        this.colOrdStutas.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordStatusProperty());
        this.colOrdPrice.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).priceProperty());
        this.colOrdQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderQtyProperty());
        this.colOrdAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderAmtProperty());
        this.colOrdAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colOrdCumPx.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).avgPxProperty());
        this.colOrdCumQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).cumQtyProperty());
        this.colOrdCumAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).totalValueProperty());
        this.colOrdCumAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colOrdOrderId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderIdProperty());
        this.colOrdErrInfo.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).errInfoProperty());
        this.colOrdSecAccntId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).inverstorSecIdProperty());
        this.colOrderTime.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).ordTimeProperty());
        this.tableCcsOrderQuery.setItems(this.mxCcsOrderList.getPageList());
        this.tableCcsOrderQuery.setPlaceholder((Node)new Label());
    }

    private void createSampleView() {
        this.colSampleBasketId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).basketIdProperty());
        this.colSampleBasketName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).basketNameProperty());
        this.colSampleAccountId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).investorIdProperty());
        this.colSampleAccountName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).accNameProperty());
        this.colSampleSide.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).sideProperty());
        this.colSampleSecId.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secIdProperty());
        this.colSampleSecName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).secNameProperty());
        this.colSampleInstPrice.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).priceProperty());
        this.colSampleInstPrice.setCellFactory(cell -> new DoubleTableCell());
        this.colSampleInstQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).execExpectQtyProperty());
        this.colSampleInstAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).execExpectAmtProperty());
        this.colSampleInstAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colSampleUnit.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).unitProperty());
        this.colSampleInverstorStatus.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).inverstorStatusProperty());
        this.colSampleOrdPrice.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).priceProperty());
        this.colSampleNowPrice.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).nPriceProperty());
        this.colSampleOrderQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderQtyProperty());
        this.colSampleOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colSampleOrderAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).orderAmtProperty());
        this.colSampleOrderAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colSampleCxlQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).wthQtyProperty());
        this.colSampleCxlAmt.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).wthAmtProperty());
        this.colSampleCxlAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colSampleAvgPx.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).avgPxProperty());
        this.colSampleAvgPx.setCellFactory(cell -> new DoubleTableCell());
        this.colSampleCumQty.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).cumQtyProperty());
        this.colSampleTotalValue.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).totalValueProperty());
        this.colSampleTotalValue.setCellFactory(p -> new DoubleTableCell());
        this.colSampleDonePercent.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).donePercentProperty());
        this.colSampleUserName.setCellValueFactory(data -> ((ObCcsOrder)data.getValue()).userNameProperty());
        this.tableSampleQuery.setItems(this.mxOrderList.getPageList());
        this.tableSampleQuery.setPlaceholder((Node)new Label());
    }

    private void createBatchSNoView() {
        this.colBatchSNo.setCellValueFactory(data -> ((Instruction)data.getValue()).idProperty());
        this.colBasketName.setCellValueFactory(data -> ((Instruction)data.getValue()).basketNameProperty());
        this.colFundAccntId.setCellValueFactory(data -> ((Instruction)data.getValue()).belongToProperty());
        this.colBasketStrategy.setCellValueFactory(data -> ((Instruction)data.getValue()).strategyStringProperty());
        this.colEntrustStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).statusProperty());
        this.colQuantity.setCellValueFactory(data -> ((Instruction)data.getValue()).totalExpectationQtyProperty());
        this.colQuantity.setCellFactory(cell -> new NumberTableCell());
        this.colEntrustAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).orderAmountProperty());
        this.colEntrustAmt.setCellFactory(cell -> new DoubleTableCell());
        this.colCumQty.setCellValueFactory(data -> ((Instruction)data.getValue()).cumQtyProperty());
        this.colTradeAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().tradeAmountProperty());
        this.colTradeAmt.setCellFactory(p -> new DoubleTableCell());
        this.colDonePct.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().ratioProperty());
        this.colDonePct.setCellFactory(p -> new DoubleTableCell());
        this.colEffectEntrustQty.setCellValueFactory(data -> ((Instruction)data.getValue()).effectOrderQtyProperty());
        this.colEffectEntrustAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).effectOrderAmtProperty());
        this.colEffectEntrustAmt.setCellFactory(p -> new DoubleTableCell());
        this.colOrdTime.setCellValueFactory(data -> ((Instruction)data.getValue()).beginTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((Instruction)data.getValue()).endTimeProperty());
        this.colAlgoName.setCellValueFactory(data -> ((Instruction)data.getValue()).algoNameProperty());
        this.tableBatchSNoQuery.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            Instruction inst = (Instruction)Instruction.class.cast(newV);
            if (inst != null) {
                if (!inst.isWorkFlowDone() || "4".equals(inst.getStatus().getRaw())) {
                    this.btnCancel.setDisable(true);
                } else {
                    this.btnCancel.setDisable(false);
                }
            }
        });
        this.tableBatchSNoQuery.setItems(this.mxList.getList());
        this.tableBatchSNoQuery.setPlaceholder((Node)new Label());
    }

    @Focus
    public void onFocus() {
    }

    @FXML
    public void initialize() {
        this.tableBatchSNoQuery.getSelectionModel().clearSelection();
        this.listener();
        this.refresh();
        this.onFocus();
        this.createBatchSNoView();
        this.createSampleView();
        this.createCcsOrderView();
        this.refresh();
        this.es.subscribe("newPriceBaketQuery", this.newPrice);
    }

    @FXML
    private void aKeyAllCancel() {
        Instruction inst = (Instruction)this.tableBatchSNoQuery.getSelectionModel().getSelectedItem();
        if (inst == null) {
            return;
        }
        String message = "";
        if (!inst.isWorkFlowDone() || "4".equals(inst.getStatus().getRaw())) {
            this.alert.alert(Alert.AlertType.CONFIRMATION, "\u65e0\u6cd5\u64a4\u5355");
            return;
        }
        int size = 0;
        try {
            size = this.model.unfinishOrder(inst).size();
        }
        catch (MException e1) {
            logger.error("\u67e5\u8be2\u672a\u5b8c\u6210\u5b50\u5355\u5931\u8d25", (Throwable)e1);
            this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u672a\u5b8c\u6210\u5b50\u5355\u5931\u8d25");
        }
        message = String.valueOf(message) + inst.getId() + "  ?" + "\u6709" + size + "\u6761\u672a\u5b8c\u6210\u5b50\u5355" + "  ";
        String info = "\u662f\u5426\u64a4\u5355\uff1a" + message;
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, info)) {
            return;
        }
        try {
            this.model.cancelAllOrder(inst);
        }
        catch (MException e) {
            logger.error("\u64a4\u5355\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u64a4\u5355\u5931\u8d25");
        }
        this.refreshOrder();
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected void queryBasketItems(Instruction instruction) {
        try {
            this.model.queryBasketItems(instruction);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                logger.error("\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            });
        }
    }

    @FXML
    public void copyBatch() {
        TableUtils.copyContentWithHead(this.tableBatchSNoQuery);
    }

    @FXML
    public void exportBatch() {
        try {
            ExcelUtils.writeExcel(this.tableBatchSNoQuery, (String)"\u7bee\u5b50\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copySample() {
        TableUtils.copyContentWithHead(this.tableSampleQuery);
    }

    @FXML
    public void exportSample() {
        try {
            ExcelUtils.writeExcel(this.tableSampleQuery, (String)"\u6837\u672c\u59d4\u6258\u6c47\u603b");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copyCcsOrder() {
        TableUtils.copyContentWithHead(this.tableCcsOrderQuery);
    }

    @FXML
    public void exportCcsOrder() {
        try {
            ExcelUtils.writeExcel(this.tableCcsOrderQuery, (String)"\u6837\u672c\u59d4\u6258\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void sumNum(MxList<Instruction> mxList) {
        double orderAmt = 0.0;
        double orderQty = 0.0;
        double cumQty = 0.0;
        double cumAmt = 0.0;
        double effctQty = 0.0;
        double effctAmt = 0.0;
        for (Instruction inst : mxList.getList()) {
            orderAmt += inst.getOrderAmount();
            orderQty += (double)inst.getResource().getTotalExpectationQty();
            cumQty += (double)inst.getCumQty();
            cumAmt += inst.getResource().getTradeAmount();
            effctQty += (double)inst.getEffectOrderQty();
            effctAmt += inst.getEffectOrderAmt();
        }
        this.lbOrderAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbOrderQty.setText(StringUtils.toThousands((Number)orderQty, (int)0));
        this.lbCumQty.setText(StringUtils.toThousands((Number)cumQty, (int)0));
        this.lbCumAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbEffctAmt.setText(StringUtils.toThousands((Number)effctAmt, (int)2));
        this.lbEffctQty.setText(StringUtils.toThousands((Number)effctQty, (int)0));
    }

    private void sumOrderNum(List<CcsOrder> ccsList) {
        double orderAmt = 0.0;
        double orderQty = 0.0;
        double cumQty = 0.0;
        double cumAmt = 0.0;
        double instQty = 0.0;
        double instAmt = 0.0;
        double wthQty = 0.0;
        double wthAmt = 0.0;
        for (CcsOrder ord : ccsList) {
            orderAmt += ord.getOrderAmt();
            orderQty += (double)ord.getOrderQty();
            cumQty += (double)ord.getCumQty();
            cumAmt += ord.getTotalValue();
            instAmt += ord.getExecExpectAmt();
            instQty += (double)ord.getExecExpectQty();
            wthQty += (double)ord.getWthQty();
            wthAmt += (double)ord.getWthAmt();
        }
        this.lbOrdAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbOrdQty.setText(StringUtils.toThousands((Number)orderQty));
        this.lbCumOrdQty.setText(StringUtils.toThousands((Number)cumQty));
        this.lbCumOrdAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbInstQty.setText(StringUtils.toThousands((Number)instQty));
        this.lbInstAmt.setText(StringUtils.toThousands((Number)instAmt, (int)2));
        this.lbWthAmt.setText(StringUtils.toThousands((Number)wthAmt, (int)2));
        this.lbWthQty.setText(StringUtils.toThousands((Number)wthQty));
    }

    public class DoubleTableCell<S>
    extends TableCell<S, Number> {
        private int scale = 2;

        public DoubleTableCell() {
        }

        public DoubleTableCell(int scale) {
            this.scale = scale;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                Object cell;
                if (item != null && (cell = this.getTableRow().getItem()) instanceof ObCcsOrder) {
                    ObCcsOrder order = (ObCcsOrder)cell;
                    RefItem refItem = BasketQueryPart.this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                    if (refItem != null) {
                        this.scale = refItem.getScale();
                    }
                    Math.pow(10.0, this.scale);
                }
                this.setText(StringUtils.toThousands((String)String.valueOf(item), (int)this.scale));
            } else {
                this.setText(null);
            }
        }
    }
}

