/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.TableUtils;
import cms.tmx.http.workflow.dto.CounterPartyAccount;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.views.BankAcc;
import java.lang.reflect.Field;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;

public class BankAccntSelectDialog
extends DialogObj {
    private CounterPartyAccount partyAccount;
    @FXML
    private TableView<BankAcc> tableBankAcc;
    @FXML
    protected TableColumn<BankAcc, Boolean> colSelected;
    @FXML
    protected TableColumn<BankAcc, String> colBankAccNo;
    protected MxList<BankAcc> mxList = new MxList();

    @FXML
    public void initialize() {
        this.createTable();
        this.initialValues();
    }

    private void createTable() {
        this.colSelected.setCellValueFactory(data -> ((BankAcc)((Object)((Object)data.getValue()))).selectedProperty());
        this.colSelected.setCellFactory(data -> new MxCheckBoxTableCellBank());
        this.colSelected.setSortable(false);
        this.colSelected.getTableView().setEditable(true);
        this.colBankAccNo.setCellValueFactory(data -> ((BankAcc)((Object)((Object)data.getValue()))).idProperty());
        this.tableBankAcc.setItems(this.mxList.getList());
        this.tableBankAcc.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableBankAcc);
    }

    protected boolean isOK(ButtonType bt) {
        for (BankAcc bankAcc : this.tableBankAcc.getItems()) {
            if (!bankAcc.isSelected()) continue;
            this.partyAccount.setSelectedAccNO(bankAcc.getId());
        }
        return true;
    }

    private void initialValues() {
        this.mxList.clear();
        for (String accntNo : this.partyAccount.getAccountNo()) {
            BankAcc acc = new BankAcc();
            if (this.partyAccount.getSelectedAccNO().equals(accntNo)) {
                acc.setSelected(true);
            } else {
                acc.setSelected(false);
            }
            acc.setId(accntNo);
            this.mxList.add((MxObject)acc);
        }
    }

    public CounterPartyAccount getPartyAccount() {
        return this.partyAccount;
    }

    public void setPartyAccount(CounterPartyAccount partyAccount) {
        this.partyAccount = partyAccount;
    }

    private class MxCheckBoxTableCellBank
    extends CheckBoxTableCell<BankAcc, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    BankAcc acc = (BankAcc)((Object)BankAcc.class.cast(this.getTableRow().getItem()));
                    this.disableProperty().bind((ObservableValue)acc.selectedProperty());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                    if (item.booleanValue()) {
                        for (BankAcc bankAcc : this.getTableView().getItems()) {
                            if (((Object)((Object)acc)).equals((Object)bankAcc)) continue;
                            bankAcc.setSelected(false);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

