/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.AdjPositionParamDialog;
import cms.tmx.query.current.views.AlgoStrategyDetailDialog;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoStrategyQueryPart
extends MxPart {
    @FXML
    protected TableView<BasketAlgoStrategy> tableAlgo;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> index;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colId;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colBelong;
    @FXML
    private TableColumn<BasketAlgoStrategy, MxNode> colType;
    @FXML
    private TableColumn<BasketAlgoStrategy, MxNode> colStatus;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colBuyProgress;
    @FXML
    private TableColumn<BasketAlgoStrategy, Number> colBuyVol;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colSellProgress;
    @FXML
    private TableColumn<BasketAlgoStrategy, Number> colSellVol;
    @FXML
    private TableColumn<BasketAlgoStrategy, Object> colOption;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colBeginTime;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colEndTime;
    private static final Logger logger = LogManager.getLogger(AlgoStrategyQueryPart.class);
    protected MxList<BasketAlgoStrategy> mxList = new MxList();
    @Inject
    private DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MxAlert alert;
    @Inject
    private AlgoStrategyQueryModel model;
    @Inject
    private PortfolioAccountModel portfMng;
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        ObservableList<BasketAlgoStrategy> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.update(this.model.getList());
        }
        this.mxList.getList().sort((a, b) -> b.getId().compareTo(a.getId()));
        this.tableAlgo.sort();
        this.tableAlgo.refresh();
    });

    @FXML
    public void initialize() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.createTable();
    }

    protected void createTable() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.index.setSortable(false);
        this.colId.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).idProperty());
        this.colBelong.setCellValueFactory(data -> {
            if (((BasketAlgoStrategy)data.getValue()).getBizAcct().startsWith("SF")) {
                String name = this.portfMng.getFundAccount(((BasketAlgoStrategy)data.getValue()).getBizAcct(), "CCS").getPortfolioName();
                return new SimpleStringProperty(name);
            }
            return ((BasketAlgoStrategy)data.getValue()).bizAcctProperty();
        });
        this.colType.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).typeProperty());
        this.colBuyProgress.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).exeBuyProperty());
        this.colBuyVol.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).dealBuyProperty());
        this.colBuyVol.setCellFactory(data -> new NumberTableCell());
        this.colSellProgress.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).exeSellProperty());
        this.colSellVol.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).dealSellProperty());
        this.colSellVol.setCellFactory(data -> new NumberTableCell());
        this.colStatus.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).statusProperty());
        this.colOption.setCellValueFactory(data -> this.setOperate((BasketAlgoStrategy)data.getValue()));
        this.colOption.setSortable(false);
        this.colBeginTime.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).orderStartTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((BasketAlgoStrategy)data.getValue()).orderEndTimeProperty());
        this.tableAlgo.setItems(this.mxList.getList());
        this.tableAlgo.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAlgo);
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableAlgo.getSortOrder().add(this.colId);
        this.tableAlgo.sort();
    }

    private ReadOnlyObjectWrapper<Object> setOperate(BasketAlgoStrategy instruction) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        if (instruction.getStatus().getRaw().equals("0") || instruction.getStatus().getRaw().equals("1")) {
            Button btn = new Button("\u64a4\u5355");
            btn.getStyleClass().add((Object)"btnOperation");
            btn.setOnAction(event -> {
                if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u5355\uff1f")) {
                    try {
                        this.model.miseCancelOrder(instruction);
                        this.refresh();
                    }
                    catch (MException e) {
                        logger.error((Object)e, (Throwable)e);
                        Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    }
                }
            });
            box.getChildren().add((Object)btn);
        }
        Button btn2 = new Button("\u7b56\u7565\u53c2\u6570");
        btn2.getStyleClass().add((Object)"btnOperation");
        btn2.setOnAction(event -> this.showParam(instruction));
        Button btn3 = new Button("\u7b56\u7565\u8be6\u60c5");
        btn3.getStyleClass().add((Object)"btnOperation");
        btn3.setOnAction(event -> this.showDetail(instruction));
        box.getChildren().add((Object)btn2);
        box.getChildren().add((Object)btn3);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showParam(BasketAlgoStrategy instruction) {
        AdjPositionParamDialog adj = (AdjPositionParamDialog)((Object)this.of.create(AdjPositionParamDialog.class));
        adj.setStrategy(instruction);
        MxDialog dialog = this.df.create((DialogObj)adj, "\u53c2\u6570");
        dialog.setBtnText(ButtonType.OK, "\u5173\u95ed");
        dialog.launch();
    }

    private void selectRow(BasketAlgoStrategy instruction) {
        this.tableAlgo.getSelectionModel().select((Object)instruction);
    }

    private void showDetail(BasketAlgoStrategy instruction) {
        this.selectRow(instruction);
        AlgoStrategyDetailDialog.setStrategy(instruction);
        AlgoStrategyDetailDialog obj = (AlgoStrategyDetailDialog)((Object)this.of.create(AlgoStrategyDetailDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u7b56\u7565\u8be6\u60c5");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.launch();
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableAlgo);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableAlgo, (String)"\u7b56\u7565\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

