/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.views.DealPart;
import cms.tmx.query.current.views.OrderPart;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoStrategyDetailDialog
extends DialogObj {
    @FXML
    private TableView<AlgoStrategyDetails> tableAlgoDetail;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colIndex;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colsecId;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colSecName;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colSide;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colOrderVol;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colDeal;
    @FXML
    private TableColumn<AlgoStrategyDetails, MxNode> colStatus;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colExeDeal;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colRemark;
    @FXML
    private HBox hboxCount;
    @FXML
    private Label labCount;
    @FXML
    private AnchorPane paneAlgo;
    @FXML
    private RadioButton rbtn;
    @FXML
    private AnchorPane paneOrder;
    @FXML
    private AnchorPane paneDeal;
    @Inject
    private AlgoStrategyQueryModel miseQuery;
    @Inject
    private OrderPart orderPart;
    @Inject
    private DealPart dealPart;
    @Inject
    protected MxAlert alert;
    @Inject
    private ExecutorService exe;
    private static final Logger logger = LogManager.getLogger(AlgoStrategyDetailDialog.class);
    private static final double WIDTH = 1000.0;
    static BasketAlgoStrategy strategy;
    private MxList<AlgoStrategyDetails> detailMxList = new MxList();
    private ObservableList<AlgoStrategyDetails> filterList = FxUtils.newList();
    private Predicate<AlgoStrategyDetails> pd = inst -> {
        boolean b = this.rbtn.isSelected();
        return !b || !"100.00".equals(inst.getExeDeal());
    };
    private InvalidationListener instModel = ob -> {
        this.detailMxList.update(this.filterList, this.pd);
        this.tableAlgoDetail.sort();
    };

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    @FXML
    public void initialize() {
        this.creatTable();
        this.rbtn.selectedProperty().addListener(this.instModel);
        this.refreshLog();
    }

    private void creatTable() {
        this.paneDeal.getChildren().add((Object)this.limitWidth(this.dealPart.getContent()));
        this.paneOrder.getChildren().add((Object)this.limitWidth(this.orderPart.getContent()));
        TableUtils.isAuto(this.colIndex);
        this.colsecId.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).secNameProperty());
        this.colSide.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new SideCell());
        this.colOrderVol.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).orderVolProperty());
        this.colOrderVol.setCellFactory(p -> new NumberTableCell());
        this.colDeal.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).dealProperty());
        this.colDeal.setCellFactory(p -> new NumberTableCell());
        this.colStatus.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).statusProperty());
        this.colExeDeal.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).exeDealProperty());
        this.colRemark.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).remarkProperty());
        this.tableAlgoDetail.setItems(this.detailMxList.getList());
        this.tableAlgoDetail.setPlaceholder((Node)new Label());
    }

    private Parent limitWidth(Parent content) {
        ((VBox)content).setPrefWidth(1000.0);
        return content;
    }

    @FXML
    public void copyLog() {
        TableUtils.copyContentWithHead(this.tableAlgoDetail);
    }

    @FXML
    public void refreshLog() {
        this.exe.execute(() -> {
            try {
                this.filterList.clear();
                this.filterList.addAll(this.miseQuery.queryAlgoDetail(strategy.getBizAcct(), "", "", strategy.getId()));
                this.detailMxList.update(this.filterList, this.pd);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    public void exportLog() {
        try {
            ExcelUtils.writeExcel(this.tableAlgoDetail, (String)"\u6267\u884c\u8fdb\u5ea6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public BasketAlgoStrategy getStrategy() {
        return strategy;
    }

    public static void setStrategy(BasketAlgoStrategy bas) {
        boolean b;
        CcsOrderModel.isNormal = b = !bas.getBizAcct().startsWith("SF");
        CcsDealModel.isNormal = b;
        strategy = bas;
    }

    public void onFinished(ButtonType bt) {
        this.orderPart.close();
        this.dealPart.close();
    }

    private class SideCell
    extends TableCell<AlgoStrategyDetails, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            switch (value) {
                case "\u4e70\u5165": {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

