/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.basket.AdjPositonParam;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.views.AdjTypeDescDialog;
import cms.tmx.utils.StringUtils;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdjPositionParamDialog
extends DialogObj {
    @FXML
    private Label lbCapital;
    @FXML
    private ComboBox<String> cmbCapital;
    @FXML
    protected ComboBox<MxNode> cmbAdjType;
    @FXML
    protected Label lbBasket;
    @FXML
    private ComboBox<String> cmbDestBasket;
    @FXML
    protected ComboBox<String> cmbAdjScale;
    @FXML
    protected ComboBox<MxNode> cmbAdjWay;
    @FXML
    protected HBox hboxCount;
    @FXML
    protected TextField txtCount;
    @FXML
    private Label qtyMag;
    @FXML
    protected HBox hboxMoney;
    @FXML
    protected TextField txtMoney;
    @FXML
    private Label amtMag;
    @FXML
    protected HBox hboxPct;
    @FXML
    protected Spinner<Double> spnStgPct;
    @FXML
    private Button btnParam;
    @FXML
    private CheckBox cbxAdjMoney;
    @FXML
    private TextField txtAdjMoney;
    @FXML
    private CheckBox cbxControlPercent;
    @FXML
    private TextField txtControlPercent;
    @Inject
    private MEventService es;
    @Inject
    private AlgoStrategyQueryModel mise;
    @Inject
    private ExecutorService exe;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    private BasketAlgoStrategy strategy;
    private AdjPositonParam param;
    private static final Logger logger = LogManager.getLogger(AdjPositionParamDialog.class);

    @FXML
    public void algoParamSet() {
        MEvent event = new MEvent();
        event.put((Object)"algoParam", (Object)this.param);
        this.es.sendEvent("adj.algo.dialog", event);
    }

    @FXML
    public void initialize() {
        this.exe.execute(() -> {
            try {
                this.param = this.mise.queryMiseParam(this.strategy.getBizAcct(), "", "", this.strategy.getId());
                Platform.runLater(() -> {
                    if (!this.param.getAccntId().isEmpty()) {
                        ObservableList list = FxUtils.newList();
                        String capital = this.param.getAccntId();
                        if (!this.param.getPortfolioId().isEmpty()) {
                            this.lbCapital.setText("\u4ea4\u6613\u6295\u7ec4");
                            capital = this.param.getPortfolioId();
                        }
                        list.add((Object)capital);
                        this.cmbCapital.setItems(list);
                        this.cmbCapital.getSelectionModel().selectFirst();
                        this.cmbCapital.setDisable(true);
                        MxNode node = MxNodeFactory.create((String)"adj_type", (String)String.valueOf(this.param.getAdjType()));
                        this.cmbAdjType.setItems(node.getNodes());
                        this.cmbAdjType.getSelectionModel().select((Object)node);
                        this.cmbAdjType.setDisable(true);
                        boolean isDerict = node.getRaw().equals("1");
                        this.lbBasket.setText(isDerict ? "\u6807\u7684\u7bee\u5b50" : "\u76ee\u6807\u7bee\u5b50");
                        if (isDerict) {
                            ((VBox)this.cmbAdjScale.getParent().getParent()).getChildren().remove((Object)this.cmbAdjScale.getParent());
                        }
                        node = MxNodeFactory.create((String)"adj_way_type", (String)String.valueOf(this.param.getAdjWay()));
                        this.cmbAdjWay.setItems(node.getNodes());
                        this.cmbAdjWay.getSelectionModel().select((Object)node);
                        this.cmbAdjWay.setDisable(true);
                        this.hboxCount.setVisible(false);
                        this.hboxCount.setDisable(true);
                        this.qtyMag.setVisible(false);
                        this.hboxMoney.setVisible(false);
                        this.hboxMoney.setDisable(true);
                        this.amtMag.setVisible(false);
                        this.hboxPct.setVisible(false);
                        this.hboxPct.setDisable(true);
                        if ("1".equals(node.getRaw())) {
                            this.hboxCount.setVisible(true);
                            this.qtyMag.setVisible(true);
                            TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.txtCount);
                            this.txtCount.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 9, 2)));
                            this.txtCount.setText(String.valueOf(this.param.getAdjWayValue()));
                        } else if ("2".equals(node.getRaw())) {
                            this.hboxMoney.setVisible(true);
                            this.amtMag.setVisible(true);
                            TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.txtMoney);
                            this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                            this.txtMoney.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
                            this.txtMoney.setText(String.valueOf(this.param.getAdjWayValue()));
                        } else if ("7".equals(node.getRaw())) {
                            this.hboxPct.setVisible(true);
                            this.spnStgPct.getEditor().setText(String.valueOf(this.param.getAdjWayValue()));
                        }
                        ObservableList list2 = FxUtils.newList();
                        list2.add((Object)this.param.getBasket().getName());
                        this.cmbDestBasket.setItems(list2);
                        this.cmbDestBasket.getSelectionModel().selectFirst();
                        this.cmbDestBasket.setDisable(true);
                        this.cbxAdjMoney.setSelected(this.param.isControlMoney());
                        this.txtAdjMoney.setText(this.param.isControlMoney() ? StringUtils.toStr((double)this.param.getMoney(), (int)2) : "");
                        this.cbxAdjMoney.setDisable(true);
                        this.txtAdjMoney.setDisable(true);
                        this.cbxControlPercent.setSelected(this.param.isControlImpact());
                        this.txtControlPercent.setText(StringUtils.toStr((double)this.param.getPercent(), (int)2));
                        this.txtControlPercent.setDisable(true);
                        this.cbxControlPercent.setDisable(true);
                    }
                });
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    private void help() {
        AdjTypeDescDialog obj = (AdjTypeDescDialog)((Object)this.of.create(AdjTypeDescDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u8c03\u4ed3\u65b9\u5f0f\u8bf4\u660e");
        dialog.launch();
    }

    public BasketAlgoStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(BasketAlgoStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategy(AlgoBaseOrder base) {
        this.strategy = new BasketAlgoStrategy();
        this.strategy.setBizAcct(base.getSubAcct());
        this.strategy.setId(base.getId());
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.OK};
    }
}

