/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExecMonitor;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.AdjExecMonitorModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class AdjExecMonitorPart
extends MxPart {
    @FXML
    protected TableView<InstructionExecMonitor> tableMonitor;
    @FXML
    private TableColumn<InstructionExecMonitor, String> colSelected;
    @FXML
    private TableColumn<InstructionExecMonitor, String> colSecId;
    @FXML
    private TableColumn<InstructionExecMonitor, String> colSecName;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDestWeight;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDestCapital;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDestPos;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colNowCapital;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colNowPos;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDiffAmount;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDiffCount;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colExecPct;
    @FXML
    private TableColumn<InstructionExecMonitor, MxNode> colSide;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDealAmount;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDealQty;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDealPrice;
    @FXML
    private TableColumn<InstructionExecMonitor, Number> colDealAvg;
    @FXML
    private TableColumn<InstructionExecMonitor, String> colOrderErr;
    @FXML
    private TableColumn<InstructionExecMonitor, String> colInvestorId;
    @FXML
    private TableColumn<InstructionExecMonitor, String> colInvestotSecId;
    @FXML
    private ComboBox<Instruction> cmbInst;
    @FXML
    private TextField txtSearch;
    @FXML
    private Label lbSum;
    @FXML
    private Label lbDestWeight;
    @FXML
    private Label lbDesCapital;
    @FXML
    private Label lbNowCapital;
    @FXML
    private Label lbBuyDiffAmount;
    @FXML
    private Label lbSellDiffAmount;
    @FXML
    private Label lbBuyDealAmount;
    @FXML
    private Label lbSellDealAmount;
    @Inject
    private AdjExecMonitorModel model;
    @Inject
    protected InstructionModel instModel;
    @Inject
    protected MxAlert alert;
    private ObservableList<Instruction> listInst = FxUtils.newList();
    private MxList<InstructionExecMonitor> mlist = new MxList();
    protected Predicate<InstructionExecMonitor> pd = en -> {
        String text = this.txtSearch.getText().trim();
        return en.getAdjItem().getCode().contains(text) || en.getAdjItem().getName().contains(text);
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<InstructionExecMonitor> observableList = this.model.getItems();
        synchronized (observableList) {
            this.mlist.filter(this.model.getItems(), this.pd);
            this.tableMonitor.sort();
            this.tableMonitor.refresh();
            this.lstnExtendOperation((List<InstructionExecMonitor>)this.mlist.getList());
        }
    };
    private InvalidationListener lstnInst = ob -> {
        ObservableList observableList = this.instModel.getList().getList();
        synchronized (observableList) {
            FilteredList list = this.instModel.getList().getList().filtered(item -> {
                AdjustPosAdvice advice;
                return "16".equals(item.getType().getRaw()) && "2".equals((advice = item.getAdjustPosAdvice()).getAdjWay().getRaw());
            });
            this.listInst.setAll((Collection)list);
        }
    };
    private InvalidationListener lstnModel = ob -> {
        ObservableList<InstructionExecMonitor> observableList = this.model.getItems();
        synchronized (observableList) {
            Platform.runLater(() -> {
                this.mlist.update(this.model.getItems(), this.pd);
                this.tableMonitor.sort();
                this.tableMonitor.refresh();
                this.lstnExtendOperation((List<InstructionExecMonitor>)this.mlist.getList());
            });
        }
    };

    @FXML
    private void initialize() {
        this.initControls();
        this.createTable();
        this.txtSearch.textProperty().addListener(this.lstnSearch);
        this.instModel.getList().getList().addListener(this.lstnInst);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    public void close() {
        this.txtSearch.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
        this.instModel.getList().getList().removeListener(this.lstnInst);
    }

    private void initControls() {
        this.lstnInst.invalidated(null);
        this.cmbInst.setItems(this.listInst);
        this.cmbInst.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.mlist.clear();
            this.model.query((Instruction)now);
        });
        this.cmbInst.setConverter((StringConverter)new StringConverter<Instruction>(){

            public String toString(Instruction object) {
                if (object != null) {
                    return object.getId();
                }
                return "";
            }

            public Instruction fromString(String string) {
                return null;
            }
        });
        if (this.instModel.getList().getList().isEmpty()) {
            this.instModel.query();
        } else {
            this.lstnInst.invalidated(null);
        }
    }

    public void lstnExtendOperation(List<InstructionExecMonitor> list) {
        double sum = list.size();
        double destWeight = 0.0;
        double desCapital = 0.0;
        double nowCapital = 0.0;
        double buyDiffAmount = 0.0;
        double sellDiffAmount = 0.0;
        double buyDealAmount = 0.0;
        double sellDealAmount = 0.0;
        for (InstructionExecMonitor monitor : list) {
            destWeight += monitor.getAdjItem().getDestWeight();
            desCapital += monitor.getAdjItem().getTargetMktValue();
            nowCapital += monitor.getAdjItem().getCapitalization();
            if (monitor.getAdjItem().isBs()) {
                buyDiffAmount += monitor.getDiffAmount();
                buyDealAmount += monitor.getExecItem().getCumAmount();
                continue;
            }
            sellDiffAmount += monitor.getDiffAmount();
            sellDealAmount += monitor.getExecItem().getCumAmount();
        }
        this.lbSum.setText(StringUtils.toThousands((Number)sum));
        this.lbDestWeight.setText(StringUtils.toThousands((Number)destWeight, (int)2));
        this.lbDesCapital.setText(StringUtils.toThousands((Number)desCapital, (int)2));
        this.lbNowCapital.setText(StringUtils.toThousands((Number)nowCapital, (int)2));
        this.lbBuyDiffAmount.setText(StringUtils.toThousands((Number)buyDiffAmount, (int)2));
        this.lbSellDiffAmount.setText(StringUtils.toThousands((Number)sellDiffAmount, (int)2));
        this.lbBuyDealAmount.setText(StringUtils.toThousands((Number)buyDealAmount, (int)3));
        this.lbSellDealAmount.setText(StringUtils.toThousands((Number)sellDealAmount, (int)3));
    }

    private void createTable() {
        TableUtils.isAuto(this.colSelected);
        this.colSecId.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().codeProperty());
        this.colSecName.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().nameProperty());
        this.colDestWeight.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().destWeightProperty());
        this.colDestCapital.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().targetMktValueProperty());
        this.colDestCapital.setCellFactory(data -> new DoubleTableCell(2));
        this.colDestPos.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().expectQtyProperty());
        this.colDestPos.setCellFactory(data -> new NumberTableCell());
        this.colNowCapital.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().capitalizationProperty());
        this.colNowCapital.setCellFactory(data -> new DoubleTableCell(2));
        this.colNowPos.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().nowPosProperty());
        this.colNowPos.setCellFactory(data -> new NumberTableCell());
        this.colDiffAmount.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).diffAmountProperty());
        this.colDiffAmount.setCellFactory(data -> new DoubleTableCell(2));
        this.colDiffCount.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).diffCountProperty());
        this.colDiffCount.setCellFactory(data -> new NumberTableCell());
        this.colExecPct.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().executePercentProperty());
        this.colExecPct.setCellFactory(data -> new DoubleTableCell(2));
        this.colSide.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().sideProperty());
        this.colDealAmount.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().cumAmountProperty());
        this.colDealAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colDealQty.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().cumQtyProperty());
        this.colDealQty.setCellFactory(cell -> new NumberTableCell());
        this.colDealPrice.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().lastDealPxProperty());
        this.colDealAvg.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getExecItem().avgPxProperty());
        this.colDealAvg.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colOrderErr.setCellValueFactory(data -> new SimpleStringProperty(((InstructionExecMonitor)data.getValue()).getOrder().getErrInfo()));
        this.colInvestorId.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().investorIdProperty());
        this.colInvestotSecId.setCellValueFactory(data -> ((InstructionExecMonitor)data.getValue()).getAdjItem().investorSecIdProperty());
        this.tableMonitor.setItems(this.mlist.getList());
        this.tableMonitor.setPlaceholder((Node)new Label());
    }

    @FXML
    private void refresh() {
        Instruction inst = (Instruction)this.cmbInst.getSelectionModel().getSelectedItem();
        if (inst != null) {
            this.model.query(inst);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableMonitor);
    }

    @FXML
    private void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableMonitor, (String)"\u6307\u4ee4\u8fdb\u5ea6\u76d1\u63a7");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

