/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.sge;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.marginxt.PositionEvent;
import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.query.sge.GetSgeStorageReq;
import cms.tmx.http.query.sge.GetSgeStorageResp;
import cms.tmx.http.query.sge.ObSgeStorage;
import cms.tmx.http.query.sge.SgeStorage;
import cms.tmx.http.query.sge.api.SgeStorageServiceApi;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.sge.SgeStorageMng;
import cms.tmx.query.current.models.SgeAccountMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SgeStorageModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(SgeStorageModel.class);
    @Inject
    private SgeAccountMap fundMng;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    private SgeStorageServiceApi sgeApi;
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Map<String, SgeStorageMng> mapQuery = new ConcurrentHashMap<String, SgeStorageMng>();
    private MxListDirty<ObSgeStorage> list = new MxListDirty();
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.PositionEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PositionEvent posEvent = (PositionEvent)this.gson.fromJson((JsonElement)obj, PositionEvent.class);
        if (!"SGE".equals(posEvent.getMarketGroup())) {
            return;
        }
        for (XtPosition po : posEvent.getPosItem()) {
            if (po.getDirection() != null || !"SGEX".equals(po.getInstrument().getMarket())) continue;
            ObSgeStorage sge = new ObSgeStorage();
            sge.getInstrument().update((Object)po.getInstrument());
            sge.setTradeDate(po.getTradingDay());
            sge.setSecAccntId(po.getSecAccntId());
            this.updateObj(sge);
        }
    }

    private void updateObj(ObSgeStorage po) {
        SgeStorageMng mng = this.getQuery(po.getSecAccntId());
        if (mng != null) {
            mng.addQuery(po);
            this.scheduleSpecQuery();
        }
    }

    private void scheduleSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("\u8d35\u91d1\u5c5e\u5e93\u5b58\u63a8\u9001\u67e5\u8be2spec query sgestorage failed", e);
            }
        });
    }

    private void specQuery() throws MException {
        LinkedList<SgeStorage> listSrc = new LinkedList<SgeStorage>();
        for (SgeStorageMng query : this.mapQuery.values()) {
            listSrc.addAll(query.queryDirty());
        }
        this.updateDirty(listSrc);
    }

    private void updateDirty(List<SgeStorage> listSrc) {
        List<ObSgeStorage> listOb = this.updateSgeStorages(listSrc);
        this.list.updateDirty(listOb);
        this.changed();
    }

    private List<ObSgeStorage> updateSgeStorages(List<SgeStorage> listQuery) {
        ArrayList<ObSgeStorage> listOb = new ArrayList<ObSgeStorage>();
        for (SgeStorage each : listQuery) {
            ObSgeStorage o = new ObSgeStorage();
            o.update((Object)each);
            listOb.add(o);
        }
        return listOb;
    }

    public synchronized SgeStorageMng getQuery(String secAccntId) {
        if (secAccntId == null) {
            return null;
        }
        if (this.mapQuery.containsKey(secAccntId)) {
            return this.mapQuery.get(secAccntId);
        }
        SgeStorageMng query = (SgeStorageMng)((Object)this.of.create(SgeStorageMng.class));
        GetSgeStorageReq req = new GetSgeStorageReq();
        req.setAccntId(Arrays.asList(secAccntId));
        query.setGetSgeStorageReq(req);
        this.mapQuery.put(secAccntId, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("\u8d35\u91d1\u5c5e\u5e93\u5b58sge storage query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        HashSet secAccntIds = new HashSet();
        this.fundMng.getAccountMap().forEach((k, v) -> v.forEach(secAccnt -> secAccntIds.add(secAccnt.getSecAccntId())));
        List<SgeStorage> listQuery = this.queryByPage(new ArrayList<String>(secAccntIds));
        List<ObSgeStorage> listOb = this.updateSgeStorages(listQuery);
        this.update(listOb);
    }

    private List<SgeStorage> queryByPage(List<String> secAccntIds) throws MException {
        LinkedList<SgeStorage> list = new LinkedList<SgeStorage>();
        GetSgeStorageReq req = new GetSgeStorageReq();
        Page pageReq = this.httpBase.getHttpDefPage();
        req.setAccntId(secAccntIds);
        req.setOpUser(this.httpBase.getHttpOpUser());
        req.setPage(pageReq);
        req.setBeginDate("");
        req.setEndDate("");
        req.setIncludeZero(Boolean.valueOf(true));
        GetSgeStorageResp resp = this.sgeApi.getSgeStorageReq(req);
        list.clear();
        list.addAll(resp.getData());
        while (!resp.isLast()) {
            pageReq.setStartRow(resp.getOffset() + resp.getSize());
            req.setPage(pageReq);
            GetSgeStorageResp res = this.sgeApi.getSgeStorageReq(req);
            list.addAll(res.getData());
        }
        return list;
    }

    private synchronized void update(List<ObSgeStorage> listQuery) {
        this.list.update(listQuery);
        this.changed();
    }

    public ObservableList<ObSgeStorage> getList() {
        return this.list.getList();
    }
}

