/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.sge;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.query.marginxt.PositionEvent;
import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.query.sge.GetSgePositionsReq;
import cms.tmx.http.query.sge.GetSgePositionsResp;
import cms.tmx.http.query.sge.ObSgePosition;
import cms.tmx.http.query.sge.SgePosition;
import cms.tmx.http.query.sge.api.SgePositionServiceApi;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.sge.SgePositionMng;
import cms.tmx.query.current.models.SgeAccountMap;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SgePositionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(SgePositionModel.class);
    private String marketGroup;
    private MxList<SgePosition> sgeList = new MxList();
    private MarketItem marketItem;
    private MxListDirty<ObSgePosition> list = new MxListDirty();
    @Inject
    private SgeAccountMap sgeAccountMap;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    private RefDataMng refMng;
    @Inject
    private MarketDataModel marketMng;
    @Inject
    private SgePositionServiceApi posApi;
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Map<String, SgePositionMng> mapQuery = new ConcurrentHashMap<String, SgePositionMng>();
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.marketGroup = "SGE";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.PositionEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PositionEvent posEvent = (PositionEvent)this.gson.fromJson((JsonElement)obj, PositionEvent.class);
        if (!"SGE".equals(posEvent.getMarketGroup())) {
            return;
        }
        for (XtPosition po : posEvent.getPosItem()) {
            if (po.getDirection() == null || StringUtils.isEmpty((String)po.getDirection().getDesc()) || !"SGEX".equals(po.getInstrument().getMarket())) continue;
            ObSgePosition sge = new ObSgePosition();
            sge.getInstrument().update((Object)po.getInstrument());
            sge.setTradeDate(po.getTradingDay());
            sge.setSecAccntId(po.getSecAccntId());
            sge.setDire(po.getDirection().getDesc());
            this.updatePosition(sge);
        }
    }

    private void updatePosition(ObSgePosition po) {
        SgePositionMng mng = this.getQuery(po.getSecAccntId());
        if (mng != null) {
            mng.addQuery(po);
            this.scheduleSpecQuery();
        }
    }

    private void scheduleSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("\u8d35\u91d1\u5c5e\u6301\u4ed3\u63a8\u9001\u67e5\u8be2spec query position failed", e);
            }
        });
    }

    private void specQuery() throws MException {
        LinkedList<SgePosition> listSrc = new LinkedList<SgePosition>();
        for (SgePositionMng query : this.mapQuery.values()) {
            listSrc.addAll(query.queryDirty());
        }
        this.updateDirty(listSrc);
    }

    private void updateDirty(List<SgePosition> listSrc) {
        List<ObSgePosition> listPosition = this.updatePositions(listSrc, false);
        this.list.updateDirty(listPosition);
        this.changed();
    }

    public synchronized SgePositionMng getQuery(String secAccntId) {
        if (secAccntId == null) {
            return null;
        }
        if (this.mapQuery.containsKey(secAccntId)) {
            return this.mapQuery.get(secAccntId);
        }
        SgePositionMng query = (SgePositionMng)((Object)this.of.create(SgePositionMng.class));
        GetSgePositionsReq req = new GetSgePositionsReq();
        req.setAccntId(Arrays.asList(secAccntId));
        query.setGetSgePositionsReq(req);
        this.mapQuery.put(secAccntId, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("\u8d35\u91d1\u5c5e\u6301\u4ed3\u67e5\u8be2sgeposition query failed", e);
            }
        });
    }

    private List<SgePosition> queryByPage(List<String> secAccntIds) throws MException {
        LinkedList<SgePosition> list = new LinkedList<SgePosition>();
        GetSgePositionsReq req = new GetSgePositionsReq();
        Page pageReq = this.httpBase.getHttpDefPage();
        req.setAccntId(secAccntIds);
        req.setOpUser(this.httpBase.getHttpOpUser());
        req.setPage(pageReq);
        req.setBeginDate("");
        req.setEndDate("");
        req.setIncludeZero(Boolean.valueOf(false));
        req.setMarketGroup("SGE");
        req.setAccntLevel("ACCNT_LEVEL_EXT");
        req.setAccntType("ACCNT_TYPE_SEC");
        GetSgePositionsResp resp = this.posApi.getSgePositionsReq(req);
        list.clear();
        list.addAll(resp.getData());
        while (!resp.isLast()) {
            pageReq.setStartRow(resp.getOffset() + resp.getSize());
            req.setPage(pageReq);
            GetSgePositionsResp res = this.posApi.getSgePositionsReq(req);
            list.addAll(res.getData());
        }
        return list;
    }

    private void fullQuery() throws MException {
        HashSet secAccntIds = new HashSet();
        this.sgeAccountMap.getAccountMap().forEach((k, v) -> v.forEach(secAccnt -> secAccntIds.add(secAccnt.getSecAccntId())));
        List<SgePosition> listQuery = this.queryByPage(new ArrayList<String>(secAccntIds));
        List<ObSgePosition> listOb = this.updatePositions(listQuery, true);
        this.sgeList.updatePart(listQuery);
        this.update(listOb);
    }

    private List<ObSgePosition> updatePositions(List<SgePosition> listQuery, boolean isAll) {
        ArrayList<ObSgePosition> listOb = new ArrayList<ObSgePosition>();
        for (SgePosition po : listQuery) {
            ObSgePosition o = new ObSgePosition();
            o.update((Object)po);
            String type = o.getInstrument().getSecType();
            String market = o.getInstrument().getMarket().getRaw();
            RefItem refItem = this.refMng.getItem(String.valueOf(type) + market, market, o.getInstrument().getSecId());
            double nowPrice = 0.0;
            if (refItem == null) {
                logger.error(String.valueOf(o.getInstrument().getSecId()) + "\u8d35\u91d1\u5c5e\u6301\u4ed3\u6ca1\u6709\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
            } else {
                this.marketItem = this.marketMng.createItem(5);
                this.marketItem.setRefItem(refItem);
                if (isAll) {
                    this.marketMng.dye(this.marketItem);
                }
                this.marketItem = this.marketMng.getItem(refItem);
                if (this.marketItem != null) {
                    nowPrice = this.marketItem.getClosePrice();
                    if (this.marketItem.getNowPrice() != 0.0) {
                        nowPrice = this.marketItem.getNowPrice();
                    }
                } else {
                    logger.error(String.valueOf(o.getInstrument().getSecId()) + "\u8d35\u91d1\u5c5e\u6301\u4ed3\u6ca1\u6709\u83b7\u53d6\u5230\u52a8\u6001\u884c\u60c5");
                }
            }
            if (refItem != null && nowPrice != 0.0 && refItem.getTradeUnit() != 0.0) {
                if (1 == o.getDirection()) {
                    o.setProfit((double)Math.round((nowPrice - o.getCost()) * refItem.getTradeUnit() * o.getBalance() * 1000.0) / 1000.0);
                } else if (2 == o.getDirection()) {
                    o.setProfit((double)Math.round((o.getCost() - nowPrice) * refItem.getTradeUnit() * o.getBalance() * 1000.0) / 1000.0);
                }
            }
            o.setLastPx(nowPrice);
            CashAccnt cashAccnt = this.sgeAccountMap.getCashAccntByAccntId(o.getAccntId());
            o.setExtCashAccntId(cashAccnt == null ? "" : cashAccnt.getCashAccntId());
            listOb.add(o);
        }
        return listOb;
    }

    private synchronized void update(List<ObSgePosition> listQuery) {
        this.list.update(listQuery);
        this.changed();
    }

    public MEvent close(ObSgePosition pos) {
        LinkedList<ObSgePosition> list = new LinkedList<ObSgePosition>();
        list.add(pos);
        return this.clear(list);
    }

    public MEvent clear(List<ObSgePosition> listClear) {
        MEvent eCall = new MEvent();
        eCall.setObj(listClear);
        this.es.sendEvent("trade.close.position", eCall);
        return eCall;
    }

    public synchronized void queryMarketItem(List<ObSgePosition> listSrc) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        LinkedList<ObSgePosition> listTmp = new LinkedList<ObSgePosition>();
        listTmp.addAll(listSrc);
        for (ObSgePosition t : listTmp) {
            RefItem item = this.refMng.getItem(String.valueOf(t.getInstrument().getSecType()) + t.getInstrument().getMarket().getRaw(), t.getInstrument().getMarket().getRaw(), t.getInstrument().getSecId());
            if (item == null) continue;
            listItem.add(item);
        }
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem);
        }
    }

    public double getNewPrice(ObSgePosition po) throws MException {
        String market = po.getInstrument().getMarket().getRaw();
        String secId = po.getInstrument().getSecId();
        String secType = po.getInstrument().getSecType();
        String posiDirection = Integer.toString(po.getDirection());
        RefItem refItem = this.refMng.getItem(String.valueOf(secType) + market, market, secId);
        if (refItem == null) {
            throw new MException(999997, "no ref item " + secId);
        }
        MarketItem marketItem = this.marketMng.getItem(refItem);
        if (marketItem == null) {
            throw new MException(999997, "no market item " + secId);
        }
        double price = 0.0;
        if ("1".equals(posiDirection)) {
            price = marketItem.getBuyPrice(0);
        } else if ("2".equals(posiDirection)) {
            price = marketItem.getSellPrice(0);
        }
        if (price <= 0.0) {
            price = marketItem.getNowPrice() > 0.0 ? marketItem.getNowPrice() : marketItem.getClosePrice();
        }
        if (price < 0.0) {
            throw new MException(999997, "\u8be5\u4ee3\u7801\u65e0\u884c\u60c5 ");
        }
        return price;
    }

    public ObservableList<ObSgePosition> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    public MxList<SgePosition> getSgeList() {
        return this.sgeList;
    }
}

