/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.sge;

import cms.tmx.core.MScheduler;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SgeContractModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(SgeContractModel.class);
    @Inject
    protected RefDataMng refMng;
    MxList<RefItem> list = new MxList();
    private Map<String, RefItem> conMap = FxUtils.newMap();
    @Inject
    private MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;

    @PostConstruct
    public void init() {
        this.refMng.getFutures();
        this.sdFullQuery.setInterval(3000);
        if (this.getMap().isEmpty()) {
            this.fullQuery();
        }
    }

    public void query() {
        this.sdFullQuery.schedule(data -> this.fullQuery());
    }

    private void fullQuery() {
        this.list.clear();
        this.refMng.getFutures();
        for (RefItem ref : this.refMng.getItems(new String[]{"FUTSGEX"})) {
            this.list.add((MxObject)ref);
            this.conMap.put(ref.getCode(), ref);
        }
        this.changed();
    }

    public Map<String, RefItem> getMap() {
        return this.conMap;
    }

    public List<RefItem> getList() {
        return this.list.getList();
    }
}

