/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.sge;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.marginxt.PositionEvent;
import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.query.sge.GetSgeCashReq;
import cms.tmx.http.query.sge.GetSgeCashResp;
import cms.tmx.http.query.sge.ObSgeCash;
import cms.tmx.http.query.sge.SgeCash;
import cms.tmx.http.query.sge.api.SgeCashServiceApi;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.SgeAccountMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SgeCashModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(SgeCashModel.class);
    @Inject
    private SgeAccountMap fundMng;
    @Inject
    private MObjFactory of;
    private MxList<ObSgeCash> list = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private SgeCashServiceApi cashApi;
    @Inject
    private HttpBaseApi httpBase;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private Gson gson = new Gson();
    private Map<String, ObSgeCash> mapList = new ConcurrentHashMap<String, ObSgeCash>();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.es.subscribe("uap.push.PositionEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PositionEvent posEvent = (PositionEvent)this.gson.fromJson((JsonElement)obj, PositionEvent.class);
        if (posEvent.getCashItem() == null || !"SGE".equals(posEvent.getMarketGroup())) {
            return;
        }
        LinkedList<ObSgeCash> listO = new LinkedList<ObSgeCash>();
        for (XtPosition po : posEvent.getCashItem()) {
            ObSgeCash o = new ObSgeCash();
            o.update((Object)po);
            this.mapList.put(o.getCashAccntId(), o);
            listO.add(o);
        }
        this.update(listO);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("\u8d35\u91d1\u5c5e\u8d44\u91d1sge account query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        ArrayList<ObSgeCash> listOb = new ArrayList<ObSgeCash>();
        ArrayList<String> cashAccntIds = new ArrayList<String>();
        this.fundMng.getAccountMap().forEach((k, v) -> cashAccntIds.add(k.getCashAccntId()));
        List<SgeCash> listQuery = this.queryByPage(cashAccntIds);
        for (SgeCash each : listQuery) {
            ObSgeCash o = new ObSgeCash();
            o.update((Object)each);
            this.mapList.put(o.getCashAccntId(), o);
            listOb.add(o);
        }
        this.update(listOb);
    }

    private List<SgeCash> queryByPage(List<String> cashAccntIds) throws MException {
        LinkedList<SgeCash> list = new LinkedList<SgeCash>();
        GetSgeCashReq req = new GetSgeCashReq();
        Page pageReq = this.httpBase.getHttpDefPage();
        req.setAccntId(cashAccntIds);
        req.setOpUser(this.httpBase.getHttpOpUser());
        req.setPage(pageReq);
        req.setBeginDate("");
        req.setEndDate("");
        req.setIncludeZero(Boolean.valueOf(true));
        GetSgeCashResp resp = this.cashApi.getSgeCashReq(req);
        list.clear();
        list.addAll(resp.getData());
        while (!resp.isLast()) {
            pageReq.setStartRow(resp.getOffset() + resp.getSize());
            req.setPage(pageReq);
            GetSgeCashResp res = this.cashApi.getSgeCashReq(req);
            list.addAll(res.getData());
        }
        return list;
    }

    private synchronized void update(List<ObSgeCash> listQuery) {
        this.list.updatePart(listQuery);
        this.changed();
    }

    public ObservableList<ObSgeCash> getList() {
        return this.list.getList();
    }

    public Map<String, ObSgeCash> getMapList() {
        return this.mapList;
    }
}

