/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.OrderMng;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.portfolio.CcsPortfOrderModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UnusualOrderModel
extends MxModel {
    @Inject
    private MObjFactory of;
    @Inject
    private ExecutorService exe;
    @Inject
    protected PortfolioAccountModel portfAccntModel;
    @Inject
    private CcsOrderModel ccsOrderModel;
    @Inject
    private CcsPortfOrderModel portOrderModel;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    private static final Logger logger = LogManager.getLogger(UnusualOrderModel.class);
    protected Map<FundAccount, OrderMng> mapQuery = new ConcurrentHashMap<FundAccount, OrderMng>();
    private List<CcsOrder> list = Collections.synchronizedList(new ArrayList());
    private List<CcsSubFundAccount> subList = new ArrayList<CcsSubFundAccount>();
    private List<FundAccount> extList = new ArrayList<FundAccount>();
    private String dimension;
    private InvalidationListener lstnModel = ob -> {
        this.list.clear();
        if ("1".equals(this.dimension)) {
            ObservableList observableList = this.ccsOrderModel.getList();
            synchronized (observableList) {
                for (CcsOrder order : this.ccsOrderModel.getList()) {
                    if (!order.isCanCancel()) continue;
                    this.list.add(order);
                }
            }
        }
        ObservableList<CcsOrder> observableList = this.portOrderModel.getList();
        synchronized (observableList) {
            for (CcsOrder order : this.portOrderModel.getList()) {
                if (!order.isCanCancel()) continue;
                this.list.add(order);
            }
        }
        this.changed();
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullQuery() throws MException, Exception {
        List<CcsOrder> list = this.getList();
        synchronized (list) {
            this.list.clear();
        }
        if (this.dimension.equals("1")) {
            for (FundAccount fundAccount : this.extList) {
                OrderMng orderMng = this.getQuery(fundAccount);
                LinkedList<Order> listOrder = new LinkedList<Order>();
                Set<Order> setQuery = null;
                try {
                    setQuery = orderMng.queryPortf(true);
                }
                catch (MException e) {
                    logger.error("query fund account order failed: ", (Throwable)e);
                }
                if (setQuery == null) continue;
                listOrder.addAll(setQuery);
                List<CcsOrder> e = this.getList();
                synchronized (e) {
                    this.list.addAll(this.ccsOrderModel.updateOrder(listOrder));
                }
            }
        } else {
            for (CcsSubFundAccount ccsSubFundAccount : this.subList) {
                OrderMng orderMng = this.getQuery((FundAccount)ccsSubFundAccount);
                LinkedList<Order> listOrder = new LinkedList<Order>();
                Set<Order> setQuery = null;
                try {
                    setQuery = orderMng.queryPortf(true);
                }
                catch (MException e) {
                    logger.error("query fund account order failed: ", (Throwable)e);
                }
                if (setQuery == null) continue;
                listOrder.addAll(setQuery);
                List<CcsOrder> list2 = this.getList();
                synchronized (list2) {
                    this.list.addAll(this.portOrderModel.updateOrder(listOrder));
                }
            }
        }
        this.changed();
    }

    public synchronized OrderMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals("CCS")) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        OrderMng query = (OrderMng)((Object)this.of.create(OrderMng.class));
        query.setFund(fund);
        if (fund instanceof CcsSubFundAccount) {
            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fund);
            query.setSubAccId(subFundAccnt.getSubAccntId());
        } else {
            query.setSubAccId("");
        }
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("\u672a\u5b8c\u6210\u59d4\u6258\u5237\u65b0\u5931\u8d25", e);
            }
        });
    }

    @PostConstruct
    public void init() {
        this.ccsOrderModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.portOrderModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.sdFullQuery.setInterval(3000);
    }

    public synchronized MEvent cancel(List<CcsOrder> list) {
        MEvent event = new MEvent();
        event.setObj(list);
        event.put((Object)"ccs.cancel.force", (Object)true);
        this.es.sendEvent("ccs.cancel.order", event);
        return event;
    }

    public List<CcsOrder> getList() {
        return this.list;
    }

    public Set<String> getInvestorSecIds() {
        return this.portfAccntModel.getInvestorSecIds();
    }

    public List<CcsSubFundAccount> getSubList() {
        return this.subList;
    }

    public void setSubList(List<CcsSubFundAccount> subList) {
        this.subList = subList;
    }

    public List<FundAccount> getExtList() {
        return this.extList;
    }

    public void setExtList(List<FundAccount> extList) {
        this.extList = extList;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }
}

