/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.ListStatusReport;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.query.current.models.basket.BasketCcsOrderModel;
import cms.tmx.query.current.models.basket.BasketTaskModel;
import cms.tmx.query.current.models.basket.PortfBasketCcsOrderModel;
import cms.tmx.utils.StringUtils;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfolioBasketTaskModel
extends BasketTaskModel {
    protected static final Logger logger = LogManager.getLogger(PortfolioBasketTaskModel.class);
    @Inject
    protected PortfBasketCcsOrderModel portfOrderModel;

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    protected void submit(MEvent event) {
        String listId = event.getStr("listId");
        if (!event.getBool("isPortfolio")) {
            return;
        }
        this.addNewBatchOrder(listId);
        this.changed();
    }

    @Override
    protected synchronized void onPush(MEvent event) {
        if (event.getObj() == null) {
            return;
        }
        if (event.getObj() instanceof ExecutionReport) {
            this.onLegOrderPush(event);
        } else if (event.getObj() instanceof ListStatusReport) {
            this.onListOrderPush(event);
        } else if (event.getObj() instanceof CancelRejectReport) {
            this.onOrderCancelPush(event);
        }
    }

    private void onOrderCancelPush(MEvent event) {
        CancelRejectReport orderCancelReject = (CancelRejectReport)CancelRejectReport.class.cast(event.getObj());
        if (!(StringUtils.isEmpty((String)orderCancelReject.getReport().getClOrdLinkId()) || StringUtils.isEmpty((String)orderCancelReject.getReport().getListId()) || StringUtils.isEmpty((String)orderCancelReject.getReport().getSubAccntId()) || StringUtils.isEmpty((String)orderCancelReject.getReport().getSubSecAccntId()))) {
            String orderListId = orderCancelReject.getReport().getListId();
            String orderLegId = orderCancelReject.getReport().getClOrdLinkId();
            String ordDate = orderCancelReject.getReport().getTradeDate();
            BasketCcsOrder basketCcsOrder = this.bskOrderFactory.create();
            basketCcsOrder.setListId(orderListId);
            basketCcsOrder.setBatchId(orderListId);
            basketCcsOrder.setOrdDate(ordDate);
            this.getOrderModel().addToBeQuery(basketCcsOrder, orderLegId);
            this.runSpecQuery();
        }
    }

    private void onListOrderPush(MEvent event) {
        ListStatusReport listStatus = (ListStatusReport)ListStatusReport.class.cast(event.getObj());
        String listId = listStatus.getReport().getListId();
        this.batchItemMxList.getObList().forEach(item -> {
            if (((BasketCcsOrder)item.getValue()).getListId().equals(listId)) {
                ((BasketCcsOrder)item.getValue()).setBatchStatusRaw(Integer.toString(listStatus.getReport().getStatusValue()));
                this.onNodeStatusChange((BasketCcsOrder)item.getValue(), ((BasketCcsOrder)item.getValue()).getBatchStatus().getRaw());
                this.changed();
                return;
            }
        });
    }

    private synchronized void onLegOrderPush(MEvent event) {
        ExecutionReport executionReport = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        if (!(StringUtils.isEmpty((String)executionReport.getReport().getClOrdLinkId()) || StringUtils.isEmpty((String)executionReport.getReport().getListId()) || StringUtils.isEmpty((String)executionReport.getReport().getSubAccntId()) || StringUtils.isEmpty((String)executionReport.getReport().getSubSecAccntId()))) {
            String orderListId = executionReport.getReport().getListId();
            String orderLegId = executionReport.getReport().getClOrdLinkId();
            String ordDate = executionReport.getReport().getTradeDate();
            BasketCcsOrder basketCcsOrder = this.bskOrderFactory.create();
            basketCcsOrder.setListId(orderListId);
            basketCcsOrder.setBatchId(orderListId);
            basketCcsOrder.setOrdDate(ordDate);
            if (!this.orderItemsMxListMap.containsKey(basketCcsOrder) && this.batchItemMxList != null) {
                this.addNewBatchOrder(orderListId);
            }
            this.getOrderModel().addToBeQuery(basketCcsOrder, orderLegId);
            this.runSpecQuery();
        }
    }

    @Override
    public BasketCcsOrderModel getOrderModel() {
        return this.portfOrderModel;
    }
}

