/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.RepoRefItem;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.PreFrozenPositions;
import cms.tmx.query.current.mng.CcsPortfPositionMng;
import cms.tmx.query.current.mng.PositionMng;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class HkwolunPortfPositionModel
extends PositionModel<CcsPortfPosition> {
    private static final Logger logger = LogManager.getLogger(HkwolunPortfPositionModel.class);
    @Inject
    private IRefDataMng refMng;
    @Inject
    private PortfolioAccountModel portFolioModel;
    @Inject
    private IPortfolioApi portFolioApi;
    @Inject
    private IBaseApi iba;
    private Map<String, PPortfolio.Portfolio> portFolioMap = new HashMap<String, PPortfolio.Portfolio>();
    private Map<FundAccount, PositionMng> mapQuery = new ConcurrentHashMap<FundAccount, PositionMng>();
    private Map<String, CcsPortfPosition> ccsPfPstMap;
    private boolean firstQuery;
    @Inject
    private EPartService eps;
    @Inject
    private ScheduledExecutorService executorService;
    private static final int DEFAULT_SECONDS = 5;
    private static final List<String> parts = Arrays.asList("cms.tmx.instructions.part.portfolio.position.query", "cms.tmx.instructions.part.portfolio.basket.position.query", "cms.tmx.instructions.part.portfolio.repo.position.query", "cms.tmx.instructions.part.portfolio.hkwolun.position.query");
    private InvalidationListener lst = ob -> {
        this.ccsPfPstMap = this.getList().stream().collect(Collectors.toMap(CcsPortfPosition::unique, p -> p, (oldValue, newValue) -> oldValue));
        this.mapChange();
    };

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("CCS");
        this.setPositionType("BOND");
        this.setSetType(1);
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("pre_frozen_position", event -> this.updatePreFrzPosition(event));
        this.changed.addListener((InvalidationListener)new WeakInvalidationListener(this.lst));
    }

    public void queryNewPrice() {
        try {
            boolean isVisible = false;
            for (String partId : parts) {
                MPart findPart = this.eps.findPart(partId);
                if (findPart == null || !this.eps.isPartVisible(findPart)) continue;
                isVisible = true;
                logger.info(String.valueOf(partId) + "\u53ef\u89c1");
                break;
            }
            if (isVisible) {
                this.queryAndGetNewPrice((List<CcsPortfPosition>)this.getList());
            } else {
                logger.info("\u65e0\u6295\u7ec4\u6301\u4ed3\u9875\u9762\u53ef\u89c1");
            }
        }
        catch (Exception e) {
            logger.error("\u6301\u4ed3\u8f6e\u8be2\u6700\u65b0\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, CcsPortfPosition> getMap() {
        return this.ccsPfPstMap;
    }

    @Override
    protected void update(List<Position> listSrc) {
        List<CcsPortfPosition> listPosition = this.updatePosition(listSrc);
        this.list.update(listPosition);
        this.changed();
    }

    @Override
    protected void updatePreFrzPosition(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof PreFrozenPositions)) {
            return;
        }
        PreFrozenPositions positions = (PreFrozenPositions)PreFrozenPositions.class.cast(obj);
        for (CcsPortfPosition pos : positions.getSubPositionsToUpdate()) {
            this.updateSubPosition(pos);
        }
    }

    protected List<CcsPortfPosition> updatePosition(List<Position> listSrc) {
        LinkedList<CcsPortfPosition> listPosition = new LinkedList<CcsPortfPosition>();
        for (Position position : listSrc) {
            if (!"SHSC".equals(position.getMarket().getRaw()) && !"SZSC".equals(position.getMarket().getRaw()) || !(position instanceof CcsPortfPosition)) continue;
            CcsPortfPosition posi = (CcsPortfPosition)CcsPortfPosition.class.cast(position);
            this.queryModel.getPositionPrice((CcsPosition)posi);
            this.queryModel.afterUpdate((Position)posi);
            listPosition.add(posi);
        }
        this.firstQuery = true;
        this.queryAndGetNewPrice(listPosition);
        return listPosition;
    }

    @Override
    protected void updateDirty(List<Position> listSrc) {
        List<CcsPortfPosition> listPosition = this.updatePosition(listSrc);
        this.list.updateDirty(listPosition);
        this.changed();
    }

    public MEvent close(CcsPortfPosition pos) {
        LinkedList<CcsPortfPosition> list = new LinkedList<CcsPortfPosition>();
        list.add(pos);
        return this.clear(list);
    }

    public MEvent clear(List<CcsPortfPosition> listClear) {
        MEvent eCall = new MEvent();
        eCall.setObj(listClear);
        this.es.sendEvent("trade.close.position", eCall);
        return eCall;
    }

    @Override
    protected void onPush(MEvent event) {
        if (!(event.getObj() instanceof ExecutionReport)) {
            return;
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        if (!this.careReport(report)) {
            return;
        }
        PMessage.ExecutionReport pReport = report.getReport();
        if (!this.carePortfolio(pReport)) {
            return;
        }
        CcsPortfPosition ccsPortfolioPost = this.fPos.createCcsPortfolio();
        ccsPortfolioPost.setSubAccntId(pReport.getSubAccntId());
        ccsPortfolioPost.setSubSecAccntId(pReport.getSubSecAccntId());
        ccsPortfolioPost.setSecId(pReport.getInstrument().getSecurityId());
        ccsPortfolioPost.getMarket().setRaw(pReport.getInstrument().getMarket());
        String marketGrp = MarketUtils.getMarketGroup((String)pReport.getInstrument().getMarket());
        ccsPortfolioPost.setMarketGrp(marketGrp);
        ccsPortfolioPost.setExtAccId(pReport.getExtAccntId());
        ccsPortfolioPost.setExtSecAccId(pReport.getExtSecAccntId());
        ccsPortfolioPost.setTradingDay(pReport.getTradeDate());
        ccsPortfolioPost.setSecType(pReport.getInstrument().getSecurityType());
        this.updateSubPosition(ccsPortfolioPost);
    }

    private void updateSubPosition(CcsPortfPosition ccsPortfolioPost) {
        CcsSubFundAccount fundAcc = this.portFolioModel.getSubFundAccountById(ccsPortfolioPost.getSubAccntId());
        PositionMng query = null;
        if (fundAcc != null) {
            if (StringUtils.isEmpty((String)ccsPortfolioPost.getTradingDay())) {
                ccsPortfolioPost.setTradingDay(fundAcc.getTradingDay());
            }
            query = this.mapQuery.get(fundAcc);
        }
        if (query != null) {
            query.addQuery((Position)ccsPortfolioPost);
            this.markDirty((Position)ccsPortfolioPost);
            CcsPortfPosition newPos = this.standardBondOnPush(ccsPortfolioPost);
            if (newPos != null) {
                query.addQuery((Position)newPos);
                this.markDirty((Position)newPos);
            }
            this.scheduleSpecQuery();
        }
    }

    private void scheduleSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException e) {
                logger.error("full query failed", (Throwable)e);
            }
        });
    }

    private void specQuery() throws MException {
        LinkedList<Position> listSrc = new LinkedList<Position>();
        List<CcsSubFundAccount> fundList = this.portFolioModel.getFundAccounts();
        for (CcsSubFundAccount fund : fundList) {
            PositionMng query = this.getQuery(fund);
            query.queryDirty().forEach(post -> {
                if (post instanceof CcsPortfPosition) {
                    CcsPortfPosition portPost = (CcsPortfPosition)CcsPortfPosition.class.cast(post);
                    portPost.setPortfolioId(fund.getPortfolioId());
                    portPost.setPortfolioName(this.getPortfolioNameById(fund.getPortfolioId()));
                    listSrc.add((Position)portPost);
                }
            });
        }
        this.updateDirty(listSrc);
    }

    private CcsPortfPosition standardBondOnPush(CcsPortfPosition pos) {
        if (!pos.getMarketGrp().equals("CCS")) {
            return null;
        }
        RefItem item = this.refMng.getItem(pos.getMarket().getRaw(), pos.getSecId());
        if (item instanceof RepoRefItem) {
            CcsPortfPosition position = this.fPos.createCcsPortfolio();
            position.update((Object)pos);
            String newSecId = ((RepoRefItem)RepoRefItem.class.cast(item)).getStdSecId();
            position.setSecId(newSecId);
            return position;
        }
        return null;
    }

    @Override
    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("full query failed", (Throwable)e);
            }
        });
    }

    private void fullQuery() throws MException {
        try {
            List portfolioIds = this.portFolioApi.getPortfolioIdsByPost(this.iba.getPostId());
            this.portFolioApi.getPortfoliosByIds(portfolioIds).forEach(portfolio -> this.portFolioMap.put(portfolio.getPortfolio().getPortfolioId(), portfolio.getPortfolio()));
        }
        catch (MException e) {
            logger.error("\u7f13\u5b58\u6295\u7ec4\u4fe1\u606f(\u5c55\u793a\u4e2d\u6587\u540d\u79f0\u7528)\u5931\u8d25" + e.getMessage());
        }
        LinkedList<Position> listSrc = new LinkedList<Position>();
        this.portFolioModel.getPortfolios().forEach(portfolio -> {
            Set<CcsFundAccount> fundList = this.portFolioModel.getMap((Portfolio)portfolio).keySet();
            for (CcsFundAccount fund : fundList) {
                if (!(fund instanceof CcsSubFundAccount)) continue;
                CcsSubFundAccount ccsSubFund = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fund);
                PositionMng query = this.getQuery(ccsSubFund);
                try {
                    query.query().forEach(post -> {
                        if (post instanceof CcsPortfPosition) {
                            CcsPortfPosition portPost = (CcsPortfPosition)CcsPortfPosition.class.cast(post);
                            portPost.setPortfolioId(ccsSubFund.getPortfolioId());
                            portPost.setPortfolioName(this.getPortfolioNameById(ccsSubFund.getPortfolioId()));
                            listSrc.add((Position)portPost);
                        }
                    });
                }
                catch (MException e) {
                    logger.error("query fund account position failed", (Throwable)e);
                }
            }
        });
        this.update(listSrc);
    }

    public List<CcsPortfPosition> getPositionByFund(String subFund, String subSec, String mktGrp) {
        LinkedList<CcsPortfPosition> listSrc = new LinkedList<CcsPortfPosition>();
        try {
            CcsPortfPositionMng posiMng = (CcsPortfPositionMng)((Object)this.of.create(CcsPortfPositionMng.class));
            posiMng.query(subFund, subSec, mktGrp).forEach(post -> {
                CcsPortfPosition portPost;
                if (post instanceof CcsPortfPosition && (portPost = (CcsPortfPosition)CcsPortfPosition.class.cast(post)).getTotalVol() > 0L) {
                    listSrc.add(portPost);
                }
            });
        }
        catch (MException e) {
            logger.error("query fund account position failed", (Throwable)e);
        }
        return listSrc;
    }

    private PositionMng getQuery(CcsSubFundAccount fund) {
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        PositionMng posiMng = (PositionMng)((Object)this.of.create(CcsPortfPositionMng.class));
        posiMng.setFund((FundAccount)fund);
        fund.setMarketGrp(this.getMarketGrp());
        posiMng.setPositionType(this.getPositionType());
        posiMng.setSetType(this.getSetType());
        this.mapQuery.put((FundAccount)fund, posiMng);
        return posiMng;
    }

    protected void portfUpdate(List<CcsPortfPosition> listSrc) {
        LinkedList<CcsPortfPosition> listPosition = new LinkedList<CcsPortfPosition>();
        for (CcsPortfPosition position : listSrc) {
            if (!"SHSC".equals(position.getMarket().getRaw()) && !"SZSC".equals(position.getMarket().getRaw()) || !(position instanceof CcsPortfPosition)) continue;
            listPosition.add((CcsPortfPosition)CcsPortfPosition.class.cast(position));
        }
        this.list.update(listPosition);
        this.changed();
    }

    private boolean carePortfolio(PMessage.ExecutionReport pReport) {
        return !StringUtils.isEmpty((String)pReport.getSubAccntId()) && !StringUtils.isEmpty((String)pReport.getSubSecAccntId());
    }

    @Override
    public double getCanSell(SecAccount account, String code) {
        CcsPortfPosition pos = this.getPosition(account, code);
        if (pos != null) {
            return pos.getCanVol();
        }
        return 0.0;
    }

    @Override
    public CcsPortfPosition getPosition(SecAccount account, String code) {
        if (account instanceof CcsSubSecAccount) {
            CcsSubSecAccount subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(account);
            return this.getPosition(subSecAccount.getSubSecAccntId(), code);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CcsPortfPosition getPosition(String subSecAccntId, String code) {
        CcsPortfPosition item = null;
        if (this.getMap() == null || this.getMap().isEmpty()) {
            ObservableList observableList = this.list.getList();
            synchronized (observableList) {
                for (CcsPortfPosition pos : this.getList()) {
                    if (!subSecAccntId.equals(pos.getSubSecAccntId()) || !code.equals(pos.getSecId())) continue;
                    item = pos;
                    break;
                }
            }
        } else {
            item = this.getMap().get(String.valueOf(subSecAccntId) + code);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CcsPortfPosition getPositionInMap(SecAccount account, String code) {
        CcsPortfPosition item = null;
        if (account instanceof CcsSubSecAccount) {
            CcsSubSecAccount subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(account);
            ObservableList observableList = this.list.getList();
            synchronized (observableList) {
                if (this.getMap() != null) {
                    item = this.getMap().get(String.valueOf(subSecAccount.getSubSecAccntId()) + code);
                }
            }
            return item;
        }
        return null;
    }

    private String getPortfolioNameById(String portfolioId) {
        if (!this.portFolioMap.containsKey(portfolioId)) {
            try {
                this.portFolioApi.getPortfoliosByIds(Arrays.asList(portfolioId)).forEach(item -> this.portFolioMap.put(item.getPortfolio().getPortfolioId(), item.getPortfolio()));
            }
            catch (MException e) {
                logger.error("\u6839\u636e\u6295\u7ec4id\u67e5\u8be2\u6295\u7ec4\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
        return this.portFolioMap.containsKey(portfolioId) ? this.portFolioMap.get(portfolioId).getPortfolioName() : "";
    }

    public synchronized void queryMarketItem(List<CcsPortfPosition> posList) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (CcsPortfPosition t : posList) {
            RefItem item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecId());
            if (item == null) continue;
            listItem.add(item);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    public synchronized void queryAndGetNewPrice(List<CcsPortfPosition> posList) {
        if (!this.firstQuery) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (CcsPortfPosition t : posList) {
                RefItem item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecId());
                if (item == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.marketMng.query(listItem, gears);
            }
        }
        for (CcsPortfPosition posi : posList) {
            BigDecimal buy;
            double buyCost;
            if (!this.firstQuery) {
                RefItem refItem = this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId());
                if (refItem == null) continue;
                MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    if (marketItem.getNowPrice() == 0.0) {
                        posi.setNowPrice(marketItem.getClosePrice());
                    } else {
                        posi.setNowPrice(marketItem.getNowPrice());
                    }
                }
            }
            if ((buyCost = (buy = new BigDecimal(posi.getBuyCost())).setScale(4, 4).doubleValue()) == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setYield(0.0);
            } else {
                double yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
                posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
            }
            BigDecimal b = new BigDecimal(posi.getCost());
            double cost = b.setScale(4, 4).doubleValue();
            if (cost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            if (posi.getNowPrice() == 0.0) continue;
            double capitalization = QueryUtils.calAmountByMarketAndSecType(posi.getMarket().getRaw(), posi.getSecType(), posi.getTotalVol(), posi.getNowPrice());
            posi.setCapitalization((double)Math.round(capitalization * 10000.0) / 10000.0);
            posi.updateProfit();
        }
        this.firstQuery = false;
    }
}

