/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.OrderMng;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HkwolunPortfOrderModel
extends OrderQueryModel<CcsOrder> {
    @Inject
    private IPortfolioApi portfolioApi;
    protected static final Logger logger = LogManager.getLogger(HkwolunPortfOrderModel.class);
    private Map<String, PPortfolio.Portfolio> portFolioMap = new HashMap<String, PPortfolio.Portfolio>();
    @Inject
    protected PortfolioAccountModel portfAccntModel;

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("CCS");
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fullQuery() throws MException {
        AtomicBoolean first = new AtomicBoolean(true);
        this.querying.set(true);
        try {
            ObservableList fundList = FxUtils.newList();
            fundList.addAll(this.portfAccntModel.getFundAccounts());
            for (CcsSubFundAccount fund : fundList) {
                OrderMng orderMng = this.getQuery(fund);
                LinkedList<Order> listOrder = new LinkedList<Order>();
                Set<Order> setQuery = null;
                try {
                    setQuery = orderMng.queryPortf(this.isUnfinishedOrder);
                }
                catch (MException e) {
                    logger.error("query fund account order failed: ", (Throwable)e);
                }
                if (setQuery == null) continue;
                if (first.get()) {
                    ObservableList observableList = this.list.getList();
                    synchronized (observableList) {
                        this.list.clear();
                        first.set(false);
                    }
                }
                listOrder.addAll(setQuery);
                this.update(listOrder);
            }
        }
        finally {
            this.querying.set(false);
        }
    }

    @Override
    protected boolean careReport(PMessage.ExecutionReport report) {
        if (StringUtils.isEmpty((String)report.getSubAccntId())) {
            return false;
        }
        if (!report.hasSingleOrder()) {
            return false;
        }
        return "SHSC".equals(report.getInstrument().getMarket()) || "SZSC".equals(report.getInstrument().getMarket());
    }

    public synchronized OrderMng getQuery(CcsSubFundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return (OrderMng)((Object)this.mapQuery.get(fund));
        }
        OrderMng query = (OrderMng)((Object)this.of.create(OrderMng.class));
        query.setFund((FundAccount)fund);
        query.setSubAccId(fund.getSubAccntId());
        this.mapQuery.put(fund, query);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObservableList<CcsOrder> getList() {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            return this.list.getList().filtered(each -> !"".equals(each.getPortfolioId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void update(List<Order> listOrder) {
        List<CcsOrder> listCcsOrder = this.updateOrder(listOrder);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            listCcsOrder.addAll((Collection<CcsOrder>)this.list.getList());
        }
        this.list.update(listCcsOrder);
        this.changed();
    }

    protected List<CcsOrder> updateOrder(List<Order> listOrder) {
        LinkedList<CcsOrder> listCcsOrder = new LinkedList<CcsOrder>();
        for (Order order : listOrder) {
            if (!"SHSC".equals(order.getInstrument().getMarket().getRaw()) && !"SZSC".equals(order.getInstrument().getMarket().getRaw()) || !(order instanceof CcsOrder)) continue;
            CcsOrder ccs = (CcsOrder)CcsOrder.class.cast(order);
            this.queryModel.afterUpdate(ccs);
            this.queryModel.getOrderPrice((Order)ccs);
            if ("".equals(ccs.getPortfolioId())) continue;
            listCcsOrder.add(ccs);
        }
        return listCcsOrder;
    }

    @Override
    protected void updateDirty(List<Order> listOrder) {
        List<CcsOrder> listCcsOrder = this.updateOrder(listOrder);
        for (CcsOrder order : listCcsOrder) {
            if (!"SHSC".equals(order.getInstrument().getMarket().getRaw()) && !"SZSC".equals(order.getInstrument().getMarket().getRaw())) continue;
            if (this.isUnfinishedOrder) {
                if (order.isCanCancel()) {
                    this.list.updatePart((MxObject)order);
                    continue;
                }
                if (this.list.getListMap().get(order) == null) continue;
                this.list.remove((MxObject)order);
                continue;
            }
            this.list.updatePart((MxObject)order);
        }
        this.changed();
    }

    protected String getPortfolioNameById(String portfolioId) throws MException {
        if (!this.portFolioMap.containsKey(portfolioId)) {
            this.portfolioApi.getPortfoliosByIds(Arrays.asList(portfolioId)).forEach(item -> this.portFolioMap.put(item.getPortfolio().getPortfolioId(), item.getPortfolio()));
        }
        return this.portFolioMap.containsKey(portfolioId) ? this.portFolioMap.get(portfolioId).getPortfolioName() : "";
    }
}

