/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.notice.ListStatusReport;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.Deal;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.DealMng;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CcsPortfDealModel
extends DealQueryModel<CcsDeal> {
    @Inject
    private IPortfolioApi portfolioApi;
    protected static final Logger logger = LogManager.getLogger(CcsPortfDealModel.class);
    private Map<String, PPortfolio.Portfolio> portFolioMap = new HashMap<String, PPortfolio.Portfolio>();
    @Inject
    protected PortfolioAccountModel portfAccntModel;
    @Inject
    protected MScheduler sdSpecQuery;
    private static final int SPEC_QUERY_INTERVAL = 1000;

    @Override
    @PostConstruct
    public void init() {
        this.sdSpecQuery.setInterval(1000);
        this.setMarketGrp("CCS");
        super.init();
    }

    @Override
    protected void fullQuery() throws MException {
        LinkedList<Deal> listDeal = new LinkedList<Deal>();
        ObservableList accList = FxUtils.newList();
        accList.addAll(this.portfAccntModel.getFundAccounts());
        for (CcsSubFundAccount acc : accList) {
            DealMng query = this.getQuery(acc);
            try {
                Set<Deal> setAccDeal = query.queryPortf();
                if (setAccDeal == null) continue;
                listDeal.addAll(setAccDeal);
            }
            catch (MException e) {
                logger.error("query fund account deals failed", (Throwable)e);
            }
        }
        this.updateList(listDeal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObservableList<CcsDeal> getList() {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            return this.list.getList().filtered(each -> !"".equals(each.getPortfolioId()));
        }
    }

    private void runSynQuery(String parentAccountID, String parentSubAccountID) {
        LinkedList<Deal> listDeal = new LinkedList<Deal>();
        for (DealMng dealMng : this.mapQuery.values()) {
            CcsSubFundAccount subFundAccnt;
            if (!(dealMng.getAccount() instanceof CcsSubFundAccount) || !(subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(dealMng.getAccount())).getParentId().equals(parentAccountID) || !subFundAccnt.getParentSubAccntId().equals(parentSubAccountID)) continue;
            try {
                LinkedList<Deal> listQuery = new LinkedList<Deal>(dealMng.query());
                listDeal.addAll(listQuery);
            }
            catch (MException | Exception e) {
                logger.error("query fund account deal failed: ", e);
            }
        }
        this.updateDirty(listDeal);
    }

    private void onListReport(MEvent event) {
        String type = event.getStr("push_type");
        if (!type.equals("123")) {
            return;
        }
        if (!(event.getObj() instanceof ListStatusReport)) {
            return;
        }
        ListStatusReport report = (ListStatusReport)ListStatusReport.class.cast(event.getObj());
        if (!("2".equals(String.valueOf(report.getReport().getStatusValue())) || "3".equals(String.valueOf(report.getReport().getStatusValue())) || "4".equals(String.valueOf(report.getReport().getStatusValue())))) {
            return;
        }
        this.sdFullQuery.schedule(e -> this.runSynQuery(report.getReport().getParentExtAccntId(), report.getReport().getParentSubAccntId()));
    }

    @Override
    protected boolean careReport(PMessage.ExecutionReport report) {
        if (StringUtils.isEmpty((String)report.getSubAccntId())) {
            return false;
        }
        if (!report.hasExecution()) {
            return false;
        }
        String market = report.getInstrument().getMarket();
        if (!"XSHE".equals(market) && !"XSHG".equals(market)) {
            return false;
        }
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        return marketGroup.equals(this.marketGroup);
    }

    private synchronized DealMng getQuery(CcsSubFundAccount acc) {
        if (this.mapQuery.containsKey(acc)) {
            return (DealMng)((Object)this.mapQuery.get(acc));
        }
        DealMng query = (DealMng)((Object)this.of.create(DealMng.class));
        query.setAccount((FundAccount)acc);
        query.setSubAccId(acc.getSubAccntId());
        this.mapQuery.put(acc, query);
        return query;
    }

    private void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.querySpec();
            }
            catch (MException e) {
                logger.error("deal spec query failed", (Throwable)e);
            }
        });
    }

    private void querySpec() throws MException {
        logger.info("\u63a8\u9001\u89e6\u53d1\u4e86\u6295\u7ec4\u6210\u4ea4\u67e5\u8be2");
        LinkedList<Deal> list = new LinkedList<Deal>();
        for (DealMng query : this.mapQuery.values()) {
            List<Deal> listQuery = query.queryToBeQuery();
            if (listQuery == null) continue;
            list.addAll(listQuery);
        }
        this.updateDirty(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateList(List<Deal> listDeal) {
        List<CcsDeal> listCcsDeal = this.updateDeal(listDeal);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.setAll(listCcsDeal);
        }
        this.changed();
    }

    protected List<CcsDeal> updateDeal(List<Deal> listDeal) {
        LinkedList<CcsDeal> listCcsDeal = new LinkedList<CcsDeal>();
        for (Deal deal : listDeal) {
            if (!"XSHG".equals(deal.getInstrument().getMarket().getRaw()) && !"XSHE".equals(deal.getInstrument().getMarket().getRaw()) || !(deal instanceof CcsDeal)) continue;
            CcsDeal ccs = (CcsDeal)CcsDeal.class.cast(deal);
            this.queryModel.getDealPrice((Deal)ccs);
            this.queryModel.afterUpdate(ccs);
            if (ccs.getPortfolioId().isEmpty()) continue;
            listCcsDeal.add(ccs);
        }
        return listCcsDeal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateDirty(List<Deal> listDeal) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.updatePart(this.updateDeal(listDeal));
        }
        this.changed();
    }

    protected String getPortfolioNameById(String portfolioId) throws MException {
        if (!this.portFolioMap.containsKey(portfolioId)) {
            this.portfolioApi.getPortfoliosByIds(Arrays.asList(portfolioId)).forEach(item -> this.portFolioMap.put(item.getPortfolio().getPortfolioId(), item.getPortfolio()));
        }
        return this.portFolioMap.containsKey(portfolioId) ? this.portFolioMap.get(portfolioId).getPortfolioName() : "";
    }
}

