/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgorithmTradeApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.Deal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.HkwolunDealModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.query.current.models.portfolio.CcsPortfDealModel;
import cms.tmx.query.current.models.portfolio.HkwolunPortfDealModel;
import cms.tmx.query.current.views.portfolio.AlgoQueryPart;
import cms.tmx.query.history.ICcsDealHisService;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class AlgoQueryModel
extends MxModel {
    private ObservableList<AlgoBaseOrder> baseOrderList = FxUtils.newList();
    private List<AlgoBaseOrder> miseList = new CopyOnWriteArrayList<AlgoBaseOrder>();
    private static final Logger logger = LogManager.getLogger(AlgoQueryModel.class);
    @Inject
    private IAlgorithmTradeApi api;
    @Inject
    private IBaseApi iba;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private ExecutorService exe;
    @Inject
    public AlgoStrategyQueryModel miseModel;
    private DateFormat format = new SimpleDateFormat("yyyyMMdd");
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    protected CcsDealModel model;
    @Inject
    protected CcsPortfDealModel pmodel;
    @Inject
    protected HkwolunDealModel modelHk;
    @Inject
    protected HkwolunPortfDealModel pmodelHk;
    @Inject
    private AlgoFuncControl algoFunc;
    @Inject
    private QueryModel queryModel;
    public static boolean isStart = false;
    Map<String, List<CcsDeal>> mapNormal;
    Map<String, List<CcsDeal>> mapPortf;
    @Inject
    private ICcsDealHisService hisDealService;
    @Inject
    private AlgoMiseMng mise;

    @PostConstruct
    public void init() {
        if (this.model.getList().size() == 0) {
            this.model.query();
        }
        if (this.pmodel.getList().size() == 0) {
            this.pmodel.query();
        }
        if (this.model.getList().size() == 0) {
            this.modelHk.query();
        }
        if (this.pmodel.getList().size() == 0) {
            this.pmodelHk.query();
        }
        this.es.subscribe(AlgoQueryPart.class.getName(), event -> this.query());
        this.miseModel.changedProperty().addListener(ob -> {
            ArrayList<AlgoBaseOrder> tempList = new ArrayList<AlgoBaseOrder>();
            for (MEvent event : this.miseModel.getListEvent()) {
                AlgoBaseOrder baseOrder = new AlgoBaseOrder();
                try {
                    baseOrder.update((Object)event);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (baseOrder.getType().getRaw().isEmpty()) continue;
                tempList.add(baseOrder);
            }
            this.miseList.clear();
            this.miseList.addAll(tempList);
            this.summarizingDeals(this.miseList);
            this.changed();
        });
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 300L, TimeUnit.SECONDS);
        });
    }

    public void startQuery() {
        if (!isStart) {
            isStart = true;
            this.es.subscribe("apama.algo.refresh", event -> this.query());
        }
    }

    public void query() {
        ArrayList deals = new ArrayList();
        ArrayList<CcsDeal> dealsPortf = new ArrayList<CcsDeal>();
        deals.addAll(this.model.getList());
        dealsPortf.addAll((Collection<CcsDeal>)this.pmodel.getList());
        deals.addAll(this.modelHk.getList());
        dealsPortf.addAll((Collection<CcsDeal>)this.pmodelHk.getList());
        if (deals.size() > 0) {
            this.mapNormal = deals.stream().filter(t -> !t.getBaseId().isEmpty()).collect(Collectors.groupingBy(Deal::getBaseId));
        }
        if (dealsPortf.size() > 0) {
            this.mapPortf = dealsPortf.stream().filter(t -> !t.getBaseId().isEmpty()).collect(Collectors.groupingBy(Deal::getBaseId));
        }
        try {
            this.queryBaseOrder();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void summarizingDeals(List<AlgoBaseOrder> list) {
        for (AlgoBaseOrder baseOrder : list) {
            if (baseOrder == null || baseOrder.getPortfolioName().isEmpty() && this.mapNormal == null || !baseOrder.getPortfolioName().isEmpty() && this.mapPortf == null || AlgoMiseMng.isMise(baseOrder.getType().getRaw()) && !baseOrder.isMiseSingleSecuirty()) continue;
            int dealCount = 0;
            double dealAmt = 0.0;
            double repoAmt = 0.0;
            if (baseOrder.getBaseId() != null) {
                List<CcsDeal> listDeal;
                String baseId = baseOrder.getBaseId();
                if (StringUtils.isApama((String)baseOrder.getType().getRaw())) {
                    baseId = baseOrder.getBaseId();
                } else if (baseOrder.getType().getRaw().equals("18")) {
                    baseId = baseOrder.getId();
                }
                if (baseOrder.getPortfolioName().isEmpty()) {
                    if (this.mapNormal.get(baseId) != null) {
                        listDeal = this.mapNormal.get(baseId);
                        dealCount = listDeal.stream().collect(Collectors.summingDouble(Deal::getLastQty)).intValue();
                        dealAmt = listDeal.stream().collect(Collectors.summingDouble(Deal::getLastAmount));
                        for (CcsDeal deal : listDeal) {
                            repoAmt += deal.getLastQty() * deal.getLastPx();
                        }
                    }
                } else if (this.mapPortf.get(baseId) != null) {
                    listDeal = this.mapNormal.get(baseId);
                    dealCount = listDeal.stream().collect(Collectors.summingDouble(Deal::getLastQty)).intValue();
                    dealAmt = listDeal.stream().collect(Collectors.summingDouble(Deal::getLastAmount));
                    for (CcsDeal deal : listDeal) {
                        repoAmt += deal.getLastQty() * deal.getLastPx();
                    }
                }
            }
            baseOrder.setDealCount(dealCount);
            baseOrder.setDealAmount(dealAmt);
            if (dealCount > 0) {
                int realDealCount = dealCount;
                if ("XSHG".equals(baseOrder.getMarket()) && "BOND".equals(baseOrder.getSecType())) {
                    realDealCount *= 10;
                } else if ("REPO".equals(baseOrder.getSecType())) {
                    dealAmt = repoAmt;
                }
                baseOrder.setAvgPrice(String.format("%.4f", dealAmt / (double)realDealCount));
            }
            double exe = 100.0 * (double)dealCount / (double)baseOrder.getCount();
            baseOrder.setExe(this.formatScale(exe, 2));
        }
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    public void summarizingDealsInst(List<AlgoBaseOrder> list) {
        String now = LocalDate.now().toString().replace("-", "");
        LinkedList<AlgoBaseOrder> listHis = new LinkedList<AlgoBaseOrder>();
        LinkedList<AlgoBaseOrder> listNow = new LinkedList<AlgoBaseOrder>((Collection<AlgoBaseOrder>)this.baseOrderList);
        listNow.addAll(this.miseList);
        for (AlgoBaseOrder algo : list) {
            if (now.equals(algo.getOrderDate())) {
                boolean flag = false;
                for (AlgoBaseOrder algoNow : listNow) {
                    if (!algoNow.getId().equals(algo.getId())) continue;
                    algo.update((Object)algoNow);
                    flag = true;
                    break;
                }
                if (flag) continue;
                listHis.add(algo);
                continue;
            }
            listHis.add(algo);
        }
        for (AlgoBaseOrder algo : listHis) {
            try {
                this.queryDealsSummarizing(algo);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public void queryDealsSummarizing(AlgoBaseOrder baseOrder) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setMarketGrp("CCS");
        page.setDimension("1");
        page.setBeginDate(baseOrder.getOrderDate());
        page.setEndDate(baseOrder.getOrderDate());
        String id = null;
        if (AlgoMiseMng.isMise(baseOrder.getType().getRaw())) {
            if (!baseOrder.isMiseSingleSecuirty()) {
                return;
            }
            id = baseOrder.getBaseId();
        } else {
            id = String.valueOf(baseOrder.getBaseId()) + "_" + baseOrder.getId();
        }
        page.setId(id);
        this.hisDealService.queryAlgoDeal((HisQueryPage<CcsDeal>)page);
        ObservableList list = page.getDataList();
        int dealCount = 0;
        double dealAmt = 0.0;
        dealCount = list.stream().collect(Collectors.summingDouble(Deal::getLastQty)).intValue();
        dealAmt = list.stream().collect(Collectors.summingDouble(Deal::getLastAmount));
        baseOrder.setDealCount(dealCount);
        baseOrder.setDealAmount(dealAmt);
        if (dealCount > 0) {
            int realDealCount = dealCount;
            if ("XSHG".equals(baseOrder.getMarket()) && "BOND".equals(baseOrder.getSecType())) {
                realDealCount *= 10;
            }
            baseOrder.setAvgPrice(String.format("%.4f", dealAmt / (double)realDealCount));
        }
        baseOrder.setExe((double)(100 * dealCount / baseOrder.getCount()));
    }

    public void cancelOrder(AlgoBaseOrder order) throws MException {
        if (Integer.parseInt(order.getType().getRaw()) == 18) {
            PStrategy.BaseOrderCancelReq.Builder builder = PStrategy.BaseOrderCancelReq.newBuilder();
            builder.setSysOrderId(order.getId());
            builder.setOpUser(this.iba.getOpUser());
            builder.setExecModeType(PField.ExecModeType.EXEC_MODE_TYPE_ALGOORDER);
            this.api.cancel(builder.build());
        } else {
            PAlgorithmTrade.AlgoBaseOrderCancel.Builder builder = PAlgorithmTrade.AlgoBaseOrderCancel.newBuilder();
            builder.setAlgoTypeValue(Integer.parseInt(order.getType().getRaw()));
            builder.setAlgoSysOrderId(order.getId());
            builder.setOpUser(this.iba.getOpUser());
            this.api.cancel(builder.build());
        }
        this.query();
    }

    public Algorithm getAlgorithm(Integer type) {
        Algorithm algo = this.algoFunc.getAlgorithm(type);
        if (algo != null) {
            return algo;
        }
        return new Algorithm(type.intValue(), "\u672a\u627e\u5230\u7b97\u6cd5\u540d\u79f0");
    }

    public synchronized void queryBaseOrder() throws MException {
        String today = this.format.format(new Date());
        List<String> listFund = this.accountMap.getExtAccList();
        List list = this.api.getBaseOrderList(today, today, listFund, false);
        ArrayList listF = new ArrayList();
        this.subAccMng.getFundAccounts().forEach(fund -> {
            boolean bl = listF.add(fund.getSubAccntId());
        });
        List listInfo = this.api.getBaseOrderList(today, today, listF, true);
        list.addAll(listInfo);
        this.updateBase(list, this.baseOrderList);
        this.summarizingDeals((List<AlgoBaseOrder>)this.baseOrderList);
        this.changed();
    }

    public synchronized List<AlgoBaseOrder> queryBaseOrder(Instruction instruction) throws MException {
        String instType;
        ObservableList orderList = FxUtils.newList();
        AlgoParam param = instruction.getAlgoParam();
        switch (instType = instruction.getType().getRaw()) {
            case "12": 
            case "13": 
            case "16": 
            case "17": {
                orderList.setAll(this.queryMiseByInst(instruction));
                break;
            }
            case "8": 
            case "9": {
                if (param != null && AlgoMiseMng.isMise(String.valueOf(param.getAlgoType()))) {
                    orderList.setAll(this.queryMiseByInst(instruction));
                    break;
                }
                orderList.setAll(this.queryApamaByInst(instruction, true));
                break;
            }
            case "2": 
            case "3": {
                if (!instruction.isCanModify()) break;
                orderList.setAll(this.queryMiseByInst(instruction));
                orderList.addAll(this.queryApamaByInst(instruction, false));
                break;
            }
            case "4": 
            case "5": {
                if (!instruction.isCanModify()) break;
                orderList.setAll(this.queryMiseByInst(instruction));
            }
        }
        return orderList;
    }

    private ObservableList<AlgoBaseOrder> queryApamaByInst(Instruction instruction, boolean isAlgo) throws MException {
        String end;
        ObservableList list = FxUtils.newList();
        ArrayList listFund = new ArrayList();
        boolean isPortf = !instruction.getPortfolioId().isEmpty();
        String begin = instruction.getBeginTime().substring(0, 8);
        String string = end = instruction.getEndTime().isEmpty() ? LocalDate.now().toString().replace("-", "") : instruction.getEndTime().substring(0, 8);
        if (isAlgo) {
            if (instruction.getAlgoParam() != null) {
                instruction.getAlgoParam().getAccSecInfoList().forEach(data -> {
                    boolean bl = listFund.add(data.getAccntId());
                });
            }
        } else if (instruction.getOrderAdvice() != null) {
            instruction.getOrderAdvice().getAccSecInfoList().forEach(data -> {
                boolean bl = listFund.add(data.getAccntId());
            });
        }
        List listResp = this.api.getBaseOrderList(begin, end, listFund, isPortf);
        this.updateBase(listResp, (ObservableList<AlgoBaseOrder>)list);
        return list;
    }

    private ObservableList<AlgoBaseOrder> queryMiseByInst(Instruction instruction) throws MException {
        boolean isPortf = !instruction.getPortfolioId().isEmpty();
        ObservableList list = FxUtils.newList();
        ArrayList<String> listFund = new ArrayList<String>();
        String instType = instruction.getType().getRaw();
        if (isPortf) {
            if ("13".equals(instType) || "5".equals(instType)) {
                List listAdvice = instruction.getBasketOrderAdvice().getItemList();
                listFund.addAll(listAdvice.stream().collect(Collectors.toMap(t -> t.getSubAccntId(), t -> t.getSubAccntId(), (key1, key2) -> key2)).keySet());
            } else if ("17".equals(instType)) {
                listFund.add(instruction.getAdjustPosAdvice().getInvestorId());
            } else {
                if (instruction.getAlgoParam() != null) {
                    instruction.getAlgoParam().getAccSecInfoList().forEach(data -> {
                        boolean bl = listFund.add(data.getAccntId());
                    });
                }
                if (instruction.getOrderAdvice() != null) {
                    instruction.getOrderAdvice().getAccSecInfoList().forEach(data -> {
                        boolean bl = listFund.add(data.getAccntId());
                    });
                }
            }
        } else if ("12".equals(instType) || "4".equals(instType)) {
            listFund.add(instruction.getBasketOrderAdvice().getInvestorId());
        } else if ("16".equals(instType)) {
            listFund.add(instruction.getAdjustPosAdvice().getInvestorId());
        } else {
            if (instruction.getAlgoParam() != null) {
                instruction.getAlgoParam().getAccSecInfoList().forEach(data -> {
                    boolean bl = listFund.add(data.getInvestorId());
                });
            }
            if (instruction.getOrderAdvice() != null) {
                instruction.getOrderAdvice().getAccSecInfoList().forEach(data -> {
                    boolean bl = listFund.add(data.getInvestorId());
                });
            }
        }
        String begin = instruction.getBeginTime().substring(0, 8);
        String end = instruction.getEndTime().isEmpty() ? LocalDate.now().toString().replace("-", "") : instruction.getEndTime().substring(0, 8);
        CopyOnWriteArrayList listEvent = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(listFund.size());
        for (String item : listFund) {
            this.exe.execute(() -> {
                try {
                    try {
                        listEvent.addAll(this.mise.queryAlgoMevent(item, begin, end));
                    }
                    catch (MException e) {
                        logger.error((Object)e, (Throwable)e);
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error((Object)e, (Throwable)e);
        }
        for (MEvent event : listEvent) {
            AlgoBaseOrder baseOrder = new AlgoBaseOrder();
            baseOrder.update((Object)event);
            list.add((Object)baseOrder);
        }
        return list;
    }

    public void getOrderDetails(AlgoBaseOrder abo) throws MException {
        if (abo.isParam()) {
            return;
        }
        if (AlgoMiseMng.isMise(abo.getType().getRaw())) {
            AlgoParam param = this.mise.queryMiseParamBasket(abo.getSubAcct(), "", "", abo.getBaseId());
            abo.getAlgoParam().update((Object)param);
            abo.setParam(true);
            return;
        }
        int type = Integer.parseInt(abo.getType().getRaw());
        if (type == 18) {
            PStrategy.BaseOrderInfo detail = this.api.getFollowUpOrderDetails(type, abo.getId());
            abo.getAlgoParam().update((Object)detail.getObject());
        } else {
            PAlgorithmTrade.BaseOrderInfomation detail = this.api.getOrderDetails(type, abo.getId());
            abo.getAlgoParam().update((Object)detail.getObject());
        }
        abo.setAlgorithm(this.getAlgorithm(Integer.valueOf(abo.getType().getRaw())));
        abo.setParam(true);
    }

    private void updateBase(List<PAlgorithmTrade.BaseOrderInfomation> listInfo, ObservableList<AlgoBaseOrder> list) {
        LinkedList<AlgoBaseOrder> data = new LinkedList<AlgoBaseOrder>();
        for (PAlgorithmTrade.BaseOrderInfomation info : listInfo) {
            AlgoBaseOrder abo = new AlgoBaseOrder();
            try {
                abo.update((Object)info);
                this.queryModel.afterUpdate(abo);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            abo.setAlgorithm(this.getAlgorithm(Integer.valueOf(abo.getType().getRaw())));
            data.add(abo);
        }
        list.setAll(data);
    }

    private void updateFollowUp(List<PStrategy.BaseOrderInfo> listInfo, ObservableList<AlgoBaseOrder> list) {
        LinkedList<AlgoBaseOrder> data = new LinkedList<AlgoBaseOrder>();
        for (PStrategy.BaseOrderInfo info : listInfo) {
            AlgoBaseOrder abo = new AlgoBaseOrder();
            abo.update((Object)info);
            abo.setAlgorithm(this.getAlgorithm(Integer.valueOf(abo.getType().getRaw())));
            data.add(abo);
        }
        list.addAll(data);
    }

    public ObservableList<AlgoBaseOrder> getOrderList() {
        return this.baseOrderList;
    }

    public List<AlgoBaseOrder> getMiseList() {
        return this.miseList;
    }
}

