/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.portfolio;

import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AlgoFuncControl {
    private Map<String, List<Algorithm>> regularAlgo = new HashMap<String, List<Algorithm>>();
    private Map<String, List<Algorithm>> regularZYAlgo = new HashMap<String, List<Algorithm>>();
    private Map<String, List<Algorithm>> portfolioAlgo = new HashMap<String, List<Algorithm>>();
    private Map<String, List<Algorithm>> portfolioRepoAlgo = new HashMap<String, List<Algorithm>>();
    private Map<String, List<Algorithm>> marginAlgo = new HashMap<String, List<Algorithm>>();
    private Map<String, List<Algorithm>> regularHkwolunAlgo = new HashMap<String, List<Algorithm>>();
    private Map<String, List<Algorithm>> portfolioHkwolunAlgo = new HashMap<String, List<Algorithm>>();
    private ObservableList<MxNode> regularBasketAlgo = FxUtils.newList();
    private ObservableList<MxNode> portfolioBasketAlgo = FxUtils.newList();
    private ObservableList<MxNode> personalAlgo = FxUtils.newList();
    private Map<Integer, Algorithm> mapAlgo = new HashMap<Integer, Algorithm>();
    private volatile boolean init = false;
    @Inject
    private IUiRightService right;

    private void initAlgo() {
        this.checkAdd("cms.tmx.instructions.part.regular_apama.twap", this.regularAlgo, 5, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_apama.vwap", this.regularAlgo, 6, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_apama.intertrade", this.regularAlgo, 7, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_apama.buy", this.regularAlgo, 10, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_apama.sell", this.regularAlgo, 11, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_apama.limittwap", this.regularAlgo, 12, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_apama.limitvwap", this.regularAlgo, 13, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_other.smartlimit", this.regularAlgo, 18, "\u5176\u4ed6\u7b97\u6cd5");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.mtwap", this.regularAlgo, 15, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.mvwap", this.regularAlgo, 16, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.limittwap", this.regularAlgo, 19, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.limitvwap", this.regularAlgo, 20, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.mpov", this.regularAlgo, 21, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.miceberg", this.regularAlgo, 22, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular_mise.limitpov", this.regularAlgo, 23, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.hkwolun.regular_mise.mtwap", this.regularHkwolunAlgo, 15, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.hkwolun.regular_mise.limittwap", this.regularHkwolunAlgo, 19, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.twap", this.regularZYAlgo, 5, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.vwap", this.regularZYAlgo, 6, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.intertrade", this.regularZYAlgo, 7, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.buy", this.regularZYAlgo, 10, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.sell", this.regularZYAlgo, 11, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.limittwap", this.regularZYAlgo, 12, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_apama.limitvwap", this.regularZYAlgo, 13, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_other.smartlimit", this.regularZYAlgo, 18, "\u5176\u4ed6\u7b97\u6cd5");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_mise.mtwap", this.regularZYAlgo, 15, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_mise.mvwap", this.regularZYAlgo, 16, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_mise.limittwap", this.regularZYAlgo, 19, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_mise.limitvwap", this.regularZYAlgo, 20, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_mise.mpov", this.regularZYAlgo, 21, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.regular.zy_mise.miceberg", this.regularZYAlgo, 22, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.twap", this.portfolioAlgo, 5, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.vwap", this.portfolioAlgo, 6, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.intertrade", this.portfolioAlgo, 7, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.buy", this.portfolioAlgo, 10, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.sell", this.portfolioAlgo, 11, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.limittwap", this.portfolioAlgo, 12, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_apama.limitvwap", this.portfolioAlgo, 13, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_other.smartlimit", this.portfolioAlgo, 18, "\u5176\u4ed6\u7b97\u6cd5");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.mtwap", this.portfolioAlgo, 15, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.mvwap", this.portfolioAlgo, 16, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.limittwap", this.portfolioAlgo, 19, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.limitvwap", this.portfolioAlgo, 20, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.mpov", this.portfolioAlgo, 21, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.miceberg", this.portfolioAlgo, 22, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.limitpov", this.portfolioAlgo, 23, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.hkwolun_mise.mtwap", this.portfolioHkwolunAlgo, 15, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.hkwolun_mise.limittwap", this.portfolioHkwolunAlgo, 19, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.twap", this.portfolioRepoAlgo, 5, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.vwap", this.portfolioRepoAlgo, 6, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.intertrade", this.portfolioRepoAlgo, 7, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.buy", this.portfolioRepoAlgo, 10, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.sell", this.portfolioRepoAlgo, 11, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.limittwap", this.portfolioRepoAlgo, 12, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_apama.limitvwap", this.portfolioRepoAlgo, 13, "Apama\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_other.smartlimit", this.portfolioRepoAlgo, 18, "\u5176\u4ed6\u7b97\u6cd5");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_mise.mtwap", this.portfolioRepoAlgo, 15, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_mise.mvwap", this.portfolioRepoAlgo, 16, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio.repo_mise.limittwap", this.portfolioRepoAlgo, 19, "Mise\u5f15\u64ce");
        this.checkAdd("cms.tmx.instructions.part.portfolio_mise.limitvwap", this.portfolioRepoAlgo, 20, "Mise\u5f15\u64ce");
        this.checkAddBasket("cms.tmx.instructions.part.basket_mise.mdef", (List<MxNode>)this.regularBasketAlgo, 14);
        this.checkAddBasket("cms.tmx.instructions.part.basket_mise.mtwap", (List<MxNode>)this.regularBasketAlgo, 15);
        this.checkAddBasket("cms.tmx.instructions.part.basket_mise.mvwap", (List<MxNode>)this.regularBasketAlgo, 16);
        this.checkAddBasket("cms.tmx.instructions.part.basket_mise.limittwap", (List<MxNode>)this.regularBasketAlgo, 19);
        this.checkAddBasket("cms.tmx.instructions.part.basket_mise.limitvwap", (List<MxNode>)this.regularBasketAlgo, 20);
        this.checkAddBasket("cms.tmx.instructions.part.portfolio.basket_mise.mdef", (List<MxNode>)this.portfolioBasketAlgo, 14);
        this.checkAddBasket("cms.tmx.instructions.part.portfolio.basket_mise.mtwap", (List<MxNode>)this.portfolioBasketAlgo, 15);
        this.checkAddBasket("cms.tmx.instructions.part.portfolio.basket_mise.mvwap", (List<MxNode>)this.portfolioBasketAlgo, 16);
        this.checkAddBasket("cms.tmx.instructions.part.portfolio.basket_mise.limittwap", (List<MxNode>)this.portfolioBasketAlgo, 19);
        this.checkAddBasket("cms.tmx.instructions.part.portfolio.basket_mise.limitvwap", (List<MxNode>)this.portfolioBasketAlgo, 20);
        this.checkAdd("cms.tmx.metrics.algo_satib", (List<MxNode>)this.personalAlgo, "StarMarketTrade");
        this.checkAdd("cms.tmx.metrics.algo_grid", (List<MxNode>)this.personalAlgo, "GridTrading");
        this.checkAdd("cms.tmx.margin.trade.regular_mise.marstag", this.marginAlgo, 24, "Mise\u5f15\u64ce");
    }

    private void checkAdd(String id, List<MxNode> list, String type) {
        MxNode node = MxNodeFactory.create((String)"algo_name", (String)type);
        boolean authority = this.right.registerCheck(new String[]{id});
        if (authority) {
            list.add(node);
        }
    }

    private void checkAdd(String id, Map<String, List<Algorithm>> map, int type, String engine) {
        MxNode node = MxNodeFactory.create((String)"algo_name", (String)this.getRaw(type));
        boolean authority = this.right.registerCheck(new String[]{id});
        Algorithm algo = this.mapAlgo.get(type);
        if (algo == null) {
            algo = new Algorithm(type, node.getValue());
            this.mapAlgo.put(type, algo);
        }
        if (authority) {
            List<Algorithm> list = map.get(engine);
            if (list == null) {
                list = new LinkedList<Algorithm>();
                map.put(engine, list);
            }
            list.add(algo);
        }
    }

    private void checkAddBasket(String id, List<MxNode> list, int type) {
        MxNode node = MxNodeFactory.create((String)"algo_name", (String)String.valueOf(type));
        boolean authority = this.right.registerCheck(new String[]{id});
        Algorithm algo = this.mapAlgo.get(type);
        if (algo == null) {
            algo = new Algorithm(type, node.getValue());
            this.mapAlgo.put(type, algo);
        }
        if (authority) {
            list.add(node);
        }
    }

    public List<Algorithm> getRegularAlgo(String engine, Boolean isBuy) {
        this.checkInitAlgo();
        LinkedList<Algorithm> list = new LinkedList<Algorithm>();
        if (this.regularAlgo.get(engine) != null) {
            list.addAll((Collection)this.regularAlgo.get(engine));
        }
        if ("Apama\u5f15\u64ce".equals(engine)) {
            int skipType = isBuy == null ? -1 : (isBuy != false ? 11 : 10);
            Algorithm cancel = this.mapAlgo.get(skipType);
            list.remove(cancel);
        }
        list.sort((o1, o2) -> o1.getType() - o2.getType());
        return list;
    }

    public List<Algorithm> getRegularZYAlgo(String engine, Boolean isBuy) {
        this.checkInitAlgo();
        LinkedList<Algorithm> list = new LinkedList<Algorithm>();
        if (this.regularZYAlgo.get(engine) != null) {
            list.addAll((Collection)this.regularZYAlgo.get(engine));
        }
        if ("Apama\u5f15\u64ce".equals(engine)) {
            int skipType = isBuy == null ? -1 : (isBuy != false ? 11 : 10);
            Algorithm cancel = this.mapAlgo.get(skipType);
            list.remove(cancel);
        }
        list.sort((o1, o2) -> o1.getType() - o2.getType());
        return list;
    }

    public List<Algorithm> getPortfolioAlgo(String engine, Boolean isBuy) {
        this.checkInitAlgo();
        LinkedList<Algorithm> list = new LinkedList<Algorithm>();
        if (this.portfolioAlgo.get(engine) != null) {
            list.addAll((Collection)this.portfolioAlgo.get(engine));
        }
        if ("Apama\u5f15\u64ce".equals(engine)) {
            int skipType = isBuy == null ? -1 : (isBuy != false ? 11 : 10);
            Algorithm cancel = this.mapAlgo.get(skipType);
            list.remove(cancel);
        }
        list.sort((o1, o2) -> o1.getType() - o2.getType());
        return list;
    }

    public List<Algorithm> getPortfolioRepoAlgo(String engine, Boolean isBuy) {
        this.checkInitAlgo();
        LinkedList<Algorithm> list = new LinkedList<Algorithm>();
        if (this.portfolioRepoAlgo.get(engine) != null) {
            list.addAll((Collection)this.portfolioRepoAlgo.get(engine));
        }
        if ("Apama\u5f15\u64ce".equals(engine)) {
            int skipType = isBuy == null ? -1 : (isBuy != false ? 11 : 10);
            Algorithm cancel = this.mapAlgo.get(skipType);
            list.remove(cancel);
        }
        list.sort((o1, o2) -> o1.getType() - o2.getType());
        return list;
    }

    public List<Algorithm> getRegularHkwolunAlgo(String engine, Boolean isBuy) {
        this.checkInitAlgo();
        LinkedList<Algorithm> list = new LinkedList<Algorithm>();
        if (this.regularHkwolunAlgo.get(engine) != null) {
            list.addAll((Collection)this.regularHkwolunAlgo.get(engine));
        }
        if ("Apama\u5f15\u64ce".equals(engine)) {
            int skipType = isBuy == null ? -1 : (isBuy != false ? 11 : 10);
            Algorithm cancel = this.mapAlgo.get(skipType);
            list.remove(cancel);
        }
        list.sort((o1, o2) -> o1.getType() - o2.getType());
        return list;
    }

    public List<Algorithm> getPortfolioHkwolunAlgo(String engine, Boolean isBuy) {
        this.checkInitAlgo();
        LinkedList<Algorithm> list = new LinkedList<Algorithm>();
        if (this.portfolioHkwolunAlgo.get(engine) != null) {
            list.addAll((Collection)this.portfolioHkwolunAlgo.get(engine));
        }
        if ("Apama\u5f15\u64ce".equals(engine)) {
            int skipType = isBuy == null ? -1 : (isBuy != false ? 11 : 10);
            Algorithm cancel = this.mapAlgo.get(skipType);
            list.remove(cancel);
        }
        list.sort((o1, o2) -> o1.getType() - o2.getType());
        return list;
    }

    public ObservableList<MxNode> getRegularBasketAlgo() {
        this.checkInitAlgo();
        return this.regularBasketAlgo;
    }

    public ObservableList<MxNode> getPortfolioBasketAlgo() {
        this.checkInitAlgo();
        return this.portfolioBasketAlgo;
    }

    public List<MxNode> getPersonalAlgo() {
        this.checkInitAlgo();
        return this.personalAlgo;
    }

    public Algorithm getAlgorithm(int type) {
        this.checkInitAlgo();
        return this.mapAlgo.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitAlgo() {
        AlgoFuncControl algoFuncControl = this;
        synchronized (algoFuncControl) {
            if (!this.init) {
                this.init = true;
                this.initAlgo();
            }
        }
    }

    private String getRaw(int type) {
        if (type == 15 || type == 16 || type == 19 || type == 20) {
            return String.valueOf(type * 10);
        }
        return String.valueOf(type);
    }
}

