/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.block;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IBlockTradeApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.notice.TradeCaptureReport;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.BlockQueryMng;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.utils.QueryModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class BlockUnfinishedModel
extends MxModel {
    private MxList<BlockOrder> mlist = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    @Inject
    private BlockQueryMng queryMng;
    @Inject
    private IBlockTradeApi tradeApi;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected IFundAccountService faccService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    private QueryModel queryMd;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    private void onPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof TradeCaptureReport)) {
            return;
        }
        TradeCaptureReport report = (TradeCaptureReport)TradeCaptureReport.class.cast(obj);
        String type = String.valueOf(report.getType());
        BlockOrder order = new BlockOrder();
        order.update(report.getReport());
        this.queryMd.afterUpdate(order);
        if (!this.careReport(type)) {
            this.mlist.remove((MxObject)order);
            this.changed();
            return;
        }
        LinkedList<BlockOrder> list = new LinkedList<BlockOrder>();
        list.add(order);
        this.updateDirty(list);
        this.logger.debug("block order push unfinished->  orderId:" + order.getOrderId() + " execType:" + type);
    }

    protected void updateDirty(List<BlockOrder> listOrder) {
        this.mlist.updatePart(listOrder);
        this.changed();
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("order query failed", e);
            }
        });
    }

    public void fullQuery() throws MException {
        this.faccService.getFundAccountList("CCS");
        Set<CcsFundAccount> funds = this.getActiveAccMap("0");
        List<FundAccount> activeFunds = funds.stream().filter(item -> !item.getStatus().getRaw().equals("3")).collect(Collectors.toList());
        ArrayList<BlockOrder> listResp = new ArrayList<BlockOrder>();
        if (!activeFunds.isEmpty()) {
            listResp.addAll(this.queryMng.queryUnfinished(activeFunds, null));
            this.logger.debug("block query unfinish size:" + listResp.size());
        } else {
            this.logger.info("\u5f53\u524d\u8d26\u6237\u672a\u5173\u8054\u8d44\u91d1\u8d26\u53f7 block query unfinish size:" + listResp.size());
        }
        this.mlist.setAll(listResp);
        this.changed();
    }

    public String cancel(List<BlockOrder> list) {
        PPostTrade.TradeCaptureReport.Builder tradeBuilder = PPostTrade.TradeCaptureReport.newBuilder();
        tradeBuilder.setOpUser(this.baseApi.getOpUser());
        tradeBuilder.setTradeReportType(PField.TradeReportType.TRADE_REPORT_TYPE_CANCEL);
        Result result = new Result();
        for (BlockOrder order : list) {
            tradeBuilder.setTradeReportId(order.getSysOrderId());
            PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
            inst.setSecurityId(order.getInstrument().getSecId());
            inst.setSecurityType(order.getInstrument().getSecType());
            inst.setMarket(order.getInstrument().getMarket().getRaw());
            inst.setMarketGroup("CCS");
            tradeBuilder.setInstrument(inst);
            try {
                this.tradeApi.submitOrder(tradeBuilder.build());
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                this.logger.error("============== block cancel:" + e.getMessage(), (Throwable)e);
            }
        }
        return result.getDesc("\u64a4\u5355");
    }

    public List<BlockOrder> getList() {
        return this.mlist.getList();
    }

    protected boolean careReport(String type) {
        return !type.equals("3") && !type.equals("5") && !type.equals("6") && !type.equals("7");
    }

    public void cancelInstruction(Instruction instruction) throws MException {
        ArrayList<FundAccount> funds = new ArrayList<FundAccount>();
        FundAccount fund = new FundAccount();
        fund.setExtAccntId(instruction.getTrdCtrRptAdvice().getExtAccntId());
        funds.add(fund);
        List<BlockOrder> orders = this.queryMng.queryUnfinished(funds, instruction);
        this.cancel(orders);
    }

    public Set<CcsFundAccount> getActiveAccMap(String instructionPanelType) {
        if (this.instrAccModel.getActiveAccMap(instructionPanelType) != null) {
            return this.instrAccModel.getActiveAccMap(instructionPanelType).keySet();
        }
        return new HashSet<CcsFundAccount>();
    }
}

