/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.block;

import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.notice.TradeCaptureReport;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.BlockQueryMng;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.utils.QueryModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class BlockOrderModel
extends MxModel {
    protected MxList<BlockOrder> mlist = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    @Inject
    protected BlockQueryMng queryMng;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected IFundAccountService faccService;
    @Inject
    private MEventService es;
    @Inject
    private QueryModel queryMd;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    protected void onPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof TradeCaptureReport)) {
            return;
        }
        TradeCaptureReport report = (TradeCaptureReport)TradeCaptureReport.class.cast(obj);
        String type = String.valueOf(report.getType());
        BlockOrder order = new BlockOrder();
        order.update(report.getReport());
        this.queryMd.afterUpdate(order);
        LinkedList<BlockOrder> list = new LinkedList<BlockOrder>();
        list.add(order);
        this.updateDirty(list);
        this.logger.debug("block order push order->  orderId:" + order.getOrderId() + " execType:" + type);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("order query failed", e);
            }
        });
    }

    public void fullQuery() throws MException {
        this.faccService.getFundAccountList("CCS");
        Set<CcsFundAccount> funds = this.getActiveAccMap("0");
        List<FundAccount> activeFunds = funds.stream().filter(item -> !item.getStatus().getRaw().equals("3")).collect(Collectors.toList());
        ArrayList<BlockOrder> listResp = new ArrayList<BlockOrder>();
        if (!activeFunds.isEmpty()) {
            listResp.addAll(this.queryMng.queryOrder(activeFunds, null));
            this.logger.debug("block query order size:" + listResp.size());
        } else {
            this.logger.info("\u5f53\u524d\u8d26\u6237\u672a\u5173\u8054\u8d44\u91d1\u8d26\u53f7 block query order size:" + listResp.size());
        }
        this.mlist.setAll(listResp);
        this.changed();
    }

    public void query(HisQueryPage<BlockOrder> queryPage) throws MException {
        List<BlockOrder> listInfo = this.queryMng.queryHisOrders((IHisQueryPageInfo<BlockOrder>)queryPage);
        queryPage.updateData(listInfo);
    }

    public List<BlockOrder> getList() {
        return this.mlist.getList();
    }

    protected void updateDirty(List<BlockOrder> listOrder) {
        this.mlist.updatePart(listOrder);
        this.changed();
    }

    public HisQueryPage<BlockOrder> getAllBlockData(HisQueryPage<BlockOrder> pageBlck) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageBlck.getBeginDate());
        page.setEndDate(pageBlck.getEndDate());
        page.setExtAccntIdList(pageBlck.getExtAccntIdList());
        page.setMarketGrp(pageBlck.getMarketGrp());
        page.setDimension(pageBlck.getDimension());
        page.setSecurityId(pageBlck.getSecurityId());
        this.query((HisQueryPage<BlockOrder>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<BlockOrder>)page);
        }
        return page;
    }

    public Set<CcsFundAccount> getActiveAccMap(String instructionPanelType) {
        if (this.instrAccModel.getActiveAccMap(instructionPanelType) != null) {
            return this.instrAccModel.getActiveAccMap(instructionPanelType).keySet();
        }
        return new HashSet<CcsFundAccount>();
    }
}

