/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.block;

import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.notice.TradeCaptureReport;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.DealSum;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.BlockQueryMng;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.utils.QueryModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class BlockDealModel
extends MxModel {
    private MxList<BlockDeal> mlist = new MxList();
    protected List<DealSum> listSum = new LinkedList<DealSum>();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    @Inject
    private BlockQueryMng queryMng;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected IFundAccountService faccService;
    @Inject
    private MEventService es;
    @Inject
    private QueryModel queryMd;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    private void onPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof TradeCaptureReport)) {
            return;
        }
        TradeCaptureReport report = (TradeCaptureReport)TradeCaptureReport.class.cast(obj);
        String type = String.valueOf(report.getType());
        if (!this.careReport(type)) {
            return;
        }
        BlockDeal order = new BlockDeal();
        order.update(report.getReport());
        this.queryMd.afterUpdate(order);
        LinkedList<BlockDeal> list = new LinkedList<BlockDeal>();
        list.add(order);
        this.updateDirty(list);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("order query failed", e);
            }
        });
    }

    public void fullQuery() throws MException {
        this.faccService.getFundAccountList("CCS");
        Set<CcsFundAccount> funds = this.getActiveAccMap("0");
        List<FundAccount> activeFunds = funds.stream().filter(item -> !item.getStatus().getRaw().equals("3")).collect(Collectors.toList());
        ArrayList<BlockDeal> listResp = new ArrayList<BlockDeal>();
        if (!activeFunds.isEmpty()) {
            listResp.addAll(this.queryMng.queryDeal(activeFunds, null));
            this.logger.debug("block query deal size:" + listResp.size());
        } else {
            this.logger.info("\u5f53\u524d\u8d26\u6237\u672a\u5173\u8054\u8d44\u91d1\u8d26\u53f7 block query deal size:" + listResp.size());
        }
        this.mlist.setAll(listResp);
        this.statistics(listResp);
        this.changed();
    }

    public void query(HisQueryPage<BlockDeal> queryPage) throws MException {
        List<BlockDeal> listInfo = this.queryMng.queryHisDeals((IHisQueryPageInfo<BlockDeal>)queryPage);
        queryPage.updateData(listInfo);
    }

    public List<BlockDeal> getList() {
        return this.mlist.getList();
    }

    public List<DealSum> getListSum() {
        return this.listSum;
    }

    protected void statistics(List<BlockDeal> newList) {
        HashMap<String, DealSum> map = new HashMap<String, DealSum>();
        LinkedList<DealSum> list = new LinkedList<DealSum>();
        int i = 0;
        while (i < newList.size()) {
            DealSum sum;
            BlockDeal deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                sum = new DealSum();
                sum.update(deal);
                map.put(key, sum);
            } else {
                sum = (DealSum)map.get(key);
                long qty = deal.getDealQty();
                double amount = deal.getDealAmount();
                long sumQty = sum.getDealQty();
                double sumAmount = sum.getDealAmount();
                sum.setDealQty(sumQty + qty);
                sum.setDealAmount(sumAmount + amount);
                sum.setDealCount(sum.getDealCount() + 1L);
            }
            ++i;
        }
        for (DealSum sum : map.values()) {
            double avgPx;
            Instrument inst = sum.getInstrument();
            String market = inst.getMarket().getRaw();
            String type = inst.getSecType();
            if ("XSHG".equals(market) && "BOND".equals(type)) {
                avgPx = sum.getDealAmount() / 10.0 / (double)sum.getDealQty();
                sum.setAvgPx(this.convert(avgPx, 4));
            } else {
                avgPx = sum.getDealAmount() / (double)sum.getDealQty();
                sum.setAvgPx(this.convert(avgPx, 4));
            }
            sum.setDealAmount(this.convert(sum.getDealAmount(), 2));
        }
        list.addAll(map.values());
        this.listSum = list;
    }

    private double convert(double avgPx, int scale) {
        BigDecimal big = new BigDecimal(avgPx);
        double decimal = big.setScale(scale, 4).doubleValue();
        return decimal;
    }

    protected String getKey(BlockDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getInstrument().getSecId() + deal.getSide().getRaw();
        return key;
    }

    protected void updateDirty(List<BlockDeal> listOrder) {
        this.mlist.updatePart(listOrder);
        this.statistics((List<BlockDeal>)this.mlist.getList());
        this.changed();
    }

    protected boolean careReport(String type) {
        return type.equals("7");
    }

    public HisQueryPage<BlockDeal> getAllBlockData(HisQueryPage<BlockDeal> pageBlock) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageBlock.getBeginDate());
        page.setEndDate(pageBlock.getEndDate());
        page.setExtAccntIdList(pageBlock.getExtAccntIdList());
        page.setMarketGrp(pageBlock.getMarketGrp());
        page.setDimension(pageBlock.getDimension());
        page.setSecurityId(pageBlock.getSecurityId());
        this.query((HisQueryPage<BlockDeal>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<BlockDeal>)page);
        }
        return page;
    }

    public Set<CcsFundAccount> getActiveAccMap(String instructionPanelType) {
        if (this.instrAccModel.getActiveAccMap(instructionPanelType) != null) {
            return this.instrAccModel.getActiveAccMap(instructionPanelType).keySet();
        }
        return new HashSet<CcsFundAccount>();
    }
}

