/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.basket;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.basket.BasketCcsOrderModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfBasketCcsOrderModel
extends BasketCcsOrderModel {
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    @Inject
    protected MObjFactory of;
    @Inject
    private PortfolioAccountModel portfAccntModel;

    @Override
    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)"handicap", (String)"0");
        this.initPriceType(node);
        this.setPriceType(node);
    }

    @Override
    public void query() throws MException {
        this.map.clear();
        this.pageList.clear();
        List listOrderList = this.queryModel.queryOrders(null, this.getSubAccntIds());
        for (POrderService.ListOrder listOrder : listOrderList) {
            BasketCcsOrder batchOrder = this.bskOrderFactory.create();
            batchOrder.update(listOrder);
            this.transferBatchField(batchOrder);
            List<BasketCcsOrder> orderList = this.queryLegOrders(batchOrder, listOrder.getListId(), null);
            this.calBatchInfo(batchOrder, orderList);
            this.map.put(batchOrder, Collections.synchronizedList(orderList));
        }
        if (this.count.intValue() == 0) {
            Platform.runLater(() -> this.changed());
        } else {
            this.clearPageList();
        }
    }

    public List<BasketCcsOrder> queryBatchOrders() throws MException {
        LinkedList<BasketCcsOrder> batchOrderList = new LinkedList<BasketCcsOrder>();
        List listOrderList = this.queryModel.queryOrders(null, this.getSubAccntIds());
        for (POrderService.ListOrder listOrder : listOrderList) {
            if (StringUtils.isEmpty((String)listOrder.getPortfolioId())) continue;
            BasketCcsOrder batchOrder = this.bskOrderFactory.create();
            batchOrder.update(listOrder);
            this.transferBatchField(batchOrder);
            batchOrderList.add(batchOrder);
        }
        return batchOrderList;
    }

    private List<String> getSubAccntIds() {
        LinkedList<String> subAccntIds = new LinkedList<String>();
        this.portfAccntModel.getFundAccounts().forEach(subAccnt -> subAccntIds.add(subAccnt.getSubAccntId()));
        return subAccntIds;
    }

    @Override
    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    @Override
    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    @Override
    public StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    @Override
    public String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    @Override
    public StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    @Override
    public String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }
}

