/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.basket;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.factory.BasketCcsOrderFactory;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.ListStatusReport;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.mng.InstructionMng;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.basket.BasketCcsOrderModel;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketTaskModel
extends MxModel {
    protected static final Logger logger = LogManager.getLogger(BasketTaskModel.class);
    @Inject
    protected BasketCcsOrderFactory bskOrderFactory;
    @Inject
    private BasketCcsOrderModel orderModel;
    @Inject
    protected MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    protected boolean firstUpdate = true;
    protected TreeItem<BasketCcsOrder> root = new TreeItem();
    protected List<String> newList = new ArrayList<String>();
    protected MxTreeList<BasketCcsOrder> batchItemMxList;
    @Inject
    private InstructionMng instructionMng;
    @Inject
    protected ScheduledExecutorService ses;
    protected Map<BasketCcsOrder, MxTreeList<BasketCcsOrder>> orderItemsMxListMap = new ConcurrentHashMap<BasketCcsOrder, MxTreeList<BasketCcsOrder>>();
    private MEventHandler hPush = event -> this.onPush(event);
    private MEventHandler hSubmit = event -> this.submit(event);
    private InvalidationListener lstnOrderModel = ob -> this.updateTreeTable();

    @PostConstruct
    public void init() {
        this.sdSpecQuery.setInterval(2000);
        this.es.subscribe("server.sub", this.hPush);
        this.es.subscribe("basket.submit", this.hSubmit);
        this.calculate();
        this.getOrderModel().changedProperty().addListener(this.lstnOrderModel);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 180L, TimeUnit.SECONDS);
        });
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("server.sub", this.hPush);
        this.es.unSubscribe("basket.submit", this.hSubmit);
        this.getOrderModel().changedProperty().removeListener(this.lstnOrderModel);
    }

    protected void submit(MEvent event) {
        String listId = event.getStr("listId");
        if (event.getBool("isPortfolio")) {
            return;
        }
        this.addNewBatchOrder(listId);
        this.changed();
    }

    private synchronized void updateTreeTable() {
        this.updateRoot(this.getOrderModel().getMap());
        this.firstUpdate = false;
    }

    protected synchronized void onPush(MEvent event) {
        if (event.getObj() == null) {
            return;
        }
        if (event.getObj() instanceof ExecutionReport) {
            this.onLegOrderPush(event);
        } else if (event.getObj() instanceof ListStatusReport) {
            this.onListOrderPush(event);
        } else if (event.getObj() instanceof CancelRejectReport) {
            this.onOrderCancelPush(event);
        }
    }

    private void onOrderCancelPush(MEvent event) {
        CancelRejectReport orderCancelReject = (CancelRejectReport)CancelRejectReport.class.cast(event.getObj());
        if (!StringUtils.isEmpty((String)orderCancelReject.getReport().getClOrdLinkId()) && !StringUtils.isEmpty((String)orderCancelReject.getReport().getListId())) {
            String orderListId = orderCancelReject.getReport().getListId();
            String orderLegId = orderCancelReject.getReport().getClOrdLinkId();
            String ordDate = orderCancelReject.getReport().getTradeDate();
            BasketCcsOrder basketCcsOrder = this.bskOrderFactory.create();
            basketCcsOrder.setListId(orderListId);
            basketCcsOrder.setBatchId(orderListId);
            basketCcsOrder.setOrdDate(ordDate);
            this.getOrderModel().addToBeQuery(basketCcsOrder, orderLegId);
            this.runSpecQuery();
        }
    }

    private synchronized void onLegOrderPush(MEvent event) {
        ExecutionReport executionReport = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        logger.info("\u6536\u5230\u7bee\u5b50\u63a8\u9001: ListId=" + executionReport.getReport().getListId() + " | legId=" + executionReport.getReport().getClOrdLinkId());
        if (!StringUtils.isEmpty((String)executionReport.getReport().getClOrdLinkId()) && !StringUtils.isEmpty((String)executionReport.getReport().getListId()) && this.batchItemMxList != null) {
            String orderListId = executionReport.getReport().getListId();
            String orderLegId = executionReport.getReport().getClOrdLinkId();
            String ordDate = executionReport.getReport().getTradeDate();
            BasketCcsOrder basketCcsOrder = this.bskOrderFactory.create();
            basketCcsOrder.setListId(orderListId);
            basketCcsOrder.setBatchId(orderListId);
            basketCcsOrder.setOrdDate(ordDate);
            if (!this.orderItemsMxListMap.containsKey(basketCcsOrder) && !this.firstUpdate) {
                this.addNewBatchOrder(orderListId);
            }
            this.getOrderModel().addToBeQuery(basketCcsOrder, orderLegId);
            this.runSpecQuery();
        }
    }

    protected synchronized void addNewBatchOrder(String listId) {
        if (this.newList.contains(listId)) {
            return;
        }
        this.newList.add(listId);
        try {
            BasketCcsOrder queryOrder = this.getOrderModel().queryOrder(listId);
            if (queryOrder == null || this.batchItemMxList == null) {
                return;
            }
            List<BasketCcsOrder> queryLegOrders = this.getOrderModel().queryLegOrders(listId, null);
            this.batchItemMxList.take((MxObject)queryOrder);
            for (TreeItem batchItem : this.root.getChildren()) {
                if (!listId.equals(((BasketCcsOrder)batchItem.getValue()).getListId())) continue;
                Platform.runLater(() -> {
                    double orderAmt = 0.0;
                    long orderQty = 0L;
                    MxTreeList orderMxList = new MxTreeList(batchItem, batchItem.getChildren(), new LinkedList(queryLegOrders));
                    for (BasketCcsOrder legOrderItem : queryLegOrders) {
                        orderAmt += legOrderItem.getOrderAmount();
                        orderQty += legOrderItem.getOrderQty();
                    }
                    ((BasketCcsOrder)batchItem.getValue()).setOrderAmount(orderAmt);
                    ((BasketCcsOrder)batchItem.getValue()).setOrderQty(orderQty);
                    this.onNodeStatusChange((BasketCcsOrder)batchItem.getValue(), ((BasketCcsOrder)batchItem.getValue()).getBatchStatus().getRaw());
                    for (TreeItem subItem : batchItem.getChildren()) {
                        this.onLeafNodeStatusChange((BasketCcsOrder)subItem.getValue(), ((BasketCcsOrder)subItem.getValue()).getOrdStatus().getRaw());
                        ((BasketCcsOrder)subItem.getValue()).ordStatusProperty().addListener((ob, oldV, newV) -> this.onLeafNodeStatusChange((BasketCcsOrder)subItem.getValue(), newV.getRaw()));
                    }
                    this.orderItemsMxListMap.put(queryOrder, (MxTreeList<BasketCcsOrder>)orderMxList);
                });
            }
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u7bee\u5b50\u6279\u91cf\u5355\u5931\u8d25" + e.getMessage());
        }
    }

    private void onListOrderPush(MEvent event) {
        ListStatusReport listStatus = (ListStatusReport)ListStatusReport.class.cast(event.getObj());
        String listId = listStatus.getReport().getListId();
        if (this.batchItemMxList == null) {
            return;
        }
        this.batchItemMxList.getObList().forEach(item -> {
            if (((BasketCcsOrder)item.getValue()).getListId().equals(listId)) {
                ((BasketCcsOrder)item.getValue()).setBatchStatusRaw(Integer.toString(listStatus.getReport().getStatusValue()));
                this.onNodeStatusChange((BasketCcsOrder)item.getValue(), ((BasketCcsOrder)item.getValue()).getBatchStatus().getRaw());
                return;
            }
        });
        this.changed();
    }

    public TreeItem<BasketCcsOrder> getTree() {
        this.query();
        Map<BasketCcsOrder, List<BasketCcsOrder>> orderMap = this.getOrderModel().getMap();
        return this.createTree(orderMap);
    }

    public synchronized void updateRoot(Map<BasketCcsOrder, List<BasketCcsOrder>> orderMap) {
        this.orderItemsMxListMap.clear();
        this.batchItemMxList = new MxTreeList(this.root, this.root.getChildren(), new LinkedList<BasketCcsOrder>(orderMap.keySet()));
        for (TreeItem batchItem : this.batchItemMxList.getObList()) {
            if (orderMap.get(batchItem.getValue()) != null) {
                MxTreeList orderMxList = new MxTreeList(batchItem, batchItem.getChildren(), new LinkedList(orderMap.get(batchItem.getValue())));
                this.orderItemsMxListMap.put((BasketCcsOrder)batchItem.getValue(), (MxTreeList<BasketCcsOrder>)orderMxList);
            }
            this.reCalBatchInfo(((BasketCcsOrder)batchItem.getValue()).getListId());
        }
        this.calculate();
    }

    protected TreeItem<BasketCcsOrder> createTree(Map<BasketCcsOrder, List<BasketCcsOrder>> mapOrder) {
        BasketCcsOrder rootOrder = this.bskOrderFactory.create();
        rootOrder.setBatchId("");
        this.root.setValue((Object)rootOrder);
        return this.root;
    }

    public TreeItem<BasketCcsOrder> getRoot() {
        return this.root;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("basket order query failed", (Throwable)e);
            }
        });
    }

    protected void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException e) {
                logger.error("basket order query failed", (Throwable)e);
            }
        });
    }

    protected void specQuery() throws MException {
        Map<BasketCcsOrder, List<BasketCcsOrder>> mapQuery = null;
        try {
            mapQuery = this.getOrderModel().queryToBeQuery();
        }
        catch (MException e) {
            logger.error("query fund account order failed: ", (Throwable)e);
        }
        if (mapQuery == null) {
            return;
        }
        this.updateDirty(mapQuery);
    }

    protected void fullQuery() throws MException {
        this.getOrderModel().query();
    }

    protected synchronized void updateDirty(Map<BasketCcsOrder, List<BasketCcsOrder>> mapQuery) {
        Platform.runLater(() -> {
            for (BasketCcsOrder listOrder : mapQuery.keySet()) {
                BasketCcsOrder order = this.bskOrderFactory.create();
                order.setListId(listOrder.getListId());
                order.setBatchId(listOrder.getListId());
                order.setOrdDate(listOrder.getOrdDate());
                for (BasketCcsOrder legOrder : (List)mapQuery.get(order)) {
                    this.onLeafNodeStatusChange(legOrder, legOrder.getOrdStatus().getRaw());
                    legOrder.ordStatusProperty().addListener((ob, oldV, newV) -> this.onLeafNodeStatusChange(legOrder, newV.getRaw()));
                }
                if (this.orderItemsMxListMap.get(order) == null) continue;
                this.orderItemsMxListMap.get(order).updateDirty((List)mapQuery.get(order));
                this.reCalBatchInfo(order.getListId());
            }
            this.changed();
        });
    }

    protected void reCalBatchInfo(String listId) {
        for (BasketCcsOrder listOrder : this.orderItemsMxListMap.keySet()) {
            if (!listOrder.getListId().equals(listId)) continue;
            long cumQty = 0L;
            double tradeAmt = 0.0;
            double cxlAmt = 0.0;
            double orderAmt = 0.0;
            int size = 0;
            for (TreeItem legOrder : this.orderItemsMxListMap.get(listOrder).getObList()) {
                if (((BasketCcsOrder)legOrder.getValue()).getOrdStatus().getRaw().equals("999")) continue;
                tradeAmt += ((BasketCcsOrder)legOrder.getValue()).getTradeAmount();
                cxlAmt += ((BasketCcsOrder)legOrder.getValue()).getCxlAmount();
                orderAmt += ((BasketCcsOrder)legOrder.getValue()).getOrderAmount();
                cumQty += ((BasketCcsOrder)legOrder.getValue()).getCumQty();
                ++size;
            }
            double per = 0.0;
            if (size != 0 && listOrder.getOrderQty() > 0L) {
                per = new BigDecimal(cumQty).divide(new BigDecimal(listOrder.getOrderQty()), 4, 4).doubleValue() * 100.0;
            }
            listOrder.setDonePercent(per);
            listOrder.setTradeAmount(tradeAmt);
            listOrder.setCxlAmount(cxlAmt);
            listOrder.setOrderAmount(orderAmt);
        }
    }

    protected void calculate() {
        for (TreeItem item : this.getRoot().getChildren()) {
            for (TreeItem subItem : item.getChildren()) {
                this.onLeafNodeStatusChange((BasketCcsOrder)subItem.getValue(), ((BasketCcsOrder)subItem.getValue()).getOrdStatus().getRaw());
                ((BasketCcsOrder)subItem.getValue()).ordStatusProperty().addListener((ob, oldV, newV) -> this.onLeafNodeStatusChange((BasketCcsOrder)subItem.getValue(), newV.getRaw()));
            }
            this.onNodeStatusChange((BasketCcsOrder)item.getValue(), ((BasketCcsOrder)item.getValue()).getBatchStatus().getRaw());
            ((BasketCcsOrder)item.getValue()).batchStatusProperty().addListener((ob, old, newV) -> this.onNodeStatusChange((BasketCcsOrder)item.getValue(), newV.getRaw()));
        }
        this.changed();
    }

    protected void onNodeStatusChange(BasketCcsOrder curItem, String value) {
        if ("1".equals(value)) {
            curItem.setCanCancel(true);
        } else {
            curItem.setSelected(false);
            curItem.setCanCancel(false);
        }
    }

    protected void onLeafNodeStatusChange(BasketCcsOrder curItem, String value) {
        String canCancelStatus = "4849";
        if (canCancelStatus.contains(value)) {
            curItem.setCanCancel(true);
        } else {
            curItem.setSelected(false);
            curItem.setCanCancel(false);
        }
    }

    public BasketCcsOrderModel getOrderModel() {
        return this.orderModel;
    }

    public void setOrderModel(BasketCcsOrderModel orderModel) {
        this.orderModel = orderModel;
    }

    public void checkInstructionPrice(Map<CcsCancelEntrust, BasketCcsOrder> enOrMap, List<String> referenceIds) throws MException {
        List<Instruction> instructions = this.instructionMng.query(referenceIds);
        Map<String, Instruction> insMap = instructions.stream().collect(Collectors.toMap(Instruction::getId, t -> t));
        for (CcsCancelEntrust entrust : enOrMap.keySet()) {
            Instruction instruction = insMap.get(entrust.getReference());
            if (instruction == null) continue;
            this.checkPriceByType(entrust, enOrMap.get((Object)entrust), instruction);
        }
    }

    private void checkPriceByType(CcsCancelEntrust entrust, BasketCcsOrder ccsOrder, Instruction ins) {
        switch (ins.getType().getRaw()) {
            case "4": 
            case "5": {
                this.resetBasketInsPrice(entrust, ccsOrder, ins);
                break;
            }
        }
    }

    private void resetBasketInsPrice(CcsCancelEntrust entrust, BasketCcsOrder ccsOrder, Instruction ins) {
        switch (String.valueOf(ins.getBasketOrderAdvice().getPriceType())) {
            case "11": {
                this.resetZero(entrust, ccsOrder);
                entrust.setTip("\u6307\u4ee4\u6307\u5b9a\u4ef7\u59d4\u6258\uff0c\u4e0d\u4f1a\u89e6\u53d1\u64a4\u4e0b\u3002" + entrust.getTip());
                break;
            }
            default: {
                String floatUnit = "";
                String priceFloat = "";
                if (ins.getBasketOrderAdvice().getFloatPercent() != 0.0) {
                    floatUnit = "%";
                    priceFloat = String.valueOf(ins.getBasketOrderAdvice().getFloatPercent());
                } else {
                    floatUnit = "\u5143";
                    priceFloat = String.valueOf(ins.getBasketOrderAdvice().getFloatPrice());
                }
                double limitPice = this.orderModel.getNewPrice(ccsOrder, ins.getBasketOrderAdvice().getPriceType(), floatUnit, priceFloat);
                if (Integer.valueOf(ccsOrder.getSide().getRaw()) == 49) {
                    if (!(ccsOrder.getNewPrice() > limitPice)) break;
                    this.resetOrderPriceByInsLimit(entrust, ccsOrder, limitPice);
                    entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5927\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                    break;
                }
                if (Integer.valueOf(ccsOrder.getSide().getRaw()) != 50 || !(ccsOrder.getNewPrice() < limitPice)) break;
                this.resetOrderPriceByInsLimit(entrust, ccsOrder, limitPice);
                entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5c0f\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
            }
            case "12": 
        }
    }

    private void resetZero(CcsCancelEntrust entrust, BasketCcsOrder ccsOrder) {
        entrust.setPrice(0.0);
        entrust.setQuantity(0L);
        entrust.setAmt(0.0);
        ccsOrder.setCanCancelReplace(false);
        entrust.setIsModified(true);
    }

    private void resetOrderPriceByInsLimit(CcsCancelEntrust entrust, BasketCcsOrder ccsOrder, double limitPice) {
        ccsOrder.setNewPrice(limitPice);
        entrust.setPrice(limitPice);
        if ("XSHG".equals(ccsOrder.getInstrument().getMarket().getRaw()) && "BOND".equals(ccsOrder.getInstrument().getSecType())) {
            entrust.setAmt((double)entrust.getQuantity() * entrust.getPrice() * 10.0);
        } else {
            entrust.setAmt((double)entrust.getQuantity() * entrust.getPrice());
        }
        entrust.setIsModified(true);
    }
}

