/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models.basket;

import cms.tmx.api.basket.imp.QueryBasketOrderImpl;
import cms.tmx.api.data.IRefItem;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.PageInTurn;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.BasketCcsOrderFactory;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketCcsOrderModel
extends MxModel {
    protected static final Logger logger = LogManager.getLogger(BasketCcsOrderModel.class);
    @Inject
    protected QueryBasketOrderImpl queryModel;
    protected Map<BasketCcsOrder, Set<String>> mapToBeQuery = new HashMap<BasketCcsOrder, Set<String>>();
    protected ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    @Named(value="fixed.query.pool")
    protected ExecutorService service;
    @Inject
    protected BasketCcsOrderFactory bskOrderFactory;
    @Inject
    protected QueryModel updateModel;
    protected Map<BasketCcsOrder, List<BasketCcsOrder>> map = new ConcurrentHashMap<BasketCcsOrder, List<BasketCcsOrder>>();
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    @Inject
    protected MObjFactory of;
    @Inject
    protected MEventService es;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng marketMng;
    private MarketItem mktItem;
    protected AtomicInteger count = new AtomicInteger(0);
    private Lock lock = new ReentrantLock();
    protected List<PageInTurn<Object, String, POrderService.ListOrderLeg>> pageList = new ArrayList<PageInTurn<Object, String, POrderService.ListOrderLeg>>();

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)"handicap", (String)"0");
        this.initPriceType(node);
        this.setPriceType(node);
    }

    public void addToBeQuery(BasketCcsOrder id, String legId) {
        this.lockTobeQuery.lock();
        try {
            if (this.mapToBeQuery.get(id) == null) {
                this.mapToBeQuery.put(id, new HashSet());
            }
            this.mapToBeQuery.get(id).add(legId);
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public Map<BasketCcsOrder, List<BasketCcsOrder>> queryToBeQuery() throws MException {
        HashMap<BasketCcsOrder, Set<String>> orderIdMap = null;
        this.lockTobeQuery.lock();
        try {
            orderIdMap = new HashMap<BasketCcsOrder, Set<String>>(this.mapToBeQuery);
            this.mapToBeQuery.clear();
        }
        finally {
            this.lockTobeQuery.unlock();
        }
        if (orderIdMap.isEmpty()) {
            return null;
        }
        return this.queryByPush(orderIdMap);
    }

    protected Map<BasketCcsOrder, List<BasketCcsOrder>> queryByPush(HashMap<BasketCcsOrder, Set<String>> orderIdMap) throws MException {
        HashMap<BasketCcsOrder, List<BasketCcsOrder>> orderMap = new HashMap<BasketCcsOrder, List<BasketCcsOrder>>();
        for (BasketCcsOrder listOrder : orderIdMap.keySet()) {
            LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
            List listOrderLegList = this.queryModel.queryListOrderLegs(listOrder.getListId(), orderIdMap.get(listOrder));
            for (POrderService.ListOrderLeg orderLeg : listOrderLegList) {
                BasketCcsOrder order = this.bskOrderFactory.create();
                order.update((Object)orderLeg);
                this.transferLegField(order);
                orderList.add(order);
            }
            orderMap.put(listOrder, orderList);
        }
        return orderMap;
    }

    protected synchronized void afterUpdateAcc(BasketCcsOrder order) {
        this.updateModel.afterUpdateAcc(order);
    }

    protected synchronized void afterUpdateSec(BasketCcsOrder order) {
        this.updateModel.afterUpdateSec(order);
        this.updateModel.getBasketPrice(order);
    }

    public List<POrderService.ListOrder> queryOrders() throws MException {
        return this.queryModel.queryOrders(this.getExtAccntIds(), null);
    }

    private List<String> getExtAccntIds() {
        LinkedList<String> extAccntIds = new LinkedList<String>();
        this.fundAccntService.getFundAccountList().forEach(accnt -> extAccntIds.add(accnt.getExtAccntId()));
        return extAccntIds;
    }

    public BasketCcsOrder queryOrder(String listId) throws MException {
        POrderService.ListOrder queryOrder = this.queryModel.queryOrder(listId);
        BasketCcsOrder batchOrder = this.bskOrderFactory.create();
        batchOrder.update(queryOrder);
        this.transferBatchField(batchOrder);
        return batchOrder;
    }

    public List<BasketCcsOrder> queryListOrder(String listId) throws MException {
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        POrderService.ListOrder queryOrder = this.queryModel.queryOrder(listId);
        String clListId = queryOrder.getClListId();
        List legsList = queryOrder.getLegsList();
        for (POrderService.ListOrderLeg orderLeg : legsList) {
            BasketCcsOrder order = this.bskOrderFactory.create();
            order.setClListId(clListId);
            order.update((Object)orderLeg);
            order.setPortfolioId(queryOrder.getPortfolioId());
            orderList.add(order);
        }
        return orderList;
    }

    protected void transferBatchField(BasketCcsOrder batchOrder) {
        this.afterUpdateAcc(batchOrder);
        this.updateModel.afterUpdatePort(batchOrder);
    }

    protected void transferLegField(BasketCcsOrder legOrder) {
        this.afterUpdateSec(legOrder);
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)legOrder.getErrorInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + legOrder.getErrorInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)legOrder.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + legOrder.getWthErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)legOrder.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u4fe1\u606f\uff08" + legOrder.getRiskDetail() + "\uff09";
        }
        legOrder.setErrorInfo(errorInfo);
    }

    public List<BasketCcsOrder> synQueryLegOrders(BasketCcsOrder batchOrder, String orderListId, List<String> legIds, AtomicInteger synCount, List<PageInTurn<Object, String, POrderService.ListOrderLeg>> synPageList) throws MException {
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        PageInTurn pi = new PageInTurn();
        pi.setPageSize(150);
        pi.setStartRow(1);
        pi.setKey((Object)batchOrder);
        pi.setParam((Object)orderListId);
        this.queryModel.queryListOrderLegsByPage((IPageInTurn)pi);
        if (pi.hasNext()) {
            synCount.getAndIncrement();
            synPageList.add((PageInTurn<Object, String, POrderService.ListOrderLeg>)pi.next());
        }
        for (POrderService.ListOrderLeg orderLeg : pi.getResList()) {
            BasketCcsOrder order = this.bskOrderFactory.create();
            order.update((Object)orderLeg);
            this.transferLegField(order);
            orderList.add(order);
        }
        return orderList;
    }

    public List<BasketCcsOrder> queryLegOrders(BasketCcsOrder batchOrder, String orderListId, List<String> legIds) throws MException {
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        PageInTurn pi = new PageInTurn();
        pi.setPageSize(150);
        pi.setStartRow(1);
        pi.setKey((Object)batchOrder);
        pi.setParam((Object)orderListId);
        this.queryModel.queryListOrderLegsByPage((IPageInTurn)pi);
        if (pi.hasNext()) {
            this.count.getAndIncrement();
            this.pageList.add((PageInTurn<Object, String, POrderService.ListOrderLeg>)pi.next());
        }
        for (POrderService.ListOrderLeg orderLeg : pi.getResList()) {
            BasketCcsOrder order = this.bskOrderFactory.create();
            order.update((Object)orderLeg);
            this.transferLegField(order);
            orderList.add(order);
        }
        return orderList;
    }

    public List<BasketCcsOrder> queryLegOrders(String orderListId, List<String> legIds) throws MException {
        LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
        List listOrderLegList = this.queryModel.queryListOrderLegs(orderListId, null);
        for (POrderService.ListOrderLeg orderLeg : listOrderLegList) {
            BasketCcsOrder order = this.bskOrderFactory.create();
            order.update((Object)orderLeg);
            this.transferLegField(order);
            orderList.add(order);
        }
        return orderList;
    }

    public void query() throws MException {
        this.map.clear();
        this.pageList.clear();
        List<POrderService.ListOrder> listOrderList = this.queryOrders(this.getExtAccntIds(), null);
        for (POrderService.ListOrder listOrder : listOrderList) {
            BasketCcsOrder batchOrder = this.bskOrderFactory.create();
            batchOrder.update(listOrder);
            this.transferBatchField(batchOrder);
            List<BasketCcsOrder> orderList = this.queryLegOrders(batchOrder, listOrder.getListId(), null);
            this.calBatchInfo(batchOrder, orderList);
            this.map.put(batchOrder, Collections.synchronizedList(orderList));
        }
        if (this.count.intValue() == 0) {
            Platform.runLater(() -> this.changed());
        } else {
            this.clearPageList();
        }
    }

    protected void clearPageList() throws MException {
        int i = 0;
        while (i < this.pageList.size()) {
            PageInTurn<Object, String, POrderService.ListOrderLeg> pi = this.pageList.get(i);
            ++i;
            if (!pi.hasNext()) continue;
            this.pageList.add((PageInTurn<Object, String, POrderService.ListOrderLeg>)pi.next());
        }
        for (PageInTurn<Object, String, POrderService.ListOrderLeg> pi : this.pageList) {
            this.service.execute(() -> {
                try {
                    this.queryModel.queryListOrderLegsByPage((IPageInTurn)pi);
                    LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
                    for (POrderService.ListOrderLeg orderLeg : pi.getResList()) {
                        BasketCcsOrder order = this.bskOrderFactory.create();
                        order.update((Object)orderLeg);
                        this.transferLegField(order);
                        orderList.add(order);
                    }
                    this.map.get(pi.getKey()).addAll(orderList);
                    if (this.check(this.map, pi)) {
                        this.count.getAndDecrement();
                        if (this.count.intValue() == 0) {
                            Platform.runLater(() -> this.changed());
                        }
                    }
                }
                catch (MException e) {
                    logger.error("\u591a\u7ebf\u7a0b\u67e5\u8be2\u7bee\u5b50\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                }
            });
        }
    }

    private boolean check(Map<BasketCcsOrder, List<BasketCcsOrder>> collectMap, PageInTurn<Object, String, POrderService.ListOrderLeg> pi) {
        return collectMap.get(pi.getKey()).size() >= pi.getTotalRow();
    }

    private List<POrderService.ListOrder> queryOrders(List<String> extAccntIds, Object object) throws MException {
        return this.queryModel.queryOrders(this.getExtAccntIds(), null);
    }

    public void calBatchInfo(BasketCcsOrder batchOrder, List<BasketCcsOrder> orderList) {
        long cumQty = 0L;
        double tradeAmt = 0.0;
        double cxlAmt = 0.0;
        double orderAmt = 0.0;
        int size = 0;
        for (BasketCcsOrder order : orderList) {
            if (order.getOrdStatus().getRaw().equals("999")) continue;
            tradeAmt += order.getTradeAmount();
            cxlAmt += order.getCxlAmount();
            orderAmt += order.getOrderAmount();
            cumQty += order.getCumQty();
            ++size;
        }
        double per = 0.0;
        if (size != 0 && batchOrder.getOrderQty() > 0L) {
            per = new BigDecimal(cumQty).divide(new BigDecimal(batchOrder.getOrderQty()), 4, 4).doubleValue() * 100.0;
        }
        batchOrder.setDonePercent(per);
        batchOrder.setTradeAmount(tradeAmt);
        batchOrder.setCxlAmount(cxlAmt);
        batchOrder.setOrderAmount(orderAmt);
    }

    public synchronized MEvent cancel(List<BasketCcsOrder> list) {
        MEvent event = new MEvent();
        event.setObj(list);
        this.es.sendEvent("basket.cancel.order", event);
        boolean returnFlag = event.getBool("basket_return_boolean");
        if (returnFlag) {
            event.put((Object)"suc.count", (Object)list.size());
        } else {
            event.put((Object)"fail.count", (Object)list.size());
        }
        return event;
    }

    public synchronized MEvent cancelAndOrder(List<BasketCcsOrder> list, BasketCcsOrder order) {
        MEvent event = new MEvent();
        event.setObj(list);
        event.put((Object)"basket.base.order", (Object)order);
        this.es.sendEvent("basket.replace.order", event);
        boolean returnFlag = event.getBool("basket_return_boolean");
        if (returnFlag) {
            event.put((Object)"suc.count", (Object)list.size());
        } else {
            event.put((Object)"fail.count", (Object)list.size());
        }
        return event;
    }

    public void queryMarketItem(List<TreeItem<BasketCcsOrder>> list) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (TreeItem<BasketCcsOrder> order : list) {
            RefItem refItem = this.refMng.getItem(((BasketCcsOrder)order.getValue()).getInstrument().getSecType(), ((BasketCcsOrder)order.getValue()).getInstrument().getMarket().getRaw(), ((BasketCcsOrder)order.getValue()).getInstrument().getSecId());
            if (refItem == null) continue;
            listItem.add(refItem);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        gears.setSell(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    public double getNewPrice(BasketCcsOrder order, int priceType, String floatUnit, String priceFloat) {
        double price = 0.0;
        RefItem refItem = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        if (refItem == null) {
            return 0.0;
        }
        this.mktItem = this.marketMng.getInfo((IRefItem)refItem);
        price = this.getPrice(priceType);
        int scale = this.mktItem.getRefItem().getScale();
        BigDecimal bg = new BigDecimal(price);
        price = bg.setScale(scale, 4).doubleValue();
        if ("\u5143".equals(floatUnit)) {
            price += Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat);
        } else if ("%".equals(floatUnit)) {
            price *= 1.0 + Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat) * 0.01;
        }
        if (!"BOND".equals(order.getInstrument().getSecType()) && !"REPO".equals(order.getInstrument().getSecType()) && !"PLEDGE".equals(order.getInstrument().getSecType()) && this.mktItem.getUpLimitPrice() > 0.0 && price > this.mktItem.getUpLimitPrice()) {
            price = this.mktItem.getUpLimitPrice();
        } else if (!"BOND".equals(order.getInstrument().getSecType()) && !"REPO".equals(order.getInstrument().getSecType()) && !"PLEDGE".equals(order.getInstrument().getSecType()) && this.mktItem.getDownLimitPrice() > 0.0 && price < this.mktItem.getDownLimitPrice()) {
            price = this.mktItem.getDownLimitPrice();
        }
        bg = new BigDecimal(String.valueOf((double)Math.round(price * 10000.0) / 10000.0));
        if ("49".equals(order.getSide().getRaw())) {
            price = bg.setScale(scale, 1).doubleValue();
        } else if ("50".equals(order.getSide().getRaw())) {
            price = bg.setScale(scale, 0).doubleValue();
        }
        return price;
    }

    private double getPrice(int i) {
        double dRet = 0.0;
        if (i == 0) {
            dRet = this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice();
        } else if (i == 100) {
            dRet = this.mktItem.getUpLimitPrice() > 0.0 ? this.mktItem.getUpLimitPrice() : this.mktItem.getClosePrice();
            if (this.mktItem.getRefItem() != null && "BOND".equals(this.mktItem.getRefItem().getType())) {
                dRet = 0.0;
            }
        } else if (i == -100) {
            dRet = this.mktItem.getDownLimitPrice() > 0.0 ? this.mktItem.getDownLimitPrice() : this.mktItem.getClosePrice();
            if (this.mktItem.getRefItem() != null && "BOND".equals(this.mktItem.getRefItem().getType())) {
                dRet = 0.0;
            }
        } else if (i > 0) {
            do {
                dRet = 0.0;
                if (i <= 0 || this.mktItem.getListBuyHandicap().size() <= i - 1) continue;
                dRet = ((HandicapInfo)this.mktItem.getListBuyHandicap().get(i - 1)).getPrice();
                --i;
            } while (dRet <= 0.0 && i > 0);
            if (dRet <= 0.0 && i == 0) {
                dRet = this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice();
            }
        } else if (i < 0) {
            i = Math.abs(i);
            do {
                dRet = 0.0;
                if (i <= 0 || this.mktItem.getListSellHandicap().size() <= i - 1) continue;
                dRet = ((HandicapInfo)this.mktItem.getListSellHandicap().get(i - 1)).getPrice();
                --i;
            } while (dRet <= 0.0 && i > 0);
            if (dRet <= 0.0 && i == 0) {
                dRet = this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice();
            }
        }
        return dRet;
    }

    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    public String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    public void setPriceFloat(String priceFloat) {
        this.priceFloatProperty().set((Object)priceFloat);
    }

    public StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    public String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }

    public void setFloatUnit(String floatUnit) {
        this.floatUnitProperty().set((Object)floatUnit);
    }

    public Map<BasketCcsOrder, List<BasketCcsOrder>> getMap() {
        return this.map;
    }

    public void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    protected void initPriceType(MxNode node) {
        this.removeOthers(node, "100");
        node.addNode("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
        node.addNode("-100");
    }

    public Map<BasketCcsOrder, List<BasketCcsOrder>> synQueryByListIds(List<String> listIds) throws MException {
        AtomicInteger synCount = new AtomicInteger(0);
        ArrayList<PageInTurn<Object, String, POrderService.ListOrderLeg>> synPageList = new ArrayList<PageInTurn<Object, String, POrderService.ListOrderLeg>>();
        ConcurrentHashMap<BasketCcsOrder, List<BasketCcsOrder>> synMap = new ConcurrentHashMap<BasketCcsOrder, List<BasketCcsOrder>>();
        this.lock.lock();
        try {
            for (String listId : listIds) {
                BasketCcsOrder batchOrder = this.bskOrderFactory.create();
                batchOrder.setListId(listId);
                List<BasketCcsOrder> orderList = this.synQueryLegOrders(batchOrder, listId, null, synCount, synPageList);
                synMap.put(batchOrder, Collections.synchronizedList(orderList));
            }
            if (synCount.intValue() == 0) {
                ConcurrentHashMap<BasketCcsOrder, List<BasketCcsOrder>> concurrentHashMap = synMap;
                return concurrentHashMap;
            }
            this.synClearPageList(synPageList, synCount, synMap);
            ConcurrentHashMap<BasketCcsOrder, List<BasketCcsOrder>> concurrentHashMap = synMap;
            return concurrentHashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void synClearPageList(List<PageInTurn<Object, String, POrderService.ListOrderLeg>> synPageList, AtomicInteger synCount, Map<BasketCcsOrder, List<BasketCcsOrder>> synMap) throws MException {
        int i = 0;
        while (i < synPageList.size()) {
            PageInTurn<Object, String, POrderService.ListOrderLeg> pi = synPageList.get(i);
            ++i;
            if (!pi.hasNext()) continue;
            synPageList.add((PageInTurn<Object, String, POrderService.ListOrderLeg>)pi.next());
        }
        CountDownLatch latch = new CountDownLatch(synCount.get());
        for (PageInTurn<Object, String, POrderService.ListOrderLeg> pi : synPageList) {
            this.service.execute(() -> {
                try {
                    this.queryModel.queryListOrderLegsByPage((IPageInTurn)pi);
                    LinkedList<BasketCcsOrder> orderList = new LinkedList<BasketCcsOrder>();
                    for (POrderService.ListOrderLeg orderLeg : pi.getResList()) {
                        BasketCcsOrder order = this.bskOrderFactory.create();
                        order.update((Object)orderLeg);
                        this.transferLegField(order);
                        orderList.add(order);
                    }
                    ((List)synMap.get(pi.getKey())).addAll(orderList);
                    if (this.check(synMap, pi)) {
                        latch.countDown();
                    }
                }
                catch (MException e) {
                    logger.error("\u591a\u7ebf\u7a0b\u67e5\u8be2\u7bee\u5b50\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                }
            });
        }
        try {
            latch.await(100000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            logger.error("\u67e5\u8be2\u7bee\u5b50\u4efb\u52a1\u8d85\u65f6\u5931\u8d25");
        }
    }
}

