/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.query.PositionEffect;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.SgeAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.DateTimeUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SgeOrderModel
extends MxModel {
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    private TradeServiceNewApi api;
    @Inject
    protected MEventService es;
    @Inject
    protected SgeAccountMap sgeMap;
    @Inject
    protected IUserService userService;
    @Inject
    protected ScheduledExecutorService ses;
    protected MxList<Order> list = new MxList();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = new Gson();
    protected boolean isUnfinishedOrder = false;
    protected Map<String, Order> map = new HashMap<String, Order>();
    protected ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    @Inject
    private OrderServiceNewApi newApi;

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    protected Integer getStatusNo(SingleOrder order) {
        if (order.getCanCancelFlag() != 1) {
            return 99999;
        }
        if (order.getOrdStatus() == null) {
            return -1;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            return (int)(1000.0 + order.getCumQty());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!"SGEX".equals(order.getInstrument().getMarket())) {
                return;
            }
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit(order.getInstrument().getSecurityType(), order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.afterUpdate(order);
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    if (order.getCanCancelFlag() == 1) {
                        this.list.updatePart((MxObject)order.convert());
                    } else if (this.list.getListMap().get(order.convert()) != null) {
                        this.list.remove((MxObject)order.convert());
                    }
                } else {
                    this.list.updatePart((MxObject)order.convert());
                }
            }
        }
        this.afterUpdate(this.list);
        this.logger.error("\u8d35\u91d1\u5c5e\u59d4\u6258\u67e5\u8be2\u63a8\u9001\u5237\u65b0");
        this.changed();
    }

    private void afterUpdate(SingleOrder o) {
        if ("SGEX".equals(o.getMarket())) {
            o.setMarket("\u91d1\u4ea4\u6240");
        }
        try {
            for (CashAccnt acc : this.sgeMap.getAccountMap().keySet()) {
                if ("".equals(acc.getAccntId()) || o.getExtCashAccntId() == null) continue;
                if (o.getExtCashAccntId().equals(acc.getAccntId())) {
                    o.setInvestorId(acc.getInvestorId());
                    List<SecAccnt> listAcc = this.sgeMap.getAccountMap().get(acc);
                    for (SecAccnt sec : listAcc) {
                        if (!o.getExtSecAccntId().equals(sec.getSecAccntId())) continue;
                        o.setInvestorSecId(sec.getInvestorSecId());
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("\u8d35\u91d1\u5c5e\u59d4\u6258\u67e5\u8be2-\u8d44\u91d1\u8d26\u53f7\u8f6c\u6362\u5f02\u5e38" + e);
        }
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    private String getNextDate() {
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat nowTime = new SimpleDateFormat("HHmmss");
        String t = nowTime.format(new Date());
        String predate = "";
        if (t.compareTo("193000") > 0) {
            Date d = new Date();
            predate = date.format(new Date(d.getTime() + 86400000L));
        } else {
            predate = date.format(new Date());
        }
        return predate;
    }

    public void query() throws IOException, MException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("SGE");
        req.setCanCancelFlag(this.isUnfinishedOrder ? 1 : 0);
        String date = this.getNextDate();
        req.setBeginDate(date);
        ArrayList<String> extAcc = new ArrayList<String>();
        for (CashAccnt acc : this.sgeMap.getAccountMap().keySet()) {
            if ("".equals(acc.getCashAccntId())) continue;
            extAcc.add(acc.getCashAccntId());
        }
        req.setExtCashAccntId(extAcc);
        Fragment fragment = this.getFragment(req);
        if (!extAcc.isEmpty()) {
            GetOrdersResp resp = this.newApi.getOrders(req);
            this.list.clear();
            this.list.addAll(resp.getData());
            int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
            while (--queryTimes > 0) {
                fragment.setOffset(fragment.getSize() + fragment.getOffset());
                req.setFragment(fragment);
                GetOrdersResp res = this.newApi.getOrders(req);
                this.list.addAll(res.getData());
            }
        }
        DateTimeUtils.getDate();
        for (Order order : this.list.getList()) {
            for (CashAccnt acc : this.sgeMap.getAccountMap().keySet()) {
                if ("".equals(acc.getCashAccntId()) || !order.getExtAccntId().getCashAccntId().equals(acc.getCashAccntId())) continue;
                order.setInvestorId(acc.getInvestorId());
                List<SecAccnt> listAcc = this.sgeMap.getAccountMap().get(acc);
                for (SecAccnt sec : listAcc) {
                    if (!order.getExtAccntId().getSecAccntId().equals(sec.getSecAccntId())) continue;
                    order.setInvestorSecId(sec.getInvestorSecId());
                }
            }
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit(order.getInstrument().getSecurityType(), order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            MxNode mxMarket = MxNodeFactory.createNew((String)"market_code");
            if (order.getInstrument() != null && "SGEX".equals(order.getInstrument().getMarket())) {
                order.setMarket(mxMarket.getNode(order.getInstrument().getMarket()).getValue());
            }
            this.map.put(order.getOrderId(), order);
        }
        this.afterUpdate(this.list);
        this.changed();
    }

    private void afterUpdate(MxList<Order> list) {
        for (Order ord : list.getList()) {
            if (ord.getPositionEffect() == null || "".equals(ord.getPositionEffect())) {
                System.out.println();
                return;
            }
            ord.setPositionEffect(String.valueOf(PositionEffect.deserialize((String)ord.getPositionEffect()).getValue()));
        }
    }

    private Fragment getFragment(GetOrdersReq req) {
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        return fragment;
    }

    public List<Order> getList() {
        return this.list.getList();
    }

    public void setUnfinishedOrder(boolean isUnfinishedOrder) {
        this.isUnfinishedOrder = isUnfinishedOrder;
    }

    public void cancelOrder(ObSingleOrderNeeq item) throws MException {
        OrderCancelRequest order = new OrderCancelRequest();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = new Instrument();
        instrument.setSecurityId(item.getSecurityId());
        instrument.setSymbol(item.getSecurityName());
        instrument.setMarket(item.getMarket());
        instrument.setSecurityType(item.getSecuritySubType());
        instrument.setMarketGroup("SGE");
        order.setInstrument(instrument);
        order.setOrderId(item.getOrderId());
        order.setExtCashAccntId(item.getExtCashAccntId());
        order.setExtSecAccntId(item.getExtSecAccntId());
        order.setAccount(item.getAccntId());
        this.newApi.sgeOrderCancel(order);
    }
}

