/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.accnt.SgeAccountServiceApi;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SgeAccountMap
extends MxModel {
    private static final Logger logger = LogManager.getLogger(SgeAccountMap.class);
    @Inject
    private MEventService es;
    @Inject
    private SgeAccountServiceApi newAccntApi;
    @Inject
    private MConfService cs;
    @Inject
    private IBaseApi baseApi;
    private boolean initDone = false;
    private Map<CashAccnt, List<SecAccnt>> sgeMapAccount = FxUtils.newMap();
    private MEventHandler handler = event -> this.initAccount(event);
    private List<String> postIds = new ArrayList<String>();
    private List<String> cashIds = new ArrayList<String>();
    private MEventHandler sendAccnts = event -> {
        ArrayList<String> accnts = new ArrayList<String>();
        for (CashAccnt acc : this.getAccountMap().keySet()) {
            accnts.add(acc.getAccntId());
        }
        try {
            event.setObj(accnts);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d35\u91d1\u5c5e\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
    };

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", this.handler);
        this.es.subscribe("sge.accnt.get", this.sendAccnts);
        this.setPostIds();
        this.setCashIds();
    }

    private void setPostIds() {
        if (!this.postIds.isEmpty()) {
            return;
        }
        String[] split = this.cs.getValue("sge.postid.filter", "").split("\\|");
        int i = 0;
        while (i < split.length) {
            this.postIds.add(split[i]);
            ++i;
        }
    }

    private void setCashIds() {
        if (!this.cashIds.isEmpty()) {
            return;
        }
        String[] split = this.cs.getValue("sge.cashid.filter", "").split("\\|");
        int i = 0;
        while (i < split.length) {
            this.cashIds.add(split[i]);
            ++i;
        }
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("stage.after.login", this.handler);
    }

    private void initAccount(MEvent event) {
        this.getAccountMap();
    }

    public synchronized Map<CashAccnt, List<SecAccnt>> getAccountMap() {
        if (!this.postIds.contains(this.baseApi.getPostId())) {
            logger.error("\u8d35\u91d1\u5c5e\u4ea4\u6613\u804c\u4f4d\u4e0d\u5339\u914d");
            return this.sgeMapAccount;
        }
        if (!this.initDone) {
            List sgeExtSecAccnts;
            List extCashAccnts;
            block10: {
                block9: {
                    logger.info("create sge account map");
                    extCashAccnts = this.newAccntApi.getSgeExtCashAccnts();
                    if (extCashAccnts != null) break block9;
                    logger.error("\u672a\u67e5\u8be2\u5230sge\u8d44\u91d1\u8d26\u53f7");
                    return null;
                }
                sgeExtSecAccnts = this.newAccntApi.getSgeExtSecAccnts();
                if (sgeExtSecAccnts != null) break block10;
                logger.error("\u672a\u67e5\u8be2\u5230sge\u8bc1\u5238\u8d26\u53f7");
                return null;
            }
            try {
                for (CashAccnt cashAccnt : extCashAccnts) {
                    if (!this.cashIds.isEmpty() && !this.cashIds.contains(cashAccnt.getInvestorId())) {
                        logger.error("\u672a\u5339\u914d\u5230sge\u8d44\u91d1\u8d26\u53f7");
                        continue;
                    }
                    ArrayList<SecAccnt> secList = new ArrayList<SecAccnt>();
                    cashAccnt.setMarketGroup("SGE");
                    cashAccnt.setMarket("SGEX");
                    this.sgeMapAccount.put(cashAccnt, secList);
                    for (SecAccnt secAccnt : sgeExtSecAccnts) {
                        if (!secAccnt.getAccntId().equals(cashAccnt.getAccntId())) continue;
                        secList.add(secAccnt);
                    }
                }
            }
            catch (MException | Exception e) {
                logger.error("\u67e5\u8be2sge\u8d26\u53f7\u5931\u8d25", e);
                return this.sgeMapAccount;
            }
        }
        this.initDone = true;
        return this.sgeMapAccount;
    }

    public CashAccnt getCashAccnt(String extAccntId, String sge) {
        if (this.sgeMapAccount.isEmpty()) {
            return null;
        }
        for (CashAccnt acc : this.sgeMapAccount.keySet()) {
            if (!acc.getCashAccntId().equals(extAccntId)) continue;
            return acc;
        }
        return null;
    }

    public CashAccnt getCashAccntByAccntId(String accntId) {
        if (this.sgeMapAccount.isEmpty()) {
            return null;
        }
        for (CashAccnt acc : this.sgeMapAccount.keySet()) {
            if (!accntId.equals(acc.getAccntId())) continue;
            return acc;
        }
        return null;
    }
}

