/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.instruction.IResourceApi;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.ObTopSpeedInstruction;
import cms.tmx.entity.trade.instruction.Resource;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ResourceModel
extends MxModel {
    @Inject
    protected MEventService es;
    @Inject
    private IResourceApi resourceApi;
    private Map<String, Resource> mapResource = new HashMap<String, Resource>();
    private ReentrantLock lockToBeQuery = new ReentrantLock();

    public Resource getResource(Instruction instruction) throws MException {
        Resource resource = null;
        if (instruction.getResource() != null) {
            resource = instruction.getResource();
        } else {
            resource = this.getResource(instruction, "", "");
            instruction.setResource(resource);
        }
        return resource;
    }

    public Resource getHisResource(Instruction instruction, String beginDate, String endDate) throws MException {
        Resource resource = null;
        if (instruction.getResource() != null) {
            resource = instruction.getResource();
        } else {
            resource = this.getResource(instruction, beginDate, endDate);
            instruction.setResource(resource);
        }
        return resource;
    }

    public Resource getResource(Instruction instruction, String beginDate, String endDate) throws MException {
        Resource resource = new Resource();
        if (this.mapResource.get(instruction.getId()) != null) {
            return this.mapResource.get(instruction.getId());
        }
        List resourceList = null;
        resourceList = this.resourceApi.getResource(instruction.getId(), Integer.parseInt(instruction.getType().getRaw()), instruction.getMarketGrp(), beginDate, endDate);
        if (resourceList != null && !resourceList.isEmpty()) {
            resource.update(resourceList.get(0));
        }
        try {
            this.lockToBeQuery.lock();
            this.mapResource.put(instruction.getId(), resource);
        }
        finally {
            this.lockToBeQuery.unlock();
        }
        return resource;
    }

    public void refreshResource(Instruction ins) throws MException {
        Resource resource = this.getResource(ins);
        HashMap<String, Integer> mapPara = new HashMap<String, Integer>();
        mapPara.put(ins.getId(), Integer.valueOf(ins.getType().getRaw()));
        List<Resource> resourceList = this.query(mapPara, "", "");
        if (resourceList != null && !resourceList.isEmpty()) {
            resource.update((Object)resourceList.get(0));
        }
    }

    public void cancelResource(Instruction instruction) throws MException {
        if (instruction == null || instruction.getResource() == null) {
            return;
        }
        this.resourceApi.cancelResource(instruction.getResource().getId(), instruction.getMarketGrp());
    }

    public void cancelResource(ObTopSpeedInstruction instruction) throws MException {
        if (StringUtils.isEmpty((String)instruction.getResourceId())) {
            return;
        }
        this.resourceApi.cancelResource(instruction.getResourceId(), instruction.getMarketGrp());
    }

    public List<Resource> query(List<String> ids) throws MException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        List resources = this.resourceApi.getResource(ids);
        try {
            this.lockToBeQuery.lock();
            for (PResource.Resource pRes : resources) {
                Resource res = this.mapResource.containsKey(pRes.getReference()) ? this.mapResource.get(pRes.getReference()) : new Resource();
                res.update((Object)pRes);
                resourceList.add(res);
                this.mapResource.put(res.getReference(), res);
            }
        }
        finally {
            this.lockToBeQuery.unlock();
        }
        return resourceList;
    }

    public List<Resource> query(Map<String, Integer> refMap, String beginTime, String endTime) throws MException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        List resources = this.resourceApi.getResource(refMap, beginTime, endTime);
        try {
            this.lockToBeQuery.lock();
            for (PResource.Resource pRes : resources) {
                Resource res = this.mapResource.containsKey(pRes.getReference()) ? this.mapResource.get(pRes.getReference()) : new Resource();
                res.update((Object)pRes);
                resourceList.add(res);
                this.mapResource.put(pRes.getReference(), res);
            }
        }
        finally {
            this.lockToBeQuery.unlock();
        }
        return resourceList;
    }
}

