/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.RepoRefItem;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.PreFrozenPositions;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.PositionMng;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public abstract class PositionQueryModel<T extends Position>
extends MxModel {
    private static final Logger logger = LogManager.getLogger(PositionQueryModel.class);
    private String marketGroup;
    private int setType;
    private String positionType;
    protected BooleanProperty mapChangePro = new SimpleBooleanProperty(true);
    private Set<String> pledgeSet;
    protected MxList<T> list = new MxList();
    private Map<FundAccount, PositionMng> mapQuery = new ConcurrentHashMap<FundAccount, PositionMng>();
    @Inject
    protected MEventService es;
    @Inject
    protected IFundAccountService fundMng;
    @Inject
    protected QueryModel queryModel;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected static final int SPEC_QUERY_INTERVAL = 1000;
    private volatile boolean querying = false;
    @Inject
    protected PositionFactory fPos;

    public ObservableList<T> getList() {
        return this.list.getList();
    }

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("pre_frozen_position", event -> this.updatePreFrzPosition(event));
        this.es.subscribe("requery_data", event -> this.query());
    }

    protected void updatePreFrzPosition(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof PreFrozenPositions)) {
            return;
        }
        PreFrozenPositions positions = (PreFrozenPositions)PreFrozenPositions.class.cast(obj);
        for (Position pos : positions.getPositionsToUpdate()) {
            this.updatePosition(pos);
        }
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("full query position failed", (Throwable)e);
            }
            catch (Exception ee) {
                logger.error("full query position failed", (Throwable)ee);
            }
        });
    }

    private void scheduleSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException e) {
                logger.error("spec query position failed", (Throwable)e);
            }
            catch (Exception ee) {
                logger.error("spec query position failed", (Throwable)ee);
            }
        });
    }

    private void specQuery() throws MException {
        LinkedList<Position> listSrc = new LinkedList<Position>();
        List fundList = this.fundMng.getFundAccountList(this.marketGroup);
        for (FundAccount fund : fundList) {
            PositionMng query = this.getQuery(fund);
            listSrc.addAll(query.queryDirty());
        }
        this.updateDirty(listSrc);
    }

    private void fullQuery() throws MException {
        this.querying = true;
        try {
            LinkedList<Position> listSrc = new LinkedList<Position>();
            List fundList = this.fundMng.getFundAccountList(this.marketGroup);
            for (FundAccount fund : fundList) {
                PositionMng query = this.getQuery(fund);
                try {
                    listSrc.addAll(query.query());
                }
                catch (MException e) {
                    logger.error("query fund account position failed", (Throwable)e);
                }
            }
            this.update(listSrc);
        }
        finally {
            this.querying = false;
        }
    }

    public boolean isQuerying() {
        return this.querying;
    }

    protected void update(List<Position> listSrc) {
        this.changed();
    }

    protected void updateDirty(List<Position> listSrc) {
        this.changed();
    }

    public void changed() {
        super.changed();
    }

    protected void markDirty(Position pos) {
        Position dirty = (Position)this.list.getListMap().get(pos);
        if (dirty != null) {
            dirty.setDirty(true);
        }
    }

    protected void onPush(MEvent event) {
        if (event.getObj() instanceof ExecutionReport) {
            ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
            if (report == null || report.getReport() == null || report.getReport().getInstrument() == null) {
                return;
            }
            String market = report.getReport().getInstrument().getMarket();
            String marketGroup = MarketUtils.getMarketGroup((String)market);
            if (!report.getReport().hasPosition()) {
                return;
            }
            if (!marketGroup.equals(this.getMarketGrp())) {
                return;
            }
            PPositionService.ExtPosition extPosition = report.getReport().getPosition();
            Position position = this.fPos.create(extPosition);
            T t = this.updateOne(position);
            this.list.updatePart(t);
            this.sdSpecQuery.schedule(e -> this.changed());
        }
    }

    protected T updateOne(Position position) {
        return null;
    }

    protected void updatePosition(Position position) {
        FundAccount fundAcc = this.fundMng.getFundAccount(position.getExtAccId(), position.getMarketGrp());
        PositionMng query = null;
        if (fundAcc != null) {
            if (StringUtils.isEmpty((String)position.getTradingDay()) && fundAcc instanceof CcsFundAccount) {
                position.setTradingDay(((CcsFundAccount)CcsFundAccount.class.cast(fundAcc)).getTradingDay());
            }
            query = this.mapQuery.get(fundAcc);
        }
        if (query != null) {
            query.addQuery(position);
            this.markDirty(position);
            Position newPos = this.standardBondOnPush(position);
            if (newPos != null) {
                query.addQuery(newPos);
                this.markDirty(newPos);
            }
            this.scheduleSpecQuery();
        }
    }

    private Position standardBondOnPush(Position pos) {
        if (!pos.getMarketGrp().equals("CCS")) {
            return null;
        }
        Position position = null;
        RefItem item = this.refMng.getItem(pos.getMarket().getRaw(), pos.getSecId());
        if (item instanceof RepoRefItem) {
            position = this.fPos.create("CCS");
            position.update((Object)pos);
            String newSecId = ((RepoRefItem)RepoRefItem.class.cast(item)).getStdSecId();
            position.setSecId(newSecId);
        } else if (item instanceof PledgeInfo) {
            position = this.fPos.create("CCS");
            position.update((Object)pos);
            PledgeInfo pledge = (PledgeInfo)PledgeInfo.class.cast(item);
            String newSecId = pledge.getStdCode();
            position.setSecId(newSecId);
            pos.setSecId(pledge.getSecCode());
        }
        return position;
    }

    public double getCanSell(SecAccount account, String code) {
        return 0.0;
    }

    public double getCanSell(String account, String code) {
        return 0.0;
    }

    public T getPosition(SecAccount account, String code) {
        return null;
    }

    public T getPosition(String account, String code) {
        return null;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public PositionMng getQuery(FundAccount fund) {
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        PositionMng posiMng = (PositionMng)((Object)this.of.create(PositionMng.class));
        posiMng.setFund(fund);
        posiMng.setPositionType(this.positionType);
        posiMng.setSetType(this.setType);
        this.mapQuery.put(fund, posiMng);
        return posiMng;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    public int getSetType() {
        return this.setType;
    }

    public void setSetType(int setType) {
        this.setType = setType;
    }

    public String getPositionType() {
        return this.positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public double getNewPrice(String secType, String market, String secId) throws MException {
        RefItem refItem = this.refMng.getItem(secType, market, secId);
        if (refItem == null) {
            throw new MException(999997, "no ref item " + secId);
        }
        MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
        if (marketItem == null) {
            throw new MException(999997, "no market item " + secId);
        }
        double price = marketItem.getBuyPrice(0);
        if (price <= 0.0) {
            price = marketItem.getNowPrice() > 0.0 ? marketItem.getNowPrice() : marketItem.getClosePrice();
        }
        if (price < 0.0) {
            throw new MException(999997, "\u8be5\u4ee3\u7801\u65e0\u884c\u60c5 ");
        }
        return price;
    }

    public Set<String> getPledgeCode() {
        if (this.pledgeSet == null) {
            this.pledgeSet = new HashSet<String>();
            List list = (List)this.refMng.getItems(new String[]{"PLEDGE"});
            for (RefItem item : list) {
                PledgeInfo info = (PledgeInfo)item;
                this.pledgeSet.add(info.getStdCode());
            }
        }
        return this.pledgeSet;
    }

    public T getPositionInMap(SecAccount account, String code) {
        return null;
    }

    public BooleanProperty mapChangeProProperty() {
        return this.mapChangePro;
    }

    protected void mapChange() {
        this.mapChangeProProperty().set(!this.mapChangeProProperty().get());
    }

    public boolean isMapChangePro() {
        return this.mapChangeProProperty().get();
    }

    public void setMapChangePro(boolean mapChangePro) {
        this.mapChangeProProperty().set(mapChangePro);
    }
}

