/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.ExtPositionsHisReq;
import cms.tmx.api.ExtPositionsHisResp;
import cms.tmx.api.trade.IPositionHisQueryApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.http.query.mail.AccntEmail;
import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.history.IAccntEmailService;
import cms.tmx.query.history.models.IndustryNameMap;
import cms.tmx.query.utils.QueryByPage;
import cms.tmx.utils.StringUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PositionCarriedForwardModel
extends CcsPositionModel {
    private static final Logger logger = Logger.getLogger(PositionCarriedForwardModel.class);
    @Inject
    private IPositionHisQueryApi hisQuery;
    private PPositionService.PositionCollect collect;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IndustryNameMap industryNames;
    Map<String, String> industryNameMap = new HashMap<String, String>();
    Set<PComponent.Instrument> insts = new HashSet<PComponent.Instrument>();
    @Inject
    private IAccntEmailService accntEmailService;
    private Map<String, AccntEmail> emailMap = new HashMap<String, AccntEmail>();

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error((Object)"full query position failed", (Throwable)e);
            }
            catch (Exception ee) {
                logger.error((Object)"full query position failed", (Throwable)ee);
            }
        });
    }

    private void fullQuery() throws MException {
        long begin = new Date().getTime();
        this.querying = true;
        this.insts.clear();
        LinkedList<Position> listSrc = new LinkedList<Position>();
        List fundList = this.fundMng.getFundAccountList(this.marketGroup);
        ExtPositionsHisReq req = new ExtPositionsHisReq();
        LocalDate.now();
        String date = LocalDate.now().toString().replace("-", "");
        req.setMarketGrp(this.marketGroup);
        req.setBeginDate(date);
        req.setEndDate(date);
        req.setSettingType(1);
        req.setPositionType("REPO");
        req.setFilterClose(true);
        HashSet<String> dateSet = new HashSet<String>();
        LinkedList<PPositionService.ExtPosition> queryByPage = new LinkedList<PPositionService.ExtPosition>();
        for (FundAccount item : fundList) {
            ArrayList<String> extAccList = new ArrayList<String>();
            this.getQuery(item);
            extAccList.add(item.getExtAccntId());
            queryByPage.addAll(this.queryByPage(extAccList, req));
        }
        for (PPositionService.ExtPosition info : queryByPage) {
            Position posi = this.fPos.create(info);
            this.queryModel.afterUpdate(posi);
            PComponent.Instrument instrument = this.industryNames.getInstrument(posi.getSecType(), posi.getSecId(), posi.getMarket().getRaw());
            if (instrument != null) {
                this.insts.add(instrument);
            }
            if (!(posi instanceof CcsPosition)) continue;
            CcsPosition ccs = (CcsPosition)CcsPosition.class.cast(posi);
            this.calculateStockPercent(ccs);
            this.queryModel.getPositionPrice(ccs);
            if (!StringUtils.isEmpty((String)ccs.getAccntGrpName())) {
                ccs.setAccntGrpName(this.assetGrpMng.getCacheAsset(ccs.getAccntGrpName()));
            }
            dateSet.add(ccs.getTradingDay());
            listSrc.add((Position)CcsPosition.class.cast(posi));
        }
        this.industryNames.queryRefData(new ArrayList<PComponent.Instrument>(this.insts));
        logger.info((Object)("\u80a1\u4efd\u67e5\u8be2\u6309\u5e74\u7ed3\u8f6c\u7ed3\u675f     " + (new Date().getTime() - begin)));
        this.update(listSrc);
    }

    private List<PPositionService.ExtPosition> queryByPage(ArrayList<String> extAccList, ExtPositionsHisReq req) throws MException {
        List<PPositionService.ExtPosition> listPosition = Collections.synchronizedList(new ArrayList());
        req.setExtAccntId(extAccList);
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            ExtPositionsHisResp hisResp = this.hisQuery.queryPositionForward(page, req);
            this.transferPosition(listPosition, hisResp);
            this.collect = hisResp.getCollect();
        });
        return listPosition;
    }

    private void transferPosition(List<PPositionService.ExtPosition> listPosition, ExtPositionsHisResp hisResp) {
        listPosition.addAll(hisResp.getList());
    }

    private void calculateStockPercent(CcsPosition posi) {
        RefItem item = null;
        item = "SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw()) ? this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId()) : this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
        posi.setTotalStockPercent("0.00");
        if (item != null && item.getTotalCapitalStock() > 0L) {
            double precent = (double)posi.getTotalVol() * 100.0 / (double)item.getTotalCapitalStock();
            posi.setTotalStockPercent(StringUtils.toStr((double)precent, (int)2).replaceAll(",", ""));
        }
    }

    @Override
    public List<CcsPosition> updatePosition(List<Position> listSrc, boolean isAll) {
        LinkedList<CcsPosition> listPosition = new LinkedList<CcsPosition>();
        for (Position position : listSrc) {
            position.setIndustry(this.industryNames.getIndustryNameMap().get(this.getKey(position)));
            if (!"XSHG".equals(position.getMarket().getRaw()) && !"XSHE".equals(position.getMarket().getRaw()) || !(position instanceof CcsPosition)) continue;
            CcsPosition posi = (CcsPosition)CcsPosition.class.cast(position);
            posi.setTotalVol(posi.getTotalVol() - (long)posi.getImpawnIn());
            this.queryModel.getPositionPrice(posi);
            this.queryModel.afterUpdate((Position)posi);
            listPosition.add(posi);
            CcsPosition ccsPosition = (CcsPosition)this.list.get((MxDirtyObj)posi);
            posi.updateCalValue(ccsPosition);
        }
        this.exe.execute(() -> {
            if (isAll) {
                this.queryAndGetNewPrice(listPosition);
                this.list.update(listPosition);
            }
            this.changed();
        });
        return listPosition;
    }

    private String getKey(Position info) {
        StringBuilder key = new StringBuilder(String.join((CharSequence)",", info.getSecId(), info.getMarket().getRaw()));
        return key.toString();
    }

    public void queryAccntEmail(List<FundAccount> list) throws MException {
        this.emailMap.clear();
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.accntEmailService.querySendListInTurn((IPageInTurn<String, String, AccntEmail>)page);
            this.transferEmail(this.emailMap, (IPageInTurn<String, String, AccntEmail>)page);
        });
        list.forEach(each -> {
            each.setEmail("");
            if (this.emailMap.get(each.getInvestId()) != null) {
                each.setEmail(this.emailMap.get(each.getInvestId()).getMailAddress());
                each.setEmailId(this.emailMap.get(each.getInvestId()).getId());
            }
        });
    }

    public void updateAccntEmail(List<FundAccount> fundList) throws MException {
        LinkedList<AccntEmail> list = new LinkedList<AccntEmail>();
        fundList.forEach(fund -> {
            AccntEmail email = new AccntEmail();
            email.setInvestorId(fund.getInvestId());
            email.setMailAddress(fund.getEmail());
            if (fund.getEmailId() != null) {
                email.setId(fund.getEmailId());
            }
            list.add(email);
        });
        this.accntEmailService.updateSendListInTurn(list);
    }

    public void uploadAccntEmail(byte[] data, FundAccount fund) throws MException {
        this.accntEmailService.uploadSendListInTurn(data, fund);
    }

    private void transferEmail(Map<String, AccntEmail> map, IPageInTurn<String, String, AccntEmail> page) throws MException {
        for (AccntEmail detail : page.getResList()) {
            if (StringUtils.isEmpty((String)detail.getInvestorId())) continue;
            map.put(detail.getInvestorId(), detail);
        }
    }
}

