/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.impl.HkwolunDataMng;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.define.BsDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.AssetReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.PreFrozenFundAccnt;
import cms.tmx.entity.web.asset.GetPortfolioAssetReq;
import cms.tmx.entity.web.asset.PortfolioAsset;
import cms.tmx.entity.web.asset.PortfolioAssets;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.http.accnt.GetExtCashAccntsReq;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IPortfolioService;
import cms.tmx.manage.IWorkFlowService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.utils.CounterNameUtils;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.asset.AssetApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PortfolioAccountModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(PortfolioAccountModel.class);
    private Map<String, Map<CcsFundAccount, List<SecAccount>>> portfolioAccntMap = new HashMap<String, Map<CcsFundAccount, List<SecAccount>>>(20);
    @Inject
    private IBaseApi bmi;
    @Inject
    private IPortfolioApi portfolioApi;
    @Inject
    private IPortfolioService portfolioService;
    @Inject
    private IFundAccountApi fundAccountApi;
    @Inject
    private ISecAccountApi secAccountApi;
    @Inject
    private CcsAccountMap ccsAccountMap;
    @Inject
    private CtpAccountMap ctpAccountMap;
    @Inject
    private AssetApi assetApi;
    private MxList<CcsSubFundAccount> subFundList = new MxList();
    private Map<String, Portfolio> portFolioMap = new HashMap<String, Portfolio>();
    private Map<CcsFundAccount, List<SecAccount>> subFundSecMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private Map<String, CcsSubFundAccount> idAccMap = new HashMap<String, CcsSubFundAccount>();
    private Map<String, CcsSubFundAccount> idnewAccMap = new HashMap<String, CcsSubFundAccount>();
    private Map<String, CcsSubSecAccount> idMarketSecMap = new HashMap<String, CcsSubSecAccount>();
    private Map<String, CcsFundAccount> idAccPortMap = new HashMap<String, CcsFundAccount>();
    private Map<String, String> investorIdCounterMap = new HashMap<String, String>();
    private Map<String, CcsSubSecAccount> idMarketSecPortMap = new HashMap<String, CcsSubSecAccount>();
    private List<Portfolio> portfolioList = new LinkedList<Portfolio>();
    private List<Portfolio> externalAssetPortfolioList = new LinkedList<Portfolio>();
    @Inject
    private MObjFactory of;
    @Inject
    private MScheduler sdRefresh;
    @Inject
    protected MEventService es;
    @Inject
    private ExecutorService exe;
    @Inject
    private HkwolunDataMng hkRetaMng;
    private AtomicBoolean firstQueryFlag = new AtomicBoolean(true);
    private Set<CcsSubFundAccount> setAccToBeQuery = new HashSet<CcsSubFundAccount>();
    private ReentrantLock lockToBeQuery = new ReentrantLock();
    private MEventHandler handler = event -> this.onPush(event);
    private MEventHandler handlerFrozen = event -> this.updatePreFrzFund(event);
    @Inject
    private AccountServiceApi newAccntApi;
    private Map<String, HashSet<String>> workflowPostMap = new ConcurrentHashMap<String, HashSet<String>>();
    private AtomicBoolean initWorkflowTraderMap = new AtomicBoolean(false);
    @Inject
    private IWorkFlowService wfService;
    private ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    private void init() {
        this.es.subscribe("server.sub", this.handler);
        this.es.subscribe("pre_frozen_fund", event -> this.updatePreFrzFund(event));
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("server.sub", this.handler);
        this.es.unSubscribe("pre_frozen_fund", this.handlerFrozen);
    }

    private void updatePreFrzFund(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof PreFrozenFundAccnt)) {
            return;
        }
        PreFrozenFundAccnt fundAccnts = (PreFrozenFundAccnt)PreFrozenFundAccnt.class.cast(obj);
        Set subAccnts = fundAccnts.getSubFundAccntsToUpdate();
        for (CcsSubFundAccount subFund : subAccnts) {
            this.addToBeQuery(subFund);
        }
        this.runQuerySpec();
    }

    private void onPush(MEvent event) {
        if (event.getObj() instanceof AssetReport) {
            this.onAssetPush((AssetReport)AssetReport.class.cast(event.getObj()));
            return;
        }
        if (!(event.getObj() instanceof ExecutionReport)) {
            return;
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        String type = Integer.toString(report.getType());
        if (!this.careReport(type)) {
            return;
        }
        String subFundAccId = report.getReport().getSubAccntId();
        if (StringUtils.isEmpty((String)subFundAccId)) {
            return;
        }
        String marketGroup = MarketUtils.getMarketGroup((String)report.getReport().getInstrument().getMarket());
        CcsSubFundAccount subFundAcc = this.getFundAccount(subFundAccId, marketGroup);
        if (subFundAcc != null) {
            this.addToBeQuery(subFundAcc);
        }
        this.runQuerySpec();
    }

    private boolean careReport(String type) {
        return type.equals("48") || type.equals("52") || type.equals("56") || type.equals("70");
    }

    private void addToBeQuery(CcsSubFundAccount acc) {
        this.lockToBeQuery.lock();
        try {
            this.setAccToBeQuery.add(acc);
        }
        finally {
            this.lockToBeQuery.unlock();
        }
    }

    private void runQuerySpec() {
        this.sdRefresh.schedule(event -> {
            try {
                this.queryToBeQuery();
            }
            catch (MException e) {
                logger.error("query spec fund account failed", (Throwable)e);
            }
        });
    }

    private void queryToBeQuery() throws MException {
        this.lockToBeQuery.lock();
        LinkedList<CcsSubFundAccount> listAcc = new LinkedList<CcsSubFundAccount>();
        try {
            listAcc.addAll(this.setAccToBeQuery);
            this.setAccToBeQuery.clear();
        }
        finally {
            this.lockToBeQuery.unlock();
        }
        for (CcsSubFundAccount acc : listAcc) {
            this.updateFundAcc(acc);
        }
    }

    private void updateFundAcc(CcsSubFundAccount subFundAcc) throws MException {
        subFundAcc.update((Object)this.querySubFundAccount(subFundAcc));
        String portfolioName = this.getPortfolioNameById(subFundAcc.getPortfolioId());
        subFundAcc.setMarketGrp(subFundAcc.getMarketGrp());
        subFundAcc.setPortfolioName(portfolioName);
        this.updatePortfolioAvailable(subFundAcc);
        this.changed();
    }

    private void updatePortfolioAvailable(CcsSubFundAccount subFundAcc) {
        Portfolio portfolio = this.getPortfolio(subFundAcc.getPortfolioId(), subFundAcc.getMarketGrp());
        double available = 0.0;
        double hkAvailable = 0.0;
        for (CcsFundAccount ccsFundAccount : this.getMap(portfolio).keySet()) {
            available += ccsFundAccount.getAvailable();
            hkAvailable += ccsFundAccount.getHkAvailable();
        }
        portfolio.setAvailable(available);
        portfolio.setHkAvailable(hkAvailable);
    }

    private PAccount.SubFundAccnt querySubFundAccount(CcsSubFundAccount subFundAcc) throws MException {
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setSubAccntId(subFundAcc.getSubAccntId());
        List subFundAccountList = this.fundAccountApi.getSubFundAccountList(subFundAcc.getMarketGrp(), newBuilder.build());
        return (PAccount.SubFundAccnt)subFundAccountList.get(0);
    }

    private void onAssetPush(AssetReport report) {
        if (StringUtils.isEmpty((String)report.getReport().getPortfolioId())) {
            return;
        }
        double available = 0.0;
        for (PAssetService.AssetField each : report.getReport().getAssetList()) {
            if (!each.getSecType().equals("CASH")) continue;
            available = each.getAssetAmount();
            break;
        }
        double money = available;
        if (StringUtils.isEmpty((String)report.getReport().getSubAccntId())) {
            this.udpatePortfolioAsset(report.getReport().getPortfolioId(), report.getReport().getMarketGrp(), report.getReport().getTotalAmount(), money);
        } else {
            this.udpateSubFundAsset(report.getReport().getPortfolioId(), report.getReport().getSubAccntId(), report.getReport().getMarketGrp(), report.getReport().getTotalAmount(), money);
        }
    }

    public BooleanProperty changedProperty() {
        return super.changedProperty();
    }

    private void udpateSubFundAsset(String portfolioId, String subAccntId, String marketGrp, double assetAmt, double available) {
        this.checkQuery();
        for (CcsSubFundAccount acc : this.subFundList.getList()) {
            if (!acc.getSubAccntId().equals(subAccntId) || !acc.getMarketGrp().equals(marketGrp)) continue;
            acc.setAssetAmt(assetAmt);
            acc.setAvailable(available);
        }
        this.changed();
    }

    private void udpatePortfolioAsset(String portfolioId, String marketGrp, double assetAmt, double available) {
        Portfolio portfolio = this.getPortfolio(portfolioId, marketGrp);
        if (portfolio == null) {
            return;
        }
        portfolio.setAssetAmt(assetAmt);
        portfolio.setAvailable(available);
        this.changed();
    }

    public Portfolio getPortfolio(String portfolioId, String marketGrp) {
        for (Portfolio portfolio : this.portfolioList) {
            if (!portfolioId.equals(portfolio.getId()) || !"CCS".equals(marketGrp)) continue;
            return portfolio;
        }
        return null;
    }

    public synchronized void query() throws MException {
        this.portfolioAccntMap.clear();
        this.subFundList.clear();
        for (Portfolio portfolio : this.portfolioList) {
            HashMap map = new HashMap(20);
            double available = 0.0;
            double hkAvailable = 0.0;
            List assignDetails = this.portfolioApi.getAccntsByPortfolioIds(portfolio.getId());
            for (PPortfolio.PortAccntAssignDetails assignDetail : assignDetails) {
                if (assignDetail.getAssignStatus() != Integer.valueOf(PortfolioStatus.ASSIGNSTATUS_ENABLED.status).intValue()) continue;
                PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
                newBuilder.setPortfolioId(portfolio.getId());
                newBuilder.setParentExtAccntId(assignDetail.getParentId());
                newBuilder.setParentSubAccntId(assignDetail.getAccountId());
                String portfolioName = this.getPortfolioNameById(portfolio.getId());
                List subFundAccountList = this.fundAccountApi.getSubFundAccountList("CCS", newBuilder.build());
                for (PAccount.SubFundAccnt subFundAccnt : subFundAccountList) {
                    if (subFundAccnt.getStatus() != Integer.valueOf(PortfolioStatus.SUBFUNDACCNT_ENABLED.status).intValue()) continue;
                    CcsSubFundAccount subFundAccount = (CcsSubFundAccount)this.of.create(CcsSubFundAccount.class);
                    subFundAccount.update((Object)subFundAccnt);
                    subFundAccount.setMarketGrp("CCS");
                    subFundAccount.setPortfolioName(portfolioName);
                    this.replaceExtAccntId((FundAccount)subFundAccount);
                    this.subFundList.add((MxObject)subFundAccount);
                    PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
                    newBuilder2.setSubAccntId(subFundAccnt.getSubAccntId());
                    List subSecAccounts = this.secAccountApi.getSubSecAccounts("CCS", newBuilder2.build());
                    LinkedList subSecAccountList = new LinkedList();
                    subSecAccounts.forEach(secItem -> {
                        if (secItem.getStatus() == Integer.valueOf(PortfolioStatus.SUBSECACCNT_ENABLED.status).intValue()) {
                            CcsSubSecAccount subSecAccount = (CcsSubSecAccount)this.of.create(CcsSubSecAccount.class);
                            subSecAccount.update(secItem);
                            subSecAccount.setPortfolioName(portfolioName);
                            subSecAccount.setInverstorId(subFundAccount.getInvestId());
                            subSecAccountList.add(subSecAccount);
                        }
                    });
                    subSecAccountList.stream().sorted((e1, e2) -> 1);
                    Collections.sort(subSecAccountList);
                    map.put(subFundAccount, new LinkedList(subSecAccountList));
                    available += subFundAccount.getAvailable();
                    hkAvailable += subFundAccount.getHkAvailable();
                }
            }
            portfolio.setAvailable(available);
            portfolio.setHkAvailable(hkAvailable);
            this.portfolioAccntMap.put(portfolio.getId(), map);
        }
        logger.info("portfolio query success, portfolio size : " + this.portfolioList.size());
        this.changed();
        this.buildAccntSecMap();
    }

    private void replaceExtAccntId(FundAccount item) {
        GetExtCashAccntsReq getCashAccReq = new GetExtCashAccntsReq();
        getCashAccReq.setAccntId(item.getParentId());
        getCashAccReq.setMarketGroup(item.getMarketGrp());
        List extCashAccnts = null;
        try {
            extCashAccnts = this.newAccntApi.getExtCashAccnts(getCashAccReq);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u8d44\u91d1\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
        if (extCashAccnts != null && !extCashAccnts.isEmpty()) {
            item.update(extCashAccnts.get(0));
        }
    }

    private void buildAccntSecMap() {
        this.idAccMap.clear();
        this.idnewAccMap.clear();
        this.idMarketSecMap.clear();
        this.idAccPortMap.clear();
        this.investorIdCounterMap.clear();
        this.idMarketSecPortMap.clear();
        this.getSubFundSecMap();
        this.subFundSecMap.forEach((ccsFundAccount, secAccounts) -> {
            if (ccsFundAccount instanceof CcsSubFundAccount) {
                CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                this.idAccMap.put(subFundAccnt.getSubAccntId(), subFundAccnt);
                this.idnewAccMap.put(subFundAccnt.getParentId(), subFundAccnt);
                this.idAccPortMap.put(String.valueOf(subFundAccnt.getExtAccntId()) + subFundAccnt.getPortfolioId(), (CcsFundAccount)subFundAccnt);
                this.investorIdCounterMap.put(subFundAccnt.getInvestId(), CounterNameUtils.getCounterName((String)subFundAccnt.getInvestId(), (String)subFundAccnt.getCounterId()));
                for (SecAccount secAccount : secAccounts) {
                    if (!(secAccount instanceof CcsSubSecAccount)) continue;
                    CcsSubSecAccount subSecAccnt = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                    this.idMarketSecMap.put(String.valueOf(subSecAccnt.getSubSecAccntId()) + subSecAccnt.getExchange().getRaw(), subSecAccnt);
                    this.idMarketSecPortMap.put(String.valueOf(subSecAccnt.getExtSecAccntId()) + subSecAccnt.getExchange().getRaw() + subSecAccnt.getPortfolioId(), subSecAccnt);
                }
            }
        });
    }

    public void updateSubFundAccnt() {
        try {
            LinkedList<CcsSubFundAccount> listSrc = new LinkedList<CcsSubFundAccount>();
            for (Portfolio portfolio : this.getPortfolios()) {
                double available = 0.0;
                double hkAvailable = 0.0;
                List assignDetails = this.portfolioApi.getAccntsByPortfolioIds(portfolio.getId());
                for (PPortfolio.PortAccntAssignDetails assignDetail : assignDetails) {
                    if (assignDetail.getAssignStatus() == Integer.valueOf(PortfolioStatus.ASSIGNSTATUS_DISABLED.status).intValue()) continue;
                    PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
                    newBuilder.setPortfolioId(portfolio.getId());
                    newBuilder.setParentExtAccntId(assignDetail.getParentId());
                    newBuilder.setParentSubAccntId(assignDetail.getAccountId());
                    String portfolioName = this.getPortfolioNameById(portfolio.getId());
                    List subFundAccountList = this.fundAccountApi.getSubFundAccountList("CCS", newBuilder.build());
                    for (PAccount.SubFundAccnt subFundAccnt : subFundAccountList) {
                        if (subFundAccnt.getStatus() == Integer.valueOf(PortfolioStatus.SUBFUNDACCNT_DISABLED.status).intValue()) continue;
                        CcsSubFundAccount subFundAccount = (CcsSubFundAccount)this.of.create(CcsSubFundAccount.class);
                        subFundAccount.update((Object)subFundAccnt);
                        subFundAccount.setMarketGrp("CCS");
                        subFundAccount.setPortfolioName(portfolioName);
                        available += subFundAccount.getAvailable();
                        hkAvailable += subFundAccount.getHkAvailable();
                        listSrc.add(subFundAccount);
                        if (this.subFundList.getList().contains((Object)subFundAccount)) continue;
                        PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
                        newBuilder2.setSubAccntId(subFundAccnt.getSubAccntId());
                        List subSecAccounts = this.secAccountApi.getSubSecAccounts("CCS", newBuilder2.build());
                        LinkedList subSecAccountList = new LinkedList();
                        subSecAccounts.forEach(secItem -> {
                            if (secItem.getStatus() == Integer.valueOf(PortfolioStatus.SUBSECACCNT_ENABLED.status).intValue()) {
                                CcsSubSecAccount subSecAccount = (CcsSubSecAccount)this.of.create(CcsSubSecAccount.class);
                                subSecAccount.update(secItem);
                                subSecAccount.setPortfolioName(portfolioName);
                                subSecAccount.setInverstorId(subFundAccount.getInvestId());
                                subSecAccountList.add(subSecAccount);
                            }
                        });
                        this.subFundList.add((MxObject)subFundAccount);
                        this.portfolioAccntMap.get(portfolio.getId()).put((CcsFundAccount)subFundAccount, subSecAccountList);
                    }
                }
                portfolio.setAvailable(available);
                portfolio.setHkAvailable(hkAvailable);
            }
            ArrayList oldList = new ArrayList();
            oldList.addAll(this.subFundList.getList());
            oldList.removeAll(listSrc);
            for (CcsSubFundAccount ccsSubFundAccount : oldList) {
                this.portfolioAccntMap.get(ccsSubFundAccount.getPortfolioId()).remove(ccsSubFundAccount);
            }
            this.recordAssetAmountAndUpdate(listSrc);
            this.changed();
            this.buildAccntSecMap();
        }
        catch (MException mException) {
            logger.error("\u5237\u65b0\u7bee\u5b50\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void recordAssetAmountAndUpdate(List<CcsSubFundAccount> listSrc) {
        HashMap assetMap = new HashMap();
        this.subFundList.getList().forEach(each -> assetMap.put(each.getSubAccntId(), each.getAssetAmt()));
        this.subFundList.update(listSrc);
        this.subFundList.getList().forEach(each -> {
            if (assetMap.get(each.getSubAccntId()) != null) {
                each.setAssetAmt(((Double)assetMap.get(each.getSubAccntId())).doubleValue());
            }
        });
    }

    public Map<CcsFundAccount, List<SecAccount>> getMap(Portfolio portfolio) {
        this.checkQuery();
        return this.portfolioAccntMap.get(portfolio.getId());
    }

    private synchronized void checkQuery() {
        if (this.firstQueryFlag.get()) {
            try {
                this.firstQueryFlag.set(false);
                this.queryPortfolios();
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u5168\u91cf\u6295\u7ec4\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public Map<CcsFundAccount, List<SecAccount>> getMap(String portfolioId) {
        this.checkQuery();
        return this.portfolioAccntMap.get(portfolioId);
    }

    public List<CcsSubFundAccount> getFundAccounts() {
        this.checkQuery();
        return this.subFundList.getList();
    }

    public CcsSubFundAccount getFundAccount(String subFundAccntId, String marketGrp) {
        this.checkQuery();
        for (CcsSubFundAccount subFundAccount : this.subFundList.getList()) {
            if (!subFundAccount.getSubAccntId().equals(subFundAccntId) || !subFundAccount.getMarketGrp().equals(marketGrp)) continue;
            return subFundAccount;
        }
        return null;
    }

    public List<String> getPortfolioIds() throws MException {
        return this.portfolioApi.getPortfolioIdsByPost(this.bmi.getPostId());
    }

    public synchronized List<Portfolio> getPortfolios() {
        try {
            if (this.firstQueryFlag.get()) {
                this.firstQueryFlag.set(false);
                this.queryPortfolios();
            }
        }
        catch (MException e) {
            logger.error("portfolio query failed ", (Throwable)e);
        }
        catch (Exception ee) {
            logger.error("portfolio query failed " + ee.getMessage());
        }
        List<Portfolio> portfs = this.portfolioList.stream().filter(item -> !item.isExternalAsset()).collect(Collectors.toList());
        return portfs;
    }

    public void refreshExtAvailable() {
        if (RefItem.getMediumRate() == 0.0) {
            this.hkRetaMng.loadRefRate();
        }
        this.exe.execute(() -> {
            GetPortfolioAssetReq req = new GetPortfolioAssetReq();
            req.setBeginDate(DateTimeUtils.getDate());
            req.setEndDate(DateTimeUtils.getDate());
            req.setPostId(this.bmi.getPostId());
            req.setType("1");
            List portfolios = this.getPortfoliosAll().stream().filter(item -> item.isExternalAsset()).collect(Collectors.toList());
            ArrayList<String> portfIds = new ArrayList<String>();
            for (Portfolio portfolio : portfolios) {
                portfIds.add(portfolio.getId());
            }
            req.setPortfolioId(portfIds);
            try {
                PortfolioAssets portfolioAssets = this.assetApi.getPortfolioAssets(req);
                for (PortfolioAsset asset : portfolioAssets.getList()) {
                    for (Portfolio portfolio : portfolios) {
                        if (!portfolio.getId().equals(asset.getPortfolioId())) continue;
                        portfolio.setExtAvailable(asset.getMoneyTotal().doubleValue());
                        portfolio.setHkExtAvailable(asset.getMoneyTotal() / (RefItem.getMediumRate() == 0.0 ? 1.0 : RefItem.getMediumRate()));
                    }
                }
                portfolioAssets.getList();
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u6295\u7ec4\u5916\u90e8\u8d44\u4ea7\u8d44\u91d1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public synchronized List<Portfolio> getPortfoliosAll() {
        this.getPortfolios();
        return this.portfolioList;
    }

    public synchronized List<Portfolio> getExternalPortfolios() {
        this.getPortfolios();
        this.externalAssetPortfolioList.clear();
        for (Portfolio po : this.portfolioList) {
            if (!po.isExternalAsset()) continue;
            this.externalAssetPortfolioList.add(po);
        }
        return this.externalAssetPortfolioList;
    }

    public Set<String> getTradersByWorkflowId(String workflowAttrId) {
        this.lock.lock();
        try {
            if (!this.initWorkflowTraderMap.get()) {
                CountDownLatch cdl = new CountDownLatch(2);
                this.exe.execute(() -> this.initPortfolioValue(cdl));
                this.exe.execute(() -> this.initFundValue(cdl));
                cdl.await(30L, TimeUnit.SECONDS);
            }
            Set set = this.workflowPostMap.get(workflowAttrId);
            return set;
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6307\u4ee4\u6d41\u4ea4\u6613\u5458\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.initWorkflowTraderMap.set(true);
            this.lock.unlock();
        }
        return null;
    }

    private void initFundValue(CountDownLatch cdl) {
        Map<CcsFundAccount, List<SecAccount>> accountMap = null;
        Map<CtpFundAccount, List<SecAccount>> ctpAccMap = null;
        try {
            try {
                accountMap = this.ccsAccountMap.getAccountMap();
                ctpAccMap = this.ctpAccountMap.getAccountMap();
                ArrayList<Object> fundAccs = new ArrayList<Object>();
                if (accountMap != null) {
                    fundAccs.addAll(accountMap.keySet());
                }
                if (ctpAccMap != null) {
                    fundAccs.addAll(ctpAccMap.keySet());
                }
                for (FundAccount fundAccount : fundAccs) {
                    try {
                        WorkFlowDescriptor wf = this.wfService.getFlowAssignInfoViaAccntId(fundAccount.getParentId(), BsDict.INSTRUCT_OBJ_TYPE_ACCOUNT);
                        if (wf == null || wf.getId() != 4) continue;
                        List stepPostIds = new ArrayList();
                        List stepList = wf.getSteps();
                        for (AccntStepAttribute step : stepList) {
                            if (step.getStepId() != 3) continue;
                            stepPostIds = step.getObjIds();
                        }
                        this.workflowPostMap.put(String.valueOf(wf.getWorkflowAttrId()), new HashSet(stepPostIds));
                    }
                    catch (MException e) {
                        logger.error("\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            catch (MException | Exception e) {
                logger.error("\u83b7\u53d6\u8d44\u91d1\u8d26\u53f7\u5931\u8d25", e);
                cdl.countDown();
            }
        }
        finally {
            cdl.countDown();
        }
    }

    private void initPortfolioValue(CountDownLatch cdl) {
        try {
            List<Portfolio> portfolios = this.getPortfolios();
            for (Portfolio portfo : portfolios) {
                try {
                    WorkFlowDescriptor wf = this.wfService.getFlowAssignInfoViaAccntId(portfo.getId(), BsDict.INSTRUCT_OBJ_TYPE_PORTFOLIO);
                    if (wf == null || wf.getId() != 7 && wf.getId() != 4) continue;
                    List stepPostIds = new ArrayList();
                    List stepList = wf.getSteps();
                    for (AccntStepAttribute step : stepList) {
                        if ((step.getStepId() != 4 || wf.getId() != 7) && (step.getStepId() != 3 || wf.getId() != 4)) continue;
                        stepPostIds = step.getObjIds();
                    }
                    this.workflowPostMap.put(String.valueOf(wf.getWorkflowAttrId()), new HashSet(stepPostIds));
                }
                catch (MException e) {
                    logger.error("\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        finally {
            cdl.countDown();
        }
    }

    private synchronized void queryPortfolios() throws MException {
        this.portfolioList.clear();
        List<String> portfolioIds = this.getPortfolioIds();
        for (String portfolioId : portfolioIds) {
            Portfolio portfolio = this.portfolioService.getPortfolioById(portfolioId);
            this.portFolioMap.put(portfolioId, portfolio);
            if (portfolio == null || !portfolio.getStatus().getRaw().equals(PortfolioStatus.PORTFOLIO_ENABLED.status)) continue;
            this.portfolioList.add(portfolio);
        }
        this.query();
    }

    public String getPortfolioNameById(String portfolioId) {
        if (!this.portFolioMap.containsKey(portfolioId)) {
            try {
                Portfolio portfolio = this.portfolioService.getPortfolioById(portfolioId);
                this.portFolioMap.put(portfolioId, portfolio);
            }
            catch (MException e) {
                logger.error("\u6839\u636e\u6295\u7ec4id\u67e5\u8be2\u6295\u7ec4\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
        return this.portFolioMap.containsKey(portfolioId) ? this.portFolioMap.get(portfolioId).getName() : "";
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getSubFundSecMap() {
        if (!this.subFundSecMap.isEmpty()) {
            return this.subFundSecMap;
        }
        this.portfolioAccntMap.forEach((portfolioId, ccsFundAccountMap) -> this.subFundSecMap.putAll((Map<CcsFundAccount, List<SecAccount>>)ccsFundAccountMap));
        return this.subFundSecMap;
    }

    public Set<String> getInvestorSecIds() {
        Collection<CcsSubSecAccount> secAccs = this.idMarketSecMap.values();
        HashSet<String> ids = new HashSet<String>();
        for (SecAccount secAccount : secAccs) {
            ids.add(secAccount.getInverstorSecId());
        }
        return ids;
    }

    public CcsSubFundAccount getSubFundAccountById(String subAccntId) {
        this.checkQuery();
        return this.idAccMap.get(subAccntId);
    }

    public String getNewSubFundAccountById(String subAccntId) {
        this.checkQuery();
        if (this.idnewAccMap.get(subAccntId) != null) {
            return this.idnewAccMap.get(subAccntId).getInvestId();
        }
        return "";
    }

    public CcsSubSecAccount getSubSecAccountByIdAndMarket(String subSecId, String market) {
        this.checkQuery();
        return this.idMarketSecMap.get(String.valueOf(subSecId) + market);
    }

    public CcsFundAccount getSubFundAccountByExtIdAndPortId(String extAccntId, String portfolioId) {
        this.checkQuery();
        return this.idAccPortMap.get(String.valueOf(extAccntId) + portfolioId);
    }

    public Map<String, String> getInvestorIdCounterMap() {
        this.checkQuery();
        return this.investorIdCounterMap;
    }

    public CcsSubSecAccount getSubSecAccountByExtIdAndMarketAndPortId(String extSecId, String market, String portfolioId) {
        this.checkQuery();
        return this.idMarketSecPortMap.get(String.valueOf(extSecId) + market + portfolioId);
    }

    public static enum PortfolioStatus {
        ASSIGNSTATUS_ENABLED("1", "\u6b63\u5e38\u5173\u8054"),
        ASSIGNSTATUS_DISABLED("2", "\u53d6\u6d88\u5173\u8054"),
        SUBFUNDACCNT_ENABLED("1", "\u542f\u7528"),
        SUBFUNDACCNT_DISABLED("0", "\u505c\u7528"),
        SUBSECACCNT_ENABLED("1", "\u542f\u7528"),
        SUBSECACCNT_DISABLED("0", "\u505c\u7528"),
        PORTFOLIO_ENABLED("1", "\u542f\u7528"),
        PORTFOLIO_DISABLED("3", "\u505c\u7528");

        public String status;
        public String desc;

        private PortfolioStatus(String status, String desc) {
            this.status = status;
            this.desc = desc;
        }
    }
}

