/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsPositionModel;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PledgePositionModel
extends MxModel {
    @Inject
    private IRefDataMng refMng;
    @Inject
    private CcsPositionModel mPosition;
    private Map<String, PledgeInfo> mapPledge = new ConcurrentHashMap<String, PledgeInfo>();
    private InvalidationListener lstnRefMng = ob -> this.loadRefItems();
    private InvalidationListener lstnChanged = ob -> this.changed();

    public Double getMultiMap(String market, String code) {
        if (this.mapPledge.get(String.valueOf(market) + code) != null) {
            return this.mapPledge.get(String.valueOf(market) + code).getMultiplier();
        }
        return 0.0;
    }

    private synchronized void loadRefItems() {
        Collection list = this.refMng.getItems(new String[]{"PLEDGE"});
        for (RefItem item : list) {
            if (!(item instanceof PledgeInfo)) continue;
            PledgeInfo info = (PledgeInfo)PledgeInfo.class.cast(item);
            this.mapPledge.put(String.valueOf(info.getMarket()) + info.getSecCode(), info);
        }
    }

    @PostConstruct
    public void init() {
        this.loadRefItems();
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefMng));
        this.mPosition.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnChanged));
    }

    public void query() {
        this.mPosition.query();
    }

    public ObservableList<CcsPosition> getList() {
        ObservableList list = FxUtils.newList();
        for (CcsPosition item : this.mPosition.getList()) {
            PledgeInfo info = this.mapPledge.get(String.valueOf(item.getMarket().getRaw()) + item.getSecId());
            if (info == null) continue;
            item.setRefItem(info);
            list.add((Object)item);
        }
        return list;
    }

    public double getCcsCanIn(SecAccount secAcc, String code) {
        CcsPosition pos = this.getCcsPosition(secAcc, code);
        if (pos != null) {
            return pos.getCanVol();
        }
        return 0.0;
    }

    public double getCcsTotal(SecAccount secAcc, String code) {
        CcsPosition pos = this.getCcsPosition(secAcc, code);
        if (pos != null) {
            return pos.getTotalVol();
        }
        return 0.0;
    }

    public double getCcsCanOut(SecAccount secAcc, String code, String security) {
        CcsPosition pos = this.getCcsPosition(secAcc, security);
        if (pos != null) {
            double multiplier = this.getMultiMap(pos.getMarket().getRaw(), pos.getSecId());
            if (multiplier == 0.0) {
                return 0.0;
            }
            String market = pos.getMarket().getRaw();
            PledgeInfo pleInfo = (PledgeInfo)this.refMng.getItem("PLEDGE", market, code);
            if (pleInfo == null) {
                this.logger.error(String.valueOf(market) + code + "\u672a\u53d6\u5230\u9759\u6001\u884c\u60c5");
                return 0.0;
            }
            CcsPosition position = this.mPosition.getPosition(pos.getExtSecAccId(), pleInfo.getStdCode());
            if (position == null) {
                return 0.0;
            }
            double canVol = position.getCanVolDouble();
            double availImpawnOut = pos.getAvailImpawnOut();
            if ("XSHE".equals(position.getMarket().getRaw())) {
                if (pleInfo.getParValue() == 0.0) {
                    this.logger.error(String.valueOf(pleInfo.getCode()) + "|" + pleInfo.getMarket() + "\u9762\u503c\u4e3a0");
                    return 0.0;
                }
                double calCount = canVol * 100.0 / (multiplier * pleInfo.getParValue());
                return new BigDecimal(calCount < availImpawnOut ? calCount : availImpawnOut).intValue();
            }
            if (canVol / multiplier < availImpawnOut) {
                return new BigDecimal(canVol / multiplier).intValue();
            }
            return new BigDecimal(availImpawnOut).intValue();
        }
        return 0.0;
    }

    public CcsPosition getCcsPosition(SecAccount secAcc, String code) {
        return this.mPosition.getPositionInMap(secAcc, code);
    }

    public CcsPosition getCcsPosition(String secAcc, String code) {
        return this.mPosition.getPosition(secAcc, code);
    }
}

