/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.notice.AssetReport;
import cms.tmx.entity.trade.PreFrozenFundAccnt;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.http.accnt.GetExtCashAccntsReq;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.OtcOrderDetail;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IPortfolioService;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.BooleanProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OtcPortfolioAccountModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(OtcPortfolioAccountModel.class);
    private Map<String, Map<CcsFundAccount, List<SecAccount>>> portfolioAccntMap = new HashMap<String, Map<CcsFundAccount, List<SecAccount>>>(20);
    @Inject
    private IBaseApi bmi;
    @Inject
    private IPortfolioApi portfolioApi;
    @Inject
    private IPortfolioService portfolioService;
    @Inject
    private IFundAccountApi fundAccountApi;
    @Inject
    private ISecAccountApi secAccountApi;
    @Inject
    private MObjFactory of;
    @Inject
    private MScheduler sdRefresh;
    @Inject
    protected MEventService es;
    @Inject
    private IAccountService ias;
    private Map<String, PPortfolio.Portfolio> portFolioMap = new HashMap<String, PPortfolio.Portfolio>();
    private Map<CcsFundAccount, List<SecAccount>> subFundSecMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private Map<String, CcsSubFundAccount> idAccMap = new HashMap<String, CcsSubFundAccount>();
    private Map<String, CcsSubFundAccount> idParentMap = new HashMap<String, CcsSubFundAccount>();
    private Map<String, CcsSubSecAccount> idMarketSecMap = new HashMap<String, CcsSubSecAccount>();
    private Map<String, CcsFundAccount> idAccPortMap = new HashMap<String, CcsFundAccount>();
    private Map<String, CcsSubSecAccount> idMarketSecPortMap = new HashMap<String, CcsSubSecAccount>();
    private List<Portfolio> portfolioList = new LinkedList<Portfolio>();
    private MxList<CcsSubFundAccount> subFundList = new MxList();
    private AtomicBoolean firstQueryFlag = new AtomicBoolean(true);
    private Set<CcsSubFundAccount> setAccToBeQuery = new HashSet<CcsSubFundAccount>();
    private ReentrantLock lockToBeQuery = new ReentrantLock();
    private MEventHandler handler = event -> this.onPush(event);
    private MEventHandler insHandler = event -> this.onInsPush(event);
    private MEventHandler handlerFrozen = event -> this.updatePreFrzFund(event);
    private Gson gson = new Gson();
    @Inject
    private AccountServiceApi newAccntApi;

    private void replaceExtAccntId(FundAccount item) {
        GetExtCashAccntsReq getCashAccReq = new GetExtCashAccntsReq();
        getCashAccReq.setAccntId(item.getParentId());
        if ("99999-01-01".equals(item.getCounterId())) {
            getCashAccReq.setMarketGroup("CCS");
        } else if ("99999-04-01".equals(item.getCounterId()) || "55555-04-01".equals(item.getCounterId())) {
            getCashAccReq.setMarketGroup("OTC");
        }
        List extCashAccnts = null;
        try {
            extCashAccnts = this.newAccntApi.getExtCashAccnts(getCashAccReq);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u8d44\u91d1\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
        if (extCashAccnts != null && !extCashAccnts.isEmpty()) {
            item.update(extCashAccnts.get(0));
        }
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("server.sub", this.handler);
        this.es.subscribe("pre_frozen_fund", event -> this.updatePreFrzFund(event));
        this.es.subscribe("uap.push.InsEvent", this.insHandler);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("server.sub", this.handler);
        this.es.unSubscribe("pre_frozen_fund", this.handlerFrozen);
        this.es.unSubscribe("uap.push.InsEvent", this.insHandler);
    }

    private void updatePreFrzFund(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof PreFrozenFundAccnt)) {
            return;
        }
        PreFrozenFundAccnt fundAccnts = (PreFrozenFundAccnt)PreFrozenFundAccnt.class.cast(obj);
        Set subAccnts = fundAccnts.getSubFundAccntsToUpdate();
        for (CcsSubFundAccount subFund : subAccnts) {
            this.addToBeQuery(subFund);
        }
        this.runQuerySpec();
    }

    private void onInsPush(MEvent event) {
        try {
            OtcOrderDetail otcDetail;
            Object detail;
            JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
            HttpInsPushMessage insPushMsg = (HttpInsPushMessage)this.gson.fromJson(pushMsg.toString(), HttpInsPushMessage.class);
            if (insPushMsg != null && insPushMsg.getInstruction() != null && "FundDetail".equals(insPushMsg.getInstruction().getType()) && (detail = Optional.ofNullable(insPushMsg).map(item -> item.getInstruction()).map(item -> item.getDetail()).orElseThrow(() -> new Exception("\u6307\u4ee4\u63a8\u9001\u66f4\u65b0\u573a\u5916\u57fa\u91d1\u6295\u7ec4\u53ef\u7528\u8d44\u91d1\u51fa\u9519"))) instanceof LinkedTreeMap && AccntLevel.ACCNT_LEVEL_SUB == (otcDetail = (OtcOrderDetail)this.gson.fromJson(this.gson.toJson(detail), OtcOrderDetail.class)).getAccntLevel()) {
                String subFundAccId = Optional.ofNullable(otcDetail).map(item -> (AccntSecInfo)item.getAccntSecInfo().get(0)).map(item -> item.getAccountId()).map(item -> item.getCashAccntId()).orElseThrow(() -> new Exception("\u6307\u4ee4\u63a8\u9001\u66f4\u65b0\u573a\u5916\u57fa\u91d1\u6295\u7ec4\u53ef\u7528\u8d44\u91d1\u51fa\u9519"));
                if (StringUtils.isEmpty((String)subFundAccId)) {
                    return;
                }
                CcsSubFundAccount subFundAcc = this.getFundAccount(subFundAccId, insPushMsg.getMarketGroup());
                if (subFundAcc != null) {
                    this.addToBeQuery(subFundAcc);
                }
                this.runQuerySpec();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void onPush(MEvent event) {
        if (event.getObj() instanceof AssetReport) {
            this.onAssetPush((AssetReport)AssetReport.class.cast(event.getObj()));
            return;
        }
    }

    private void addToBeQuery(CcsSubFundAccount acc) {
        this.lockToBeQuery.lock();
        try {
            this.setAccToBeQuery.add(acc);
        }
        finally {
            this.lockToBeQuery.unlock();
        }
    }

    private void runQuerySpec() {
        this.sdRefresh.schedule(event -> {
            try {
                this.queryToBeQuery();
            }
            catch (MException e) {
                logger.error("query spec fund account failed", (Throwable)e);
            }
        });
    }

    private void queryToBeQuery() throws MException {
        this.lockToBeQuery.lock();
        LinkedList<CcsSubFundAccount> listAcc = new LinkedList<CcsSubFundAccount>();
        try {
            listAcc.addAll(this.setAccToBeQuery);
            this.setAccToBeQuery.clear();
        }
        finally {
            this.lockToBeQuery.unlock();
        }
        for (CcsSubFundAccount acc : listAcc) {
            this.updateFundAcc(acc);
        }
    }

    private void updateFundAcc(CcsSubFundAccount subFundAcc) throws MException {
        subFundAcc.update((Object)this.querySubFundAccount(subFundAcc));
        String portfolioName = this.getPortfolioNameById(subFundAcc.getPortfolioId());
        subFundAcc.setMarketGrp(subFundAcc.getMarketGrp());
        subFundAcc.setPortfolioName(portfolioName);
        this.updatePortfolioAvailable(subFundAcc);
        this.changed();
    }

    private void updatePortfolioAvailable(CcsSubFundAccount subFundAcc) {
        Portfolio portfolio = this.getPortfolio(subFundAcc.getPortfolioId(), subFundAcc.getMarketGrp());
        double available = 0.0;
        for (CcsFundAccount ccsFundAccount : this.getMap(portfolio).keySet()) {
            available += ccsFundAccount.getAvailable();
        }
        portfolio.setAvailable(available);
    }

    private PAccount.SubFundAccnt querySubFundAccount(CcsSubFundAccount subFundAcc) throws MException {
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setSubAccntId(subFundAcc.getSubAccntId());
        List subFundAccountList = this.fundAccountApi.getSubFundAccountList(subFundAcc.getMarketGrp(), newBuilder.build());
        return (PAccount.SubFundAccnt)subFundAccountList.get(0);
    }

    private void onAssetPush(AssetReport report) {
        if (StringUtils.isEmpty((String)report.getReport().getPortfolioId())) {
            return;
        }
        if ("P0000287".equals(report.getReport().getPortfolioId())) {
            System.err.println();
        }
        double available = 0.0;
        for (PAssetService.AssetField each : report.getReport().getAssetList()) {
            if (!each.getSecType().equals("CASH")) continue;
            available = each.getAssetAmount();
            break;
        }
        double money = available;
        if (StringUtils.isEmpty((String)report.getReport().getSubAccntId())) {
            this.udpatePortfolioAsset(report.getReport().getPortfolioId(), report.getReport().getMarketGrp(), report.getReport().getTotalAmount(), money);
        } else {
            this.udpateSubFundAsset(report.getReport().getPortfolioId(), report.getReport().getSubAccntId(), report.getReport().getMarketGrp(), report.getReport().getTotalAmount(), money);
        }
    }

    public BooleanProperty changedProperty() {
        return super.changedProperty();
    }

    private void udpateSubFundAsset(String portfolioId, String subAccntId, String marketGrp, double assetAmt, double available) {
        this.checkQuery();
        for (CcsSubFundAccount acc : this.subFundList.getList()) {
            if (!acc.getSubAccntId().equals(subAccntId) || !acc.getMarketGrp().equals(marketGrp)) continue;
            acc.setAssetAmt(assetAmt);
            acc.setAvailable(available);
        }
        this.changed();
    }

    private void udpatePortfolioAsset(String portfolioId, String marketGrp, double assetAmt, double available) {
        Portfolio portfolio = this.getPortfolio(portfolioId, marketGrp);
        if (portfolio == null) {
            return;
        }
        portfolio.setAssetAmt(assetAmt);
        portfolio.setAvailable(available);
        this.changed();
    }

    public Portfolio getPortfolio(String portfolioId, String marketGrp) {
        for (Portfolio portfolio : this.portfolioList) {
            if (!portfolioId.equals(portfolio.getId())) continue;
            return portfolio;
        }
        return null;
    }

    public synchronized void query() throws MException {
        this.portfolioAccntMap.clear();
        this.subFundList.clear();
        this.cachePortfolioName();
        for (Portfolio portfolio : this.portfolioList) {
            HashMap map = new HashMap(20);
            double available = 0.0;
            boolean flags = false;
            List assignDetails = this.portfolioApi.getAccntsByPortfolioIds(portfolio.getId());
            for (PPortfolio.PortAccntAssignDetails assignDetail : assignDetails) {
                Account accountFromCache;
                if (assignDetail.getAssignStatus() == Integer.valueOf(PortfolioStatus.ASSIGNSTATUS_DISABLED.status).intValue() || (accountFromCache = this.ias.getAccountFromCache(assignDetail.getParentId())) == null) continue;
                PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
                newBuilder.setPortfolioId(portfolio.getId());
                newBuilder.setParentExtAccntId(assignDetail.getParentId());
                newBuilder.setParentSubAccntId(assignDetail.getAccountId());
                String portfolioName = this.getPortfolioNameById(portfolio.getId());
                List subFundAccountList = new LinkedList();
                if ("99999-01-01".equals(accountFromCache.getTradePlatformId())) {
                    subFundAccountList = this.fundAccountApi.getSubFundAccountList("CCS", newBuilder.build());
                } else if ("99999-04-01".equals(accountFromCache.getTradePlatformId()) || "55555-04-01".equals(accountFromCache.getTradePlatformId())) {
                    subFundAccountList = this.fundAccountApi.getSubFundAccountList("OTC", newBuilder.build());
                }
                for (PAccount.SubFundAccnt subFundAccnt : subFundAccountList) {
                    if (subFundAccnt.getStatus() == Integer.valueOf(PortfolioStatus.SUBFUNDACCNT_DISABLED.status).intValue()) continue;
                    CcsSubFundAccount subFundAccount = (CcsSubFundAccount)this.of.create(CcsSubFundAccount.class);
                    subFundAccount.update((Object)subFundAccnt);
                    subFundAccount.setPortfolioName(portfolioName);
                    this.replaceExtAccntId((FundAccount)subFundAccount);
                    this.subFundList.add((MxObject)subFundAccount);
                    PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
                    newBuilder2.setSubAccntId(subFundAccnt.getSubAccntId());
                    List subSecAccounts = new LinkedList();
                    if ("99999-04-01".equals(subFundAccnt.getTradePlatformId()) || "55555-04-01".equals(accountFromCache.getTradePlatformId())) {
                        subFundAccount.setMarketGrp("OTC");
                        subSecAccounts = this.secAccountApi.getSubSecAccounts("OTC", newBuilder2.build());
                    } else if ("99999-01-01".equals(subFundAccnt.getTradePlatformId())) {
                        subFundAccount.setMarketGrp("CCS");
                        subSecAccounts = this.secAccountApi.getSubSecAccounts("CCS", newBuilder2.build());
                    }
                    LinkedList<CcsSubSecAccount> subSecAccountList = new LinkedList<CcsSubSecAccount>();
                    for (PAccount.SubSecAccnt secItem : subSecAccounts) {
                        if (secItem.getStatus() != Integer.valueOf(PortfolioStatus.SUBSECACCNT_ENABLED.status).intValue() || !"XOTC".equals(secItem.getMarket())) continue;
                        flags = true;
                        CcsSubSecAccount subSecAccount = (CcsSubSecAccount)this.of.create(CcsSubSecAccount.class);
                        subSecAccount.update((Object)secItem);
                        subSecAccount.setPortfolioName(portfolioName);
                        subSecAccountList.add(subSecAccount);
                    }
                    available += subFundAccount.getAvailable();
                    subSecAccountList.stream().sorted((e1, e2) -> 1);
                    Collections.sort(subSecAccountList);
                    map.put(subFundAccount, new LinkedList(subSecAccountList));
                }
            }
            portfolio.setAvailable(available);
            if (!flags) continue;
            this.portfolioAccntMap.put(portfolio.getId(), map);
        }
        logger.info("portfolio query success, portfolio size : " + this.portfolioList.size());
        this.changed();
        this.buildAccntSecMap();
    }

    private void buildAccntSecMap() {
        this.idAccMap.clear();
        this.idParentMap.clear();
        this.idMarketSecMap.clear();
        this.idAccPortMap.clear();
        this.idMarketSecPortMap.clear();
        LinkedList<String> list = new LinkedList<String>();
        this.getSubFundSecMap();
        for (CcsFundAccount ccsFundAccount : this.subFundSecMap.keySet()) {
            if (!(ccsFundAccount instanceof CcsSubFundAccount)) continue;
            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
            this.idAccMap.put(subFundAccnt.getSubAccntId(), subFundAccnt);
            this.idParentMap.put(subFundAccnt.getParentId(), subFundAccnt);
            this.idAccPortMap.put(String.valueOf(subFundAccnt.getExtAccntId()) + subFundAccnt.getPortfolioId(), (CcsFundAccount)subFundAccnt);
            for (SecAccount secAccount : this.subFundSecMap.get(ccsFundAccount)) {
                if (!(secAccount instanceof CcsSubSecAccount)) continue;
                CcsSubSecAccount subSecAccnt = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                this.idMarketSecMap.put(String.valueOf(subSecAccnt.getSubSecAccntId()) + subSecAccnt.getExchange().getRaw(), subSecAccnt);
                this.idMarketSecPortMap.put(String.valueOf(subSecAccnt.getExtSecAccntId()) + subSecAccnt.getExchange().getRaw() + subSecAccnt.getPortfolioId(), subSecAccnt);
            }
            list.add(subFundAccnt.getParentId());
        }
        MEvent event = new MEvent();
        event.put((Object)"OTC_ACCNT", list);
        this.es.postEvent("otc.accnt.sub", event);
    }

    private void cachePortfolioName() {
        try {
            List portfolioIds = this.portfolioApi.getPortfolioIdsByPost(this.bmi.getPostId());
            this.portfolioApi.getPortfoliosByIds(portfolioIds).forEach(portfolio -> this.portFolioMap.put(portfolio.getPortfolio().getPortfolioId(), portfolio.getPortfolio()));
        }
        catch (MException e) {
            logger.error("\u7f13\u5b58\u6295\u7ec4\u4fe1\u606f(\u5c55\u793a\u4e2d\u6587\u540d\u79f0\u7528)\u5931\u8d25" + e.getMessage());
        }
    }

    public Map<CcsFundAccount, List<SecAccount>> getMap(Portfolio portfolio) {
        this.checkQuery();
        return this.portfolioAccntMap.get(portfolio.getId());
    }

    private synchronized void checkQuery() {
        if (this.firstQueryFlag.get()) {
            try {
                this.firstQueryFlag.set(false);
                this.queryPortfolios();
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u5168\u91cf\u6295\u7ec4\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public Map<CcsFundAccount, List<SecAccount>> getMap(String portfolioId) {
        this.checkQuery();
        return this.portfolioAccntMap.get(portfolioId);
    }

    public List<CcsSubFundAccount> getFundAccounts() {
        this.checkQuery();
        return this.subFundList.getList();
    }

    public CcsSubFundAccount getFundAccount(String subFundAccntId, String marketGrp) {
        this.checkQuery();
        for (CcsSubFundAccount subFundAccount : this.subFundList.getList()) {
            if (!subFundAccount.getSubAccntId().equals(subFundAccntId) || !subFundAccount.getMarketGrp().equals(marketGrp)) continue;
            return subFundAccount;
        }
        return null;
    }

    public List<String> getPortfolioIds() throws MException {
        return this.portfolioApi.getPortfolioIdsByPost(this.bmi.getPostId());
    }

    public synchronized List<Portfolio> getPortfolios() {
        try {
            if (this.firstQueryFlag.get()) {
                this.firstQueryFlag.set(false);
                this.queryPortfolios();
            }
        }
        catch (MException e) {
            logger.error("portfolio query failed ", (Throwable)e);
        }
        catch (Exception ee) {
            logger.error("portfolio query failed " + ee.getMessage());
        }
        return this.portfolioList;
    }

    private synchronized void queryPortfolios() throws MException {
        this.portfolioList.clear();
        List<String> portfolioIds = this.getPortfolioIds();
        for (String portfolioId : portfolioIds) {
            Portfolio portfolio = this.portfolioService.getPortfolioById(portfolioId);
            if (portfolio == null || StringUtils.isEmpty((String)portfolio.getId()) || !portfolio.getStatus().getRaw().equals(PortfolioStatus.PORTFOLIO_ENABLED.status)) continue;
            this.portfolioList.add(portfolio);
        }
        this.query();
    }

    public String getPortfolioNameById(String portfolioId) {
        if (!this.portFolioMap.containsKey(portfolioId)) {
            try {
                this.portfolioApi.getPortfoliosByIds(Arrays.asList(portfolioId)).forEach(item -> this.portFolioMap.put(item.getPortfolio().getPortfolioId(), item.getPortfolio()));
            }
            catch (MException e) {
                logger.error("\u6839\u636e\u6295\u7ec4id\u67e5\u8be2\u6295\u7ec4\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
        return this.portFolioMap.containsKey(portfolioId) ? this.portFolioMap.get(portfolioId).getPortfolioName() : "";
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getSubFundSecMap() {
        if (!this.subFundSecMap.isEmpty()) {
            return this.subFundSecMap;
        }
        for (String portfolioId : this.portfolioAccntMap.keySet()) {
            this.subFundSecMap.putAll(this.portfolioAccntMap.get(portfolioId));
        }
        return this.subFundSecMap;
    }

    public CcsSubFundAccount getSubFundAccountById(String subAccntId) {
        return this.idAccMap.get(subAccntId);
    }

    public CcsSubFundAccount getSubFundAccountByParentId(String parentId) {
        return this.idParentMap.get(parentId);
    }

    public CcsSubSecAccount getSubSecAccountByIdAndMarket(String subSecId, String market) {
        return this.idMarketSecMap.get(String.valueOf(subSecId) + market);
    }

    public CcsFundAccount getSubFundAccountByExtIdAndPortId(String extAccntId, String portfolioId) {
        return this.idAccPortMap.get(String.valueOf(extAccntId) + portfolioId);
    }

    public CcsSubSecAccount getSubSecAccountByExtIdAndMarketAndPortId(String extSecId, String market, String portfolioId) {
        return this.idMarketSecPortMap.get(String.valueOf(extSecId) + market + portfolioId);
    }

    public static enum PortfolioStatus {
        ASSIGNSTATUS_ENABLED("1", "\u6b63\u5e38\u5173\u8054"),
        ASSIGNSTATUS_DISABLED("2", "\u53d6\u6d88\u5173\u8054"),
        SUBFUNDACCNT_ENABLED("1", "\u542f\u7528"),
        SUBFUNDACCNT_DISABLED("0", "\u505c\u7528"),
        SUBSECACCNT_ENABLED("1", "\u542f\u7528"),
        SUBSECACCNT_DISABLED("0", "\u505c\u7528"),
        PORTFOLIO_ENABLED("1", "\u542f\u7528"),
        PORTFOLIO_DISABLED("3", "\u505c\u7528");

        public String status;
        public String desc;

        private PortfolioStatus(String status, String desc) {
            this.status = status;
            this.desc = desc;
        }
    }
}

