/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.mng.OrderMng;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OrderQueryModel<T extends Order>
extends MxModel {
    protected static final Logger logger = LogManager.getLogger(OrderQueryModel.class);
    protected String marketGroup;
    protected Map<FundAccount, OrderMng> mapQuery = new ConcurrentHashMap<FundAccount, OrderMng>();
    @Inject
    protected IFundAccountService faccService;
    @Inject
    protected CcsAccountMap ccsAccSecMap;
    @Inject
    protected CtpAccountMap ctpAccSecMap;
    @Inject
    protected MObjFactory of;
    protected MxList<T> list = new MxList();
    @Inject
    protected MEventService es;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected OrderFactory orderFactory;
    protected CopyOnWriteArraySet<Order> dirtySet = new CopyOnWriteArraySet();
    protected ReentrantLock dirtyLock = new ReentrantLock();
    @Inject
    protected QueryModel queryModel;
    @Inject
    protected IUserService userService;
    @Inject
    protected ScheduledExecutorService ses;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected BooleanProperty querying = new SimpleBooleanProperty(false);
    protected boolean isUnfinishedOrder = false;
    protected ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 120L, TimeUnit.SECONDS);
        });
    }

    public synchronized OrderMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        OrderMng query = (OrderMng)((Object)this.of.create(OrderMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("order query failed", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullQuery() throws MException {
        this.querying.set(true);
        ObservableList<T> observableList = this.getList();
        synchronized (observableList) {
            this.list.clear();
        }
        ArrayList<Order> listQuery = new ArrayList<Order>();
        try {
            List fundList = this.faccService.getFundAccountList(this.marketGroup);
            for (FundAccount fund : fundList) {
                OrderMng orderMng = this.getQuery(fund);
                Set<Order> setQuery = null;
                try {
                    setQuery = orderMng.query(this.isUnfinishedOrder);
                }
                catch (MException e) {
                    logger.error("query fund account order failed: ", (Throwable)e);
                }
                if (setQuery == null) continue;
                listQuery.addAll(setQuery);
            }
            this.afterUpdate(listQuery);
            this.update(listQuery);
        }
        finally {
            this.querying.set(false);
        }
        this.update(listQuery);
    }

    private void afterUpdate(List<Order> listQuery) {
        for (Order order : listQuery) {
            int scale = 3;
            RefItem refItem = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
            if (refItem != null) {
                scale = refItem.getScale();
            }
            double d = Math.pow(10.0, scale);
            order.setOrderAmt((double)Math.round(order.getOrderAmt() * d) / d);
            order.setTotalValue((double)(Math.round(order.getTotalValue() * 100.0) / 100L));
        }
    }

    protected void onPush(MEvent event) {
        if (event.getObj() instanceof ExecutionReport) {
            this.onExecutionReport(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExecutionReport(MEvent event) {
        try {
            ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
            String market = report.getReport().getInstrument().getMarket();
            String marketGroup = MarketUtils.getMarketGroup((String)market);
            if (!this.careReport(report.getReport())) {
                return;
            }
            POrderService.SingleOrder singleOrder = report.getReport().getSingleOrder();
            if (!marketGroup.equals(this.marketGroup) || singleOrder == null) {
                return;
            }
            Order order = this.orderFactory.create(singleOrder);
            this.updateOrder(order);
            if ("52".equals(order.getOrdStatus().getRaw()) || "70".equals(order.getOrdStatus().getRaw())) {
                order.setWthUserName(this.getWthUserName(singleOrder));
                order.setErrInfo(order.transferErrInfo());
            }
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = String.valueOf(order.getSysOrderId()) + "_" + order.getOrdDate();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        logger.info(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getSysOrderId() + " now:" + statusNow + " old:" + statusOld);
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    if (order.isCanCancel()) {
                        this.list.updatePart((MxObject)order);
                    } else if (this.list.getListMap().get(order) != null) {
                        this.list.remove((MxObject)order);
                    }
                } else {
                    this.list.updatePart((MxObject)order);
                }
            }
            this.changed();
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u63a8\u9001\u65f6\u53d1\u751f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean careReport(PMessage.ExecutionReport report) {
        return report.hasSingleOrder();
    }

    protected Integer getStatusNo(Order order) {
        if (order.getOrdStatus().getRaw().equals("56")) {
            return -2;
        }
        if (!order.isCanCancel()) {
            return 99999999;
        }
        if (order.getOrdStatus().getRaw().equals("90")) {
            return 0;
        }
        if (order.getOrdStatus().getRaw().equals("48")) {
            return 1;
        }
        if (order.getOrdStatus().getRaw().equals("49")) {
            return 1000 + order.getCumQty();
        }
        return -1;
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    protected void updateOrder(Order order) {
        if (order instanceof CtpOrder) {
            CtpOrder ctp = (CtpOrder)CtpOrder.class.cast(order);
            this.queryModel.afterUpdate(ctp);
        } else if (order instanceof CcsOrder) {
            CcsOrder ccs = (CcsOrder)CcsOrder.class.cast(order);
            this.queryModel.afterUpdate(ccs);
            this.queryModel.getOrderPrice((Order)ccs);
        }
    }

    protected String getWthUserName(POrderService.SingleOrder pOrder) {
        try {
            String wthName = this.userService.getCachedUser(pOrder.getWthUserId()).getName().equals("") ? pOrder.getWthUserId() : this.userService.getCachedUser(pOrder.getWthUserId()).getName();
            return wthName;
        }
        catch (MException | Exception e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u540d\u5931\u8d25", e);
            return "";
        }
    }

    public Set<Order> queryUnfinishedOrder(FundAccount fund) {
        OrderMng orderMng = this.getQuery(fund);
        Set<Order> setQuery = null;
        try {
            setQuery = orderMng.query(true);
        }
        catch (MException e) {
            logger.error("query fund account order failed: ", (Throwable)e);
        }
        if (setQuery == null) {
            return setQuery;
        }
        return setQuery;
    }

    protected synchronized void update(List<Order> listOrder) {
        this.changed();
    }

    protected synchronized void updateDirty(List<Order> listOrder) {
        this.changed();
    }

    public ObservableList<T> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public boolean isQuerying() {
        return this.querying.get();
    }

    public BooleanProperty queryingProperty() {
        return this.querying;
    }
}

