/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.ListExecuteReport;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.OrderMng;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OrderModel<T extends Order>
extends MxModel {
    private static final Logger logger = LogManager.getLogger(OrderModel.class);
    private String marketGroup;
    protected Map<FundAccount, OrderMng> mapQuery = new ConcurrentHashMap<FundAccount, OrderMng>();
    @Inject
    protected IFundAccountService faccService;
    @Inject
    protected CcsAccountMap ccsAccSecMap;
    @Inject
    protected CtpAccountMap ctpAccSecMap;
    @Inject
    protected MObjFactory of;
    protected MxList<T> list = new MxList();
    @Inject
    protected MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected OrderFactory fOrder;
    protected CopyOnWriteArraySet<Order> dirtySet = new CopyOnWriteArraySet();
    protected ReentrantLock dirtyLock = new ReentrantLock();
    @Inject
    protected QueryModel queryModel;
    @Inject
    protected ScheduledExecutorService ses;
    private static final int FULL_QUERY_INTERVAL = 3000;
    protected static final int SPEC_QUERY_INTERVAL = 1000;
    protected volatile boolean querying = false;
    protected boolean isUnfinishedOrder = false;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 120L, TimeUnit.SECONDS);
        });
    }

    public synchronized OrderMng getQuery(FundAccount fund) {
        System.out.println("OrderModel    |  " + Thread.currentThread().getName());
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        OrderMng query = (OrderMng)((Object)this.of.create(OrderMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("order query failed", e);
            }
        });
    }

    protected void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("order query failed", e);
            }
        });
    }

    private void runSynQuery(String extAccountID) {
        this.querying = true;
        try {
            LinkedList<Order> listOrder = new LinkedList<Order>();
            for (OrderMng orderMng : this.mapQuery.values()) {
                if (orderMng.getFund() instanceof CcsSubFundAccount || !orderMng.getFund().getExtAccntId().equals(extAccountID)) continue;
                try {
                    LinkedList<Order> listQuery = new LinkedList<Order>(orderMng.query(this.isUnfinishedOrder));
                    listOrder.addAll(listQuery);
                }
                catch (MException e) {
                    logger.error("query fund account order failed: ", (Throwable)e);
                }
            }
            this.updateDirty(listOrder);
        }
        finally {
            this.querying = false;
        }
        this.runSpecQuery();
    }

    protected void specQuery() throws MException {
        logger.info("\u63a8\u9001\u89e6\u53d1\u4e86\u4e00\u7ea7\u8d26\u53f7\u59d4\u6258\u67e5\u8be2");
        LinkedList<Order> listOrder = new LinkedList<Order>();
        for (OrderMng orderMng : this.mapQuery.values()) {
            List<Order> listQuery = null;
            try {
                listQuery = orderMng.queryToBeQuery(this.querying);
            }
            catch (MException e) {
                logger.error("query fund account order failed: ", (Throwable)e);
            }
            if (listQuery == null) continue;
            listOrder.addAll(listQuery);
        }
        this.updateDirty(listOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullQuery() throws MException {
        this.querying = true;
        try {
            ObservableList<T> observableList = this.getList();
            synchronized (observableList) {
                System.out.println("OrderModel    |  " + Thread.currentThread().getName());
                this.list.clear();
            }
            List fundList = this.faccService.getFundAccountList(this.marketGroup);
            for (FundAccount fund : fundList) {
                OrderMng orderMng = this.getQuery(fund);
                ArrayList<Order> listQuery = new ArrayList<Order>();
                Set<Order> setQuery = null;
                try {
                    setQuery = orderMng.query(this.isUnfinishedOrder);
                }
                catch (MException e) {
                    logger.error("query fund account order failed: ", (Throwable)e);
                }
                if (setQuery == null) continue;
                listQuery.addAll(setQuery);
                this.update(listQuery);
            }
        }
        finally {
            this.querying = false;
        }
        this.runSpecQuery();
    }

    protected boolean careReport(String marketGroup, String type) {
        if (!marketGroup.equals(this.marketGroup)) {
            return false;
        }
        return "48".equals(type) || "52".equals(type) || "56".equals(type) || "70".equals(type) || "65".equals(type) || "73".equals(type);
    }

    private void onListReport(MEvent event) {
        String type = event.getStr("push_type");
        if (!type.equals("124")) {
            return;
        }
        if (!(event.getObj() instanceof ListExecuteReport)) {
            return;
        }
        ListExecuteReport report = (ListExecuteReport)ListExecuteReport.class.cast(event.getObj());
        this.sdFullQuery.schedule(e -> this.runSynQuery(report.getReport().getExtAccntId()));
    }

    protected void onPush(MEvent event) {
        if (event.getObj() instanceof ExecutionReport) {
            this.onExecutionReport(event);
        } else if (event.getObj() instanceof CancelRejectReport) {
            this.onOrderCancelPush(event);
        }
    }

    private void onExecutionReport(MEvent event) {
        String type;
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        String market = report.getReport().getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        if (!this.careReport(marketGroup, type = Integer.toString(report.getType()))) {
            return;
        }
        FundAccount acc = this.faccService.getFundAccount(report.getReport().getExtAccntId(), marketGroup);
        OrderMng query = this.getQuery(acc);
        if (query != null) {
            query.addToBeQuery(report);
        }
        this.runSpecQuery();
    }

    private void onOrderCancelPush(MEvent event) {
        CancelRejectReport orderCancelReject = (CancelRejectReport)CancelRejectReport.class.cast(event.getObj());
        String market = orderCancelReject.getReport().getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        FundAccount acc = this.faccService.getFundAccount(orderCancelReject.getReport().getExtAccntId(), marketGroup);
        OrderMng query = this.getQuery(acc);
        if (query != null) {
            query.addToBeQuery(orderCancelReject);
        }
        this.runSpecQuery();
    }

    protected synchronized void update(List<Order> listOrder) {
        System.out.println("OrderModel    |  " + Thread.currentThread().getName());
        this.changed();
    }

    protected synchronized void updateDirty(List<Order> listOrder) {
        System.out.println("OrderModel    |  " + Thread.currentThread().getName());
        this.changed();
    }

    public ObservableList<T> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public boolean isQuerying() {
        return this.querying;
    }

    public boolean isUnfinishedOrder() {
        return this.isUnfinishedOrder;
    }

    public void setUnfinishedOrder(boolean isUnfinishedOrder) {
        this.isUnfinishedOrder = isUnfinishedOrder;
    }
}

